﻿/**
*/
module nemuxi.file.items.linkitem;

debug import std.stdio: wl = writefln, pl = printf;

debug(linkitem) void main() {}

import etc.kareki.kareki;

import nemuxi.base;
import nemuxi.negui.negui;
import nemuxi.file.items.item;
public import nemuxi.file.items.itemfunc;

///
class LinkItemException: ItemException {
	mixin MixInNemuxiException;
}


/**
忘れないうちにメモ：リンク先を指すクラス。

overrideメソッドがリンク先と競合した際にこいつを優先させる。
*/
class LinkItem: Item {
	invariant() {
		if(src.ks[ITEM.WORKFOLDER])
			assert(src.ks[ITEM.WORKFOLDER].type() == HAGATA.String);
		if(src.ks[ITEM.OPTION])
			assert(src.ks[ITEM.OPTION].type() == HAGATA.String);
		if(src.ks[ITEM.ICON_ADDRESS])
			assert(src.ks[ITEM.ICON_ADDRESS].type() == HAGATA.String);
		if(src.ks[ITEM.ICON_INDEX])
			assert(src.ks[ITEM.ICON_INDEX].get!(Integer) >= 0);
		if(src.ks[ITEM.SHOW])
			assert(src.ks[ITEM.SHOW].type() == HAGATA.Integer);
		if(src.ks[ITEM.SHOW])
			assert(src.ks[ITEM.SHOW].get!(Integer) >= SHOW.min && src.ks[ITEM.SHOW].get!(Integer) <= SHOW.max);
		if(src.ks[ITEM.TAGS])
			assert(src.ks[ITEM.TAGS].type() == HAGATA.TSV_String);
		/+
		if(src.ks[ITEM.HISTORY_WORKFOLDERS])
			assert(src.ks[ITEM.HISTORY_WORKFOLDERS].type() == HAGATA.TSV_String);
		if(src.ks[ITEM.HISTORY_OPTIONS])
			assert(src.ks[ITEM.HISTORY_OPTIONS].type() == HAGATA.TSV_String);
		+/
	}
	protected Item src;
	
	/**
	コンストラクタ。

	Params:
		item = TYPE.LINKアイテム。

		ItemRoot = itemの指すべきアイテムを保持しているツリー元。
	*/
	this(Item item, Kareha ItemRoot)
	in {
		assert(item);
		assert(ItemRoot);
		assert(item.type() == TYPE.LINK);
	}
	body {
		src = item;

		try {
			super(src.link, ItemRoot);
		} catch(KarekiException e) {
			throw new LinkItemException("ダメだって", EC.NONE, e);
		}
	}
	override Text itemID() const {
		return src.itemID;
	}
	
	alias Item.name name;
	
	/// 競合
	override const Text information() {
		return src.information().length
			? src.information()
			: super.information();
	}
	/// 競合
	override const Text workFolder() {
		return src.ks[ITEM.WORKFOLDER]
			? src.workFolder
			: super.workFolder;
	}
	
	/// 競合
	override const Text option() {
		return src.ks[ITEM.OPTION]
			? src.option()
			: super.option();
	}
	/// 競合
	override const Text iconAddress() {
		return src.ks[ITEM.ICON_ADDRESS]
			? src.iconAddress()
			: super.iconAddress();
	}
	/// 競合
	override const Integer iconIndex() {
		return src.ks[ITEM.ICON_INDEX]
			? src.iconIndex()
			: super.iconIndex();
	}

	const bool isShowOverride() {
		return cast(bool)src.ks[ITEM.SHOW];
	}
	/// 競合
	override const SHOW show() {
		return src.ks[ITEM.SHOW]
			? src.show()
			: super.show();
	}
	/// リンク元
	override const Text[] tags() {
		return src.tags();
	}
	/// リンク元
	override const DateTime historyResist() {
		return src.historyResist();
	}
	/// リンク元
	override const DateTime historyLast() {
		return src.historyLast();
	}
	/// リンク元
	override const Integer historyUse() {
		return src.historyUse();
	}
}

debug(linkitem) unittest {
	auto aki=newItem();
	auto item=new Item(Text("ie"), aki[`Items`]);
	auto link=new LinkItem(new Item(Text("link"), aki[`Items`]), aki[`Items`]);
	wl((cast(Item)link).address.toString);
	link.name=Text("aaa");
}


