﻿/**
ファイル検索。

Phobosはちっと使わない。
*/
module nemuxi.file.find;

debug import std.stdio: wl = writefln, pl = printf;

debug(find) void main() {}

import win32.windows;

import nemuxi.base;
import nemuxi.system.raii;
import nemuxi.utility.meta.memberproperty;

/**
History:
	1.00β13:
		[S] 隠蔽用ptrメソッド実装。
		[S] 構造体変数を改名。
*/
struct FILEITEM {
	mixin(SMixInStructHiddenOriginal!(WIN32_FIND_DATA)(q{FindData}));
	WIN32_FIND_DATA FindData;
	alias FindData info;

	/// ファイル属性。
	static enum ATTRIBUTE {
		READONLY      = FILE_ATTRIBUTE_READONLY      , /// 読み取り専用属性を持ちます。この属性を持つファイルは読み込むことができますが書き込んだり削除したりすることはできません。この属性を持つディレクトリを削除することはできません。
		HIDDEN        = FILE_ATTRIBUTE_HIDDEN        , /// 隠しファイル属性を持ちます。
		SYSTEM        = FILE_ATTRIBUTE_SYSTEM        , /// システム属性を持ちます。
		DIRECTORY     = FILE_ATTRIBUTE_DIRECTORY     , /// ディレクトリです。
		ARCHIVE       = FILE_ATTRIBUTE_ARCHIVE       , /// アーカイブ属性を持ちます。
		ENCRYPTED     = FILE_ATTRIBUTE_ENCRYPTED     , /// 暗号化属性を持ちます。この属性を持つファイルはデータが暗号化されていることを示します。この属性を持つディレクトリは、このディレクトリの中に新しく作成されるファイルやサブディレクトリがデフォルトで暗号化属性を持つことを示します。
		NORMAL        = FILE_ATTRIBUTE_NORMAL        , /// ほかのどの属性も設定されていません。
		TEMPORARY     = FILE_ATTRIBUTE_TEMPORARY     , /// 一時記憶領域として利用されているファイルです。
		SPARSE_FILE   = FILE_ATTRIBUTE_SPARSE_FILE   , /// スパースファイルです。
		REPARSE_POINT = FILE_ATTRIBUTE_REPARSE_POINT , /// 関連付けられたリパースポイントを持ちます。
		COMPRESSED    = FILE_ATTRIBUTE_COMPRESSED    , /// 圧縮属性を持ちます。この属性を持つファイルはデータが圧縮されていることを示します。この属性を持つディレクトリは、このディレクトリの中に新しく作成されるファイルやサブディレクトリがデフォルトで圧縮属性を持つことを示します。
		OFFLINE       = FILE_ATTRIBUTE_OFFLINE       , /// ファイルは直接利用することができません。この属性は、ファイルがオフラインストレージに移動されたものであることを示します。アプリケーションはこの属性を変更するべきではありません。
	}
	/// ファイル属性。
	const ATTRIBUTE attributes() {
		return cast(ATTRIBUTE)FindData.dwFileAttributes;
	}

	/// 時間。てけとう。
	alias FindData.ftCreationTime   createTime;
	/// ditto
	alias FindData.ftLastAccessTime lastAccessTime;
	/// ditto
	alias FindData.ftLastWriteTime  lastWriteTime;

	const ulong size() {
		return FindData.nFileSizeHigh * DWORD.max + FindData.nFileSizeLow;
	}

	/// ファイル名。
	Text fileName() {
		return Text(FindData.cFileName.ptr);
	}
	/// 8.3文字ファイル名。
	Text shortFileName() {
		return Text(FindData.cAlternateFileName.ptr);
	}

	/**
	History:
		1.00β14:
			[P] const属性追加。
	*/
	const bool isFolder() {
		return (FindData.dwFileAttributes & ATTRIBUTE.DIRECTORY) == ATTRIBUTE.DIRECTORY
			? true
			: false;
	}
}

/**
ファイル検索。

History:
	1.00β14:
		[S] 使い道の無いであろうnewPatternメソッドを非推奨に。
*/
class Finder: Raii {
	protected HBRUSH hFind;
	mixin KillResource!("ファイル検索", hFind, FindClose, 0);

	private bool NextFind;

	protected wchar* FilePattern;
	protected size_t Count;
	
	this(in Text FilePattern) {
		super(false);
		this.FilePattern = FilePattern.ptr;
	}

	deprecated void newPattern(in Text FilePattern) {
		Kill();
		
		super.Suicide    = true;
		NextFind         = false;
		hFind            = null;
		Count            = 0;
		this.FilePattern = FilePattern.ptr;
	}

	bool find(ref FILEITEM FileItem) {
		if(NextFind) {
			if(FindNextFile(hFind, &FileItem.info)) {
				Count++;
				return true;
			} else {
				NextFind=false;
				return false;
			}
		} else {
			auto FileFind=FindFirstFile(FilePattern, &FileItem.info);
			if(FileFind == INVALID_HANDLE_VALUE) {
				super.Suicide = false;
				return false;
			} else {
				super.Suicide = true;
				NextFind = true;
				hFind = FileFind;
				Count++;
				return true;
			}
		}
	}

	const size_t count() {
		return Count;
	}
}



