﻿/**
ちょっとしたデータ。
*/
module nemuxi.file.data;

debug import std.stdio: wl = writefln, pl = printf;
debug(data) void main() {}

//import std.file;
import std.string;
import std.stream;
//import core.thread;

public import etc.kareki.kareki;

//import nemuxi.base;

import nemuxi.file.file;
import nemuxi.utility.meta.memberproperty;
import nemuxi.system.exception;

///
class DataException: NemuxiException {
	mixin MixInNemuxiException;
}

/**
Kareha集合体。

少しでも早くアクセスしたい、そんな思いを配列に。
*/
class Data {
	protected {
		/// アクセス用配列。わけわからん修飾子だなぁ。
		package Kareha[] ks;
		/// 文字列取得。
		const Text GetText(size_t n) {
			if(auto s=ks[n].unSafe!(string)) {
				return s.toText;
			} else {
				return Text.emptyText;
			}
			//return Text(ks[n].unSafe!(string));
		}
		/// 真偽値取得。
		const bool GetBool(size_t n) {
			return ks[n].get!(Integer) == 0 ? false: true;
		}
	}
	/// 空Kareha生成。
	static protected Kareha Empty() {
		return new Kareha();
	}
	/// ditto
	static protected Kareha EmptyString() {
		return new Kareha(string.init);
	}
	/// ditto
	static protected Kareha EmptyInteger(Integer ini=Integer.init) {
		return new Kareha(ini);
	}
	/// ditto
	static protected Kareha EmptyTsvInteger() {
		return new Kareha((Integer[]).init);
	}
	/// ditto
	static protected Kareha EmptyTsvString() {
		return new Kareha((string[]).init);
	}

	/**
	登録簡易化。
	
	------------------------------------------
	// Before
	if(!ks[ITEM.XXX](TREE.XXX_YYY)) {
		ks[ITEM.XXX].plus(TREE.XXX_YYY, super.EmptyTsvString());
	}
	ks[ITEM.XXX_YYY] = ks[ITEM.XXX][TREE.XXX_YYY];
	if(
		!ks[ITEM.XXX_YYY].have()
		|| ks[ITEM.XXX_YYY].type() != HAGATA.TSV_String
		|| (ks[ITEM.XXX_YYY].tsvLength() < 2)
	) {
		ks[ITEM.XXX_YYY] = (string[]).init;
	}
	
	//After
	Regist!((string[]).init)(
		ks[ITEM.XXX],
		TREE.XXX_YYY,
		ITEM.XXX_YYY,
		!ks[ITEM.XXX_YYY].have()
		|| ks[ITEM.XXX_YYY].type() != HAGATA.TSV_String
		|| (ks[ITEM.XXX_YYY].tsvLength() < 2)
	);
	------------------------------------------
	#あんましかわんねー…。

	Params:
		Value = Expが真の場合に設定される値。

		BaseData = 基底ツリー。

		TreeData = 対象のツリー。

		TargetIndex = 設定すべきksの添え字。

		Exp = 対象ksの無効値。

		ArraySubstitution = BaseData[TreeData]が無効な場合に生成して代入を行うか。
	*/
	deprecated protected void Regist(alias Value)(Kareha BaseData, string TreeData, size_t TargetIndex, lazy bool Exp, bool ArraySubstitution=true) {
		if(ArraySubstitution) {
			if(!(TreeData in BaseData)) {
				BaseData.plus(TreeData, this.Empty());
			}
			ks[TargetIndex] = BaseData[TreeData];
			//auto Exps=ks[TargetIndex];
			if(Exp) {
				ks[TargetIndex] = Value;
			}
		} else {
			if((TreeData in BaseData)) {
				ks[TargetIndex] = BaseData[TreeData];
				//auto Exps=ks[TargetIndex];
				if(Exp) {
					ks[TargetIndex] = Value;
				}
			}
		}
	}
	/**
	invariant()にそのまま使えるようにassertとかenforceに合わせてExpが偽の場合に処理を行う。
	*/
	final protected void RegistEx(alias Value)(Kareha BaseData, string TreeData, size_t TargetIndex, lazy bool Exp, bool ArraySubstitution=true) {
		if(ArraySubstitution) {
			if(!(TreeData in BaseData)) {
				BaseData.plus(TreeData, this.Empty());
			}
			ks[TargetIndex] = BaseData[TreeData];
			
			if(!Exp) {
				ks[TargetIndex] = Value;
			}
		} else {
			if(TreeData in BaseData) {
				ks[TargetIndex] = BaseData[TreeData];
				
				if(!Exp) {
					ks[TargetIndex] = Value;
				}
			}
		}
	}
	
	const Kareha opIndex(size_t n) {
		return cast(Kareha)ks[n];
	}
	/**
	History:
		1.00β15:
			新規追加。
	*/
	const size_t length() {
		return ks.length;
	}
}


class AkiStream: EndianStream {
	/**
	*/
	this(in Text path, FileMode mode = (FileMode).In, uint bufferSize = BufferedStream.DefaultBufferSize) {
		super(new BufferedFile(path.toString(), mode, bufferSize));
		
		if((mode & FileMode.In) == FileMode.In && size > 0) {
			Bom = readBOM == -1 ? false: true;
		}
	}

	///
	private bool Bom;
	mixin(StructGetSet!(bool)("bom", q{Bom}));

	void writeBOM() {
		if(Bom) {
			super.writeBOM(BOM.UTF8);
		}
	}
}
/+
string[] ReadAkiDocument(Text file)
in {
	assert(IsPath(file));
}
body {
	scope aki=new AkiStream(file);
	string[] data;

	foreach(char[] line; aki) {
		data ~= line.idup;
	}

	return data;
}
+/
AkiDocument ReadAkiDocument(in Text file)
in {
	assert(FILE.isExistence(file));
}
body {
	scope aki=new AkiStream(file);
	string[] data;

	foreach(char[] line; aki) {
		data ~= line.idup;
	}

	return new AkiDocument(data);
}
void WriteAkiDocument(in Text file, AkiDocument AkiData) {
	auto data=AkiData.toString().splitlines();
	auto aki=new AkiStream(file, FileMode.OutNew);
	scope(exit) {
		aki.flush;
		aki.close;
		delete aki;
	}
	aki.bom = true;
	aki.writeBOM();

	foreach(line; data) {
		aki.writeLine(line);
	}

}


