﻿/**
ﾈﾑぃで使用する専用DLL。

D Interfaceで統一。

History:
	1.00β11:
		moduleをnemuxidllからpluginに変更。
		packageをnemuxi.dllからnemuxi.dll.pluginへ移動。
*/
module nemuxi.dll.plugin.plugin;

debug import std.stdio: wl = writefln, pl = printf;
debug(plugin) void main() {}

import core.memory;
import core.runtime;
import std.contracts;

import win32.windows;

import nemuxi.base;
import nemuxi.file.data;
import nemuxi.dll.dll;
public import nemuxi.dll.plugin.dllinterface;

///
class PluginException: DllException {
	mixin MixInNemuxiException;
}

/// rt.dmain2
private extern(C) {
	alias void  function(void*) gcSetFn;
	alias void  function()      gcClrFn;

	void* gc_getProxy();
}

/**
History:
	1.00β17:
		[P] I/F変更に伴う修正。
		[P] abstract属性を撤廃。
*/
class NemuxiDLL: DLL {
	private DLL_InformationType DLL_Information;
	private DLL_HaveSettingDialogType DLL_HaveSettingDialog;
	protected {
		struct INFORMATION {
			Text ToolName;             /// DLL名。
			Text ToolVer;              /// DLLバージョン。
			Text VendorName;           /// 製作者名。
			Text VendorSiteName;       /// 製作者サイト名。
			Text VendorSiteUri;        /// 製作者サイトURI。
			Text VendorMail;           /// 製作者メールアドレス。
			Text VendorComment;        /// 製作者コメント。
			Text LicenseName;          /// ライセンス名。
			Text LicenseDoc;           /// ライセンス内容。
		}
		INFORMATION Information;
	}
	const ref const(INFORMATION) information() {
		return Information;
	}
	override protected void Kill() {
		if(auto gcClr = address!(gcClrFn)(Text("gc_clrProxy"))) {
			gcClr();
		}
		
		super.Kill();
	}
	final protected const RET LoadAddress(RET)(in Text AddressName, int AddressIndex)
	in {
		assert(AddressName.length);
		assert(AddressIndex);
	}
	body {
		if(auto Ret=address!(RET)(AddressName)) {
			return cast(RET)Ret;
		} else if(auto Ret=address!(RET)(AddressIndex)) {
			return cast(RET)Ret;
		}
		throw new PluginException(Text("Not Found %s(%s)", AddressName.text, AddressIndex));
	}
	
	override this(in Text Path) {
		super(Path);

		if(auto gcSet = address!(gcSetFn)(Text("gc_setProxy"))) {
			gcSet(gc_getProxy());
		}

		// DLL情報の取得 ---------------------------
		DLLINFORMATION DllInfos;
		DLL_Information = LoadAddress!(DLL_InformationType)(Text("DLL_Information"), 1);
		
		// 必要領域の取得
		with(DllInfos) if(DLL_Information(&DllInfos)) {
			wchar* GetSize(size_t Size) {
				if(Size) {
					return (new wchar[Size]).ptr;
				}

				return null;
			}
			
			ToolName       = GetSize(ToolNameLength);
			ToolVer        = GetSize(ToolVerLength);
			VendorName     = GetSize(VendorNameLength);
			VendorSiteName = GetSize(VendorSiteNameLength);
			VendorSiteUri  = GetSize(VendorSiteUriLength);
			VendorMail     = GetSize(VendorMailLength);
			VendorComment  = GetSize(VendorCommentLength);
			LicenseName    = GetSize(LicenseNameLength);
			LicenseDoc     = GetSize(LicenseDocLength);

			enforce(DLL_Information(&DllInfos), new PluginException(Text("プラグイン読み込み失敗")));

			Text GetValue(wchar* Value, size_t Size) {
				if(Size && Value) {
					return Text(Value[0 .. Size]);
				}

				return Text.emptyText;
			}

			Information.ToolName       = GetValue(ToolName       , ToolNameLength);
			Information.ToolVer        = GetValue(ToolVer        , ToolVerLength);
			Information.VendorName     = GetValue(VendorName     , VendorNameLength);
			Information.VendorSiteName = GetValue(VendorSiteName , VendorSiteNameLength);
			Information.VendorSiteUri  = GetValue(VendorSiteUri  , VendorSiteUriLength);
			Information.VendorMail     = GetValue(VendorMail     , VendorMailLength);
			Information.VendorComment  = GetValue(VendorComment  , VendorCommentLength);
			Information.LicenseName    = GetValue(LicenseName    , LicenseNameLength);
			Information.LicenseDoc     = GetValue(LicenseDoc     , LicenseDocLength);

			//解放しとく。
			delete ToolName;
			delete ToolVer;
			delete VendorName;
			delete VendorSiteName;
			delete VendorSiteUri;
			delete VendorMail;
			delete VendorComment;
			delete LicenseName;
			delete LicenseDoc;
		}
	}
	final bool haveSettingDialog() {
		if(DLL_HaveSettingDialog is null) {
			DLL_HaveSettingDialog = LoadAddress!(DLL_HaveSettingDialogType)(Text("DLL_HaveSettingDialog"), 2);
		}
		return cast(bool)DLL_HaveSettingDialog();
	}
}




