﻿/**
DLLインターフェイス。

序数1-9は予約されたものとして処理。

<dl>
	<dt>DLL_Information</dt>
	<dd>
		Index: 1
		extern(C) int DLL_Information(DLLINFORMATION* pDllInformation);

		Params:
			pDllInformation = DLL情報を格納する領域。
			                  wchar*メンバがnullの場合はその情報を格納せずに対応size_tメンバのみに値を格納する。
			                  size_tメンバにはwchar*メンバに必要なサイズ(番兵不要)が格納される。

		Return:
			成功すれば0以外、失敗すれば0を返す。
	</dd>

	<dt>DLL_SettingDialog</dt>
	<dd>
		Index: 2
		extern(C) int DLL_HaveSettingDialog();

		Return:
			DLLが設定ダイアログを持っていれば0以外、もっていなければ0を返す。
	</dd>
	
</dl>

<pre>
version(build) {
	pragma(build_def, `

EXPORTS

		DLL_Information             @1
		DLL_HaveSettingDialog       @2

	`);
}

</pre>

Deprecated:
	他言語との協調性も確立すべき。

History:
	1.00β17:
		[P] 新しく生まれ変わり。

	1.00β11:
		packageをnemuxi.dllからnemuxi.dll.pluginへ移動。
*/
module nemuxi.dll.plugin.dllinterface;

debug import std.stdio: wl = writefln, pl = printf;

debug(dllinterface) void main() {}


// 新しいの -------------------------------------------------------------------

// DLL_Information -----------------------------------------
/**
DLL情報。
*/
struct DLLINFORMATION {
	wchar* ToolName;             /// DLL名。
	size_t ToolNameLength;       /// ditto
	wchar* ToolVer;              /// DLLバージョン。
	size_t ToolVerLength;        /// ditto
	wchar* VendorName;           /// 製作者名。
	size_t VendorNameLength;     /// ditto
	wchar* VendorSiteName;       /// 製作者サイト名。
	size_t VendorSiteNameLength; /// ditto
	wchar* VendorSiteUri;        /// 製作者サイトURI。
	size_t VendorSiteUriLength;  /// ditto
	wchar* VendorMail;           /// 製作者メールアドレス。
	size_t VendorMailLength;     /// ditto
	wchar* VendorComment;        /// 製作者コメント。
	size_t VendorCommentLength;  /// ditto
	wchar* LicenseName;          /// ライセンス名。
	size_t LicenseNameLength;    /// ditto
	wchar* LicenseDoc;           /// ライセンス内容。
	size_t LicenseDocLength;     /// ditto
}
alias extern(C) int function(DLLINFORMATION* pDllInformation) DLL_InformationType;

// DLL_HaveSettingDialog -----------------------------------
alias extern(C) int function() DLL_HaveSettingDialogType;


