﻿/**


*/
module nemuxi.com.ipersistfile;

debug import std.stdio: wl = writefln;
debug(ipersistfile) void main() {}

import win32.wtypes;

import nemuxi.negui.system.text;
//import nemuxi.system.text;
public import nemuxi.com.com;
public import nemuxi.com.ipersist;

extern(C) {
	CLSID IID_IPersistFile= {0x0000010B, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
}

interface IPersistFile: IPersist {
	HRESULT IsDirty();
	HRESULT Load(LPCOLESTR, DWORD);
	HRESULT Save(LPCOLESTR, BOOL);
	HRESULT SaveCompleted(LPCOLESTR);
	HRESULT GetCurFile(LPOLESTR*);
}


enum STGM {
	DIRECT           = STGM_DIRECT,
	TRANSACTED       = STGM_TRANSACTED,
	SIMPLE           = STGM_SIMPLE,
	READ             = STGM_READ,
	WRITE            = STGM_WRITE,
	READWRITE        = STGM_READWRITE,
	SHARE_DENY_NONE  = STGM_SHARE_DENY_NONE,
	SHARE_DENY_READ  = STGM_SHARE_DENY_READ,
	SHARE_DENY_WRITE = STGM_SHARE_DENY_WRITE,
	SHARE_EXCLUSIVE  = STGM_SHARE_EXCLUSIVE,
	PRIORITY         = STGM_PRIORITY,
	DELETEONRELEASE  = STGM_DELETEONRELEASE,
	CREATE           = STGM_CREATE,
	CONVERT          = STGM_CONVERT,
	FAILIFTHERE      = STGM_FAILIFTHERE,
	NOSCRATCH        = STGM_NOSCRATCH,
	NOSNAPSHOT       = STGM_NOSNAPSHOT,
}

/**
IPersistFile用interface。

IPersistFileを使用するComでオーバーライドさせると便利かも。
*/
interface IComPersistFile {
	/**
	Load。
	*/
	bool fileLoad(in Text FilePath, STGM Stgm);

	/**
	Save。

	Params:
		FilePath = フルパス指定のファイル名を表す文字列のアドレスを指定します。

		Remember = FilePathで指定したファイルをカレントファイルとして使用するかどうかを指定します。
		           trueを指定した場合は、FilePathがカレントファイルとなり、保存後にダーティーフラグ（更新されたかを示すフラグ）をクリアします。
		           falseを指定した場合は、カレントファイルは変化せず、ダーティーフラグはクリアされません。

	Return:
		保存した出来たはtrue、失敗した場合はfalse。

	Note:
		オブジェクトが正常に保存された場合は 0x00000000 (S_OK) が返ります。
		オブジェクトが保存できなかった場合は 0x80004005 (E_FAIL) 返ります。
	*/
	bool fileSave(in Text FilePath, bool Remember);

	/***/
	bool isDirty();
}

