﻿/**

History:
	1.00β16:
		新規作成。
*/
module nemuxi.com.imalloc;

debug import std.stdio: wl = writefln;
debug(imalloc) void main() {}

import std.contracts;

import win32.wtypes;
import win32.shlobj: SHGetMalloc;

import nemuxi.negui.system.text;
//import nemuxi.system.text;
//import nemuxi.system.nemuxierrors;
import nemuxi.system.exception;
public import nemuxi.com.com;


extern(C) {
	CLSID IID_IMalloc= {0x00000002, 0x0000, 0x0000, [0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46]};
}

interface IMalloc: IUnknown {
	void* Alloc(size_t);
	void* Realloc(void*, size_t);
	void Free(void*);
	size_t GetSize(void*);
	int DidAlloc(void*);
	void HeapMinimize();
}

///
class MallocException: ComException {
	mixin MixInNemuxiException;
}

class Malloc: Com!(IMalloc) {
	this() {
		auto res=SHGetMalloc(cast(win32.shlobj.IMalloc*)&Known);
		enforce(res == NOERROR, new MallocException(Text("res != NOERROR")));
		super(true);
	}

	/**
	なんとなく。
	*/
	void free(void* p) {
		Known.Free(p);
	}
}


