﻿/**
*/
module hookfunc;

import std.mmfile;

import win32.windows;

import hooker;
import hookdef;

version(build) {
	pragma(build_def, `

EXPORTS

		RegistHook          @10
		UnRegistHook        @11

	`);
}


union SHARED {
	ubyte[12] memory;
	struct {
		HWND  hWnd;
		HHOOK hHook;
		UINT  LoopMessage;
	}
}
__gshared SHARED ShardData;
__gshared MmFile ShardFile;

extern(C) export HHOOK RegistHook(HWND hWnd, DWORD Hook, UINT LoopMessage) {
	ShardFile = new MmFile(null, MmFile.Mode.ReadWrite, SHARED.sizeof, null);
	ShardData.hWnd = hWnd;
	ShardData.LoopMessage = LoopMessage;
	ShardData.hHook = SetWindowsHookEx(cast(int)Hook, cast(HOOKPROC)&HookProc,cast(HANDLE)g_hInst, 0);
	for(auto i=0; i < ShardFile.length; i++) {
		ShardFile[i] = ShardData.memory[i];
	}
	return ShardData.hHook;
}

extern(C) export bool UnRegistHook() {
	delete ShardFile;
	immutable res=cast(bool)UnhookWindowsHookEx(ShardData.hHook);

	return res;
}


extern(Windows) LRESULT HookProc(UINT Code, WPARAM wParam, LPARAM lParam) {
	
	if(Code < 0 || Code != HC_ACTION) {
		return CallNextHookEx(ShardData.hHook, Code, wParam, lParam);
	}
	
	HOOKDATA HookData=void;
	HookData.Code = Code;
	HookData.wParam = wParam;
	HookData.lParam = lParam;
	HookData.Chain = true;
	
	SendMessage(ShardData.hWnd, ShardData.LoopMessage, cast(WPARAM)&HookData, 0);
	if(HookData.Chain) {
		return CallNextHookEx(ShardData.hHook, HookData.Code, HookData.wParam, HookData.lParam);
	} else {
		return true;
	}
}

