﻿/**

*/
module nemuxi.utility.filter.item;

debug import std.stdio: wl = writefln, pl = printf;

import std.string;
import std.uni;

import etc.kareki.kareki;

import nemuxi.base;
import nemuxi.file.items.item;
public import nemuxi.utility.filter.filter;

Text SafeId(in Text text) {
	immutable Pattern=
		"~"w
		//秋文書 型情報
		`:`
		`*`
		`\\`
		`?`
		`=`
		`@`
		`$`
		`!`
		//秋文書 名前
		`/`
		`;`
		"\r"
		"\n"

		//アイテム
		` `
		`\.`
		`,`
		"\t"
	;

	return ErasePattern(text, Pattern.toText.quot("[", "]"));
}
debug(item) unittest {
	assert(SafeId(Text("a:b")) == "ab");
	assert(SafeId(Text("a*b")) == "ab");
	assert(SafeId(Text("a\\b")) == "ab");
	assert(SafeId(Text("a?b")) == "ab");
	assert(SafeId(Text("a=b")) == "ab");
	assert(SafeId(Text("a@b")) == "ab");
	assert(SafeId(Text("a$b")) == "ab");
	assert(SafeId(Text("a!b")) == "ab");
	assert(SafeId(Text("a/b")) == "ab");
	assert(SafeId(Text("a;b")) == "ab");
	assert(SafeId(Text("a\rb")) == "ab");
	assert(SafeId(Text("a\nb")) == "ab");
	assert(SafeId(Text("a b")) == "ab");
	assert(SafeId(Text("a.b")) == "ab");
	assert(SafeId(Text("a,b")) == "ab");
	assert(SafeId(Text("a\tb")) == "ab");
}


