﻿/**

*/
module nemuxi.utility.filter.filter;

debug import std.stdio: wl = writefln, pl = printf;
debug(filter) void main() {}

import std.regex;

import nemuxi.system.nemuxierrors;
import nemuxi.system.text;

///
mixin(ThrowableClasses("Filter"));
///
typedef void function(in Text) FilterFunctionType;
///
typedef void delegate(in Text) FilterDelegateType;


Text ErasePattern(in Text Target, in Text Pattern) {
	auto reg=regex(Pattern.toString, "g");
	return replace(Target.toString, reg, "").toText;
}
debug(filter) unittest {
	Text t;
	
	t = "123.456.789";
	assert(ErasePattern(t, Text(`\.`)) == "123456789");
	assert(ErasePattern(t, Text(`\d`)) == "..");
	assert(ErasePattern(t, Text(`[1-8]`)) == "..9");
	assert(ErasePattern(t, Text(`[^1-8]`)) == "12345678");
}


