﻿/**

*/
module nemuxi.utility.convert.env;

debug import std.stdio: wl = writefln, pl = printf;
debug(env) void main() {}

import win32.windows;

import nemuxi.base;
public import nemuxi.utility.convert.convert;

/**
%**%の展開。
*/
Text EnvToPlain(in Text EnvText)
in {
	assert(EnvText.length);
}
body {
	auto pEnvText=EnvText.ptr;
	DWORD Length=ExpandEnvironmentStrings(pEnvText, null, 0);

	auto text=new wchar[Length];
	ExpandEnvironmentStrings(pEnvText, text.ptr, Length);

	return Text(text[0..Length-1]);
}

Text toPlain(in Text t) {
	if(t.find('%') == -1) {
		return cast(Text)t;
	}
	return EnvToPlain(t);
}
debug(env) unittest {
	Text t1="ComSpec";
	Text t2=t1;
	assert(toPlain(t1) == t2);

	assert(EnvToPlain(Text(`%USERNAME%`)) == "sk");
}



