﻿/**
テスト専用ダイアログ。
*/
module nemuxi.test.itemdialog;

debug import std.stdio: wl = writefln, pl = printf;
debug(itemdialog) void main() {}

import win32.windows;

import nemuxi.base;
import nemuxi.system.application;
import nemuxi.image.font;
import nemuxi.negui.window.dialog.dialog;
import nemuxi.gui.control.combobox;
import nemuxi.file.items.item;
import nemuxi.file.items.items;
import nemuxi.gui.control.listview;
import nemuxi.gui.control.iteminput;
import nemuxi.gui.control.editbox;


debug{} else {static assert(false, "debug only!");}
class ItemDialog: ModalDialog {
	enum CTRL: ITEM_ID {
		ITEM
	}
	Font font;
	ItemComboBox cb;
	ColorList cl;
	ItemAddress ia, ia2;
	MultiInput m;
	this(NeWindow Owner) {
		GUIINFO NeGuiInfo;
		NeGuiInfo.Owner   = Owner;

		super(&NeGuiInfo);

		size(500,300);
	}
	protected override {
		void OnDestroy() {
			delete font;
			super.OnDestroy();
		}
		void OnCreate() {
			caption=true;
			haveSystemMenu=true;
			frameThick=true;
			
			font=GetSystemFont(SYSFONT.MESSAGE);

			Item[] items;
			cb = new ItemComboBox(this,100);
			//foreach(ha; application.itemBase.keys) {
			//	items~=new Item(ha, application.itemBase());
			//}
			cb.setItemList=items;
			//cb.selectID = Text(`iii.`);
			cb.font=font;
			cb.move(10,10,200,200);

			cl = new ColorList(this, 200);
			cl.move(10,40,200,200);

			LISTCOLUMN clm;
			with(clm) {
				mask = MASK.POSITION | MASK.WIDTH | MASK.TEXT;
				position = POSITION.LEFT;
				px = 100;
				text = Text(__FILE__);
			}
			cl.insertColumn(0, &clm);
			clm.text = Text(__LINE__);
			cl.insertColumn(1, &clm);
			clm.text = Text(999);
			cl.insertColumn(2, &clm);

			LISTITEM li;
			with(li) {
				mask = MASK.TEXT;
				//data = &(cast(COLOR)SYSTEMCOLOR.ActiveCaption());
				text = Text(__VENDOR__);
				index=0;
				subIndex=0;
			}
			cl.insertItem(&li);
			with(li) {
				mask = MASK.TEXT;
				//data = &(cast(COLOR)SYSTEMCOLOR.ActiveCaption());
				text = Text(__VERSION__);
				index=1;
				subIndex=0;
			}
			cl.insertItem(&li);

			cl.color(0, 1, COLOR.Yellow);
			cl.color(0, 2, COLOR.Blue);
			cl.color(1, 1, COLOR.Red);
			cl.color(1, 2, COLOR.Green);

			ia = new ItemAddress(this, 300, items, items[0]);
			ia.setItem(cb.selectItem);
			ia.move(210,40,200,200);
			ia.font=font;
			
			ia2 = new ItemAddress(this, 400, items, null);
			//ia.changeType(Item.TYPE.MULTI);
			ia2.move(210,250,200,200);
			ia2.font=font;

			try{

				m=new MultiInput(this,900);
				m.move(220,10,200,20);
				m.font=font;

				m.setItemList = items;
				m.nowItemList = items[0..10];
				
			}catch(Object o)Msg(o);

			//startTimer(WM_APP+10, 2000);
			
		}
		

		int OnNotify(ITEM_ID ItemID, NOTIFY* Notify) {
			if(ItemID == 200 && cl) {
				return cl.onNotify(Notify);
			}
			return 0;
		}
		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui gui) {
			if(cb && gui is cb && (MessageType == ComboBox.EVENT.LISTCHANGE)) {
				//ia.setItem(cb.selectItem);
				ia.changeType(cb.selectItem.type);
				return true;
			}
			return false;
		}
		void OnTimer(in TIMER_ID Id) {
			auto f=m.font;
			m.destroy;
			m=new MultiInput(this,900);
			m.move(220,10,200,45);
			m.font=f;

			m.setItemList = cb.getItemList;
			m.nowItemList = cb.getItemList[0..10];
			
		}
		
	}
}
