﻿/**
*/
module nemuxi.system.staticdata;

debug import std.stdio: wl = writefln, pl = printf;
debug(staticdata) void main() {}

import std.uni;
import std.conv;
import std.string;

//import kareki.kareki;


import nemuxi.base;
import nemuxi.file.file;
import nemuxi.file.folder;
import nemuxi.file.data;
import nemuxi.utility.convert.env;
import nemuxi.utility.meta.memberproperty;
//import nemuxi.negui.window.dialog.system;


private string Getter(in string Member) {
	auto Method = cast(char)toUniLower(Member[0]) ~ Member[1..$];
	
	return `
	
	static Text ` ~ Method ~ `() {
		return ` ~ Member ~ `.toText;
	}
	
	`;
}

/**
固定値。

設定ミスによるﾈﾑぃの異常を許可。

History:
	[V]:
		ログフォルダ・フラグ追加。
*/
static class StaticData {
	
	private static immutable {
		auto DATAFOLDER_AKI = "folder/data";
		auto DATAFOLDER_DEF = `<NEMUXI>\data\%USERNAME%\`;
		auto TEMPORARYFOLDER_AKI = "folder/temp";
		auto TEMPORARYFOLDER_DEF = `%TEMP%\nemuxi\`;
		auto RESOURCEFOLDER_AKI = "folder/res";
		auto RESOURCEFOLDER_DEF = `<NEMUXI>\resource\`;
		auto LANGUAGEFOLDER_AKI = "folder/lang";
		auto LANGUAGEFOLDER_DEF = `<NEMUXI>\resource\language\`;
		auto LOGFOLDER_AKI      = "folder/log";
		auto LOGFOLDER_DEF      = `<NEMUXI>\log\`;

		auto APPLICATIONDATAFILE_AKI = "file/data/application";
		auto APPLICATIONDATAFILE_DEF = `app.aki`;
		auto GROUPDATAFILE_AKI       = "file/data/groups";
		auto GROUPDATAFILE_DEF       = `groups.aki`;
		auto ITEMDATAFILE_AKI        = "file/data/items";
		auto ITEMDATAFILE_DEF        = `items.aki`;

		auto PLUGINFOLDER_AKI = "folder/plugin";
		auto PLUGINFOLDER_DEF = `<NEMUXI>\plugin\`;
		auto PLUGIN_HOOKER_AKI= "file/plugin/hooker";
		auto PLUGIN_HOOKER_DEF= `Hooker.dll`;

		auto HELPFILE_AKI = "help";
		auto HELPFILE_DEF = `<NEMUXI>\help\help.hta`;

		auto LOGSETTING_AKI = "setting/log";
		auto LOGSETTING_DEF = 0;
	}
	private static immutable {
		wstring DataFolder;
		wstring TemporaryFolder;
		wstring ResourceFolder;
		wstring LanguageFolder;
		wstring LogFolder;

		wstring ApplicationDataFile;
		wstring GroupDataFile;
		wstring ItemDataFile;

		wstring[][] FileFilter;

		//wstring Plugin;
		wstring DllHooker;

		wstring Help;

	}
	static immutable {
		bool logEnable;
	}
	/+
	static Text dataFolder() {
		return DataFolder.toText;
	}
	+/
	mixin(Getter(q{DataFolder}));
	mixin(Getter(q{TemporaryFolder}));
	mixin(Getter(q{ResourceFolder}));
	mixin(Getter(q{LanguageFolder}));
	mixin(Getter(q{LogFolder}));
	
	mixin(Getter(q{ApplicationDataFile}));
	mixin(Getter(q{ItemDataFile}));
	mixin(Getter(q{GroupDataFile}));

	mixin(Getter(q{DllHooker}));

	mixin(Getter(q{Help}));
	
	static Text[][] fileFilter() {
		Text[][] Filters;
		
		foreach(i, filter;FileFilter) {
			Filters ~= Texts(filter);
		}

		return Filters;
	}

	static private {
		/**
		History:
			1.00β11:
				MyPathの埋め合わせ。
		*/
		string NemuxiToPlain(in string src) {
			//auto s=replace(src, "<NEMUXI>", PATH.delFolderSep(MyPath(true)).toString);
			auto s=replace(src, "<NEMUXI>", PATH.delFolderSep(PATH.myFolder).toString);
			return s;
		}

		/**
		History:
			1.00β11:
				MyPathの埋め合わせ。
		*/
		wstring GetPlain(AkiDocument aki, string tree, string def) {
			return toPlain(NemuxiToPlain(aki.defGet(tree, def)).toText).idup;
		}
	}

	

	/**
	History:
		1.00β11:
			MyPathの埋め合わせ。
			各変数へのGetPlainの使用。
	*/
	static this() {
		AkiDocument aki;
		scope(exit) delete aki;
		Throwable ReadE;
		scope(exit) Logger.write(ReadE);
		try {
			auto MyFolder=PATH.myFolder;
			debug(staticdata) {
				aki = ReadAkiDocument(MyFolder ~ `..\static.aki`);
			} else {
				aki = ReadAkiDocument(MyFolder ~ `.\static.aki`);
			}
		} catch(Throwable e) {
			ReadE = e;
			aki = new AkiDocument();
		}

		// データフォルダ
		//DataFolder = toPlain(Text(NemuxiToPlain(aki.defGet!(string)(DATAFOLDER_AKI, DATAFOLDER_DEF)))).idup;
		DataFolder = GetPlain(aki, DATAFOLDER_AKI, DATAFOLDER_DEF);
		
		// 一時フォルダ
		//TemporaryFolder = toPlain(Text(NemuxiToPlain(aki.defGet!(string)(TEMPORARYFOLDER_AKI, TEMPORARYFOLDER_DEF)))).idup;
		TemporaryFolder = GetPlain(aki, TEMPORARYFOLDER_AKI, TEMPORARYFOLDER_DEF);
		// リソースフォルダ
		//ResourceFolder = toPlain(Text(NemuxiToPlain(aki.defGet!(string)(RESOURCEFOLDER_AKI, RESOURCEFOLDER_DEF)))).idup;
		ResourceFolder = GetPlain(aki, RESOURCEFOLDER_AKI, RESOURCEFOLDER_DEF);
		// 言語フォルダ
		//LanguageFolder = toPlain(Text(NemuxiToPlain(aki.defGet!(string)(LANGUAGEFOLDER_AKI, LANGUAGEFOLDER_DEF)))).idup;
		LanguageFolder = GetPlain(aki, LANGUAGEFOLDER_AKI, LANGUAGEFOLDER_DEF);
		// ログフォルダ
		LogFolder = GetPlain(aki, LOGFOLDER_AKI, LOGFOLDER_DEF);

		// プログラムファイル
		//ApplicationDataFile = Text(NemuxiToPlain(aki.defGet!(string)(APPLICATIONDATAFILE_AKI, APPLICATIONDATAFILE_DEF))).idup;
		ApplicationDataFile = GetPlain(aki, APPLICATIONDATAFILE_AKI, APPLICATIONDATAFILE_DEF);
		// グループファイル
		//GroupDataFile = Text(NemuxiToPlain(aki.defGet!(string)(GROUPDATAFILE_AKI, GROUPDATAFILE_DEF))).idup;
		GroupDataFile = GetPlain(aki, GROUPDATAFILE_AKI, GROUPDATAFILE_DEF);
		// アイテムファイル
		//ItemDataFile = Text(NemuxiToPlain(aki.defGet!(string)(ITEMDATAFILE_AKI, ITEMDATAFILE_DEF))).idup;
		ItemDataFile = GetPlain(aki, ITEMDATAFILE_AKI, ITEMDATAFILE_DEF);

		
		if("filter" in aki) {
			auto Filters=aki.defGet!(string[])("filter", ["all"]);
			wstring[][] FilterLines;
			foreach(Filter; Filters) {
				auto Exts=aki[["filter", Filter]].defGet!(string[])(["*"]);
				auto FilterLine=new wstring[Exts.length];
				foreach(i, Ext; Exts) {
					FilterLine[i] = to!(wstring)(Ext);
				}
				FilterLines ~= FilterLine;
			}
			FileFilter= cast(immutable wstring[][])FilterLines;
		} else {
			FileFilter = [["all"w, "*"]];
		}

		//plugin
		//const Plugin= toPlain(Text(NemuxiToPlain(aki.defGet!(string)(PLUGINFOLDER_AKI, PLUGINFOLDER_DEF)))).idup;
		const Plugin = GetPlain(aki, PLUGINFOLDER_AKI, PLUGINFOLDER_DEF);
		
		//フック
		//DllHooker = Plugin ~ toPlain(Text(NemuxiToPlain(aki.defGet!(string)(PLUGIN_HOOKER_AKI, PLUGIN_HOOKER_DEF)))).idup;
		DllHooker = Plugin ~ GetPlain(aki, PLUGIN_HOOKER_AKI, PLUGIN_HOOKER_DEF);

		//ヘルプファイル
		//Help = toPlain(Text(NemuxiToPlain(aki.defGet!(string)(HELPFILE_AKI, HELPFILE_DEF)))).idup;
		Help = GetPlain(aki, HELPFILE_AKI, HELPFILE_DEF);

		//設定
		logEnable = cast(bool)aki.defGet(LOGSETTING_AKI, cast(Integer)LOGSETTING_DEF);
	}
	
}


