﻿/**
例外やらエラー。

わけの分からんことになってきてるので早々に解決せねばならん。

*/
module nemuxi.system.nemuxierrors;

debug import std.stdio: wl = writefln, pl = printf;

debug(nemuxierrors) void main() {}

import std.string: format;
static import std.string;
debug static import std.traits;

import nemuxi.system.timer;
import nemuxi.system.text;
import nemuxi.system.log;
//debug import nemuxi.system.err;
import nemuxi.utility.meta.basic;

private typedef int ThrowableCode;

interface INemuxiThrowable {
	const string time();
}
template NemuxiThrowable(T: ThrowableCode) {
	protected T Code;
	protected d_time Utc;
	///
	this(string msg, in T Code=T.init, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		this.Utc=UTCtoLocalTime(getUTCtime());
		super(msg, file, line, next);
		this.Code = Code;
		debug {
			Logger.write(this, file, line);
		}
	}
	this(Object msg, in T Code=T.init, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		this(msg.toString(), Code, next, file, line);
	}
	this(in Text msg, in T Code=T.init, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		this(msg.toString(), Code, next, file, line);
	}
	override string toString() {
		auto s=format(
			"%s(%s) %s[%s] %s",
			file,
			line,
			msg,
			Code,
			time()
		);
		/+
		if(next) {
			s ~= newline ~ next.toString();
		}
		+/
		if(next) {
			return s ~ "\n" ~ next.toString();
		} else {
			return s;
		}
	}
	
	final T code() const {
		return Code;
	}
	
	final string time() const {
		return (new ThrowableTime(Utc)).toString;
	}
}
interface test{}
class NemuxiError: Error, INemuxiThrowable,test {
	static enum CODE: ThrowableCode {
		NONE = ThrowableCode.init, /// 未設定、暫定。

		// -------------------------------
		PANEL,
		PANEL_ARRAY_BOUNDS,
		
	}
	mixin NemuxiThrowable!(CODE);
}

///
class NemuxiException: Exception, INemuxiThrowable {
	///
	static enum CODE: ThrowableCode {
		NONE = ThrowableCode.init, /// 未設定、暫定。

		// -------------------------------
		NEMUXI, /// 根本的な部分
		NEMUXI_USERNAME, /// ユーザー名。
		NEMUXI_PCNAME, /// PC名。
		NEMUXI_MYPATH, /// 自身のアドレス。

		// -------------------------------
		ITEM, /// アイテム関連の例外。
		ITEM_LINK, /// 重複リンク例外。
		ITEM_MULTI, /// 循環マルチアイテム例外。
		ITEM_DATE, /// 日付変換
		ITEM_DATE_LENGTH,
		ITEM_DATE_SPLIT,
		ITEM_DATE_INFO,

		// -------------------------------
		DATE,
		DATE_DAY,
		DATE_HOUR,
		DATE_MINUTE,
		DATE_MONTH,
		DATE_MONTH_LIST,
		DATE_SECOND,
		DATE_WEEK,
		DATE_WEEKLIST,
		DATE_WEEK_NAME,


		
		// -------------------------------
		FILE, /// ファイル関連の例外。
		FILE_EXECUTE, /// ファイル実行例外
		FILE_EXECUTE_PATH, /// ファイルパス実行例外
		FILE_EXECUTE_FOLDER, /// フォルダ実行例外
		FILE_EXECUTE_PROPERTY, /// フォルダPROPERTY例外
		
		FILE_FOUND, /// ファイルが発見できない例外。
		FILE_WRITE, /// ファイルの書き込み例外。
		FILE_READ, /// ファイルの読み込み例外。
		FILE_CREATE, /// ファイル作成例外。

		// -------------------------------
		PROCCESS,
		PROCCESS_CREATE,
		
		// -------------------------------
		GUI,
		GUI_CREATE,
	}
	mixin NemuxiThrowable!(CODE);
}
alias NemuxiException.CODE EC; /// NemuxiException.Code NECになっちまうんであえてEC。

///
private immutable TOPBASE_THROWABLE_NAME = "Nemuxi";
/**
*/
string ThrowableClasses(in string ThrowableName, in string BaseTypeName=TOPBASE_THROWABLE_NAME) {
	immutable ER = "Error";
	immutable EX = "Exception";

	immutable TOPBASE_ER = TOPBASE_THROWABLE_NAME ~ ER;
	immutable TOPBASE_EX = TOPBASE_THROWABLE_NAME ~ EX;
	
	immutable ERRORNAME     = ThrowableName ~ ER;
	immutable EXCEPTIONNAME = ThrowableName ~ EX;

	immutable BASEERRORNAME     = BaseTypeName ~ ER;
	immutable BASEEXCEPTIONNAME = BaseTypeName ~ EX;

	string Content = `
	override this(string msg, in CODE Code=CODE.NONE, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		// もうやだー
		debug {
			bool Inheritance=false;
			foreach(ty; std.traits.InterfacesTuple!(` ~ ERRORNAME ~ `)) {
				if(Inheritance |= is(ty == INemuxiThrowable)) {
					break;
				}
			};
			assert(Inheritance);
		}
		
		super(msg, Code, next, file, line);
	}
	override this(Object msg, in CODE Code=CODE.NONE, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		this(msg.toString(), Code, next, file, line);
	}
	override this(in Text msg, in CODE Code=CODE.NONE, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		this(msg.toString(), Code, next, file, line);
	}
	`;
	
	immutable THROWABLECLASS = `
	class ` ~ ERRORNAME ~ ` : ` ~ BASEERRORNAME ~ ` {
		` ~ Content ~ `
	}
	class ` ~ EXCEPTIONNAME ~ ` : ` ~ BASEEXCEPTIONNAME ~ ` {
		` ~ Content ~ `
	}
	`;
	return THROWABLECLASS;
}

mixin(ThrowableClasses("Item"));
mixin(ThrowableClasses("NeGui"));
mixin(ThrowableClasses("DateTime"));
mixin(ThrowableClasses("Draw"));
mixin(ThrowableClasses("Data"));
mixin(ThrowableClasses("KeyBoard"));
mixin(ThrowableClasses("ItemSet"));
mixin(ThrowableClasses("DropFile"));
mixin(ThrowableClasses("NemuxiPath"));
mixin(ThrowableClasses("SystemDialog"));
mixin(ThrowableClasses("ClipBoard"));
mixin(ThrowableClasses("NemuxiFile"));
mixin(ThrowableClasses("NemuxiLayout"));
mixin(ThrowableClasses("NemuxiFolder", "NemuxiFile"));
mixin(ThrowableClasses("Control", "NeGui"));
mixin(ThrowableClasses("Window", "NeGui"));
mixin(ThrowableClasses("NeWindow", "Window"));
mixin(ThrowableClasses("ApplicationData", "Data"));
mixin(ThrowableClasses("NemuxiGui", "NeGui"));
mixin(ThrowableClasses("Menu", "NeGui"));
mixin(ThrowableClasses("TaskTray", "NeGui"));
mixin(ThrowableClasses("GroupBox", "Control"));
mixin(ThrowableClasses("ComboBox", "Control"));
mixin(ThrowableClasses("UpDown", "Control"));
mixin(ThrowableClasses("Brush", "Draw"));
mixin(ThrowableClasses("Cursor", "Draw"));
mixin(ThrowableClasses("NemuxiPanel", "NemuxiLayout"));
mixin(ThrowableClasses("Setting", "NeWindow"));
mixin(ThrowableClasses("ItemData", "Setting"));
mixin(ThrowableClasses("SetData", "Setting"));
mixin(ThrowableClasses("Input", "NeWindow"));

