﻿/**
内部情報統括。
*/
module nemuxi.system.application;

debug import std.stdio: wl = writefln, pl = printf;

debug(application) void main() {}

import std.stream;
import std.string;
import std.math;
import std.contracts;

import win32.windows;

import nemuxi.base;
import nemuxi.file.file;
import nemuxi.file.data;
import nemuxi.file.app;
import nemuxi.file.exec;
import nemuxi.file.items.group;
import nemuxi.file.items.item;
import nemuxi.file.items.itemfunc;
import nemuxi.file.items.linkitem;
import nemuxi.negui.draw.canvas;
import nemuxi.image.icon;
import nemuxi.image.font;
import nemuxi.negui.draw.unit;
import nemuxi.negui.window.window;
import nemuxi.negui.window.adtb;

/**
ビバ！グローバル変数。

History:
	[V]:
		使用禁止。
*/
deprecated public Application gApp;
/**
アクセスしたくはないけれどもドキュメントには残したい、
そんな淡い思いをのせてprotectedな保護。

おかしいよね、finalなのに。
*/
final class Application {
	protected {
		AkiDocument AppDataBase;   // プログラムデータ秋文書
		AkiDocument GroupDataBase; // グループデータ秋文書
		AkiDocument ItemsDataBase; // アイテムデータ秋文書
	}
	Kareha groupBase() {
		assert(GroupDataBase);
		return GroupDataBase["Group"];
	}
	Kareha itemBase() {
		assert(ItemsDataBase);
		return ItemsDataBase["Item"];
	}
	
	App AppData; /// プログラムデータ

	Main MainData; /// メイングループデータ
	//Sub SubData; /// サブグループデータ
	Sub MenuData; /// メニューグループデータ

	protected {
		string MainGroupName; /// 現在メイングループ
		string SubGroupName; /// 現在サブグループ
		string MenuGroupName; /// 現在メニューグループ
		Item FolderItem;
	}
	
	this() {}

	private AkiDocument DataFileRead(in Text FillAddress) {
		
		if(FILE.isExistence(FillAddress)) {
			try {
				// 読み込み
				return ReadAkiDocument(FillAddress);
			} catch(Exception e) {
				return new AkiDocument();
			}
		} else {
			return new AkiDocument();
		}
	}
	/***/
	void readApp(in Text AppFile) {
		/+
		delete AppDataBase;
		
		if(IsFile(AppFile)) {
			// 読み込み
			auto data=ReadAkiDocument(AppFile);
			// パース
			AppDataBase = new AkiDocument(data);
		} else {
			AppDataBase = new AkiDocument();
		}
		+/
		delete AppDataBase;
		AppDataBase = DataFileRead(AppFile);
		
		AppData=new App(AppDataBase);
	}
	void readGroups(in Text GroupFile) {
		delete GroupDataBase;
		GroupDataBase = DataFileRead(GroupFile);
		invariant Trees = ["Group", "Group/<Menu>"];
		foreach(Tree; Trees) {
			if(!(Tree in GroupDataBase)) {
				GroupDataBase[Tree] = 0;
				GroupDataBase[Tree].fileKill();
			}
		}
		MainData = new Main(GroupDataBase["Group"]);
		MenuData = new Sub(MainData, GroupDataBase["Group/<Menu>"]);
		if(MainData.length) {
			// 何がしたかったのか忘れた
		} else {
			MainGroupName = SubGroupName = MenuGroupName = null;
		}
	
	}
	/***/
	void readItems(in Text ItemsFile) {
		//DataFileRead(ItemsFile, ItemsDataBase);
		delete ItemsDataBase;
		ItemsDataBase = DataFileRead(ItemsFile);

		//invariant Trees = ["Group", "Group/<Menu>", "Item"];
		/+
		if(!ItemsDataBase("Group")) {
			ItemsDataBase["Group"] = 0;
			ItemsDataBase["Group"].fileKill();
		}
		if(!ItemsDataBase("Group/<Menu>")) {
			ItemsDataBase["Group/<Menu>"] = 0;
			ItemsDataBase["Group/<Menu>"].fileKill();
		}
		+/
		/+
		foreach(Tree; Trees) {
			if(!(Tree in ItemsDataBase)) {
				ItemsDataBase[Tree] = 0;
				ItemsDataBase[Tree].fileKill();
			}
		}
		+/
			if(!("Item" in ItemsDataBase)) {
				ItemsDataBase["Item"] = 0;
				ItemsDataBase["Item"].fileKill();
			}
		
	}
	private void DataFileWrite(Text FillAddress, AkiDocument DataBase)
	in {
		assert(DataBase);
	}
	body {
		WriteAkiDocument(FillAddress, DataBase);
	}
	void writeApp(Text AppFile) {
		DataFileWrite(AppFile, AppDataBase);
	}
	void writeGroup(Text GroupFile) {
		DataFileWrite(GroupFile, GroupDataBase);
	}
	void writeItems(Text AppFile) {
		DataFileWrite(AppFile, ItemsDataBase);
	}
	
	/+
	/**
	ボタン型のボタンサイズを計算。

	クイック起動を参考に適当に計算。
	もうテキストとかの位置は固定、面倒。

	Params:
		Size = こいつにサイズが入るよ～。
	*/
	void getExeButtonSize(inout SIZE Size) {
		auto IconSize=AppData.exeButtonIcon();
		auto IconRect=GetIconSize(IconSize);

		Size.cx = Size.cy = IconRect;
		Size.cx += GetSystemMetrics(SM_CXEDGE) * 2;
		Size.cy += GetSystemMetrics(SM_CYEDGE) * 2;

		if(AppData.exeButtonText()) {
			// もうしらね
			with(ICONSIZE) switch(IconSize) {
				case SMALL:  // 横：適当にデスクトップの1/8-9くらい？
					Size.cx += GetSystemMetrics(SM_CXSCREEN) / 9;
					break;
				case NORMAL: // 下：アイコンに引っ付く文字の高さ一行分？
					scope font=GetSystemFont(SYSFONT.ICON);
					Size.cy += abs(PointToPixel(font.height()));
					break;
				default:
					assert(false);
			}
		}
	}
	+/

	/**
	ボタン型の初期グループ名。

	Return:
		メイン・サブのどちらかが不完全の場合はnullを返す。
		両方が有効であればその文字列配列を返す。
		[0]:メイン
		[1]:サブ
	*/
	string[] initExeButtonGroup() {
		string MainGroupName=MainData()[0];

		if(!MainGroupName.length) {
			return null;
		}

		try {
			auto SubData=MainData.subGroup(MainGroupName);
			string SubGroupName=SubData()[0];
		
			if(!SubGroupName.length) {
				return null;
			}

			return [MainGroupName, SubGroupName];
		} catch(KarekiException e) {
			Logger.write(e);
			return null;
		}
	}
	string initExeMenuGroup() {
		string MenuGroupName=MenuData()[0];
		
		return MenuGroupName;
	}
	
	/**
	メイングループ名取得。
	*/
	string getMainGroupName() {
		return MainGroupName;
	}
	/**
	サブグループ名取得。
	*/
	string getSubGroupName() {
		return SubGroupName;
	}
	/**
	メニューグループ名取得。
	*/
	string getMenuGroupName() {
		return MenuGroupName;
	}
	/**
	メイングループ変更。

	Paraqms:
		MainGroupName = メイングループ名。

	Return:
		変更出来た場合はtrue、出来なかった場合はfalse。
	*/
	bool changeMainGroup(string MainGroupName) {
		if(MainGroupName in MainData) {
			this.MainGroupName = MainGroupName;
			return true;
		}
		
		return false;
	}
	/**
	サブグループ変更。

	Paraqms:
		SubGroupName = サブグループ名。

	Return:
		変更出来た場合はtrue、出来なかった場合はfalse。
	*/
	bool changeSubGroup(string SubGroupName) {
		if(!(MainGroupName in MainData)) {
			return false;
		}
		
		auto SubNames=MainData[MainGroupName].get!(string[]);
		foreach(string SubName; SubNames) {
			if(SubName == SubGroupName) {
				this.SubGroupName = SubGroupName;
				return true;
			}
		}
		
		return false;
	}
	/**
	メニューグループ変更。

	Paraqms:
		MenuGroupName = メニューグループ名。

	Return:
		変更出来た場合はtrue、出来なかった場合はfalse。
	*/
	bool changeMenuGroup(string MenuGroupName) {
		auto SubNames=MenuData();
		
		foreach(string SubName; SubNames) {
			if(SubName == MenuGroupName) {
				this.MenuGroupName = MenuGroupName;
				return true;
			}
		}
		
		return false;
	}

	/**
	グループから連続アイテムの取得。

	Params:
		MainGroupName = メイングループ。
		                nullならメニュー。

		SubGroupName = サブグループ。
	*/
	private BM_ITEM[] GetItems(string MainGroupName, string SubGroupName) {
		bool ExeButton = MainGroupName.length ? true: false;
		
		if(ExeButton) {
			auto sub=MainData.subGroup(MainGroupName);
			return ButtonMenuGroupItems(sub, SubGroupName, this.itemBase, true, AppData.exeButtonIcon());
		} else {
			return ButtonMenuGroupItems(MenuData, SubGroupName, this.itemBase, true, AppData.exeMenuIcon());
		}
	}
	///
	BM_ITEM[] getExeButtonItems(string MainGroupName, string SubGroupName) {
		return GetItems(MainGroupName, SubGroupName);
	}
	///
	BM_ITEM[] getExeMenuItems(string MenuGroupName) {
		return GetItems(null, MenuGroupName);
	}

	/**
	グループ番号からグループ名取得。
	*/
	void getButtonGroupName(ushort MainGroupIndex, ushort SubGroupIndex, out string MainGroupName, out string SubGroupName) {
		bool MainChange=true;
		if(!MainGroupIndex) {
			MainGroupName = this.MainGroupName;
			MainChange = false;
		} else {
			MainGroupIndex--;
		}
		SubGroupIndex--;

		if(MainChange) {
			MainGroupName = MainData()[MainGroupIndex];
		}
		Sub SubGroup=MainData.subGroup(MainGroupName);
		SubGroupName = SubGroup()[SubGroupIndex];
	}

	/**
	指定アイテムの実行。

	Params:
		Item = 実行するアイテム。

		PlusInfo = 実行するアイテムに上書きする情報。
		           未指定の場合はnull。上書きされるものは、
		           <ul>
		             <li>作業フォルダ</li>
		             <li>オプション</li>
		             <li>表示方法</li>
		           </ul>

	Exception:
		とりあえず失敗ならExceptionを投げる。
	*/
	void executeItem(Item item, OverrideInfo* OverInfo=null) {
		void ExecuteItem(Item item, OverrideInfo* OverInfo) {
			bool ExecFlag=false;
			Text Address;
			with(Item.TYPE) switch(item.type()) {
				case NORMAL:
					Address  = item.address;
					ExecFlag = true;
					break;
				case URI:
					Address  = item.uri;
					ExecFlag = true;
					break;
				case MULTI:
					foreach(IDs; item.multi) {
						ExecuteItem(new Item(IDs, this.itemBase()), OverInfo);
					}
					break;
				case LINK:
					ExecuteItem(new LinkItem(item, this.itemBase()), OverInfo);
					break;
				default:
					assert(false);
			}
			version(unittest) {
				if(!ExecFlag) assert(!Address.length);
			}
			struct OverrideFlag {
				bool WorkFolder;
				bool Option;
				bool Show;
			}
			OverrideFlag of;
			// 実行
			if(ExecFlag) {
				Text   WorkFolder = GetWorkFolder(item, this.itemBase());
				Text   Option     = item.option;
				SHOW Show       = item.show;
				
				if(OverInfo) {
					// 作業フォルダ情報上書き
					if((OverInfo.Mask & OverrideInfo.MASK.WORK) == OverrideInfo.MASK.WORK) {
						WorkFolder = OverInfo.WorkFolder;
						of.WorkFolder = true;
					}
					// コマンドラインオプション情報上書き
					if((OverInfo.Mask & OverrideInfo.MASK.OPTION) == OverrideInfo.MASK.OPTION) {
						Option = OverInfo.Option;
						of.Option = true;
					}
					// 表示情報上書き
					if((OverInfo.Mask & OverrideInfo.MASK.SHOW) == OverrideInfo.MASK.SHOW) {
						Show = OverInfo.Show;
						of.Show = true;
					}
				}
				
				if(FILE.isExistence(Address)) {
					if(FILE.isFile(Address)) {
						FileExecute(
							Address,
							Option,
							WorkFolder,
							Show,
							AppData.folder == FOLDER.EXPLORER,
							null
						);
					} else {
						enforce(FILE.isFolder(Address), new NemuxiException("どないせーと"));
						if(AppData.folder == FOLDER.PROGRAM) {
							assert(FolderItem);
							OverrideInfo ofTemp;
							ofTemp.Mask       = OverrideInfo.MASK.WORK | OverrideInfo.MASK.OPTION | OverrideInfo.MASK.SHOW;
							ofTemp.WorkFolder = WorkFolder.toString;
							ofTemp.Option     = Address.quot('"').toString;
							ofTemp.Show       = Show;
							ExecuteItem(FolderItem, &ofTemp);
						} else {
							FolderExecute(Address, AppData.folder, Show, null);
						}
					}
				} else {
					FileExecute(
						Address,
						Option,
						WorkFolder,
						Show,
						AppData.folder == FOLDER.EXPLORER,
						null
					);
				}
			}
			
		}
		try {
			ExecuteItem(item, OverInfo);

			// 実行情報設定。
			// 日時とか使用回数とかその辺の情報
			// OverrideInfo情報は設定しない。
			item.historyLast = new ItemDateTime();
			item.historyUse  = item.historyUse + 1;
			
		} catch(Exception e) {
			throw new NemuxiException(
				format(
					"アイテム(%s)実行例外",
					item.itemID
				),
				EC.NONE,
				e
			);
		}
	}
	
	/**
	パスの実行。

	History:
		1.00β11:
			引数をinに。
	*/
	void executePath(in Text path) {
		try {
			if(FILE.isFile(path)) {
				FileExecute(path, Text.emptyText, Text.emptyText, SHOW.SHOWNORMAL, AppData.folder == FOLDER.EXPLORER);
			} else {
				if(AppData.folder == FOLDER.PROGRAM) {
					assert(FolderItem);
					OverrideInfo OverInfo;
					OverInfo.Mask   = OverrideInfo.MASK.OPTION | OverrideInfo.MASK.SHOW;
					OverInfo.Option = path.quot('"').toString();
					OverInfo.Show   = SHOW.SHOWNORMAL;
					this.executeItem(FolderItem, &OverInfo);
				} else {
					FolderExecute(path, AppData.folder, SHOW.SHOWNORMAL, null);
				}
			}
		} catch(FileException e) {
			Logger.write(e);
			FileExecute(path, Text.emptyText, Text.emptyText, SHOW.SHOWNORMAL, AppData.folder == FOLDER.EXPLORER);
		}
	}
	/+
	debug(this) unittest {
		auto a=MakeApplication();
		a.executeItem(new Item(`z`,a.itemBase), OverInfo);
	}
	+/

	bool isAppDeskTopToolBar(App.POSITION Position) {
		with(App.POSITION) return !(Position == FLOAT || Position == SMALL);
	}
	
		/+
	void setNemuxiPosition(HWND hWnd, App.POSITION Position, UINT CallBackMessage=0)
	in {
		assert(hWnd);
		if(this.isAppDeskTopToolBar(Position)) {
			assert(CallBackMessage >= WM_APP);
		}
	}
	body {
		auto window=new Window(hWnd);
		if(this.isAppDeskTopToolBar(AppData.position)) {
			// 現在有効なら一旦登録解除
			UnRegistAppDeskTopToolBar(hWnd);
		}
		//
		if(this.isAppDeskTopToolBar(Position)) {
			// タイトルバー無効化
			window.showTitleBar(false);
			// 登録
			RegistAppDeskTopToolBar(hWnd, Position);
		} else if(Position == App.POSITION.FLOAT) {
			// 窓型ならタイトルバー有効化
			window.showTitleBar(true);
		}
		with(App.POSITION) switch(Position) {
			case LEFT:
				break;
			case TOP:
				break;
			case RIGHT:
				break;
			case BOTTOM:
				break;
			case FLOAT:
				break;
			case SMALL:
				break;
			default:
				assert(false);
		}
	}
		+/
}

/**
Applicationの生成と保存。。

Exception:
	ぐっだぐだになったらNemuxiExceptionを投げる。
*/
Application MakeApplication() {
	auto app=new Application();
	Text DataFolder=StaticData.dataFolder();
	//Text UserFolder=GetUserFolder();
	
	//MakeFolder(UserFolder);
	//UserFolder = PathAddSep(UserFolder);

	//MessageBox(null, UserFolder.ptr, null, 0);

	/+
	Text AppFile   = UserFolder ~ "app.aki";
	Text GroupFile = UserFolder ~ "groups.aki";
	Text ItemsFile = UserFolder ~ "items.aki";
	+/
	Text AppFile   = PATH.addFolderSep(StaticData.dataFolder) ~ StaticData.applicationDataFile;
	Text ItemsFile = PATH.addFolderSep(StaticData.dataFolder) ~ StaticData.itemDataFile;
	Text GroupFile = PATH.addFolderSep(StaticData.dataFolder) ~ StaticData.groupDataFile;

	app.readApp(AppFile);
	app.readGroups(GroupFile);
	app.readItems(ItemsFile);
	
	if(app.AppData.folder == FOLDER.PROGRAM) {
		try {
			app.FolderItem = new Item(app.AppData.folderProgram, app.itemBase);
		} catch(Exception e) {
			Logger.write(e);
			app.AppData.folder = FOLDER.NORMAL;
		}
	}

	return app;
}
debug(application) unittest {
	auto a=MakeApplication;
	/+
	a.AppData.exeButtonText=true;
	a.AppData.exeButtonIcon=ICONSIZE.NORMAL;
	wl(a.SubGroup);
	SIZE n;
	a.getExeButtonSize(n);
	wl("w=%s", n.cx);
	wl("h=%s", n.cy);
	auto groups=a.initExeButtonGroup;
	wl(groups);
	foreach(ppp; a.GetItems(groups[0], groups[1])) with(ppp){
		wl("name=", name);
		wl("icon=", icon);
		wl("live=", live);
	}
	+/
	/+
	wl(a.changeMainGroup("いろいろ"));
	wl(a.changeSubGroup("ブラウザ・ビューア"));
	wl(a.changeMenuGroup("bb"));
	string b,c;
	a.getButtonGroupName(2, 1, b, c);
	wl(b);
	wl(c);
	+/
	//a.executeItem(new Item("firefox", a.itemBase));
	//a.executeItem(new Item("iii", a.itemBase));
}
/// ditto
void SaveApplication(Application app) {
	Text DataFolder=StaticData.dataFolder();
	
	FILE.makeFolder(DataFolder);

	Text AppFile   = PATH.addFolderSep(StaticData.dataFolder) ~ StaticData.applicationDataFile;
	Text ItemsFile = PATH.addFolderSep(StaticData.dataFolder) ~ StaticData.itemDataFile;
	Text GroupFile = PATH.addFolderSep(StaticData.dataFolder) ~ StaticData.groupDataFile;
	
	app.writeApp(AppFile);
	app.writeItems(ItemsFile);
	app.writeGroup(GroupFile);
}


