﻿/**
ﾈﾑぃ

Version
	1.00β11

History:
	[V]:
		設定画面における「OK」と「CANCEL」の位置を入れ替え。
		メインウィンドウがバー状態でもタイトルバーD&Dによる移動が許可されていたバグの修正。
		メインウィンドウがバー状態の際に特定方向のみへサイズ変更するようにヒットテスト修正。
		アイテムの設定で「アドレスに合わせる」を実装。

	1.00β11, 2009/08/24:
		アイコン取得時にアドレスがDLLだった場合にアイコンインデックスが無視される不具合を修正。
		アイコン入力欄を入力可能に変更。
		アイテムメニューにおいて拡張子無しのファイル(と.無しフォルダ)が存在する場合に落ちるバグを修正。
		バージョン情報ダイアログ暫定実装。
		フォルダオープン時にエクスプローラ表示が無視されていた不具合を修正。
	
	1.00β10, 2009/08/19:
		公開。
*/
module nemuxi.nemuxi;

version(build) {
	pragma(build_def, "EXETYPE NT");
	pragma(build_def, "SUBSYSTEM WINDOWS,5.0");
}

import win32.windows;
import win32.commctrl;

import nemuxi.base;
import nemuxi.system.application;
//import nemuxi.negui.proc.nemuxiwnd.nemuxiwnd;
import nemuxi.gui.window.nemuxiwindow.nemuxiwindow;
import nemuxi.negui.window.dialog.system;
//import nemuxi.negui.proc.commandwnd.commandwnd;
import nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;


/**
History:
	[V]:
		設定ファイルの書き込みタイミングを変更。

	1.00β11:
		例外catchの悪足掻きを追加。
*/
int main(string[] args) {
	//debug Logger.flag=true;
	//Logger.flag=StaticData.logEnable;
	
	try {
		auto hWnd=new NemuxiWindow(MakeApplication());
		
		try {
			scope(success) SaveApplication(hWnd.application);
			Logger.write("args -> %s", args);
			
			hWnd.dataLoad;
			auto ret=hWnd.execute();
			return ret;
		} catch(NemuxiException e) {
			Logger.write(e);
			ShowExceptionDialog(hWnd, e);
			return e.code;
		}
	} catch (Throwable e) {
		Logger.write(e);
		ShowExceptionDialog(null, e);
		return -1;
	} catch(Object o) {
		Logger.write(o);
		MessageDialog.show(o.toString.toText);
		return -2;
	}

}

