﻿/**

*/
module nemuxi.negui.window.newindow;

debug import std.stdio: wl = writefln, pl = printf;
debug(newindow) void main() {}

import win32.windows;

import nemuxi.base;
public import nemuxi.negui.negui;
//public import nemuxi.negui.event;
public import nemuxi.negui.window.window;
public import nemuxi.negui.dropfile;
public import nemuxi.negui.layout.layout;
import nemuxi.negui.window.dialog.dialog;
public import nemuxi.negui.keyboard.accelerator;


private immutable NEGUICLASS = "NeGuiWindow"w;
static this() {
	WNDCLASSEX WndClass;

	with(WndClass) {
		cbSize          = WndClass.sizeof;
		style           = CS_HREDRAW | CS_SAVEBITS | CS_VREDRAW;
		lpfnWndProc     = &NeWindow.NeGuiEventProc;
		cbClsExtra      = 0;
		//cbWndExtra      = DLGWINDOWEXTRA;
		hInstance       = GetModuleHandle(null);
		hIcon = hIconSm = LoadIcon(hInstance, IDI_APPLICATION);
		hCursor         = LoadCursor(NULL, IDC_ARROW);
		hbrBackground   = cast(HBRUSH)COLOR_BTNFACE+1;
		lpszMenuName    = null;
		lpszClassName   = NEGUICLASS.ptr;
	}
	if(!RegisterClassEx(&WndClass)) {
		throw new NeWindowError("ウィンドウクラス登録失敗, " ~ Err.toString);
	}
}



///
abstract class NeWindow: Window {
	protected override this(GUIINFO* NeGuiInfo) {
		NeGuiInfo.ClassName = NEGUICLASS;
		super(NeGuiInfo);
	}

	mixin NeGuiDestructor;

	mixin NeGuiEvent;

	mixin MixInNeGuiEventProc!(NeWindow);
}

deprecated extern(Windows) LRESULT NeWndProc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam) {
	/+
	auto NeGuiObject = cast(NeWindow)NeGui.getGui(hWnd);
	if(!NeGuiObject && Message != WM_CREATE) {
		return DefWindowProc(hWnd, Message, wParam, lParam);
	}
	+/
	mixin(EVENTLOOP.ProcTop!(NeWindow));
	
	switch(Message) {
		case WM_CREATE: {
			/+
			assert(!NeGuiObject);
			try {
				NeGuiObject = cast(NeWindow)
				cast(void*)(cast(CREATESTRUCT*)lParam).lpCreateParams;
				NeGuiObject.hItem = hWnd;
				NeGuiObject.guiObject(NeGuiObject);
				NeGuiObject.layoutManager=new LayoutManager(NeGuiObject);
				NeGuiObject.OnCreate();
			} catch(Exception e) {
				Logger.write(e);
				return -1;
			}
			return 0;
			+/
			mixin(EVENTLOOP.WM_CREATE!(NeWindow));
		}
		
		case WM_SIZE: {
			/+
			if(NeGuiObject) {
				if(NeGuiObject.layoutManager) {
					NeGuiObject.layoutManager.onSize(LOWORD(lParam), HIWORD(lParam));
				}
				NeGuiObject.OnSize(LOWORD(lParam), HIWORD(lParam));
			} else {
				goto default;
			}
			return 0;
			+/
			mixin(EVENTLOOP.WM_SIZE());
		}
		
		case WM_SIZING: {
			/+
			NeGuiObject.OnSizing(cast(SIDEFLAG)wParam, cast(RECT*)lParam);
			return 0;
			+/
			mixin(EVENTLOOP.WM_SIZING());
		}
		case WM_MOVING: {
			/+
			NeGuiObject.OnMoving(cast(SIDEFLAG)wParam, cast(RECT*)lParam);
			return 0;
			+/
			mixin(EVENTLOOP.WM_MOVING());
		}
		case WM_ENTERSIZEMOVE: {
			/+
			NeGuiObject.OnEnterSizeMove();
			goto default;
			+/
			mixin(EVENTLOOP.WM_ENTERSIZEMOVE());
		}
		case WM_EXITSIZEMOVE: {
			/+
			NeGuiObject.OnExitSizeMove();
			goto default;
			+/
			mixin(EVENTLOOP.WM_EXITSIZEMOVE());
		}
		case WM_WINDOWPOSCHANGING: {
			/+
			NeGuiObject.OnWindowPosChanging(cast(WINDOWPOS*)lParam);
			goto default;
			+/
			mixin(EVENTLOOP.WM_WINDOWPOSCHANGING());
		}
		case WM_WINDOWPOSCHANGED: {
			/+
			NeGuiObject.OnWindowPosChanged(cast(WINDOWPOS*)lParam);
			goto default;
			+/
			mixin(EVENTLOOP.WM_WINDOWPOSCHANGED());
		}
		case WM_GETMINMAXINFO: {
			/+
			auto info=cast(MINMAXINFO*)lParam;
			if(NeGuiObject && NeGuiObject.OnMinMax(&info.ptMaxSize, &info.ptMaxPosition, &info.ptMaxTrackSize, &info.ptMinTrackSize)) {
				return 0;
			} else {
				goto default;
			}
			+/
			mixin(EVENTLOOP.WM_GETMINMAXINFO());
			
		}
		case WM_CLOSE: {
			/+
			if(NeGuiObject.OnClose()) {
				NeGuiObject.destroy;
			}
			return 0;
			+/
			mixin(EVENTLOOP.WM_CLOSE());
		}
		case WM_DESTROY: {
			/+
			NeGuiObject.OnDestroy();
			return 0;
			+/
			mixin(EVENTLOOP.WM_DESTROY());
		}
		case WM_ACTIVATE: {
			/+
			NeGuiObject.OnActive(cast(WA)LOWORD(wParam), cast(bool)HIWORD(wParam), cast(HWND)lParam);
			return 0;
			+/
			mixin(EVENTLOOP.WM_ACTIVATE());
		}
		case WM_ACTIVATEAPP: {
			/+
			NeGuiObject.OnActiveOther(wParam == TRUE ? true: false, cast(HANDLE)lParam);
			return 0;
			+/
			mixin(EVENTLOOP.WM_ACTIVATEAPP());
		}
		case WM_MEASUREITEM: {
			/+
			//auto i=cast(MEASUREITEMSTRUCT*)lParam;
			//NeGuiObject.OnMeasureItem(cast(MEASUREITEMSTRUCT*)lParam);
			NeGuiObject.OnMeasureItem(cast(MEASUREITEM*)lParam);
			return 1;
			+/
			mixin(EVENTLOOP.WM_MEASUREITEM());
		}
		case WM_DRAWITEM: {
			/+
			NeGuiObject.OnDrawItem(cast(DRAWITEM*)lParam);
			return 1;
			+/
			mixin(EVENTLOOP.WM_DRAWITEM());
		}
		case WM_INITMENU: {
			/+
			if(NeGuiObject.OnInitMenu(cast(HMENU)wParam)) {
				return 0;
			} else {
				goto default;
			}
			+/
			mixin(EVENTLOOP.WM_INITMENU());
		}
		case WM_INITMENUPOPUP: {
			/+
			if(NeGuiObject.OnInitPupUpMenu(cast(ITEM_ID)LOWORD(lParam), cast(bool)HIWORD(lParam), cast(HMENU)wParam)) {
				return 0;
			} else {
				goto default;
			}
			+/
			mixin(EVENTLOOP.WM_INITMENUPOPUP());
		}
		case WM_MENUSELECT: {
			/+
			NeGuiObject.OnMenuSelect(cast(ITEM_ID)LOWORD(wParam), cast(MF)HIWORD(wParam), cast(HMENU)lParam);
			return 0;
			+/
			mixin(EVENTLOOP.WM_MENUSELECT());
		}
		case WM_COMMAND: {
			/+
			if(NeGuiObject.OnCommand(cast(ITEM_ID)LOWORD(wParam), cast(MESSAGETYPE)HIWORD(wParam), NeGui.getGui(cast(HWND)lParam))) {
				return 0;
			} else {
				goto default;
			}
			+/
			mixin(EVENTLOOP.WM_COMMAND());
		}
		case WM_CONTEXTMENU: { // ものすごい不安。
			/+
			NeGuiObject.OnContexMenu(NeGui.getGui(cast(HWND)wParam), LOWORD(lParam), HIWORD(lParam));
			return 0;
			+/
			mixin(EVENTLOOP.WM_CONTEXTMENU());
		}
		case WM_NCHITTEST: {
			//return NeGuiObject.OnNcHitTest(cast(HT)DefWindowProc(hWnd, WM_NCHITTEST, wParam, lParam), LOWORD(lParam), HIWORD(lParam));
			mixin(EVENTLOOP.WM_NCHITTEST());
		}
		case WM_ENABLE: {
			/+
			NeGuiObject.OnEnable(cast(bool)wParam);
			return 0;
			+/
			mixin(EVENTLOOP.WM_ENABLE());
		}
		case WM_MOUSEMOVE: {
			/+
			POINT Pos;
			Pos.x = cast(short)LOWORD(lParam);
			Pos.y = cast(short)HIWORD(lParam);
			
			if(!NeGuiObject.HoverFlag) {
				TRACKMOUSEEVENT TrackEvent;
				TrackEvent.cbSize      = TrackEvent.sizeof;
				TrackEvent.dwFlags     = TME_LEAVE | TME_HOVER;
				TrackEvent.hwndTrack   = hWnd;
				TrackEvent.dwHoverTime = HOVER_DEFAULT;
				
				if(TrackMouseEvent(&TrackEvent) == 0)
					throw new NeWindow(Text("WM_MOUSEMOVEイベントでミス"));
				
				NeGuiObject.HoverFlag = true;
				//Pos = Point(cast(short)LOWORD(lParam), cast(short)HIWORD(lParam));
				NeGuiObject.OnMouseOver(cast(MOUSE_KEY)wParam, Pos.x, Pos.y);
			}
			NeGuiObject.OnMouseMove(cast(MOUSE_KEY)wParam, Pos.x, Pos.y);
			return 0;
			+/
			mixin(EVENTLOOP.WM_MOUSEMOVE());
		}
		case WM_MOUSELEAVE: {
			/+
			NeGuiObject.HoverFlag = false;
			NeGuiObject.OnMouseLeave(cast(MOUSE_KEY)wParam, cast(short)LOWORD(lParam), cast(short)HIWORD(lParam));
			return 0;
			+/
			mixin(EVENTLOOP.WM_MOUSELEAVE());
		}
		case WM_MOUSEHOVER: {
			/+
			NeGuiObject.OnMouseHover(cast(MOUSE_KEY)wParam, cast(short)LOWORD(lParam), cast(short)HIWORD(lParam));
			return 0;
			+/
			mixin(EVENTLOOP.WM_MOUSEHOVER());
		}

		case WM_LBUTTONDOWN, WM_RBUTTONDOWN, WM_MBUTTONDOWN: {
			/+
			SetCapture(hWnd); // キャプチャはどのタイミングでやんのか分からん。
			
			NeGuiObject.MouseEvent OnMouse=void;
			
			switch(Message) {
				case WM_LBUTTONDOWN:
					OnMouse = &NeGuiObject.OnMouseLeftDown;
					break;
				case WM_RBUTTONDOWN:
					OnMouse = &NeGuiObject.OnMouseRightDown;
					break;
				case WM_MBUTTONDOWN:
					OnMouse = &NeGuiObject.OnMouseMiddleDown;
					break;
				default:
					assert(false);
			}
			NeGuiObject.ClickPos.x = cast(short)LOWORD(lParam);
			NeGuiObject.ClickPos.y = cast(short)HIWORD(lParam);
			if(OnMouse(cast(MOUSE_KEY)LOWORD(wParam), NeGuiObject.ClickPos.x, NeGuiObject.ClickPos.y)) {
				return 0;
			} else {
				goto default;
			}
			+/
			mixin(EVENTLOOP.WM_BUTTONDOWN());
		}
		case WM_LBUTTONUP, WM_RBUTTONUP, WM_MBUTTONUP: {
			/+
			scope(exit) ReleaseCapture();
			
			NeGuiObject.MouseEvent OnMouseClick=void;
			NeGuiObject.MouseEvent OnMouseUp=void;

			NeGuiObject.CLICKPOS Pos;
			Pos.x = cast(short)LOWORD(lParam);
			Pos.y = cast(short)HIWORD(lParam);

			switch(Message) {
				case WM_LBUTTONUP:
					OnMouseClick = &NeGuiObject.OnMouseLeftClick;
					OnMouseUp    = &NeGuiObject.OnMouseLeftUp;
					break;
				case WM_RBUTTONUP:
					OnMouseClick = &NeGuiObject.OnMouseRightClick;
					OnMouseUp    = &NeGuiObject.OnMouseRightUp;
					break;
				case WM_MBUTTONUP:
					OnMouseClick = &NeGuiObject.OnMouseMiddleClick;
					OnMouseUp    = &NeGuiObject.OnMouseMiddleUp;
					break;
				default:
					assert(false);
			}
			if(NeGuiObject.ClickPos == Pos) {
				OnMouseClick(cast(MOUSE_KEY)LOWORD(wParam), Pos.x, Pos.y);
			}
			if(OnMouseUp(cast(MOUSE_KEY)LOWORD(wParam), Pos.x, Pos.y)) {
				NeGuiObject.ClickPos = NeGuiObject.ClickPos.init;
				return 0;
			} else {
				goto default;
			}
			+/
			mixin(EVENTLOOP.WM_BUTTONUP());
		}
		case WM_LBUTTONDBLCLK, WM_RBUTTONDBLCLK, WM_MBUTTONDBLCLK: {
			/+
			NeGuiObject.MouseEvent OnMouse=void;
		
			switch(Message) {
				case WM_LBUTTONDBLCLK:
					OnMouse = &NeGuiObject.OnMouseLeftDoubleClick;
					break;
				case WM_RBUTTONDBLCLK:
					OnMouse = &NeGuiObject.OnMouseRightDoubleClick;
					break;
				case WM_MBUTTONDBLCLK:
					OnMouse = &NeGuiObject.OnMouseMiddleDoubleClick;
					break;
				default:
					assert(false);
			}
			
			if(OnMouse(cast(MOUSE_KEY)LOWORD(wParam), cast(short)LOWORD(lParam), cast(short)HIWORD(lParam))) {
				return 0;
			} else {
				goto default;
			}
			+/
			mixin(EVENTLOOP.WM_BUTTONDBLCLK());
		}
		case WM_MOUSEWHELL: {
			/+
			NeGuiObject.MouseEvent OnMouse=void;

			if(cast(short)HIWORD(wParam) > 0) {
				OnMouse = &NeGuiObject.OnMouseWhellUp;
			} else {
				OnMouse = &NeGuiObject.OnMouseWhellDown;
			}

			if(OnMouse(cast(MOUSE_KEY)LOWORD(wParam), cast(short)LOWORD(lParam), cast(short)HIWORD(lParam))) {
				return 0;
			} else {
				goto default;
			}
			+/
			mixin(EVENTLOOP.WM_MOUSEWHELL());
		}
			// IKeyEvent
		case WM_KEYDOWN: {
			/+
			auto KeyData=KEYDATA(lParam);
			if(KeyData.prev) {
				NeGuiObject.OnKeyPress(cast(KEY)wParam, KeyData);
			} else {
				NeGuiObject.OnKeyDown(cast(KEY)wParam, KeyData);
			}
			return 0;
			+/
			mixin(EVENTLOOP.WM_KEYDOWN());
		}
		case WM_KEYUP: {
			/+
			NeGuiObject.OnKeyUp(cast(KEY)wParam, cast(KEYDATA)lParam);
			return 0;
			+/
			mixin(EVENTLOOP.WM_KEYDOWN());
		}
		case WM_DROPFILES: {
			/+
			scope drop=new DropFile(cast(HDROP)wParam, true);
			NeGuiObject.OnDropFiles(drop);
			+/
			mixin(EVENTLOOP.WM_DROPFILES());
		}
		case WM_PAINT: {
			/+
			PAINTSTRUCT Paint;
			/*
			scope canvas=new Canvas(BeginPaint(hWnd, &Paint), false);
			assert(!canvas.suicide);
			scope(exit) EndPaint(hWnd, &Paint);
			*/
			scope canvas=NeGuiObject.beguinPaint(&Paint);
			scope(exit) NeGuiObject.endPaint(&Paint);

			if(NeGuiObject.OnPaint(canvas, &Paint.rcPaint, Paint.fErase == 1 ? true: false)) {
				return 0;
			} else {
				goto default;
			}
			+/
			mixin(EVENTLOOP.WM_PAINT());
		}
		case WM_PRINT: {
			/+
			scope canvas=new Canvas(cast(HDC)wParam, false);
			/*
			if(FontData)
				canvas.setFont = FontData;
			*/

			if(NeGuiObject.OnPrint(canvas, cast(PRF)lParam)) {
				return 0;
			} else {
				goto default;
			}
			+/
			mixin(EVENTLOOP.WM_PRINT());
		}
		case WM_ERASEBKGND: {
			/+
			scope canvas=new Canvas(cast(HDC)wParam, false);
			auto dg=NeGuiObject.OnEraseBackGround(canvas);
			if(dg) {
				return cast(LRESULT)dg();
			} else {
				goto default;
			}
			+/
			mixin(EVENTLOOP.WM_ERASEBKGND());
		}
		
		case WM_HOTKEY: {
			/+
			NeGuiObject.OnHotKey(cast(HOTKEY_ID)wParam, cast(HOTKEY)LOWORD(lParam), cast(KEY)HIWORD(lParam));
			return 0;
			+/
			mixin(EVENTLOOP.WM_HOTKEY());
		}
		
		case WM_TIMER: {
			/+
			NeGuiObject.OnTimer(cast(TIMER_ID)wParam);
			return 0;
			+/
			mixin(EVENTLOOP.WM_TIMER());
		}

		case WM_NOTIFY: {
			/+
			if(auto NotifyCode=NeGuiObject.OnNotify(cast(ITEM_ID)wParam, cast(NOTIFY*)lParam)) {
				return NotifyCode;
			} else {
				goto default;
			}
			+/
			mixin(EVENTLOOP.WM_NOTIFY());
		}
		
		case WM_DISPLAYCHANGE: {
			/+
			NeGuiObject.OnDisplayChange(wParam, LOWORD(lParam), HIWORD(lParam));
			goto default;
			+/
			mixin(EVENTLOOP.WM_DISPLAYCHANGE());
		}

		/+
		// この子どうしよう…
		case WM_PARENTNOTIFY: {
			switch(LOWORD(wParam)) {
				case WM_CREATE:
					//NeGuiObject.OnChildCreate(cast(HWND)lParam);
					break;
				case WM_DESTROY:
					NeGuiObject.OnChildDestroy(NeGui.getGui(cast(HWND)lParam));
					break;
				case WM_LBUTTONDOWN:
					//NeGuiObject.OnChildMouseLeftDown(cast(short)LOWORD(lParam), cast(short)HIWORD(lParam));
					break;
				case WM_MBUTTONDOWN:
					//NeGuiObject.OnChildMouseMiddleDown(cast(short)LOWORD(lParam), cast(short)HIWORD(lParam));
					break;
				case WM_RBUTTONDOWN:
					//NeGuiObject.OnChildMouseRightDown(cast(short)LOWORD(lParam), cast(short)HIWORD(lParam));
					break;
				default:
					assert(false);
			}
			goto default;
		}
		+/
		case WM_PARENTNOTIFY: {
			/+
			NeGuiObject.OnChild(wParam, lParam);
			goto default;
			+/
			mixin(EVENTLOOP.WM_PARENTNOTIFY());
		}

		default:
			/+
			if(NeGuiObject && NeGuiObject.OnOtherEvent(Message, wParam, lParam)) {
				return 0;
			} else {
				break;
			}
			+/
			mixin(EVENTLOOP.WM_DEFAULT());
	}
	//return DefWindowProc(hWnd, Message, wParam, lParam);
	mixin(EVENTLOOP.WM_LAST!(NeWindow)());
}

