﻿/**

*/
module nemuxi.negui.window.menu.ownerdraw;

debug import std.stdio: wl = writefln, pl = printf;

debug(ownerdraw) void main() {}

debug import std.string;

import win32.windows;

import nemuxi.base;
import nemuxi.system.raii;
import nemuxi.negui.draw.canvas;
import nemuxi.negui.draw.color;
import nemuxi.negui.draw.brush;
import nemuxi.image.icon;
import nemuxi.image.font;
import nemuxi.negui.draw.unit;
import nemuxi.negui.negui;
import nemuxi.negui.control.control;
public import nemuxi.negui.window.menu.menu;
public import nemuxi.negui.window.menu.popup;

///
struct DRAWMENUITEM {
	Text text; /// 表示文字列
	Icon icon; /// 表示アイコン
	wchar key; /// アクセスキー。
	//KEY key;

	debug string toString() {
		return format("[%s]%s", key, text);
	}
}

/**
オーナードローを少しだけ補助。
描画に必要そうなDRAWMENUITEMをIDと関連付けて保持と共にdwTypeDataにDRAWMENUITEMを設定。
*/
class OwnerDrawMenu: PopUp {
	invariant() {
		assert(PxSize == GetIconSize(IconSize));
	}
	protected {
		/// 対GC。Killの対象注意
		DRAWMENUITEM[COMMAND_ID] DrawItems;
		/// アイコンサイズ。
		ICONSIZE IconSize;
		/// アイコンサイズに対応するピクセルサイズ。
		int PxSize;
		/+
		/// 最大サイズ
		SIZE MaxSize;
		+/
	}

	
	DRAWMENUITEM[] GetKeyItem(wchar c) {
		DRAWMENUITEM[] items;
		foreach(DrawItem; DrawItems) {
			if(DrawItem.key == c) {
				items ~= DrawItem;
			}
		}
		return items;
	}
	

	this(ICONSIZE IconSize) {
		this.IconSize = IconSize;
		PxSize = GetIconSize(IconSize);
		super();
	}

	void iconSize(ICONSIZE IconSize) {
		this.IconSize = IconSize;
		PxSize = GetIconSize(IconSize);
	}
	ICONSIZE iconSize() {
		return IconSize;
	}

	override void Kill() {
		if(super.Suicide) {
			auto Values=this.DrawItems.values;
			foreach(key; this.DrawItems.keys) {
				this.DrawItems.remove(key);
			}
			foreach(DrawItem; Values) {
				delete DrawItem.icon;
				delete DrawItem.text.text;
			}
			this.DrawItems = null;
			
		}
		super.Kill();
	}

	///
	bool insert(ref const(MENUITEM) MenuItem, DRAWMENUITEM* DrawItem) {
		if(super.insert(MenuItem)) {
			if(DrawItem) {
				DrawItems[MenuItem.id] = *DrawItem;
			}
			
			return true;
		}

		return false;
	}

	bool isDrawItem(COMMAND_ID Id) {
		return (Id in DrawItems) !is null;
	}
	// 保持しているDRAWMENUITEMの参照。
	DRAWMENUITEM* opIndex(COMMAND_ID Id)
	in {
		assert(isDrawItem(Id));
	}
	body {
		return &DrawItems[Id];
	}

	/**
	オーナードロー描画準備。
	*/
	void measureItem(NeGui gui, MEASUREITEM* MeasureItem) {
		assert(this.isDrawItem(MeasureItem.commandID), "設計ミス１");
		
		invariant IconWidth =PxSize + GetSystemMetrics(SM_CXEDGE)*2;
		invariant IconHeight=PxSize + GetSystemMetrics(SM_CYEDGE)*2;
		
		auto ItemData  =DrawItems[MeasureItem.commandID];

		scope font=GetSystemFont(SYSFONT.MENU);
		scope canvas=gui.canvas();//new Canvas(new NeGui(hWnd));
		canvas.setFont(font);
		SIZE Size=void;
		canvas.getTextArea(ItemData.text, Size);
		MeasureItem.width  = IconWidth + Size.cx;
		MeasureItem.height = GetMenuHeight(IconHeight);

		/+
		// 再計算しない用
		if(MaxSize.cx < MeasureItem.itemWidth) {
			MaxSize.cx = MeasureItem.itemWidth;
		}
		if(MaxSize.cy < MeasureItem.itemHeight) {
			MaxSize.cy = MeasureItem.itemHeight;
		}
		+/
	}
	/**
	オーナードロー描画。
	*/
	void drawItem(DRAWITEM* DrawItem) {
		assert(this.isDrawItem(DrawItem.commandID), "設計ミス２");
		
		invariant IconWidth =PxSize + GetSystemMetrics(SM_CXEDGE)*2;
		invariant IconHeight=PxSize + GetSystemMetrics(SM_CYEDGE)*2;
		
		auto ItemData  =DrawItems[DrawItem.commandID];

		SYSTEMCOLOR TextColor;
		SYSTEMCOLOR BackColor;

		if(DrawItem.state & DRAWITEM.STATE.SELECTED) {
			if(DrawItem.state & DRAWITEM.STATE.DISABLED) {
				TextColor = SYSTEMCOLOR.MenuBack();
			} else {
				TextColor = SYSTEMCOLOR.SelectedText();
			}
			BackColor = SYSTEMCOLOR.SelectedBack();
		} else {
			TextColor = SYSTEMCOLOR.MenuText();
			BackColor = SYSTEMCOLOR.MenuBack();
		}
		
		scope back=new Brush(BackColor);
		scope font=GetSystemFont(SYSFONT.MENU);
		//scope canvas=new Canvas(DrawItem.hDC, false);
		scope canvas=DrawItem.canvas;
		canvas.textColor(cast(COLOR)TextColor);
		canvas.backMode(Canvas.BACKMODE.TR);
		canvas.setBrush(back);
		canvas.setFont(font);

		canvas.fillRect(DrawItem.rect);

		auto LineHeight=DrawItem.rect.bottom - DrawItem.rect.top;
		POINT IconPos=void;
		IconPos.x = DrawItem.rect.left + GetSystemMetrics(SM_CXEDGE);
		IconPos.y = DrawItem.rect.top  + LineHeight/2 - IconHeight/2 + GetSystemMetrics(SM_CYEDGE); // あとでかいぜん
		if(ItemData.icon) {
			/+
			if(DrawItem.itemState & ODS_DISABLED) {
				//canvas.drawState(ItemData.icon, &IconPos, PxSize, false);
			} else {
				canvas.drawIcon(ItemData.icon, &IconPos, PxSize, null);
			}
			+/
			canvas.drawIcon(ItemData.icon, &IconPos, PxSize, null);
			
		}

		IconPos.x += GetSystemMetrics(SM_CXEDGE) + PxSize;
		IconPos.y =  DrawItem.rect.top  + LineHeight/2 + (PointToPixel(font.height()))/2;
		canvas.drawState(
			ItemData.text,
			&IconPos,
			!(DrawItem.state & DRAWITEM.STATE.DISABLED),
			false
		);
		/+
		canvas.drawText(
			ItemData.text,
			&DrawItem.rcItem,
			Canvas.FORMAT.END_ELLIPSIS
			| Canvas.FORMAT.LEFT
			| Canvas.FORMAT.NOPREFIX
			| Canvas.FORMAT.SINGLELINE
			| Canvas.FORMAT.VCENTER
		);
		+/
	}

	static  enum MNC {
		IGNORE  = MNC_IGNORE , /// 押されたキーを破棄し、警告音を鳴らす(デフォルト)
		CLOSE   = MNC_CLOSE  , /// アクティブなメニューをクローズする
		EXECUTE = MNC_EXECUTE, /// 戻り値の下位ワードで指定するメニュー項目を破棄しオーナーウィンドウにWM_COMMANDを送る
		SELECT  = MNC_SELECT , /// 戻り値の下位ワードで指定するメニュー項目を選択する
	}

	version(none) {
	protected {
		wchar OldKey;
		size_t KeyConut;
	}
	
	LRESULT keyDown(wchar Key) {
		if(Key == OldKey) {
			KeyConut++;
		} else {
			KeyConut = 0;
		}
		auto di=GetKeyItem(Key);
		return 0;
	}
	}

	
}


