﻿/**
ダイアログ表示。

モーダルとモードレスの二通り。
*/
module nemuxi.negui.window.dialog.dialog;

debug import std.stdio: wl = writefln, pl = printf;
debug(dialog) void main() {}

debug public import core.memory;

import win32.windows;

import nemuxi.base;
public import nemuxi.negui.window.newindow;
public import nemuxi.negui.control.button.button;
public import nemuxi.negui.keyboard.accelerator;
import nemuxi.image.cursor;

/// モードレスダイアログの親ウィンドID。
invariant DIALOG_ID MAINLOOP_KEY=1; /// 特に指定しない場合の親ウィンドウID。
typedef int DIALOG_ID=MAINLOOP_KEY;


/**
ウィンドウのメッセージループ開始点設置用テンプレート。
*/
template Message() {
	/**
	モーダルループの開始。

	Params:
		DialogID = モーダルループ時の親。
		           同じ親を介す場合は同じIDに(たしかその設計)。

	Return:
		終了コード。
	*/
	INT loop(DIALOG_ID DialogID=MAINLOOP_KEY) {
		MSG Message;
		INT MessageRet;
		
		while((MessageRet = GetMessage(&Message, null, 0, 0)) != 0) {
			debug {
				GC.collect();
				GC.minimize();
			}

			if(MessageRet == -1) {
				return MessageRet;
			} else if(Accelerator.isTranslateAccelerator(this, &Message)) {
				continue;
			} else if(Modeless.isDialogMessage(DialogID, &Message)) {
				continue;
			} else if(IsDialogMessage(hWnd, &Message)) {
				continue;
			}
			
			TranslateMessage(&Message);
			DispatchMessage(&Message);
		}

		return MessageRet;
	}
	
}

/**
ダイアログ基底。

*/
abstract class Dialog: NeWindow {
	invariant() {
		assert(LoopOwnerID);
	}
	protected {
		immutable DIALOG_ID LoopOwnerID;
		NeWindow Owner;
	}
	/+
	this(HWND hWnd) {
		super(hWnd);
		//auto Parent=super.parent();
		this.Owner = new Window(super.parent()());
	}
	+/
	
	protected override this(GUIINFO* NeGuiInfo, DIALOG_ID LoopOwnerID=DIALOG_ID.init) {
		this.Owner       = cast(NeWindow)NeGuiInfo.Owner;
		this.LoopOwnerID = LoopOwnerID;
		super(NeGuiInfo);
	}
	
	
	/**
	親取得。
	
	NeGui.parentと違いNeWindowへアップキャスト可能であることが保障されている。
	*/
	override const NeGui parent() {
		return cast(NeGui)Owner;
	}

	/+
	INT modal() {
		MSG Message;
		INT MessageRet;

		while((MessageRet = GetMessage(&Message, null, 0, 0)) != 0) {
			if(MessageRet == -1) {
				debug wd(wf("内部エラー？"));
				return MessageRet;
			} else if(IsDialogMessage(hWnd, &Message)) {
				continue;
			}
			TranslateMessage(&Message);
			DispatchMessage(&Message);
		}

		return MessageRet;
	}
	+/

	void ownerEnable(bool Enable) {
		if(Owner && Owner.alive) {
			Owner.enable = Enable;
			//Owner.enable = Enable;
			if(Enable) {
				//SetForegroundWindow(Owner());
				Owner.foreGround();
				Owner.send(WM_NULL, NONE, NONE);
			}
		}
	}

	static enum WINDOWTYPE {
		POPUP = WS_POPUP,
		CHILD = WS_CHILD,
	}
	private mixin(ItemStyleGetSetMixStrEx!(WINDOWTYPE, DWORD)(
		"WindowType", false, [
		q{WINDOWTYPE.POPUP}, q{WINDOWTYPE.CHILD},
		q{WS_POPUP},         q{WS_CHILD}
	]));
	
	void toChild() {
		WindowType = WINDOWTYPE.CHILD;
		accelerator = null;
		SetParent(hWnd, parent()());
		caption = false;
		reLoad;
	}
	protected enum ACCELERATOR_DEFKEY: COMMAND_ID {
		EXECUTE = ushort.max-0,
		CANCEL  = ushort.max-1,
	}
	
	protected Accelerator AccelObject;
	Accelerator accelerator() {
		return AccelObject;
	}
	void accelerator(Accelerator Accel) {
		if(cast(bool)(AccelObject = Accel)) {
//			Accelerator.idRegist(LoopOwnerID, this, AccelObject);
			Accelerator.idRegist(this, AccelObject);
		} else {
			//Accelerator.idUnRegist(LoopOwnerID, this);
			Accelerator.idUnRegist(this);
		}
	}
	
	protected Push DefaultButton;
	Push defButton() {
		return DefaultButton;
	}
	void defButton(Push button) {
		DefaultButton = button;
	}
	protected override {
		void OnCreate() {
			ACCELERATOR Execute, Cancel;
			Execute.type    = ACCELERATOR.TYPE.VIRTKEY;
			Execute.key     = KEY.ENTER;
			Execute.command = ACCELERATOR_DEFKEY.EXECUTE;
			Cancel .type    = ACCELERATOR.TYPE.VIRTKEY;
			Cancel .key     = KEY.ESC;
			Cancel .command = ACCELERATOR_DEFKEY.CANCEL;

			accelerator = new Accelerator([Execute, Cancel]);
		}
		void OnDestroy() {
			if(accelerator) {
				accelerator(null);
			}
			delete AccelObject;
//			debug wl("%s(%s), %s", __FILE__, __LINE__, this.classinfo.name);
		}
		bool OnAccelerator(COMMAND_ID Id) {
			switch(Id) {
				case ACCELERATOR_DEFKEY.EXECUTE:
					if(DefaultButton) {
						DefaultButton.click;
						return true;
					} else {
						return false;
					}
				case ACCELERATOR_DEFKEY.CANCEL:
					return destroy;
				default:
					return false;
			}
		}
	}
}

deprecated template DialogClass() {
	override this(HWND hWnd) {
		super(hWnd);
	}
}


abstract class ModalDialog: Dialog {
	private mixin Message;

	
	protected override this(GUIINFO* NeGuiInfo, DIALOG_ID LoopOwnerID=DIALOG_ID.init) {
		super(NeGuiInfo, LoopOwnerID);
	}
	
	protected void ModalQuit(int ExitCode=0) {
		PostQuitMessage(ExitCode);
	}
	
	protected override {
		///
		void OnCreate() {
			super.OnCreate();
		}
		///
		void OnDestroy() {
			super.OnDestroy();
			ModalQuit(0);
		}
	}
	
	INT messageLoop(CENTER Center=CENTER.WINDOW) {
		ownerEnable(false);
		scope(exit) ownerEnable(true);

		toCenter(Center, parent);
		setShow(SHOW.SHOWNORMAL);
		
		if(DefaultButton) {
			SetOverAuto(DefaultButton);
		}
		auto n=loop(LoopOwnerID);
		return n;
	}
	
}

/**
モードレス用構造体。

曖昧な知識と変に汎用性を求めてよく分からないものの出来上がり。
*/
static struct Modeless {
	private static HWND[DIALOG_ID] hWnd;

	/// とりあえず作ったら登録。
	static void keyRegist(DIALOG_ID LoopOwnerID, Dialog DialogWindow)
	in {
		assert(LoopOwnerID);
		assert(DialogWindow);
	}
	body {
		hWnd[LoopOwnerID] = DialogWindow();
	}
	/// 登録解除
	static void keyUnRegist(DIALOG_ID LoopOwnerID)
	in {
		assert(LoopOwnerID);
	}
	body {
		hWnd[LoopOwnerID] = null;
		hWnd.remove(LoopOwnerID);
	}

	/// メッセージループで。
	static bool isDialogMessage(DIALOG_ID LoopOwnerID, MSG* Message)
	in {
		assert(LoopOwnerID);
		assert(Message);
	}
	body {
		if(LoopOwnerID in hWnd && hWnd[LoopOwnerID]) {
			return cast(bool)IsDialogMessage(hWnd[LoopOwnerID], Message);
		}
		return false;
	}

	/// ウィンドウプロシージャで。
	static void onActive(DIALOG_ID LoopOwnerID, ModelessDialog dialog, WA Active)
	in {
		assert(LoopOwnerID);
		assert(dialog);
	}
	body {
		if(LoopOwnerID in this.hWnd) {
			this.hWnd[LoopOwnerID] = Active == WA.ACTIVE ? dialog(): null;
		}
	}
}

abstract class ModelessDialog: Dialog {
	invariant() {
		assert(LoopOwnerID);
	}
	
	override this(GUIINFO* NeGuiInfo, DIALOG_ID LoopOwnerID) {
		super(NeGuiInfo, LoopOwnerID);
	}

	protected override {
		void OnCreate() {
			super.OnCreate();
			Modeless.keyRegist(LoopOwnerID, this);
		}
		void OnActive(WA Active, bool NotSmall, HWND NextWnd) {
			Modeless.onActive(LoopOwnerID, this, Active);
		}
		void OnDestroy() {
			Modeless.keyUnRegist(LoopOwnerID);
			super.OnDestroy();
		}
	}
}


