﻿/**
Application Desktop Toolbar

URI:
	参考というよりかはコピペ
	
	[タスクバーみたいなウインドウを作る　その１]http://hp.vector.co.jp/authors/VA016117/appbar1.html
	[タスクバーみたいなウインドウを作る　その２]http://hp.vector.co.jp/authors/VA016117/appbar2.html
*/
module nemuxi.negui.window.adtb;

debug import std.stdio: wl = writefln, pl = printf;

debug(adtb) void main() {}

import win32.windows;

import nemuxi.base;
import nemuxi.system.raii;
import nemuxi.negui.window.window;

/**
アプリケーションデスクトップツールバー登録。
*/
private bool RegistAppDeskTopToolBar(HWND hWnd, UINT CallBackMessage) {
	APPBARDATA AppbarData;

	AppbarData.cbSize           = AppbarData.sizeof;
	AppbarData.hWnd             = hWnd;
	AppbarData.uCallbackMessage = CallBackMessage;

	return SHAppBarMessage(ABM_NEW, &AppbarData)
		? true
		: false;
}
/**
アプリケーションデスクトップツールバー登録解除。
*/
private bool UnRegistAppDeskTopToolBar(HWND hWnd) {
	APPBARDATA AppbarData;

	AppbarData.cbSize           = AppbarData.sizeof;
	AppbarData.hWnd             = hWnd;

	return SHAppBarMessage(ABM_REMOVE, &AppbarData)
		? true
		: false;
}

class ApplicationDesktopToolBar: Raii {
	protected Window window;
	protected const UINT MessageID;

	override protected void Kill() {
		UnRegistAppDeskTopToolBar(window());
	}
	
	this(Window window, UINT MessageID) {
		super(true);
		
		this.window = window;
		this.MessageID = MessageID;

		RegistAppDeskTopToolBar(window(), MessageID);
	}
	
	///
	static enum ABE {
		LEFT   = ABE_LEFT,   /// 左
		TOP    = ABE_TOP,    /// 上
		RIGHT  = ABE_RIGHT,  /// 右
		BOTTOM = ABE_BOTTOM, /// 下
	}
	protected ABE Position;
	ABE position() {
		return Position;
	}
	void position(ABE Pos) {
		Position = Pos;

		//RECT Rect;
		SIZE Size;
		APPBARDATA AppbarData;

		SetAppbarData(&AppbarData);
		querySize(Size);
		queryPos(Position, &Size, &AppbarData);

		//最終的なサイズをシステムに伝える
		SHAppBarMessage(ABM_SETPOS, &AppbarData);

		//ウインドウの大きさを変える
		window.move(
			AppbarData.rc.left,
			AppbarData.rc.top, 
			AppbarData.rc.right  - AppbarData.rc.left,
			AppbarData.rc.bottom - AppbarData.rc.top,
			true
		);
	}
	
	void queryPos(ABE Abe, SIZE* Size, APPBARDATA* AppbarData) {
		AppbarData.uEdge = Abe; 

		AppbarData.rc.left   = 0;
		AppbarData.rc.top    = 0;
		AppbarData.rc.bottom = GetSystemMetrics(SM_CYSCREEN);
		AppbarData.rc.right  = GetSystemMetrics(SM_CXSCREEN);

		with(ABE) switch(Abe) {
			case LEFT:
				AppbarData.rc.right=AppbarData.rc.left+Size.cx;
				break;
			case TOP:
				AppbarData.rc.bottom=AppbarData.rc.top+Size.cy;
				break;
			case RIGHT:
				AppbarData.rc.left=AppbarData.rc.right-Size.cx;
				break;
			case BOTTOM:
				AppbarData.rc.top=AppbarData.rc.bottom-Size.cy;
				break;
			default:
				assert(false);
		}

		//システムにサイズを調整してもらう
		SHAppBarMessage(ABM_QUERYPOS, AppbarData); 

		with(ABE) switch(Abe) {
			case LEFT:
				AppbarData.rc.right = AppbarData.rc.left + Size.cx;
				break;
			case RIGHT:
				AppbarData.rc.left = AppbarData.rc.right - Size.cx;
				break;
 			case TOP:
				AppbarData.rc.bottom = AppbarData.rc.top + Size.cy;
				break;
			case BOTTOM:
				AppbarData.rc.top = AppbarData.rc.bottom - Size.cy;
				break;
			default:
				assert(false);
		}
	}
	void querySize(ref SIZE Size) {
		/+
		RECT Rect;
		window.itemRect(Rect);
		Size.cx = Rect.right  - Rect.left;
		Size.cy = Rect.bottom - Rect.top;
		+/
		Size = window.itemSize();
	}

	protected void SetAppbarData(APPBARDATA* AppbarData)
	in {
		assert(AppbarData);
	}
	body {
		AppbarData.cbSize = AppbarData.sizeof;
		AppbarData.hWnd   = window();
		AppbarData.lParam = 0;
	}

	/// WM_ACTIVATE
	void procActivate() {
		APPBARDATA AppbarData;

		SetAppbarData(&AppbarData);

		SHAppBarMessage(ABM_ACTIVATE, &AppbarData);
	}
	/// WM_WINDOWPOSCHANGED
	void procWindowPosChanged() {
		APPBARDATA AppbarData;

		SetAppbarData(&AppbarData);

		SHAppBarMessage(ABM_WINDOWPOSCHANGED, &AppbarData);
	}
}

