﻿/**
ホットキー
*/
module nemuxi.negui.subclass;

debug(subclass) import std.stdio: wl = writefln, pl = printf;
debug(subclass) void main() {}

import win32.windows;

import nemuxi.base;
import nemuxi.system.raii;
import nemuxi.utility.controller;
import nemuxi.negui.negui;

//mixin(ThrowableClasses("SubClass", "NeGui"));

/***/
class SubClass: Raii, IController {
	// 珍しくprivateのみ。
	private {
		WNDPROC SrcProc;
		WNDPROC SubProc;
		NeGui gui;
	}

	const WNDPROC subProc() {
		return cast(WNDPROC)SubProc;
	}

	override protected void Kill() {
		if(SrcProc) {
			if(!gui.setItemInfo(NeGui.GWL.WNDPROC, cast(LRESULT)SrcProc)) {
				throw new NeGuiException("サブクラス化解除失敗");
			}
			
			SrcProc = null;
		}
	}
	
	this(NeGui gui, WNDPROC SubProc)
	in {
		assert(gui);
		assert(SubProc);
	}
	body {
		this.gui     = gui;
		this.SubProc = SubProc;
		super(true);
	}

	override bool start() {
		//SrcProc = cast(WNDPROC)gui.setItemInfo(NeGui.GWL.WNDPROC, cast(LONG_PTR)SubProc);
		SrcProc = gui.proc(SubProc);
		return SrcProc
			? true
			: false
		;
	}
	override bool stop() {
		return super.kill();
	}
	override const bool isRunning() {
		return SubProc
			? true
			: false
		;
	}

	LRESULT call(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam) {
		assert(SrcProc);
		return CallWindowProc(SrcProc, hWnd, Message, wParam, lParam);
	}
}
/**
サブクラス化を実装するNeGuiが持っとくべきもの。

サブクラス化のサブクラス化に対処するためprivateで実装。
非privateのときにstack overflowに。
*/
interface ISubClass {
	private LRESULT call(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam);
	//private SubClass subClass();
	
	private void SubClassOnNeGuiConstructor();
	private void SubClassOnNeGuiDestructor();

}
pure nothrow string TSubClass(in string SubclassObject=q{SubclassObject}, in string SubClass_Proc=q{SubClass_Proc}) {
	return `

	private SubClass ` ~ SubclassObject ~ `;
	mixin MixinSubClass!(` ~ SubclassObject ~ `, ` ~ SubClass_Proc ~ `);

	/+
	private override LRESULT call(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam) {
		return this.` ~ SubclassObject ~ `.call(hWnd, Message, wParam, lParam);
	}

	/*
	private override SubClass subClass() {
		return this.` ~ SubclassObject ~ `;
	}
	*/

	private override void SubClassOnNeGuiConstructor() {
		` ~ SubclassObject ~ ` = new SubClass(this, &` ~ SubClass_Proc ~ `);
		` ~ SubclassObject ~ `.start();

		this.OnCreated();
	}
	private override void SubClassOnNeGuiDestructor() {
		delete ` ~ SubclassObject ~ `;
	}
	+/
	
	`;
}
private template MixinSubClass(alias SubclassObjectName, alias SubClass_ProcName) {
	private override LRESULT call(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam) {
		assert(SubclassObjectName);
		return SubclassObjectName.call(hWnd, Message, wParam, lParam);
	}

	private override void SubClassOnNeGuiConstructor() {
		SubclassObjectName = new SubClass(this, &SubClass_ProcName);
		SubclassObjectName.start();

		this.OnCreated();
	}
	private override void SubClassOnNeGuiDestructor() {
		delete SubclassObjectName;
	}
}

