﻿/**

いろいろ触ってたら単独コンパイルできんくなった不遇のパッケージ。
落ち着いてから直すさ。
*/
module nemuxi.negui.negui;

debug import std.stdio: wl = writefln, pl = printf;
debug(negui) void main() {}

import std.string;

import win32.winuser;
import win32.core;
import win32.shellapi;
import std.contracts;


public import nemuxi.base;
public import nemuxi.utility.meta.memberproperty;
public import nemuxi.utility.meta.guimethod;
public import nemuxi.negui.draw.font;
public import nemuxi.negui.draw.canvas;
public import nemuxi.image.icon;
//import nemuxi.negui.proc.proc;
public import nemuxi.negui.event;
//public import nemuxi.negui.subclass;
public import nemuxi.negui.keyboard.keyboard;
public import nemuxi.negui.layout.layout;
/+
class NemuxiGuiException: NemuxiException {
	mixin NemuxiExceptionClass;
}
+/
//mixin(ThrowableClasses("NemuxiGui"));

/// アイテム用ID。
/// typedef int ITEM_ID;
/// ホットキー用ID。
//typedef int HOTKEY_ID;
/// タイマー用ID。
//typedef int TIMER_ID;

string ItemExStyleGetSetMixStr(string Method, string Value, bool Override=false) {
	return ItemInfoSetGetMixStr("this.exStyle", Method, Value, Override);
}
string ItemStyleGetSetMixStr(string Method, string Value, bool Override=false) {
	return ItemInfoSetGetMixStr("this.style", Method, Value, Override);
}
string ItemExStyleGetSetMixStrEx(ENUMTYPE, VALUETYPE)(string Method, bool Override, string[] Args) {
	return ItemInfoGetSetMixStrEx!(ENUMTYPE, VALUETYPE, Array)("this.exStyle", Method, Override, Args);
}
string ItemStyleGetSetMixStrEx(ENUMTYPE, VALUETYPE)(string Method, bool Override, string[] Args) {
	return ItemInfoGetSetMixStrEx!(ENUMTYPE, VALUETYPE, string[])("this.style", Method, Override, Args);
}

///
struct GUIINFO {
	DWORD   ExStyle;       /// 拡張ウィンドウスタイル。
	Text    ClassName;      /// ウィンドウクラス名。
	DWORD   Style;        /// ウィンドウスタイル。
	NeGui     Owner;   /// 親ウィンドウのハンドル。
	ITEM_ID Id;
	bool EventLoop=false;
	alias EventLoop Window;

	string toString() {
		return format(
			"[GUIINFO]"
			"  ClassName = %s", ClassName,
			", ExStyle = %08x", ExStyle,
			", Style = %08x",   Style,
			", Owner = %s",     Owner,
			", Id = %s",        Id,
			", EventLoop = %s", EventLoop
		);
	}
}

/**
GUIオブジェクト操作用ラッパ。

取得関係のメソッドは内部がどうなっていようとconstとして処理する。
*/
abstract class NeGui {
	/// 操作ハンドル。
	protected HANDLE hItem;
	/// コンストラクタ。
	protected this(HWND hWnd)
	in {
		assert(hWnd);
	}
	body {
		hItem = hWnd;
	}
	/// GWLP_USERDATA代わり。
	Object userData;
	/+
	/// ditto
	this(NeGui gui) {
		this(gui.hItem);
	}
	+/

	this(GUIINFO* NeGuiInfo) {
		hItem = CreateWindowEx(
			NeGuiInfo.ExStyle,
			NeGuiInfo.ClassName.ptr,
			NeGuiInfo.ClassName.ptr,
			NeGuiInfo.Style,
			0, 0,
			0, 0,
			NeGuiInfo.Owner ? NeGuiInfo.Owner(): GetDesktopWindow(),
			cast(HANDLE)NeGuiInfo.Id,
			GetModuleHandle(null),
			NeGuiInfo.EventLoop ? cast(void*)this: null
		);
		auto code=Err.code;
		if(!hItem) {
			throw new NeGuiException("Gui生成失敗", EC.GUI, new NeGuiException(Err.text, EC.GUI_CREATE, new NeGuiException(NeGuiInfo.toString)));
		}
		
		this.guiObject(this);
	}
	
	/// 操作ハンドル取得。
	final HWND opCall() const {
		return hItem;
	}
	override final bool opEquals(Object obj) {
		auto gui=cast(NeGui)obj;
		return this == gui.hItem;
	}
	final bool opEquals(HANDLE Handle) const {
		return hItem == Handle;
	}

	/// 意味を成さないsend/post引数。
	invariant INT NONE=0;
	/**
	SendMessageラッパ。

	Bugs:
		やっちゃいけないんだろうけどconst属性。
	*/
	final const LRESULT send(UINT Message, WPARAM wParam, LPARAM lParam) {
		return SendMessage(hItem, Message, wParam, lParam);
	}
	/**
	PostMessageラッパ。
	
	Bugs:
		sendと同じく。
	*/
	final const LRESULT post(UINT Message, WPARAM wParam, LPARAM lParam) {
		return PostMessage(hItem, Message, wParam, lParam);
	}
	/+
	/// SendDlgItemMessageラッパ。
	final LRESULT sendChild(ITEM_ID Id, UINT Message, WPARAM wParam, LPARAM lParam) {
		return this.child(Id).send(Message, wParam, lParam);
	}
	+/
	
	/// アイテム情報取得フラグ。
	static enum GWL {
		EXSTYLE    = GWL_EXSTYLE,     /// 拡張ウィンドウスタイルを取得します。
		STYLE      = GWL_STYLE,       /// ウィンドウスタイルを取得します。
		WNDPROC    = GWLP_WNDPROC,    /// ウィンドウプロシージャへのポインタ、またはウィンドウプロシージャへのポインタを表すハンドルを取得します。ウィンドウプロシージャを呼び出すには、CallWindowProc 関数を使わなければなりません。
		HINSTANCE  = GWLP_HINSTANCE,  /// アプリケーションインスタンスのハンドルを取得します。
		HWNDPARENT = GWLP_HWNDPARENT, /// 親ウィンドウがある場合、そのハンドルを取得します。
		ID         = GWLP_ID,         /// ウィンドウ ID を取得します。
		USERDATA   = GWLP_USERDATA,   /// ウィンドウに関連付けられた 32 ビット値を取得します。この 32 ビット値は、ウィンドウを作成したアプリケーションで使用する目的で各ウィンドウが持っているものです。この値の初期値は 0 です。
	}
	/// Get/SetWindowLongPtrラッパ。
	protected final LONG_PTR GetItemInfo(GWL Index) {
		return GetWindowLongPtr(hItem, Index);
	}
	/// ditto
	protected final LONG_PTR SetItemInfo(GWL Index, LONG_PTR NewInfo) {
		return SetWindowLongPtr(hItem, Index, NewInfo);
	}
	/// ditto
	final const LONG_PTR getItemInfo(int Index) {
		return GetWindowLongPtr(hItem, Index);
	}
	/// ditto
	final LONG_PTR setItemInfo(int Index, LONG_PTR NewInfo) {
		return SetWindowLongPtr(hItem, Index, NewInfo);
	}
	final const LONG_PTR exStyle() {
		return this.getItemInfo(GWL.EXSTYLE);
	}
	final LONG_PTR exStyle(LONG_PTR NewInfo) {
		return this.setItemInfo(GWL.EXSTYLE, NewInfo);
	}
	final const LONG_PTR style() {
		return this.getItemInfo(GWL.STYLE);
	}
	final LONG_PTR style(LONG_PTR NewInfo) {
		return this.setItemInfo(GWL.STYLE, NewInfo);
	}
	final const WNDPROC proc() {
		return cast(WNDPROC)this.getItemInfo(NeGui.GWL.WNDPROC);
	}
	final WNDPROC proc(WNDPROC NewProc) {
		return cast(WNDPROC)this.setItemInfo(NeGui.GWL.WNDPROC, cast(LONG_PTR)NewProc);
	}
	final const Text className() {
		immutable CLASSLEN = 256;

		auto name = new wchar[CLASSLEN];

		if(!GetClassName(hItem, name.ptr, CLASSLEN)) {
			throw new NeGuiException(Err.toString);
		}

		return Text(name.ptr);
	}
	/// ditto
	final const NeGui guiObject() {
		return cast(NeGui)cast(void*)getItemInfo(GWL.USERDATA);
	}
	/+
	/// ditto
	final void* userData(void* NewInfo) {
		return cast(void*)setItemInfo(GWL.USERDATA, cast(LONG_PTR)NewInfo);
	}
	+/
	final NeGui guiObject(NeGui NewGuiData) {
		return cast(NeGui)cast(void*)setItemInfo(GWL.USERDATA, cast(LONG_PTR)cast(void*)NewGuiData);
	}

	///
	LayoutManager layoutManager;
	
	static {
		/+
		deprecated void setClass(HWND hWnd, NeGui obj) {
			auto gui=new NeGui(hWnd);
			gui.userData(obj);
		}
		deprecated NeGui getClass(HWND hWnd) {
			auto gui=new NeGui(hWnd);
			return gui.userData();
		}
		+/

		/***/
		NeGui getGuiObject(HWND hWnd) {
			return cast(NeGui)cast(void*)GetWindowLongPtr(hWnd, GWL_USERDATA);
		}
		deprecated alias getGuiObject getGui;
	}

	mixin(ItemExStyleGetSetMixStr("doubleFrame", q{WS_EX_DLGMODALFRAME}, false));
	mixin(ItemExStyleGetSetMixStr("clientEdge",  q{WS_EX_CLIENTEDGE},    false));
	mixin(ItemExStyleGetSetMixStr("transParent", q{WS_EX_TRANSPARENT},   false));
	mixin(ItemExStyleGetSetMixStr("windowEdge",  q{WS_EX_WINDOWEDGE},    false));
	mixin(ItemExStyleGetSetMixStr("staticEdge",  q{WS_EX_STATICEDGE},    false));
	
	/// WS_BORDER, @reLoad
	mixin(ItemStyleGetSetMixStr("border",      q{WS_BORDER}, false));
	mixin(ItemStyleGetSetMixStr("dialogFrame", q{WS_DLGFRAME}, false));
	
	mixin(ItemStyleGetSetMixStr("hScroll", q{WS_HSCROLL}, false));
	mixin(ItemStyleGetSetMixStr("vScroll", q{WS_VSCROLL}, false));

	
	/// アイテムクラス情報取得フラグ。
	static enum CLASSFLAG {
		ATOM          = GCW_ATOM,            /// ウィンドウクラスを一意的に識別するアトム値を取得します。これは、RegisterClassEx 関数が返すアトムと同じです。
		CBCLSEXTRA    = GCL_CBCLSEXTRA,      /// クラスに関連付けられた拡張クラスメモリのサイズをバイト単位で取得します。
		CBWNDEXTRA    = GCL_CBWNDEXTRA,      /// ウィンドウに関連付けられた拡張ウィンドウメモリのサイズをバイト単位で取得します。このメモリへのアクセス方法については、GetWindowLongPtr 関数の説明を参照してください。
		HBRBACKGROUND = GCL_HBRBACKGROUND,  /// クラスに関連付けられた背景ブラシのハンドルを取得します。
		HCURSOR       = GCL_HCURSOR,        /// クラスに関連付けられたカーソルのハンドルを取得します。
		HICON         = GCL_HICON,          /// クラスに関連付けられたアイコンのハンドルを取得します。
		HICONSM       = GCL_HICONSM,        /// クラスに関連付けられた小さいアイコンのハンドルを取得します。
		HMODULE       = GCL_HMODULE,        /// クラスを登録したモジュールのハンドルを取得します。
		MENUNAME      = GCL_MENUNAME,       /// クラスに関連付けられたメニューリソースを識別するメニュー名文字列へのポインタを取得します。
		STYLE         = GCL_STYLE,           /// ウィンドウクラスのスタイルビットを取得します。
		WNDPROC       = GCL_WNDPROC,        /// ウィンドウプロシージャのアドレス、またはウィンドウプロシージャのアドレスを表すハンドルを取得します。ウィンドウプロシージャを呼び出すには、CallWindowProc 関数を使わなければなりません。
	}
	alias CLASSFLAG GCL;
	version(none) {
		/// GetClassLongPtrラッパ。
		ULONG_PTR getClassInfo(CLASSFLAG Index) {
			return GetClassLongPtr(hItem, Index);
		}
		/// ditto
		ULONG_PTR getClassInfo(int Index) {
			return GetClassLongPtr(hItem, Index);
		}
		/// SetClassLongPtrラッパ。
		ULONG_PTR setClassInfo(CLASSFLAG Index, LONG_PTR NewInfo) {
			return SetClassLongPtr(hItem, Index, NewInfo);
		}
		/// ditto
		ULONG_PTR setClassInfo(int Index, LONG_PTR NewInfo) {
			return SetClassLongPtr(hItem, Index, NewInfo);
		}
	} else {
		/// GetClassLongラッパ。
		DWORD getClassInfo(CLASSFLAG Index) {
			return GetClassLong(hItem, Index);
		}
		/// ditto
		DWORD getClassInfo(int Index) {
			return GetClassLong(hItem, Index);
		}
		/// SetClassLongラッパ。
		ULONG_PTR setClassInfo(CLASSFLAG Index, LONG NewInfo) {
			return SetClassLong(hItem, Index, NewInfo);
		}
		/// ditto
		ULONG_PTR setClassInfo(int Index, LONG NewInfo) {
			return SetClassLong(hItem, Index, NewInfo);
		}
	}
	
	/// アイテムテキスト
	const Text text() {
		if(auto len = this.textLength()) {
			auto text=new wchar[len+1];
			
			if(GetWindowText(hItem, text.ptr, len+1)) {
				return Text(text[0..len]);
			}
			
			throw new NeGuiException("text");
		}
		
		return Text.emptyText();
	}
	/// ditto
	bool text(in Text text) {
		return SetWindowText(hItem, text.ptr)
			? true
			: false
		;
	}
	bool number(T: int)(T Number) {
		try {
			return text(Text(Number));
		} catch(Throwable e) {
			Logger.write(e);
			return false;
		}
	}

	
	/// アイテムテキスト長取得
	const size_t textLength() {
		return GetWindowTextLength(hItem);
	}
	
	/// 自身を終了させる。
	bool destroy() {
		return DestroyWindow(hItem)
			? true
			: false
		;
	}
	/// Windowsシステム上で有効か。
	const bool alive() {
		return IsWindow(hItem)
			? true
			: false
		;
	}
	
	//// 有効無効
	bool enable(bool Enable) {
		return EnableWindow(hItem, Enable)
			? true
			: false
		;
	}
	/// ditto
	const bool enable() {
		return IsWindowEnabled(hItem)
			? true
			: false
		;
	}
	bool upDate() {
		return cast(bool)UpdateWindow(hItem);
	}
	void reDraw(bool ReDraw) {
		send(WM_SETREDRAW, ReDraw, NONE);
	}
	/***/
	bool invaliDateRect(ref const(RECT) Rect, bool BackErase) {
		return cast(bool)InvalidateRect(hItem, cast(RECT*)&Rect, BackErase);
	}
	/// ditto
	bool invaliDateRect(bool BackErase) {
		return cast(bool)InvalidateRect(hItem, null, BackErase);
	}
	/+
BOOL InvalidateRect(
  HWND hWnd,           // ウィンドウのハンドル
  CONST RECT *lpRect,  // 長方形の座標
  BOOL bErase          // 消去するかどうかの状態
);
	+/
	
	/**
	指定アイテムは子供か。

	Params:
		gui = 調べたい子供。

	Return:
		成功すればtrue、失敗すればfalseを返す。
	*/
	const bool isChild(in NeGui gui) {
		return IsChild(hItem, gui.hItem)
			? true
			: false
		;
	}
	
	/**
	子アイテムの取得。

	Params:
		Id = 取得したいアイテムのID。

	Return:
		指定アイテムが有効ならそのアイテム。
	*/
	const NeGui child(ITEM_ID Id) {
		auto item=GetDlgItem(hItem, Id);

		return item
			? NeGui.getGuiObject(item)
			: null
		;
	}
	/**
	クライアント座標から子アイテムの取得。

	Params:
		Point = クライアント座標。

	Return:
		子アイテム。
		指定座標に子アイテムが存在しなければ自身を返す。

	Exception:
		座標が変だった場合にはNeGuiExceptionを投げる。
	*/
	const NeGui child(ref const(POINT) Point) {
		auto Handle=ChildWindowFromPoint(hItem, Point);

		enforce(Handle, new NeGuiException("うん？"));

		return NeGui.getGuiObject(Handle);
	}
	
	private static {
		struct CHILDREN {
			NeGui[] list;
		}
		extern(Windows) BOOL EnumChildProc(HWND hWnd , LPARAM lParam) {
			if(auto gui=getGuiObject(hWnd)) {
				auto Children=cast(CHILDREN*)lParam;
				Children.list ~= gui;
			}
			return TRUE;
		}
	}
	const NeGui[] children() {
		CHILDREN Children;
		if(EnumChildWindows(hItem, &EnumChildProc, cast(LPARAM)&Children)) {
			return Children.list;
		}
		throw new NeGuiException(Err.toString);
	}
	/**
	親取得。
	*/
	const NeGui parent() {
		if(auto hWnd=GetParent(hItem)) {
			if(auto gui=cast(NeGui)NeGui.getGuiObject(hWnd)) {
				return gui;
			} else {
				return new OtherGui(hWnd);
			}
		}
	
		return null;
	}
	const NeGui root() {
		if(auto gui=parent) {
			return gui.root;
		}
		
		return new OtherGui(hItem);
	}

	static NeGui pointToGui(const ref POINT Point) {
		if(auto hWnd=WindowFromPoint(cast(POINT)Point)) {
			if(auto gui=NeGui.getGuiObject(hWnd)) {
				return gui;
			} else {
				return new OtherGui(hWnd);
			}
		}

		return null;
	}

	///スクリーン座標→クライアント座標
	const bool pointToClient(ref POINT Point) {
		return cast(bool)ScreenToClient(hItem, &Point);
	}
	///クライアント座標→スクリーン座標
	const bool pointToScreen(ref POINT Point) {
		return cast(bool)ClientToScreen(hItem, &Point);
	}

	invariant GW_ENABLEDPOPUP = 6;
	///
	static enum GW {
		CHILD = GW_CHILD,     /// Z 順位が一番上の子ウィンドウを取得します。 
		FIRST = GW_HWNDFIRST, /// 指定したウィンドウと同じタイプのウィンドウで、Z 順位が一番上のウィンドウを取得します。 
		LAST  = GW_HWNDLAST,  /// 指定したウィンドウと同じタイプのウィンドウで、Z 順位が一番下のウィンドウを取得します。 
		NEXT  = GW_HWNDNEXT,  /// Z 順位が、指定したウィンドウの次にあるウィンドウを取得します。 
		PREV  = GW_HWNDPREV,  /// Z 順位が、指定したウィンドウの前にあるウィンドウを取得します。 
		OWNER = GW_OWNER,     /// 指定したウィンドウの親ウィンドウを取得します。
		ENABLEDPOPUP = GW_ENABLEDPOPUP,
	}
	const NeGui relation(GW gw) {
		if(auto hWnd=GetWindow(hItem, gw)) {
			//return NeGui.getGuiObject(hWnd);
			if(auto negui=NeGui.getGuiObject(hWnd)) {
				return negui;
			} else {
				return new OtherGui(hWnd);
			}
		}

		return null;
	}
	
	/**
	ウィンドウをZ順位の一番手前に持ってきて、アクティブにします
	
	子ウィンドウの場合は、その子ウィンドウを所有する親ウィンドウがアクティブになります。

	Return:
		成功すればtrue、失敗すればfalseを返す。
	*/
	bool topMost() {
		return BringWindowToTop(hItem)
			? true
			: false
		;
	}
	///
	bool setShow(SHOW Show) {
		return ShowWindow(hItem, Show)
			? true
			: false
		;
	}
	///
	const bool visible() {
		return IsWindowVisible(hItem)
			? true
			: false
		;
	}
	/**
	フォアグラウンドへ設定。

	Return:
		成功すればtrue、失敗すればfalse。
	*/
	bool foreGround() {
		return cast(bool)SetForegroundWindow(hItem);
	}
	

	///
	bool move(int x, int y, int Width, int Height, bool RePaint=true) {
		return MoveWindow(
			hItem,
			x, y,
			Width, Height,
			RePaint
		) ? true: false;
	}
	///
	static enum AFTER {
		NONE      = 0,                       /// 無指定。
		BOTTOM    = cast(int)HWND_BOTTOM,    /// ウィンドウを Z 順位の一番下に設定します。最前面ウィンドウは同時に WS_EX_TOPMOST の指定が解除されます。 
		NOTOPMOST = cast(int)HWND_NOTOPMOST, /// 最前面ウィンドウ（WS_EX_TOPMOST）指定を解除します。 
		TOP       = cast(int)HWND_TOP,       /// ウィンドウを Z 順位の一番上に設定します。 
		TOPMOST   = cast(int)HWND_TOPMOST,   /// ウィンドウを最前面ウィンドウに設定します。最前面ウィンドウとは、常に最前面に表示されるウィンドウのことです。
	}
	///
	static enum SWP {
		DRAWFRAME      = SWP_DRAWFRAME, /// 再描画時に、ウィンドウの枠も再描画の対象とします。 
		FRAMECHANGED   = SWP_FRAMECHANGED, /// ウィンドウ サイズが変更されない場合でも、WM_NCCALCSIZE メッセージを送ります。 
		HIDEWINDOW     = SWP_HIDEWINDOW, /// ウィンドウを非表示にします。 
		NOACTIVATE     = SWP_NOACTIVATE, /// ウィンドウをアクティブ化しないようにします。 
		NOCOPYBITS     = SWP_NOCOPYBITS, /// ウィンドウ再配置時に、クライアント領域の内容を破棄します。 
		NOMOVE         = SWP_NOMOVE, /// ウィンドウの現在の位置を維持します。X パラメータ、Y パラメータは無視されます。 
		NOOWNERZORDER  = SWP_NOOWNERZORDER, /// オーナーウィンドウの Z 順位を変更しないようにします。
		NOREPOSITION   = SWP_NOREPOSITION, /// ditto
		NOREDRAW       = SWP_NOREDRAW, /// 変更結果を再描画しないようにします。 
		NOSENDCHANGING = SWP_NOSENDCHANGING, /// ウィンドウに WM_WINDOWPOSCHANGING メッセージを送らないようにします。 
		NOSIZE         = SWP_NOSIZE, /// ウィンドウの現在のサイズを維持します。cx パラメータ、cy パラメータは無視されます。 
		NOZORDER       = SWP_NOZORDER, /// 現在の Z 順位を維持します。hWndInsertAfter パラメータは無視されます。 
		SHOWWINDOW     = SWP_SHOWWINDOW, /// ウィンドウを表示します。 
	}
	///
	bool pos(AFTER After, int x, int y, int Width, int Height, SWP Flags) {
		return SetWindowPos(hItem, cast(HWND)After, x, y, Width, Height, Flags)
			? true
			: false
		;
	}
	/**
	*/
	bool reLoad() {
		return this.pos(AFTER.NONE, 0, 0, 0, 0, SWP.DRAWFRAME | SWP.NOOWNERZORDER | SWP.NOSIZE | SWP.NOZORDER | SWP.NOMOVE);
	}
	/**
	*/
	bool topMost(bool TopMpst) {
		return this.pos(TopMpst ? AFTER.TOPMOST: AFTER.NOTOPMOST, 0, 0, 0, 0, SWP.NOMOVE | SWP.NOSIZE | SWP.NOACTIVATE);
	}
	/**
	座標。
	*/
	bool position(in int x, in int y) {
		return this.pos(AFTER.NONE, x, y, 0, 0, SWP.DRAWFRAME | SWP.NOSIZE | SWP.NOZORDER);
	}
	/// ditto
	bool position(ref const(POINT) Point) {
		return this.position(Point.x, Point.y);
	}
	
	/**
	サイズ。
	*/
	bool size(in int Width, in int Height) {
		return this.pos(AFTER.NONE, 0, 0, Width, Height, SWP.DRAWFRAME | SWP.NOMOVE | SWP.NOZORDER);
	}
	/// ditto
	bool size(ref const(SIZE) Size) {
		return this.size(Size.cx, Size.cy);
	}

	/**
	*/
	deprecated bool clientSize(ref SIZE Size) {
		RECT Rect=void;
		if(GetClientRect(hItem, &Rect)) {
			Size.cx = Rect.right;
			Size.cy = Rect.bottom;

			return true;
		}
		
		return false;
	}

	/**
	アイテムのクライアントサイズを取得。

	Return:
		アイテムのクライアントサイズ。

	Exception:
		NeGuiException
	*/
	const ref SIZE clientSize() {
		RECT Rect=void;
		
		enforce(GetClientRect(hItem, &Rect), new NeGuiException(Err.toString));
		
		auto Size=new SIZE;
		Size.cx = Rect.right;
		Size.cy = Rect.bottom;

		return *Size;

	}

	/**
	スクリーン座標の取得。
	*/
	deprecated bool itemRect(ref RECT Rect) {
		return GetWindowRect(hItem, &Rect)
			? true
			: false
		;
	}

	/**
	アイテムのスクリーン座標を取得。

	Return:
		アイテムのスクリーン座標。

	Exception:
		NeGuiException
	*/
	const ref RECT itemRect() {
		auto Rect=new RECT;

		enforce(GetWindowRect(hItem, Rect), new NeGuiException(Err.toString));

		return *Rect;
	}

	deprecated bool itemSize(ref SIZE Size) {
		RECT Rect;
		
		if(itemRect(Rect)) {
			Size.cx = Rect.right  - Rect.left;
			Size.cy = Rect.bottom - Rect.top;
		}
		
		return false;
	}
	
	/**
	アイテムのサイズを取得。

	Return:
		アイテムサイズ。

	Exception:
		NeGuiException
	*/
	const ref SIZE itemSize() {
		auto Rect=itemRect();

		auto Size=new SIZE;

		Size.cx = Rect.right  - Rect.left;
		Size.cy = Rect.bottom - Rect.top;

		return *Size;
	}

	/**
	呼び出し側スレッドのフォーカスアイテムを取得。

	Return:
		失敗時にはnull。
	*/
	final static NeGui getFocus() {
		auto Handle=GetFocus();

		return Handle
			? NeGui.getGuiObject(Handle)
			: null
		;
	}
	/**
	*/
	bool setFocus() {
		return SetFocus(hItem)
			? true
			: false
		;
	}

	/**
	*/
	bool lockUpDate(bool Lock) {
		return LockWindowUpdate(Lock ? hItem: null)
			? true
			: false
		;
	}

	/**
	デバイスコンテキストの取得。
	*/
	const HDC getDC() {
		return GetDC(hItem);
	}
	/**
	デバイスコンテキストの解放。

	--------------------------------
	auto gui=new NeGui(HANDLE);

	auto hDC=gui.getDC();
	scope(exit) gui.releaseDC(hDC);
	--------------------------------
	*/
	bool releaseDC(HDC hDC) {
		return ReleaseDC(hItem, hDC)
			? true
			: false
		;
	}

	/// アイテムのCabvasを取得
	Canvas canvas() {
		return new Canvas(this);
	}
	/// WM_PAINTの糖衣
	Canvas beguinPaint(ref PAINTSTRUCT PaintStruct)
	out(r) {
		assert(!r.suicide);
	}
	body {
		return new Canvas(BeginPaint(hItem, &PaintStruct), false);
	}
	/// ditto
	void endPaint(ref PAINTSTRUCT PaintStruct) {
		EndPaint(hItem, &PaintStruct);
	}
	
	const Icon getIcon(ICONSIZE IconSize) {
		return new Icon(cast(HICON)send(WM_GETICON, IconSize == ICONSIZE.NORMAL ? ICON_BIG: ICON_SMALL, NONE), false);
	}
	Icon setIcon(ICONSIZE IconSize, in Icon icon) {
		HICON hIcon=cast(HICON)send(WM_SETICON, IconSize == ICONSIZE.NORMAL ? ICON_BIG: ICON_SMALL, icon ? cast(LPARAM)icon(): NONE);
		if(hIcon) {
			return new Icon(hIcon, false);
		}
		return null;
	}
	const Font font() {
		auto hFont=cast(HFONT)send(WM_GETFONT, NONE, NONE);

		return hFont
			? new Font(hFont, false)
			: null
		;
	}
	void font(in Font font) {
		send(WM_SETFONT, cast(WPARAM)font(), true);
	}

	///
	bool startHotKey(HOTKEY_ID Id, MOD Mod, KEY Key)
	in {
		version(gui) {
			assert(Id <= 0xBFFF);
		} else version(dll) {
			assert(0xC000 <= Id && Id <= 0xFFFF);
		}
	}
	body {
		return RegisterHotKey(hItem, Id, Mod, Key)
			? true
			: false
		;
	}
	///
	bool stopHotKey(HOTKEY_ID Id) {
		return UnregisterHotKey(hItem, Id)
			? true
			: false
		;
	}

	/**
	タイマー開始。
	*/
	bool startTimer(TIMER_ID Id, DWORD ms, TIMERPROC TimerProc=null)
	in {
		assert(Id > WM_APP);
	}
	body {
		return SetTimer(hItem, Id, ms, TimerProc)
			? true
			: false
		;
	}
	
	bool stopTimer(TIMER_ID Id)
	in {
		assert(Id > WM_APP);
	}
	body {
		return KillTimer(hItem, Id)
			? true
			: false
		;
	}

	void dropFile(bool Accept) {
		DragAcceptFiles(hItem, Accept);
	}

}

deprecated template NeGuiClass() {
	///
	override this(HWND hWnd) {
		super(hWnd);
	}

	///
	override this(NeGui gui) {
		super(gui);
	}
	
	override this(GUIINFO* NeGuiInfo) {
		super(NeGuiInfo);
	}
	
}

template NeGuiDestructor() {
	~this() {
		if(hItem) {
			if(auto me=getGuiObject(hItem)) {
				if(me.alive) {
					me.destroy;
				}
				hItem = null;
			}
		}
	}
}

class OtherGui: NeGui {
	this(HWND hWnd) {
		super(hWnd);
	}
}

NeGui GetGui(HWND hWnd)
body {
	if(hWnd) {
		if(auto gui=NeGui.getGuiObject(hWnd)) {
			return gui;
		} else {
			return new OtherGui(hWnd);
		}
	} else {
		return null;
	}
}

