﻿/**
ライン。
*/
module nemuxi.negui.layout.panel.line;

debug import std.stdio: wl = writefln, pl = printf;
debug(line) void main() {}

import std.math;
import std.contracts;

import win32.windows;

import nemuxi.base;
public import nemuxi.negui.negui;
public import nemuxi.negui.layout.layout;
public import nemuxi.negui.layout.panel.panel;


/**
ライン型パネル。

Tansuに似てるけどこっちはセル幅を各要素毎に設定可能。

最終要素のSIZEINFOに対してSizeInfo[$-1].absolute = -1を設定しておくと残りのコンテント領域を埋めようとする。
*/
class Line: Panel, IDirection  {
	protected {
		SIZEINFO[] SizeInfo;
	}
	/+
	protected DIRECTION Direction;
	override const DIRECTION direction() {
		return Direction;
	}
	+/
	mixin TDirection;
	
	this(DIRECTION Direction, size_t Length=0) {
		this.Direction = Direction;
		if(Length) {
			length = Length;
		}
	}
	///
	alias Panel.length length;
	/// ditto
	override void length(in size_t Length) {
		super.length(Length);
		SizeInfo.length = Length;
	}
	
	///
	override void opAddAssign(CONTENT Content) {
		super.opAddAssign(Content);
		SizeInfo ~= SIZEINFO.init;
	}
	/// ditto
	override void opAddAssign(NeGui gui) {
		super.opAddAssign(gui);
		SizeInfo ~= SIZEINFO.init;
	}
	/// ditto
	override void opAddAssign(Panel panel) {
		super.opAddAssign(panel);
		SizeInfo ~= SIZEINFO.init;
	}
	/// ditto
	override void opAddAssign(void* None) {
		super.opAddAssign(None);
		SizeInfo ~= SIZEINFO.init;
	}

	ref SIZEINFO sizeInfo(in size_t Index) const {
		return SizeInfo[Index];
	}

	override void onSize(ref const(RECT) TotalSize) {
		if(!Contents.length) {
			return;
		}
		
		immutable InPaddingSize=GetInPaddingSize(TotalSize);
		
		auto ContentSize=GetContentSize(InPaddingSize);
		
		int IncrementElementSize=0;

		foreach(i, Content; Contents) {
			bool LoopLast() {
				return i == Contents.length - 1 && SizeInfo[i].type == SIZEINFO.TYPE.ABSOLUTE && SizeInfo[i].absolute == -1;
			}
			
			immutable ElementSize = GetElemntSize(Direction, SizeInfo[i], InPaddingSize);
			
			switch(Direction) {
				case DIRECTION.HORIZON:
					ContentSize.left  = InPaddingSize.left + padding.left * (i + 1) + padding.right * i + IncrementElementSize;
					ContentSize.right = ContentSize.left + ElementSize;
				
					if(LoopLast()) {
						ContentSize.right = InPaddingSize.right  - padding.right;
					}
					break;
				
				case DIRECTION.VERTICAL:
					ContentSize.top    = InPaddingSize.top + padding.top * (i + 1) + padding.bottom * i + IncrementElementSize;
					ContentSize.bottom = ContentSize.top + ElementSize;
				
					if(LoopLast()) {
						ContentSize.bottom = InPaddingSize.bottom  - padding.bottom;
					}
					break;
				
				default:
					assert(false);
			}
			IncrementElementSize += ElementSize;
			
			Content.onSize(ContentSize);
		}

	}
}
debug(line) unittest {
	int[string] a;
	assert(!("aaa" in a));

}

