﻿/**
キーボードアクセラレータ。
*/
module nemuxi.negui.keyboard.accelerator;

debug import std.stdio: wl = writefln, pl = printf;
debug(accelerator) void main() {}

import std.string;
import std.contracts;

import win32.core;

import nemuxi.base;
import nemuxi.system.raii;
public import nemuxi.negui.keyboard.keyboard;
import nemuxi.utility.meta.memberproperty;
import nemuxi.negui.window.menu.menu;
import nemuxi.negui.window.newindow;
private import nemuxi.negui.window.dialog.dialog;

struct ACCELERATOR {
	ACCEL Accel;
	
	///
	static enum TYPE: byte {
		ALT     = FALT,     /// [ALT]キー
		CONTROL = FCONTROL, /// [Ctrl]キー
		SHIFT   = FSHIFT,   /// [Shift]キー
		VIRTKEY = FVIRTKEY, /// 仮想キーコード
	}
	mixin(StructGetSet!(TYPE)("type", q{Accel.fVirt}));
	mixin(StructGetSet!(KEY)("key", q{Accel.key}));
	mixin(StructGetSet!(COMMAND_ID)("command", q{Accel.cmd}));

	string toString() {
		return format(
			"[ACCELERATOR]"
			"  type = %s",    type,
			" ,key = %s",     key,
			" ,command = %s", command
		);
	}
}
unittest {
	assert(ACCEL.sizeof == ACCELERATOR.sizeof);
}
class Accelerator: HandleRaii {
	static {
		private struct ACCELTABLE {
			NeWindow window;
			Accelerator accel;

			static ACCELTABLE opCall(NeWindow window, Accelerator Accel)
			in {
				assert(window);
				assert(Accel);
			}
			body {
				ACCELTABLE Table;
				Table.window = window;
				Table.accel  = Accel;
				return Table;
			}
		}
		private ACCELTABLE[NeWindow] AccelTable;

		void idRegist(NeWindow window, Accelerator Accel)
		in {
			//assert(LoopOwnerID);
			assert(window);
			assert(Accel);
		}
		body {
			AccelTable[window] = ACCELTABLE(window, Accel);
		}
		
		Accelerator idUnRegist(NeWindow window)
		in {
			//assert(LoopOwnerID);
		}
		body {
			auto Accel = AccelTable[window].accel;
			AccelTable.remove(window);
			return Accel;
		}
		// すっげー重そう。
		bool isTranslateAccelerator(NeWindow window, MSG* Message)
		in {
//			assert(LoopOwnerID);
			assert(Message);
		}
		body {
			if(AccelTable && window in AccelTable) {
				assert(AccelTable[window].window.alive);
				assert(AccelTable[window].accel());
				return cast(bool)TranslateAccelerator(AccelTable[window].window(), AccelTable[window].accel(), Message);
			}
			return false;
		}
	}
	
	protected alias Handle hAccel;
	mixin KillResource!("キーボードアクセラレータ", hAccel, DestroyAcceleratorTable, 0);

	this(ACCELERATOR[] Accels)
	in {
		assert(Accels.length);
	}
	body {
		super(CreateAcceleratorTable(cast(ACCEL*)Accels.ptr, Accels.length), true);
		if(!hAccel) {
			throw new KeyBoardException(Text(Accels));
		}
	}

	const ACCELERATOR[] get() {
		if(auto Length=CopyAcceleratorTable(hAccel, NULL, 0)) {
			auto Accels=new ACCELERATOR[Length];
			enforce(CopyAcceleratorTable(hAccel, cast(ACCEL*)Accels.ptr, Length), new KeyBoardException(Err.toString));

			return Accels;
		}
		
		return null;
	}

	void opAddAssign(const ref ACCELERATOR Accel) {
		/+
		ACCELERATOR[] Accels=get();

		Accels ~= Accel;

		delete this;
		this = new Accelerator(Accels);
		+/
		opAddAssign([Accel]);
	}
	void opAddAssign(in Accelerator Accel) {
		opAddAssign(Accel.get());
	}
	void opAddAssign(in ACCELERATOR[] Accels) {
		ACCELERATOR[] NowAccels=get();
		
		NowAccels ~= Accels;
		
		delete this;
		this = new Accelerator(NowAccels);
	}

}

