﻿/**
ホットキー
*/
module nemuxi.negui.hotkey;

debug(hotkey) import std.stdio: wl = writefln, pl = printf;
debug(hotkey) void main() {}

import win32.windows;

import nemuxi.base;
import nemuxi.system.raii;
import nemuxi.utility.controller;
import nemuxi.negui.negui;

class HotKey: Raii, IRaii, IController {
	private {
		NeGui gui;
		HOTKEY_ID Id;
		KEY Key;
		MOD Mod;
		bool Running=false;
	}

	override protected void Kill() {
		if(Running) {
			if(this.stop()) {
				return;
			}

			throw new NemuxiException("止められない＞＜");
		}
	}

	const HOTKEY_ID id() {
		return Id;
	}

	this(NeGui gui, HOTKEY_ID Id, MOD Mod, KEY Key) {
		super(true);
		this.gui = gui;
		this.Id  = Id;
		this.Mod = Mod;
		this.Key = Key;
	}

	override bool start() {
		Running = gui.startHotKey(Id, Mod, Key);
		
		return Running;
	}
	override bool stop() {
		Running = !gui.stopHotKey(Id);

		return !Running;
	}
	override const bool isRunning() {
		return Running;
	}
}
/+
/**
ホットキーの付加。
*/
template HotKeyEx() {
	HotKey[HOTKEY_ID] RegistedHotKey;

	/**
	登録済みホットキーの起動。

	Return:
		成功すればtrue、失敗すればfalseを返す。
	*/
	bool startHotKey(HOTKEY_ID Id) {
		return RegistedHotKey[Id].start();
	}
	bool stopHotKey(HOTKEY_ID Id) {
		return RegistedHotKey[Id].stop();
	}
	/**
	ホットキーの登録。

	メソッドか関数かは知らないけどこいつを呼ばないとstartHotKey, stopHotKeyは呼び出せない。
	*/
	void registHotKey(HotKey hotkey)
	in {
		assert(hotkey);
	}
	body {
		RegistedHotKey[hotkey.id] = hotkey;
	}
}
+/
