﻿/**
イベントを模したもの。

基本的な定数や構造体のみ。
コントロール特有なものなんかはそのコントロールのmoduleで補完。
*/
module nemuxi.negui.event;

debug import std.stdio: wl = writefln, pl = printf;
debug(event) void main() {}

import std.bitmanip;
import std.string;
import std.contracts;

import win32.winuser;
import win32.core;
import win32.shellapi;
import win32.commctrl;

public import nemuxi.negui.system.type;
import nemuxi.negui.negui;
import nemuxi.negui.subclass;
import nemuxi.utility.meta.basic;
import nemuxi.negui.layout.panel.panel;

private {
	immutable ARG_GUIOBJECT = q{NeGuiObject};
	immutable ARG_HWND      = q{hWnd};
	immutable ARG_MESSAGE   = q{Message};
	immutable ARG_WPARAM    = q{wParam};
	immutable ARG_LPALAM    = q{lParam};
}
/+
struct NEGUIPOINT {
	union {
		LPARAM lParam;
		struct {
			short x;
			short y;
		}
	}
}

/// プログラム表示方法
enum SHOW {
//	NONE            = -1,                 /// 表示非表示のフラグでなく別途用途に使用。
	HIDE            = SW_HIDE,            /// ウィンドウを非表示にして、他のウィンドウをアクティブにします。
	SHOWNORMAL      = SW_SHOWNORMAL,      /// ウィンドウをアクティブにして表示します。ウィンドウが最小化または最大化されている場合は、ウィンドウの位置とサイズを元に戻します。アプリケーションは、最初にウィンドウを表示させるときにこのフラグを指定するべきです。
	SHOWMINIMIZED   = SW_SHOWMINIMIZED,   /// ウィンドウをアクティブにして、最小化されたウィンドウとして表示します。
	SHOWMAXIMIZED   = SW_SHOWMAXIMIZED,   /// ウィンドウをアクティブにして、最大化されたウィンドウとして表示します。
	SHOWNOACTIVATE  = SW_SHOWNOACTIVATE,  /// ウィンドウをアクティブにはせずに表示します。
	SHOW            = SW_SHOW,            /// ウィンドウをアクティブにして、現在の位置とサイズで表示します。
	MINIMIZE        = SW_MINIMIZE,        /// 指定されたウィンドウを最小化して、次の Z オーダーにあるトップレベルウィンドウをアクティブにします。
	SHOWMINNOACTIVE = SW_SHOWMINNOACTIVE, /// ウィンドウを最小化されたウィンドウとして表示します。ウィンドウはアクティブ化されません。
	SHOWNA          = SW_SHOWNA,          /// ウィンドウを現在の位置とサイズで表示します。ウィンドウはアクティブ化されません。
	RESTORE         = SW_RESTORE,         /// ウィンドウをアクティブにして表示します。ウィンドウが最小化または最大化されている場合は、ウィンドウの位置とサイズを元に戻します。アプリケーションは、最小化されたウィンドウの位置とサイズを元に戻すときにこのフラグを指定するべきです。
	SHOWDEFAULT     = SW_SHOWDEFAULT,     /// アプリケーションを起動したプログラムが CreateProcess 関数にパラメータとして渡した STARTUPINFO 構造体で指定されている SW_ 値に基づいて表示状態が設定されます。
	FORCEMINIMIZE   = SW_FORCEMINIMIZE,   /// Windows 2000/XP： ウィンドウを所有しているスレッドがハングしている状態であっても、ウィンドウを最小化します。他のスレッドからウィンドウを最小化させる場合にのみ、このフラグを使用するべきです。
}
+/
/+
/// コマンド用ID。
typedef DWORD COMMAND_ID;
/// アイテム用ID。
typedef DWORD ITEM_ID;
/// ホットキー用ID。
typedef int HOTKEY_ID;
/// タイマー用ID。
typedef int TIMER_ID;
/// 通知メッセージ用。
typedef DWORD MESSAGETYPE;


//public import nemuxi.negui.proc.proc;
public import nemuxi.negui.draw.canvas;
//public import nemuxi.negui.window.menu.menu;
public import nemuxi.negui.dropfile;
public import nemuxi.negui.keyboard.keyboard;
public import nemuxi.negui.negui;
//import nemuxi.negui.window.menu.menu: COMMAND_ID;
//import nemuxi.negui.control.control: ITEM_ID;
import nemuxi.utility.meta.memberproperty;


invariant WM_MOUSEWHELL = 0x20A;

enum WINDOW_ACTIVE {
	INACTIVE    = WA_INACTIVE,    /// 非アクティブ化されます。
	ACTIVE      = WA_ACTIVE,      /// マウスクリック以外の方法（例えば、キーボードインターフェースによる選択や、 SetActiveWindow 関数によるもの）でアクティブ化されます。
	CLICKACTIVE = WA_CLICKACTIVE, /// マウスクリックによってアクティブ化されます。
}
alias WINDOW_ACTIVE WA;

enum SC {
	CLOSE        = SC_CLOSE        , /// ウィンドウを終了する
	CONTEXTHELP  = SC_CONTEXTHELP  , /// マウスポインタを疑問符付きにする
	DEFAULT      = SC_DEFAULT      , /// デフォルト項目を選択する
	HOTKEY       = SC_HOTKEY       , /// ホットキーに関連する
	HSCROLL      = SC_HSCROLL      , /// 水平方向にスクロールする
	ICON         = SC_ICON         , /// = SC_MINIMIZE
	KEYMENU      = SC_KEYMENU      , /// キーストロークを使用してメニューを取得
	MAXIMIZE     = SC_MAXIMIZE     , /// ウィンドウを最大化
	MINIMIZE     = SC_MINIMIZE     , /// ウィンドウをアイコン化
	MONITORPOWER = SC_MONITORPOWER , /// ディスプレイの電源管理状態を設定
	MOUSEMENU    = SC_MOUSEMENU    , /// マウスを使用してメニューを取得
	MOVE         = SC_MOVE         , /// ウィンドウを移動する
	NEXTWINDOW   = SC_NEXTWINDOW   , /// 次のウィンドウに移動
	PREVWINDOW   = SC_PREVWINDOW   , /// 前のウィンドウに移動
	RESTORE      = SC_RESTORE      , /// ウィンドウを元のサイズに戻す
	SCREENSAVE   = SC_SCREENSAVE   , /// スクリーンセーバを実行
	SIZE         = SC_SIZE         , /// ウィンドウのサイズを変更
	TASKLIST     = SC_TASKLIST     , /// タスクマネージャを実行
	VSCROLL      = SC_VSCROLL      , /// 水平方向にスクロールする
	ZOOM         = SC_ZOOM         , /// = SC_MAXIMIZE
}

/// WM_SIZE wParam
enum SIZE_TYPE: WPARAM {
	RESTORED  = SIZE_RESTORED,  ///	ウィンドウがサイズ変更されました。ただし最小化または最大化ではありません。
	MINIMIZED = SIZE_MINIMIZED, ///	ウィンドウが最小化されました。
	MAXIMIZED = SIZE_MAXIMIZED, ///	ウィンドウが最大化されました。
	MAXSHOW   = SIZE_MAXSHOW,   ///	ある他のウィンドウが元のサイズに戻されたとき、すべてのポップアップウィンドウに送られます。
	MAXHIDE   = SIZE_MAXHIDE,   ///	ある他のウィンドウが最大化されたとき、すべてのポップアップウィンドウに送られます。}
}


enum CONTROL_TYPE {
	BUTTON   = ODT_BUTTON  , /// ボタン
	COMBOBOX = ODT_COMBOBOX, /// コンボボックス
	LISTBOX  = ODT_LISTBOX , /// リストボックス
	LISTVIEW = ODT_LISTVIEW, /// リストビューコントロール
	MENU     = ODT_MENU    , /// メニュー
	STATIC   = ODT_STATIC  , /// スタティックコントロール
	TAB      = ODT_TAB     , /// タブ コントロール
}

unittest {
	assert(NMHDR.sizeof == NOTIFY.sizeof);
}
///
struct NOTIFY {
	NMHDR Nmhdr;
	mixin(SMixInStructHiddenOriginal!(void*)(q{Nmhdr}));

	//mixin(StructGetSet!(HWND)("handle", q{Nmhdr.hwndFrom}));
	NeGui sender() {
		return NeGui.getGuiObject(Nmhdr.hwndFrom);
	}
	mixin(StructGetSet!(ITEM_ID)("id", q{Nmhdr.idFrom}));
	mixin(StructGetSet!(MESSAGETYPE)("code", q{Nmhdr.code}));
}

deprecated enum ODT {
	BUTTON   = ODT_BUTTON  , /// ボタン
	COMBOBOX = ODT_COMBOBOX, /// コンボボックス
	LISTBOX  = ODT_LISTBOX , /// リストボックス
	LISTVIEW = ODT_LISTVIEW, /// リストビューコントロール
	MENU     = ODT_MENU    , /// メニュー
	STATIC   = ODT_STATIC  , /// スタティックコントロール
	TAB      = ODT_TAB     , /// タブ コントロール
}
unittest {
	assert(MEASUREITEMSTRUCT.sizeof == MEASUREITEM.sizeof);
}
/***/
struct MEASUREITEM {
	MEASUREITEMSTRUCT MeasureItem;
	mixin(SMixInStructHiddenOriginal!(MEASUREITEMSTRUCT*)(q{MeasureItem}));

	mixin(StructGetSet!(CONTROL_TYPE)("type", q{MeasureItem.CtlType}));
	mixin(StructGetSet!(ITEM_ID)("id", q{MeasureItem.CtlID}));

	mixin(StructGetSet!(COMMAND_ID)("commandID", q{MeasureItem.itemID}));
	
	mixin(StructGetSet!(int)("width", q{MeasureItem.itemWidth}));
	mixin(StructGetSet!(int)("height", q{MeasureItem.itemHeight}));

	mixin(StructGetSet!(void*)("data", q{MeasureItem.itemData}));
}
unittest {
	assert(DRAWITEMSTRUCT.sizeof == DRAWITEM.sizeof);
}
/***/
struct DRAWITEM {
	DRAWITEMSTRUCT DrawItem;
	mixin(SMixInStructHiddenOriginal!(DRAWITEMSTRUCT*)(q{DrawItem}));

	mixin(StructGetSet!(CONTROL_TYPE)("type", q{DrawItem.CtlType}));
	mixin(StructGetSet!(ITEM_ID)("id", q{DrawItem.CtlID}));
	mixin(StructGetSet!(COMMAND_ID)("commandID", q{DrawItem.itemID}));

	///
	enum ACTION {
		DRAWENTIRE = ODA_DRAWENTIRE, /// コントロール全体を描画する必要がある場合は、このビットが設定されます。
		FOUCS      = ODA_FOCUS     , /// コントロールが入力フォーカスを取得したり失ったりするときに、このビットが設定されます。itemState メンバをチェックして、コントロールがフォーカスを持っているかどうかを調べる必要があります。
		SELECT     = ODA_SELECT    , /// 選択項目のステータスが変更されたときにだけ、このビットが設定されます。itemState メンバをチェックして、新しい選択項目のステータスを調べる必要があります。
	}
	mixin(StructGetSet!(ACTION)("action", q{DrawItem.itemAction}));

	/// 現在の描画動作が行われた後の項目の表示状態を指定します。
	enum STATE {
		CHECKED      = ODS_CHECKED     , /// メニュー項目をチェックする場合は、このビットが設定されます。このビットはメニューだけで使われます。
		DISABLED     = ODS_DISABLED    , /// 項目を使用できない状態で描画する場合は、このビットが設定されます。
		FOCUS        = ODS_FOCUS       , /// 項目が入力フォーカスを持つ場合は、このビットが設定されます。
		GRAYED       = ODS_GRAYED      , /// 項目を淡色表示する場合は、このビットが設定されます。このビットはメニューだけで使われます。
		SELECTED     = ODS_SELECTED    , /// 項目が選択されている場合は、このビットが設定されます。
		COMBOBOXEDIT = ODS_COMBOBOXEDIT, /// 描画が、オーナー描画コンボ ボックスの選択フィールド (エディット コントロール) で行われます。
		DEFAULT      = ODS_DEFAULT     , /// 項目は既定の項目です。
	}
	mixin(StructGetSet!(STATE)("state", q{DrawItem.itemState}));

	Canvas canvas() {
		return new Canvas(DrawItem.hDC, false);
	}

	// これどうしよ
	mixin(StructGetSet!(HWND)("handle", q{DrawItem.hwndItem}));
	
	//mixin(StructGetSet!(RECT)("rect", q{DrawItem.rcItem}));
	ref RECT rect() {
		return DrawItem.rcItem;
	}
	mixin(StructGetSet!(void*)("data", q{DrawItem.itemData}));
}

enum MOUSE_KEY {
	CONTROL = MK_CONTROL, /// [Ctrl]が押されている
	LEFT    = MK_LBUTTON, /// 左のマウスボタンが押されている
	MIDDLE  = MK_MBUTTON, /// 中央のマウスボタンが押されている
	RIGHT   = MK_RBUTTON, /// 右のマウスボタンが押されている
	SHIFT   = MK_SHIFT  , /// [Shift]キーが押されている
	OTHERS_1= MK_XBUTTON1,
	OTHERS_2= MK_XBUTTON2,
}

enum {
	HTHSCROOL = 6,
}
enum HT {
	BORDER      = HTBORDER     , /// 可変枠を持たない境界線上にある
	BOTTOM      = HTBOTTOM     , /// 可変枠の下辺境界線上にある
	BOTTOMLEFT  = HTBOTTOMLEFT , /// 同、左下隅にある
	BOTTOMRIGHT = HTBOTTOMRIGHT, /// 同、右下隅にある
	CAPTION     = HTCAPTION    , /// キャプションバー上にある
	CLIENT      = HTCLIENT     , /// クライアント領域内にある
	ERROR       = HTERROR      , /// デスクトップ上にあり、警告音を鳴らす
	HSCROOL     = HTHSCROOL    , /// 水平スクロールバーないある
	LEFT        = HTLEFT       , /// 可変枠の左辺境界線上にある
	MENU        = HTMENU       , /// メニューバー内にある
	MINBUTTON   = HTMINBUTTON  , /// アイコン化ボタン上にある
	REDUCE      = HTREDUCE     , /// ditto
	MAXBUTTON   = HTMAXBUTTON  , /// 最大化ボタン上にある
	ZOOM        = HTZOOM       , /// ditto
	NOWHERE     = HTNOWHERE    , /// デスクトップ上にある
	RIGHT       = HTRIGHT      , /// 可変枠の右辺境界線上にある
	SIZE        = HTSIZE       , /// サイズボックス内にある
	GROWBOX     = HTGROWBOX    , /// ditto
	SYSMENU     = HTSYSMENU    , /// システムメニュー内にある
	TOP         = HTTOP        , /// 可変枠の上辺境界線上にある
	TOPLEFT     = HTTOPLEFT    , /// 可変枠の左上隅にある
	TOPRIGHT    = HTTOPRIGHT   , /// 可変枠の右上隅にある
	TRANSPARENT = HTTRANSPARENT, /// 同じスレッドの別のウィンドウの下にある
	VSCROLL     = HTVSCROLL    , /// 垂直スクロールバー内にある
}

///
enum SIDEFLAG {
	LEFT        = WMSZ_LEFT,        /// 左辺
	RIGHT       = WMSZ_RIGHT,       /// 右辺
	TOP         = WMSZ_TOP,         /// 上辺
	TOPLEFT     = WMSZ_TOPLEFT,     /// 左上隅
	TOPRIGHT    = WMSZ_TOPRIGHT,    /// 右上隅
	BOTTOM      = WMSZ_BOTTOM,      /// 底辺
	BOTTOMLEFT  = WMSZ_BOTTOMLEFT,  /// 左下隅
	BOTTOMRIGHT = WMSZ_BOTTOMRIGHT, /// 右下隅
}

///
enum MENU_FLAG: ushort {
	GRAYED      = MF_GRAYED      , /// アイテムは灰色表示されています。
	DISABLED    = MF_DISABLED    , /// アイテムは無効化されています。
	BITMAP      = MF_BITMAP      , /// アイテムはビットマップを表示します。
	POPUP       = MF_POPUP       , /// アイテムはドロップダウンメニューまたはサブメニューを持ちます。
	HILITE      = MF_HILITE      , /// アイテムはハイライト表示されています。
	OWNERDRAW   = MF_OWNERDRAW   , /// アイテムはオーナードローアイテムです。
	SYSMENU     = MF_SYSMENU     , /// アイテムはウィンドウメニュー（システムメニュー）に含まれています。 hMenu パラメータには、メッセージに関連付けられたメニューのハンドルが指定されます。
	MOUSESELECT = MF_MOUSESELECT , /// アイテムはマウス操作によって選択されています。
}
alias MENU_FLAG MF;

enum MESSAGE_TYPE: MESSAGETYPE {
	MENU        = 0,
	ACCELERATOR = 1,
}

enum {
	DLGC_WANTARROWS      = 0x0001,
	DLGC_WANTTAB         = 0x0002,
	DLGC_WANTALLKEYS     = 0x0004,
	DLGC_WANTMESSAGE     = 0x0004,
	DLGC_HASSETSEL       = 0x0008,
	DLGC_DEFPUSHBUTTON   = 0x0010,
	DLGC_UNDEFPUSHBUTTON = 0x0020,
	DLGC_RADIOBUTTON     = 0x0040,
	DLGC_WANTCHARS       = 0x0080,
	DLGC_STATIC          = 0x0100,
	DLGC_BUTTON          = 0x2000,
	DLGC_PUSHBUTTON = 0x0020,

}
enum DLGC {
	DEFPUSHBUTTON = DLGC_DEFPUSHBUTTON, /// デフォルトプッシュボタン
	HASSETSEL     = DLGC_HASSETSEL,     /// EM_SETSELメッセージ
	PUSHBUTTON    = DLGC_PUSHBUTTON,    /// プッシュボタン
	RADIOBUTTON   = DLGC_RADIOBUTTON,   /// オプションボタン
	WANTALLKEYS   = DLGC_WANTALLKEYS,   /// 全てのキーボード入力
	WANTARROWS    = DLGC_WANTARROWS,    /// 方向キー
	WANTCHARS     = DLGC_WANTCHARS,     /// WM_CHARメッセージ
	//WANTMESSAG    = DLGC_WANTMESSAG,    /// E全てのキーボード入力(アプリケーションはこのメッセージをコントロールに渡す)
	WANTTAB       = DLGC_WANTTAB,       /// [Tab]キー
}

///
enum PRF {
	CHECKVISIBLE = PRF_CHECKVISIBLE, /// 見えている状態のときのみ描画
	CHILDREN     = PRF_CHILDREN    , /// 可視状態の子ウィンドウを描画
	CLIENT       = PRF_CLIENT      , /// クライアント領域を描画
	ERASEBKGND   = PRF_ERASEBKGND  , /// 描画前に背景を再描画
	NONCLIENT    = PRF_NONCLIENT   , /// 非クライアント領域を描画
	OWNED        = PRF_OWNED       , /// 所有する全てのウィンドウを描画
}

typedef bool delegate() OnEraseBackGroundDg;
+/

/**
History:
	[V]:
		OnNonClientMouseXXX追加。
*/
template NeGuiEvent() {
	// いっくよー！
	protected {
		bool HoverFlag;
		//POINT ClickPos;
		/+
		struct CLICKPOS {
			short x;
			short y;
		}
		CLICKPOS ClickPos;
		+/
		NEGUIPOINT ClickPos;
		NEGUIPOINT NonClientClickPos;
	}
	protected {
		/// NeWindow作成時
		void OnCreate() {}
		/// OnCreat終了時
		void OnCreated() {}
		/// サイズ変更時。パネルのおかげで出番が少なくなりました。
		void OnSize(SIZE_TYPE, int Width, int Height) {}
		//void OnSizing(SIDEFLAG Sides, RECT* Rect) {}
		void OnSizing(SIDEFLAG Sides, ref RECT Rect) {}
		void OnMoving(SIDEFLAG Sides, ref RECT Rect) {}
		void OnWindowPosChanging(WINDOWPOS* WindowPos) {}
		//void OnWindowPosChanged(WINDOWPOS* WindowPos) {}
		void OnWindowPosChanged(ref WINDOWPOS WindowPos) {}
		bool OnMinMax(POINT* MaxSize, POINT* MaxPos, POINT* MaxTrack, POINT* MinTrack) { return false;}
		void OnEnterSizeMove() {}
		void OnExitSizeMove() {}

		/// 終了時の確認。trueで終了。
		bool OnClose() {
			return true;
		}
		/// 常にsuper.OnDestroyを最後に呼ぶべし。
		void OnDestroy() {
			Logger.write(this.classinfo.name ~ ".NeGuiDestroy()");
		}
		void OnMeasureItem(MEASUREITEM* Measure) {}
		void OnDrawItem(DRAWITEM* DrawItem) {}
		void OnActive(WINDOW_ACTIVE Active, bool NotSmall, HWND NextWnd) {}
		void OnActiveOther(in bool Active, in HANDLE OtherHandle) {}
		bool OnInitMenu(HMENU hMenu) { return false;}
		bool OnInitPupUpMenu(ITEM_ID Id, bool SystemFlag, HMENU hMenu) { return false;}
		void OnMenuSelect(ITEM_ID Id, MF MenuFlag, HMENU hMenu) {}
		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) { return false;}
		bool OnMenuCommand(COMMAND_ID Id) { return false;};
		bool OnAccelerator(COMMAND_ID Id) { return false;};
		void OnContexMenu(NeGui CatchItem, int x, int y) {}
		HT OnNcHitTest(HT HitFlag, int x, int y) { return HitFlag;}

		/// 処理した場合はtrue、しなければfalse。(あんまし関係ないけど)
		typedef bool delegate(HT HitFlag, int x, int y) NonClientMouseEvent;
		bool OnNonClientMouseLeftDown(HT HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseLeftUp(HT HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseLeftClick(HT HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseLeftDoubleClick(HT HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseRightDown(HT HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseRightUp(HT HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseRightClick(HT HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseRightDoubleClick(HT HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseMiddleDown(HT HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseMiddleUp(HT HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseMiddleClick(HT HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseMiddleDoubleClick(HT HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseOtherButtonDown(HT HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseOtherButtonUp(HT HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseOtherButtonClick(HT HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseOtherButtonDoubleClick(HT HitFlag, int x, int y) { return false;}
		bool OnNonClientMouseMove(HT HitFlag, int x, int y) { return false;}
		
		void OnEnable(bool Enable) {}
		
		void OnEnterFocus(NeGui LostedGui) {}
		void OnExitFocus(NeGui NewGui) {}

		void OnScroll(DIRECTION Direction, SCROLL Scroll, int Position, NeGui Sender) {}
		
		/// オブジェクト内でマウス移動[WM_MOUSEMOVE]
		void OnMouseMove(MOUSE_KEY Keys, int x, int y) {}
		/// マウスがオブジェクト内に入った。
		void OnMouseOver(MOUSE_KEY Keys, int x, int y) {}
		/// マウスがオブジェクト上に留まった。[WM_MOUSEHOVER]
		void OnMouseHover(MOUSE_KEY Keys, int x, int y) {}
		/// マウスがオブジェクトの外に出た。[WM_MOUSELEAVE]
		void OnMouseLeave(MOUSE_KEY Keys, int x, int y) {}
		///
		typedef bool delegate(MOUSE_KEY Keys, int x, int y) MouseEvent;
		/// 左ボタンが押された。[WM_LBUTTONDOWN]
		bool OnMouseLeftDown(MOUSE_KEY Keys, int x, int y) { return false;}
		/// 左ボタンが上げられた。[WM_LBUTTONUP]
		bool OnMouseLeftUp(MOUSE_KEY Keys, int x, int y) { return false;}
		/// 左ボタンがクリックされた。[WM_LBUTTONDOWN + WM_LBUTTONUP]
		bool OnMouseLeftClick(MOUSE_KEY Keys, int x, int y) { return false;}
		/// 左ボタンがダブルクリック[WM_LBUTTONDBLCLK]
		bool OnMouseLeftDoubleClick(MOUSE_KEY Keys, int x, int y) { return false;}
		/// 右ボタンが押された。[WM_RBUTTONDOWN]
		bool OnMouseRightDown(MOUSE_KEY Keys, int x, int y) { return false;}
		/// 右ボタンが上げられた。[WM_RBUTTONUP]
		bool OnMouseRightUp(MOUSE_KEY Keys, int x, int y) { return false;}
		/// 右ボタンがクリックされた。[WM_RBUTTONDOWN + WM_RBUTTONUP]
		bool OnMouseRightClick(MOUSE_KEY Keys, int x, int y) { return false;}
		/// 右ボタンがダブルクリック[WM_RBUTTONDBLCLK]
		bool OnMouseRightDoubleClick(MOUSE_KEY Keys, int x, int y) { return false;}
		/// ホイールが押された。[WM_MBUTTONDOWN]
		bool OnMouseMiddleDown(MOUSE_KEY Keys, int x, int y) { return false;}
		/// ホイールが上げられた。[WM_MBUTTONUP]
		bool OnMouseMiddleUp(MOUSE_KEY Keys, int x, int y) { return false;}
		/// ホイールがクリックされた。[WM_MBUTTONDOWN + WM_MBUTTONUP]
		bool OnMouseMiddleClick(MOUSE_KEY Keys, int x, int y) { return false;}
		/// ホイールがダブルクリック[WM_MBUTTONDBLCLK]
		bool OnMouseMiddleDoubleClick(MOUSE_KEY Keys, int x, int y) { return false;}
		/// ホイールが下に回された。[WM_MOUSEWHELL]
		bool OnMouseWhellDown(MOUSE_KEY Keys, int x, int y) { return false;}
		/// ホイールが上に回された。[WM_MOUSEWHELL]
		bool OnMouseWhellUp(MOUSE_KEY Keys, int x, int y) { return false;}
		/// X
		bool OnMouseOtherButtonDown(MOUSE_KEY Keys, int x, int y) { return false;}
		bool OnMouseOtherButtonUp(MOUSE_KEY Keys, int x, int y) { return false;}
		bool OnMouseOtherButtonClick(MOUSE_KEY Keys, int x, int y) { return false;}
		bool OnMouseOtherButtonDoubleClick(MOUSE_KEY Keys, int x, int y) { return false;}
		
		void OnKeyDown(in KEY Key, KEYDATA KeyData)
		in {
			assert(!KeyData.prev);
			assert(!KeyData.keyup);
		}
		body {}
		void OnKeyPress(in KEY Key, KEYDATA KeyData) {}
		void OnKeyUp(in KEY Key, KEYDATA KeyData)
		in {
			assert(!KeyData.context);
			assert(KeyData.prev);
			assert(KeyData.keyup);
		}
		body {}
		
		void OnDropFiles(DropFile drop) {};

		bool OnPaint(Canvas canvas, ref const(RECT) Rect, bool BackReDraw) { return false;}
		bool OnPrint(Canvas canvas, PRF Prf) { return false;}
		OnEraseBackGroundDg OnEraseBackGround(Canvas canvas) { return null;}
		
		void OnTimer(in TIMER_ID Id) {}
		void OnHotKey(HOTKEY_ID Id, HOTKEY HotKey, KEY VKey) {}
		int OnNotify(ITEM_ID Id, NOTIFY* Notify) { return 0;}
		bool OnOtherEvent(UINT Message, WPARAM wParam, LPARAM lParam) {return false;}

		void OnDisplayChange(int Bits, int Horizontal, int Vertical) {}

		void OnChildCreate(NeGui ChildGui) {}
		void OnChildDestroy(NeGui ChildGui) {}
		
		typedef void delegate(NeGui ChildGui, ref const(POINT) Point) ChildEvent;
		void OnChildMouseLeftDown(NeGui ChildGui, ref const(POINT) Point) {}
		void OnChildMouseRightDown(NeGui ChildGui, ref const(POINT) Point) {}
		void OnChildMouseMiddleDown(NeGui ChildGui, ref const(POINT) Point) {}
		void OnChildMouseOtherButtonDown(NeGui ChildGui, ref const(POINT) Point) {}
	}
	final private void OnChild(WPARAM wParam, LPARAM lParam) {
		switch(LOWORD(wParam)) {
			case WM_CREATE:
				if(auto gui=NeGui.getGuiObject(cast(HWND)lParam)) {
					OnChildCreate(gui);
				}
				break;
			
			case WM_DESTROY:
				OnChildDestroy(NeGui.getGuiObject(cast(HWND)lParam));
				break;

			case WM_LBUTTONDOWN, WM_RBUTTONDOWN, WM_MBUTTONDOWN, WM_XBUTTONDOWN:
				POINT Point;
				Point.x = cast(short)LOWORD(lParam);
				Point.y = cast(short)HIWORD(lParam);

				auto gui=child(Point);
				if(this !is gui) {
					ChildEvent OnChildEvent=void;
					switch(LOWORD(wParam)) {
						case WM_LBUTTONDOWN: OnChildEvent=&OnChildMouseLeftDown;        break;
						case WM_RBUTTONDOWN: OnChildEvent=&OnChildMouseRightDown;       break;
						case WM_MBUTTONDOWN: OnChildEvent=&OnChildMouseMiddleDown;      break;
						case WM_XBUTTONDOWN: OnChildEvent=&OnChildMouseOtherButtonDown; break;
						default:             assert(false);
					}
					OnChildEvent(gui, Point);
				}
				break;
			
			default:
				assert(false);
		}
	}
}

static struct EVENTLOOP {
static:
	typedef pure nothrow string function(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) EventLoopFunc;

	// 長いなぁ
	private {
		pure nothrow string SingleMethod(T...)(in string MethodName, in string NeGuiObject, in T Params) {
			return NeGuiObject ~ "." ~ MethodName ~ "(" ~ (Params.length ? join(", ", Params): string.init) ~ ")";
		}
		private pure nothrow string SingleMethodReturn(T...)(in string ReturnCode, in string MethodName, in string NeGuiObject, in T Params) {
			return `

			` ~ SingleMethod(MethodName, NeGuiObject, Params) ~ `;
			return ` ~ ReturnCode ~ `;

			`;
		}
		private pure nothrow string SingleMethodReturnQ(alias R="0", T...)(in string ReturnCode, in string MethodName, in string NeGuiObject, in T Params) {
			return `

			` ~ SingleMethod(MethodName, NeGuiObject, Params) ~ `;
			return ` ~ R ~ `;

			`;
		}
		private pure nothrow string SingleMethodGotoDefault(T...)(in string MethodName, in string NeGuiObject, in T Params) {
			//string JoinParams = Params.length ? join(", ", Params): string.init;
			/+
			foreach(Param; Params) {
				if(JoinParams.length) {
					JoinParams ~= ", ";
				}
				JoinParams ~= Param;
			}
			+/
			/+
			return `

			` ~ NeGuiObject ~ `.` ~ MethodName ~ `(` ~ JoinParams ~ `);
			goto default;

			`;
			+/
			return `

			` ~ SingleMethod(MethodName, NeGuiObject, Params) ~ `;
			goto default;

			`;
		}
	}

	pure nothrow string WM_TOP(CastType: NeGui)(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		static if(is(CastType: ISubClass)) {
			return `auto ` ~  NeGuiObject ~ ` = cast(` ~ CastType.stringof ~ `)NeGui.getGuiObject(` ~ hWnd ~ `);`;
		} else {
			return `

			auto ` ~  NeGuiObject ~ `= cast(` ~ CastType.stringof ~ `)NeGui.getGuiObject(` ~ hWnd ~ `);
			if(!` ~  NeGuiObject ~ ` && ` ~ Message ~ ` != WM_CREATE) {
				return DefWindowProc(` ~ hWnd ~ `, ` ~ Message ~ `, ` ~ wParam ~ `, ` ~ lParam ~ `);
			}
			
			`;
		}
	}
	deprecated alias WM_TOP ProcTop;
	
	deprecated pure nothrow string SubProcTop(CastType: NeGui)(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `auto ` ~  NeGuiObject ~ ` = cast(` ~ CastType.stringof ~ `)NeGui.getGuiObject(` ~ hWnd ~ `);`;
	}
	
	pure nothrow string WM_CREATE(CastType: NeGui)(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `
		
		assert(!` ~ NeGuiObject ~ `);
		try {
			` ~ NeGuiObject ~ ` = cast(` ~ CastType.stringof ~ `)
			cast(void*)(cast(CREATESTRUCT*)` ~ lParam ~ `).lpCreateParams;
			` ~ NeGuiObject ~ `.hItem = ` ~ hWnd ~ `;
			` ~ NeGuiObject ~ `.guiObject(` ~ NeGuiObject ~ `);
			` ~ NeGuiObject ~ `.layoutManager=new LayoutManager(` ~ NeGuiObject ~ `);
			` ~ NeGuiObject ~ `.OnCreate();
			` ~ NeGuiObject ~ `.OnCreated();
		} catch(Exception e) {
			Logger.write(e);
			return -1;
		}
		return 0;
		
		`;
	}
	pure nothrow string WM_SIZE(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `
		
		if(` ~ NeGuiObject ~ `) {
			auto Width  = LOWORD(` ~ lParam ~ `);
			auto Height = HIWORD(` ~ lParam ~ `);
			if(` ~ NeGuiObject ~ `.layoutManager) {
				` ~ NeGuiObject ~ `.layoutManager.onSize(Width, Height);
			}
			` ~ NeGuiObject ~ `.OnSize(cast(SIZE_TYPE)` ~ wParam ~ `, Width, Height);
		} else {
			goto default;
		}
		
		return 0;
		
		`;
	}

	pure nothrow string WM_SIZING(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		/+
		return `

		` ~ NeGuiObject ~ `.OnSizing(cast(SIDEFLAG)wParam, cast(RECT*)lParam);
		return 0;

		`;
		+/
		return SingleMethodReturn("0", q{OnSizing}, NeGuiObject, q{cast(SIDEFLAG)wParam}, q{*cast(RECT*)lParam});
	}

	pure nothrow string WM_MOVING(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		/+
		return `

		` ~ NeGuiObject ~ `.OnMoving(cast(SIDEFLAG)wParam, cast(RECT*)lParam);
		return 0;

		`;
		+/
		return SingleMethodReturn("0", q{OnMoving}, NeGuiObject, q{cast(SIDEFLAG)wParam}, q{*cast(RECT*)lParam});
	}

	pure nothrow string WM_ENTERSIZEMOVE(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		/+
		return `

		` ~ NeGuiObject ~ `.OnEnterSizeMove();
		goto default;
		
		`;
		+/
		return SingleMethodGotoDefault(q{OnEnterSizeMove}, NeGuiObject);
	}
	
	pure nothrow string WM_EXITSIZEMOVE(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return SingleMethodGotoDefault(q{OnExitSizeMove}, NeGuiObject);
	}
	pure nothrow string WM_WINDOWPOSCHANGING(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return SingleMethodGotoDefault(q{OnWindowPosChanging}, NeGuiObject, q{cast(WINDOWPOS*)lParam});
	}
	pure nothrow string WM_WINDOWPOSCHANGED(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return SingleMethodGotoDefault(q{OnWindowPosChanged}, NeGuiObject, q{*cast(WINDOWPOS*)lParam});
	}

	pure nothrow string WM_GETMINMAXINFO(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `

		auto info=cast(MINMAXINFO*)` ~ lParam ~ `;
		if(` ~ NeGuiObject ~ ` && ` ~ NeGuiObject ~ `.OnMinMax(&info.ptMaxSize, &info.ptMaxPosition, &info.ptMaxTrackSize, &info.ptMinTrackSize)) {
			return 0;
		} else {
			goto default;
		}
		
		`;
	}
	
	pure nothrow string WM_CLOSE(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `

		if(` ~ NeGuiObject ~ `.OnClose()) {
			` ~ NeGuiObject ~ `.destroy;
		}
		return 0;
		
		`;
	}
	
	pure nothrow string WM_DESTROY(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return SingleMethodReturn("0", q{OnDestroy}, NeGuiObject);
	}
	pure nothrow string WM_ACTIVATE(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return SingleMethodReturn("0", q{OnActive}, NeGuiObject, `cast(WA)LOWORD(` ~ wParam ~ `)`, `cast(bool)HIWORD(` ~ wParam ~ `)`, `cast(HWND)` ~ lParam);
	}
	pure nothrow string WM_ACTIVATEAPP(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return SingleMethodReturn("0", q{OnActiveOther}, NeGuiObject, wParam ~ ` == TRUE ? true: false`, `cast(HANDLE)` ~ lParam);
	}
	pure nothrow string WM_MEASUREITEM(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return SingleMethodReturn("1", q{OnMeasureItem}, NeGuiObject, `cast(MEASUREITEM*)` ~ lParam);
	}
	pure nothrow string WM_DRAWITEM(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return SingleMethodReturn("1", q{OnDrawItem}, NeGuiObject, `cast(DRAWITEM*)` ~ lParam);
	}
	
	pure nothrow string WM_INITMENU(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `

		if(` ~ NeGuiObject ~ `.OnInitMenu(cast(HMENU)` ~ wParam ~ `)) {
			return 0;
		} else {
			goto default;
		}
		
		`;
	}

	pure nothrow string WM_INITMENUPOPUP(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `
		
		if(` ~ NeGuiObject ~ `.OnInitPupUpMenu(cast(ITEM_ID)LOWORD(` ~ lParam ~ `), cast(bool)HIWORD(` ~ lParam ~ `), cast(HMENU)` ~ wParam ~ `)) {
			return 0;
		} else {
			goto default;
		}
		
		`;
	}

	pure nothrow string WM_MENUSELECT(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return SingleMethodReturn("0", q{OnMenuSelect}, NeGuiObject, `cast(ITEM_ID)LOWORD(` ~ wParam ~ `)`, `cast(MF)HIWORD(` ~ wParam ~ `)`, `cast(HMENU)` ~ lParam);
	}
	
	pure nothrow string WM_COMMAND(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `

		/+
		if(` ~ NeGuiObject ~ `.OnCommand(cast(ITEM_ID)LOWORD(` ~ wParam ~ `), cast(MESSAGETYPE)HIWORD(` ~ wParam ~ `), NeGui.getGuiObject(cast(HWND)` ~ lParam ~ `))) {
			return 0;
		} else {
			goto default;
		}
		+/
		
		auto MessageType=cast(MESSAGETYPE)HIWORD(` ~ wParam ~ `);
		auto Id=LOWORD(` ~ wParam ~ `);
		
		if(auto Sender=NeGui.getGuiObject(cast(HWND)` ~ lParam ~ `)) {
			if(` ~ NeGuiObject ~ `.OnCommand(cast(ITEM_ID)Id, MessageType, Sender)) {
				return 0;
			}
		} else {
			bool delegate(COMMAND_ID) OnEvent;
			switch(cast(MESSAGE_TYPE)MessageType) {
				case MESSAGE_TYPE.MENU:        OnEvent = &` ~ NeGuiObject ~ `.OnMenuCommand; break;
				case MESSAGE_TYPE.ACCELERATOR: OnEvent = &` ~ NeGuiObject ~ `.OnAccelerator; break;
				default: goto _default;
			}
			
			if(OnEvent(cast(COMMAND_ID)Id)) {
				return 0;
			}
			_default:;
		}
		goto default;
		`;
	}
	
	pure nothrow string WM_CONTEXTMENU(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return SingleMethodReturn("0", q{OnContexMenu}, NeGuiObject, `NeGui.getGuiObject(cast(HWND)` ~ wParam ~ `)`, `LOWORD(` ~ lParam ~ `)`, `HIWORD(` ~ lParam ~ `)`);
	}
	pure nothrow string WM_NCHITTEST(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `return ` ~ NeGuiObject ~ `.OnNcHitTest(cast(HT)DefWindowProc(` ~ hWnd ~ `, WM_NCHITTEST, ` ~ wParam ~ `, ` ~ lParam ~ `), LOWORD(` ~ wParam ~ `), HIWORD(` ~ lParam ~ `));`;
	}

	alias WM_NCBUTTONDOWN WM_NCLBUTTONDOWN;
	alias WM_NCBUTTONDOWN WM_NCRBUTTONDOWN;
	alias WM_NCBUTTONDOWN WM_NCMBUTTONDOWN;
	alias WM_NCBUTTONDOWN WM_NCXBUTTONDOWN;
	pure nothrow string WM_NCBUTTONDOWN(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `
		
		` ~ NeGuiObject ~ `.NonClientMouseEvent OnMouse=void;
		
		switch(` ~ Message ~ `) {
			case WM_NCLBUTTONDOWN:
				OnMouse = &` ~ NeGuiObject ~ `.OnNonClientMouseLeftDown;
				break;
			case WM_NCRBUTTONDOWN:
				OnMouse = &` ~ NeGuiObject ~ `.OnNonClientMouseRightDown;
				break;
			case WM_NCMBUTTONDOWN:
				OnMouse = &` ~ NeGuiObject ~ `.OnNonClientMouseMiddleDown;
				break;
			case WM_NCXBUTTONDOWN:
				OnMouse = &` ~ NeGuiObject ~ `.OnNonClientMouseOtherButtonDown;
				break;
			default:
				assert(false);
		}
		` ~ NeGuiObject ~ `.NonClientClickPos.lParam = ` ~ lParam ~ `;
		
		if(OnMouse(cast(HT)` ~ wParam ~ `, ` ~ NeGuiObject ~ `.NonClientClickPos.x, ` ~ NeGuiObject ~ `.NonClientClickPos.y)) {
			return 0;
		} else {
			goto default;
		}
		
		`;
	}
	alias WM_NCBUTTONUP WM_NCLBUTTONUP;
	alias WM_NCBUTTONUP WM_NCRBUTTONUP;
	alias WM_NCBUTTONUP WM_NCMBUTTONUP;
	alias WM_NCBUTTONUP WM_NCXBUTTONUP;
	pure nothrow string WM_NCBUTTONUP(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `
		
		//scope(exit) ReleaseCapture();
		
		` ~ NeGuiObject ~ `.NonClientMouseEvent OnMouseClick=void;
		` ~ NeGuiObject ~ `.NonClientMouseEvent OnMouseUp=void;

		/+
		` ~ NeGuiObject ~ `.CLICKPOS Pos;
		Pos.x = cast(short)LOWORD(` ~ lParam ~ `);
		Pos.y = cast(short)HIWORD(` ~ lParam ~ `);
		+/
		NEGUIPOINT Pos=void;
		Pos.lParam = ` ~ lParam ~ `;

		switch(` ~ Message ~ `) {
			case WM_NCLBUTTONUP:
				OnMouseClick = &` ~ NeGuiObject ~ `.OnNonClientMouseLeftClick;
				OnMouseUp    = &` ~ NeGuiObject ~ `.OnNonClientMouseLeftUp;
				break;
			case WM_NCRBUTTONUP:
				OnMouseClick = &` ~ NeGuiObject ~ `.OnNonClientMouseRightClick;
				OnMouseUp    = &` ~ NeGuiObject ~ `.OnNonClientMouseRightUp;
				break;
			case WM_NCMBUTTONUP:
				OnMouseClick = &` ~ NeGuiObject ~ `.OnNonClientMouseMiddleClick;
				OnMouseUp    = &` ~ NeGuiObject ~ `.OnNonClientMouseMiddleUp;
			case WM_NCXBUTTONUP:
				OnMouseClick = &` ~ NeGuiObject ~ `.OnNonClientMouseOtherButtonClick;
				OnMouseUp    = &` ~ NeGuiObject ~ `.OnNonClientMouseOtherButtonUp;
				break;
			default:
				assert(false);
		}
		if(` ~ NeGuiObject ~ `.NonClientClickPos == Pos) {
			OnMouseClick(cast(HT)` ~ wParam ~ `, Pos.x, Pos.y);
		}
		if(OnMouseUp(cast(HT)` ~ wParam ~ `, Pos.x, Pos.y)) {
			` ~ NeGuiObject ~ `.NonClientClickPos = ` ~ NeGuiObject ~ `.NonClientClickPos.init;
			return 0;
		} else {
			goto default;
		}

		`;
	}
	
	alias WM_NCBUTTONDBLCLK WM_NCLBUTTONDBLCLK;
	alias WM_NCBUTTONDBLCLK WM_NCRBUTTONDBLCLK;
	alias WM_NCBUTTONDBLCLK WM_NCMBUTTONDBLCLK;
	alias WM_NCBUTTONDBLCLK WM_NCXBUTTONDBLCLK;
	pure nothrow string WM_NCBUTTONDBLCLK(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `

		` ~ NeGuiObject ~ `.NonClientMouseEvent OnMouse=void;
	
		switch(` ~ Message ~ `) {
			case WM_NCLBUTTONDBLCLK:
				OnMouse = &` ~ NeGuiObject ~ `.OnNonClientMouseLeftDoubleClick;
				break;
			case WM_NCRBUTTONDBLCLK:
				OnMouse = &` ~ NeGuiObject ~ `.OnNonClientMouseRightDoubleClick;
				break;
			case WM_NCMBUTTONDBLCLK:
				OnMouse = &` ~ NeGuiObject ~ `.OnNonClientMouseMiddleDoubleClick;
				break;
			case WM_NCXBUTTONDBLCLK:
				OnMouse = &` ~ NeGuiObject ~ `.OnNonClientMouseOtherButtonDoubleClick;
				break;
			default:
				assert(false);
		}
		
		if(OnMouse(cast(HT)` ~ wParam ~ `, cast(short)LOWORD(` ~ lParam ~ `), cast(short)HIWORD(` ~ lParam ~ `))) {
			return 0;
		} else {
			goto default;
		}

		`;
	}
	pure nothrow string WM_NCMOUSEMOVE(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return SingleMethodReturn("false", q{OnNonClientMouseMove}, NeGuiObject, `cast(HT)` ~ wParam, `LOWORD(` ~ lParam ~ `)`, `HIWORD(` ~ lParam ~ `)`);
	}

	
	pure nothrow string WM_ENABLE(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return SingleMethodReturn("0", q{OnEnable}, NeGuiObject, `cast(bool)` ~ wParam);
	}

	pure nothrow string WM_SETFOCUS(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return SingleMethodReturn("0", q{OnEnterFocus}, NeGuiObject, `GetGui(cast(HWND)` ~ wParam ~ `)`);
	}
	pure nothrow string WM_KILLFOCUS(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return SingleMethodReturn("0", q{OnExitFocus}, NeGuiObject, `GetGui(cast(HWND)` ~ wParam ~ `)`);
	}

	alias WM_SCROLL WM_VSCROLL;
	alias WM_SCROLL WM_HSCROLL;
	pure nothrow string WM_SCROLL(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {

		return `
		
		immutable Direction= ` ~ Message ~ ` == WM_VSCROLL
			? DIRECTION.VERTICAL
			: DIRECTION.HORIZON
		;

		` ~ NeGuiObject ~ `.OnScroll(Direction, cast(SCROLL)LOWORD(` ~ wParam ~ `), HIWORD(` ~ wParam ~ `), GetGui(cast(HWND)` ~ lParam ~ `));

		return 0;
		
		`;
	}
	

	pure nothrow string WM_MOUSEMOVE(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		auto MouseKey = `cast(MOUSE_KEY)` ~ wParam;
		
		return `
		
		POINT Pos;
		Pos.x = cast(short)LOWORD(` ~ lParam ~ `);
		Pos.y = cast(short)HIWORD(` ~ lParam ~ `);
		
		if(!` ~ NeGuiObject ~ `.HoverFlag) {
			TRACKMOUSEEVENT TrackEvent;
			TrackEvent.cbSize      = TrackEvent.sizeof;
			TrackEvent.dwFlags     = TME_LEAVE | TME_HOVER;
			TrackEvent.hwndTrack   = ` ~ hWnd ~ `;
			TrackEvent.dwHoverTime = HOVER_DEFAULT;
			
			if(TrackMouseEvent(&TrackEvent) == 0)
				throw new NemuxiException(Text("WM_MOUSEMOVEイベントでミス"));
			
			` ~ NeGuiObject ~ `.HoverFlag = true;
			` ~ NeGuiObject ~ `.OnMouseOver(` ~ MouseKey ~ `, Pos.x, Pos.y);
		}
		` ~ NeGuiObject ~ `.OnMouseMove(` ~ MouseKey ~ `, Pos.x, Pos.y);
		return 0;
		
		`;
	}
	
	pure nothrow string WM_MOUSELEAVE(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return
			  NeGuiObject ~ `.HoverFlag = false;`
			~ SingleMethodReturn("0", q{OnMouseLeave}, NeGuiObject, `cast(MOUSE_KEY)` ~ wParam, `cast(short)LOWORD(` ~ lParam ~ `)`, `cast(short)HIWORD(` ~ lParam ~ `)`);
		
	}
	pure nothrow string WM_MOUSEHOVER(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return SingleMethodReturn("0", q{OnMouseLeave}, NeGuiObject, `cast(MOUSE_KEY)` ~ wParam, `cast(short)LOWORD(` ~ lParam ~ `)`, `cast(short)HIWORD(` ~ lParam ~ `)`);
	}

	alias WM_BUTTONDOWN WM_LBUTTONDOWN;
	alias WM_BUTTONDOWN WM_RBUTTONDOWN;
	alias WM_BUTTONDOWN WM_MBUTTONDOWN;
	alias WM_BUTTONDOWN WM_XBUTTONDOWN;
	pure nothrow string WM_BUTTONDOWN(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `
		
		SetCapture(` ~ hWnd ~ `); // キャプチャはどのタイミングでやんのか分からん。
		
		` ~ NeGuiObject ~ `.MouseEvent OnMouse=void;
		
		switch(` ~ Message ~ `) {
			case WM_LBUTTONDOWN:
				OnMouse = &` ~ NeGuiObject ~ `.OnMouseLeftDown;
				break;
			case WM_RBUTTONDOWN:
				OnMouse = &` ~ NeGuiObject ~ `.OnMouseRightDown;
				break;
			case WM_MBUTTONDOWN:
				OnMouse = &` ~ NeGuiObject ~ `.OnMouseMiddleDown;
				break;
			case WM_XBUTTONDOWN:
				OnMouse = &` ~ NeGuiObject ~ `.OnMouseOtherButtonDown;
				break;
			default:
				assert(false);
		}
		//` ~ NeGuiObject ~ `.ClickPos.x = cast(short)LOWORD(` ~ lParam ~ `);
		//` ~ NeGuiObject ~ `.ClickPos.y = cast(short)HIWORD(` ~ lParam ~ `);
		` ~ NeGuiObject ~ `.ClickPos.lParam = ` ~ lParam ~ `;
		
		if(OnMouse(cast(MOUSE_KEY)LOWORD(` ~ wParam ~ `), ` ~ NeGuiObject ~ `.ClickPos.x, ` ~ NeGuiObject ~ `.ClickPos.y)) {
			return 0;
		} else {
			goto default;
		}
		
		`;
	}

	alias WM_BUTTONUP WM_LBUTTONUP;
	alias WM_BUTTONUP WM_RBUTTONUP;
	alias WM_BUTTONUP WM_MBUTTONUP;
	alias WM_BUTTONUP WM_XBUTTONUP;
	pure nothrow string WM_BUTTONUP(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `
		
		scope(exit) ReleaseCapture();
		
		` ~ NeGuiObject ~ `.MouseEvent OnMouseClick=void;
		` ~ NeGuiObject ~ `.MouseEvent OnMouseUp=void;

		/+
		` ~ NeGuiObject ~ `.CLICKPOS Pos;
		Pos.x = cast(short)LOWORD(` ~ lParam ~ `);
		Pos.y = cast(short)HIWORD(` ~ lParam ~ `);
		+/
		NEGUIPOINT Pos=void;
		Pos.lParam = ` ~ lParam ~ `;

		switch(` ~ Message ~ `) {
			case WM_LBUTTONUP:
				OnMouseClick = &` ~ NeGuiObject ~ `.OnMouseLeftClick;
				OnMouseUp    = &` ~ NeGuiObject ~ `.OnMouseLeftUp;
				break;
			case WM_RBUTTONUP:
				OnMouseClick = &` ~ NeGuiObject ~ `.OnMouseRightClick;
				OnMouseUp    = &` ~ NeGuiObject ~ `.OnMouseRightUp;
				break;
			case WM_MBUTTONUP:
				OnMouseClick = &` ~ NeGuiObject ~ `.OnMouseMiddleClick;
				OnMouseUp    = &` ~ NeGuiObject ~ `.OnMouseMiddleUp;
			case WM_XBUTTONUP:
				OnMouseClick = &` ~ NeGuiObject ~ `.OnMouseOtherButtonClick;
				OnMouseUp    = &` ~ NeGuiObject ~ `.OnMouseOtherButtonUp;
				break;
			default:
				assert(false);
		}
		if(` ~ NeGuiObject ~ `.ClickPos == Pos) {
			OnMouseClick(cast(MOUSE_KEY)LOWORD(` ~ wParam ~ `), Pos.x, Pos.y);
		}
		if(OnMouseUp(cast(MOUSE_KEY)LOWORD(` ~ wParam ~ `), Pos.x, Pos.y)) {
			` ~ NeGuiObject ~ `.ClickPos = ` ~ NeGuiObject ~ `.ClickPos.init;
			return 0;
		} else {
			goto default;
		}

		`;
	}

	alias WM_BUTTONDBLCLK WM_LBUTTONDBLCLK;
	alias WM_BUTTONDBLCLK WM_RBUTTONDBLCLK;
	alias WM_BUTTONDBLCLK WM_MBUTTONDBLCLK;
	alias WM_BUTTONDBLCLK WM_XBUTTONDBLCLK;
	pure nothrow string WM_BUTTONDBLCLK(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `

		` ~ NeGuiObject ~ `.MouseEvent OnMouse=void;
	
		switch(` ~ Message ~ `) {
			case WM_LBUTTONDBLCLK:
				OnMouse = &` ~ NeGuiObject ~ `.OnMouseLeftDoubleClick;
				break;
			case WM_RBUTTONDBLCLK:
				OnMouse = &` ~ NeGuiObject ~ `.OnMouseRightDoubleClick;
				break;
			case WM_MBUTTONDBLCLK:
				OnMouse = &` ~ NeGuiObject ~ `.OnMouseMiddleDoubleClick;
				break;
			case WM_XBUTTONDBLCLK:
				OnMouse = &` ~ NeGuiObject ~ `.OnMouseOtherButtonDoubleClick;
				break;
			default:
				assert(false);
		}
		
		if(OnMouse(cast(MOUSE_KEY)LOWORD(` ~ wParam ~ `), cast(short)LOWORD(` ~ lParam ~ `), cast(short)HIWORD(` ~ lParam ~ `))) {
			return 0;
		} else {
			goto default;
		}

		`;
	}
	
	pure nothrow string WM_MOUSEWHELL(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `

		` ~ NeGuiObject ~ `.MouseEvent OnMouse=void;

		if(cast(short)HIWORD(` ~ wParam ~ `) > 0) {
			OnMouse = &` ~ NeGuiObject ~ `.OnMouseWhellUp;
		} else {
			OnMouse = &` ~ NeGuiObject ~ `.OnMouseWhellDown;
		}

		if(OnMouse(cast(MOUSE_KEY)LOWORD(` ~ wParam ~ `), cast(short)LOWORD(` ~ lParam ~ `), cast(short)HIWORD(` ~ lParam ~ `))) {
			return 0;
		} else {
			goto default;
		}

		`;
	}
	
	pure nothrow string WM_KEYDOWN(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `
		
		auto KeyData=KEYDATA(` ~ lParam ~ `);
		if(KeyData.prev) {
			` ~ NeGuiObject ~ `.OnKeyPress(cast(KEY)` ~ wParam ~ `, KeyData);
		} else {
			` ~ NeGuiObject ~ `.OnKeyDown(cast(KEY)` ~ wParam ~ `, KeyData);
		}
		return 0;

		`;
	}
	
	pure nothrow string WM_KEYUP(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return SingleMethodReturn("0", q{OnKeyUp}, NeGuiObject, `cast(KEY)` ~ wParam, `cast(KEYDATA)` ~ lParam);
	}
	
	pure nothrow string WM_DROPFILES(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `
		
			scope drop=new DropFile(cast(HDROP)` ~ wParam ~ `, true);
			` ~ NeGuiObject ~ `.OnDropFiles(drop);
		
		`;
	}

	pure nothrow string WM_PAINT(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `

		PAINTSTRUCT Paint;
		scope canvas=` ~ NeGuiObject ~ `.beguinPaint(Paint);
		scope(exit) ` ~ NeGuiObject ~ `.endPaint(Paint);

		if(` ~ NeGuiObject ~ `.OnPaint(canvas, Paint.rcPaint, Paint.fErase == 1 ? true: false)) {
			return 0;
		} else {
			goto default;
		}

		`;
	}
	
	pure nothrow string WM_PRINT(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `

		scope canvas=new Canvas(cast(HDC)` ~ wParam ~ `, false);

		if(` ~ NeGuiObject ~ `.OnPrint(canvas, cast(PRF)` ~ lParam ~ `)) {
			return 0;
		} else {
			goto default;
		}

		`;
	}

	pure nothrow string WM_ERASEBKGND(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `

		scope canvas=new Canvas(cast(HDC)` ~ wParam ~ `, false);
		auto dg=` ~ NeGuiObject ~ `.OnEraseBackGround(canvas);
		if(dg) {
			return cast(LRESULT)dg();
		} else {
			goto default;
		}

		`;
	}
	
	pure nothrow string WM_HOTKEY(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return SingleMethodReturn("0", q{OnHotKey}, NeGuiObject, `cast(HOTKEY_ID)` ~ wParam, `cast(HOTKEY)LOWORD(` ~ lParam ~ `)`, `cast(KEY)HIWORD(` ~ lParam ~ `)`);
	}
	pure nothrow string WM_TIMER(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return SingleMethodReturn("0", q{OnTimer}, NeGuiObject, `cast(TIMER_ID)` ~ wParam);
	}

	pure nothrow string WM_NOTIFY(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `

		if(auto NotifyCode=` ~ NeGuiObject ~ `.OnNotify(cast(ITEM_ID)` ~ wParam ~ `, cast(NOTIFY*)` ~ lParam ~ `)) {
			return NotifyCode;
		} else {
			goto default;
		}

		`;
	}

	pure nothrow string WM_PARENTNOTIFY(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return SingleMethodGotoDefault(q{OnChild}, NeGuiObject, wParam, lParam);
	}

	pure nothrow string WM_DISPLAYCHANGE(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return SingleMethodGotoDefault(q{OnDisplayChange}, NeGuiObject, wParam, `LOWORD(` ~ lParam ~ `)`, `HIWORD(` ~ lParam ~ `)`);
	}

	pure nothrow string WM_DEFAULT(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `

		if(` ~ NeGuiObject ~ ` && ` ~ NeGuiObject ~ `.OnOtherEvent(` ~ Message ~ `, ` ~ wParam ~ `, ` ~ lParam ~ `)) {
			return 0;
		} else {
			break;
		}
		
		`;
	}
	deprecated pure nothrow string WM_DEFAULT_SUBCLASS(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		return `return ` ~ NeGuiObject ~ `.Subclass.call(` ~ hWnd ~ `, ` ~ Message ~ `, ` ~ wParam ~ `, ` ~ lParam ~ `);`;
	}
	pure nothrow string WM_LAST(T: NeGui)(in string NeGuiObject=ARG_GUIOBJECT, in string hWnd=ARG_HWND, in string Message=ARG_MESSAGE, in string wParam=ARG_WPARAM, in string lParam=ARG_LPALAM) {
		static if(is(T: ISubClass)) {
			return `return ` ~ NeGuiObject ~ `.call(` ~ hWnd ~ `, ` ~ Message ~ `, ` ~ wParam ~ `, ` ~ lParam ~ `);`;
		} else {
			return `return DefWindowProc(` ~ hWnd ~ `, ` ~ Message ~ `, ` ~ wParam ~ `, ` ~ lParam ~ `);`;
		}
	}

}

/**
History:
	[V]:
		WM_NCLBUTTONDOWN,   WM_NCRBUTTONDOWN,   WM_NCMBUTTONDOWN,   WM_NCXBUTTONDOWN,
		WM_NCLBUTTONUP,     WM_NCRBUTTONUP,     WM_NCMBUTTONUP,     WM_NCXBUTTONUP,
		WM_NCLBUTTONDBLCLK, WM_NCRBUTTONDBLCLK, WM_NCMBUTTONDBLCLK, WM_NCXBUTTONDBLCLKの追加。
		WM_XBUTTONUP, WM_XBUTTONDOWN, WM_XBUTTONDBLCLKを拾ってなかったのでそれを修正。

*/
template MixInNeGuiEventProc(NEGUI: NeGui) {
	private static extern(Windows) LRESULT NeGuiEventProc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam) {
		mixin(EVENTLOOP.WM_TOP!(NEGUI));
		
		switch(Message) {
			case WM_CREATE: {
				mixin(EVENTLOOP.WM_CREATE!(NEGUI));
			}
			
			case WM_SIZE: {
				mixin(EVENTLOOP.WM_SIZE());
			}
			
			case WM_SIZING: {
				mixin(EVENTLOOP.WM_SIZING());
			}
			case WM_MOVING: {
				mixin(EVENTLOOP.WM_MOVING());
			}
			case WM_ENTERSIZEMOVE: {
				mixin(EVENTLOOP.WM_ENTERSIZEMOVE());
			}
			case WM_EXITSIZEMOVE: {
				mixin(EVENTLOOP.WM_EXITSIZEMOVE());
			}
			case WM_WINDOWPOSCHANGING: {
				mixin(EVENTLOOP.WM_WINDOWPOSCHANGING());
			}
			case WM_WINDOWPOSCHANGED: {
				mixin(EVENTLOOP.WM_WINDOWPOSCHANGED());
			}
			case WM_GETMINMAXINFO: {
				mixin(EVENTLOOP.WM_GETMINMAXINFO());
			}
			case WM_CLOSE: {
				mixin(EVENTLOOP.WM_CLOSE());
			}
			case WM_DESTROY: {
				mixin(EVENTLOOP.WM_DESTROY());
			}
			case WM_ACTIVATE: {
				mixin(EVENTLOOP.WM_ACTIVATE());
			}
			case WM_ACTIVATEAPP: {
				mixin(EVENTLOOP.WM_ACTIVATEAPP());
			}
			case WM_MEASUREITEM: {
				mixin(EVENTLOOP.WM_MEASUREITEM());
			}
			case WM_DRAWITEM: {
				mixin(EVENTLOOP.WM_DRAWITEM());
			}
			case WM_INITMENU: {
				mixin(EVENTLOOP.WM_INITMENU());
			}
			case WM_INITMENUPOPUP: {
				mixin(EVENTLOOP.WM_INITMENUPOPUP());
			}
			case WM_MENUSELECT: {
				mixin(EVENTLOOP.WM_MENUSELECT());
			}
			case WM_COMMAND: {
				mixin(EVENTLOOP.WM_COMMAND());
			}
			case WM_CONTEXTMENU: {
				mixin(EVENTLOOP.WM_CONTEXTMENU());
			}
			case WM_NCHITTEST: {
				mixin(EVENTLOOP.WM_NCHITTEST());
			}
			
			case WM_NCLBUTTONDOWN, WM_NCRBUTTONDOWN, WM_NCMBUTTONDOWN, WM_NCXBUTTONDOWN: {
				mixin(EVENTLOOP.WM_NCBUTTONDOWN());
			}
			case WM_NCLBUTTONUP, WM_NCRBUTTONUP, WM_NCMBUTTONUP, WM_NCXBUTTONUP: {
				mixin(EVENTLOOP.WM_NCBUTTONUP());
			}
			case WM_NCLBUTTONDBLCLK, WM_NCRBUTTONDBLCLK, WM_NCMBUTTONDBLCLK, WM_NCXBUTTONDBLCLK: {
				mixin(EVENTLOOP.WM_NCBUTTONDBLCLK());
			}
			case WM_NCMOUSEMOVE: {
				mixin(EVENTLOOP.WM_NCMOUSEMOVE());
			}

			case WM_ENABLE: {
				mixin(EVENTLOOP.WM_ENABLE());
			}
			
			case WM_SETFOCUS: {
				mixin(EVENTLOOP.WM_SETFOCUS());
			}
			case WM_KILLFOCUS: {
				mixin(EVENTLOOP.WM_KILLFOCUS());
			}
			
			case WM_VSCROLL, WM_HSCROLL: {
				mixin(EVENTLOOP.WM_SCROLL());
			}
			
			case WM_MOUSEMOVE: {
				mixin(EVENTLOOP.WM_MOUSEMOVE());
			}
			case WM_MOUSELEAVE: {
				mixin(EVENTLOOP.WM_MOUSELEAVE());
			}
			case WM_MOUSEHOVER: {
				mixin(EVENTLOOP.WM_MOUSEHOVER());
			}

			case WM_LBUTTONDOWN, WM_RBUTTONDOWN, WM_MBUTTONDOWN, WM_XBUTTONDOWN: {
				mixin(EVENTLOOP.WM_BUTTONDOWN());
			}
			case WM_LBUTTONUP, WM_RBUTTONUP, WM_MBUTTONUP, WM_XBUTTONUP: {
				mixin(EVENTLOOP.WM_BUTTONUP());
			}
			case WM_LBUTTONDBLCLK, WM_RBUTTONDBLCLK, WM_MBUTTONDBLCLK, WM_XBUTTONDBLCLK: {
				mixin(EVENTLOOP.WM_BUTTONDBLCLK());
			}
			case WM_MOUSEWHELL: {
				mixin(EVENTLOOP.WM_MOUSEWHELL());
			}
			case WM_KEYDOWN: {
				mixin(EVENTLOOP.WM_KEYDOWN());
			}
			case WM_KEYUP: {
				mixin(EVENTLOOP.WM_KEYDOWN());
			}
			case WM_DROPFILES: {
				mixin(EVENTLOOP.WM_DROPFILES());
			}
			case WM_PAINT: {
				mixin(EVENTLOOP.WM_PAINT());
			}
			case WM_PRINT: {
				mixin(EVENTLOOP.WM_PRINT());
			}
			case WM_ERASEBKGND: {
				mixin(EVENTLOOP.WM_ERASEBKGND());
			}
			
			case WM_HOTKEY: {
				mixin(EVENTLOOP.WM_HOTKEY());
			}
			
			case WM_TIMER: {
				mixin(EVENTLOOP.WM_TIMER());
			}

			case WM_NOTIFY: {
				mixin(EVENTLOOP.WM_NOTIFY());
			}
			
			case WM_DISPLAYCHANGE: {
				mixin(EVENTLOOP.WM_DISPLAYCHANGE());
			}
			
			case WM_PARENTNOTIFY: {
				mixin(EVENTLOOP.WM_PARENTNOTIFY());
			}

			default: {
				mixin(EVENTLOOP.WM_DEFAULT());
			}
		}
		mixin(EVENTLOOP.WM_LAST!(NEGUI)());
	}
}

