﻿/**

*/
module nemuxi.negui.draw.cursor;

debug import std.stdio: wl = writefln, pl = printf;

debug(cursor) void main() {}

import std.contracts;

import win32.windows;

import nemuxi.base;
import nemuxi.system.raii;
import nemuxi.negui.draw.draw;


class Cursor: Draw {
	//protected HCURSOR hCursor;
	protected alias Handle hCursor;
	mixin KillResource!("カーソル", hCursor, DestroyCursor, 0);

	mixin HandleRaiiClass;

	/// カーソル位置設定。
	static bool setPos(in int x, in int y) {
		return SetCursorPos(x, y)
			? true
			: false
		;
	}
	/// ditto
	static bool setPos(ref const(POINT) Point) {
		return setPos(Point.x, Point.y);
	}

	/// カーソル位置取得。
	deprecated static bool getPos(out int x, out int y) {
		POINT Point=void;
		if(getPos(Point)) {
			x = Point.x;
			y = Point.y;
			
			return true;
		}
		return false;
	}
	/// ditto
	deprecated static bool getPos(ref POINT Point) {
		return GetCursorPos(&Point)
			? true
			: false
		;
	}

	/***/
	static ref POINT getPos() {
		auto Point=new POINT;

		enforce(GetCursorPos(Point), new CursorException(Err.toString));

		return *Point;
	}
}



