﻿/**

*/
module nemuxi.negui.draw.color;

debug import std.stdio: wl = writefln, pl = printf;
debug(color) void main() {}

import std.string;
import std.math;

import win32.winuser;

import nemuxi.base;

///
private template COLORBODY() {
	union {
		/// カラーコード。
		uint code;
		///
		struct {
			/// 赤成分。
			ubyte r;
			/// 緑成分。
			ubyte g;
			/// 青成分。
			ubyte b;
			/// 透明度 (ubyte.min, ubyte.max) = (不透明, 完全透明)
			ubyte a;
		}
	}
	///
	const Text toHexColor(in bool Upper=true, in bool Alpha=false) {
		invariant Formater=Upper ? "%02X": "%02x";
		Text color;
		
		if(Alpha) {
			color = format(Formater.repeat(4), r, g, b, a);
		} else {
			color = format(Formater.repeat(3), r, g, b);
		}
		
		return color;
	}

	/// (X)HTMLで使用するカラーコードを取得。
	const Text toHTML(in bool Upper=true) {
		return Text("#" ~ toHexColor(Upper).toString());
	}

	/// RGBの配列。
	const ubyte[] toRGBArray() {
		return [r, g, b];
	}

	///
	const string toString() {
		return format("%s, %s, %s, %s", r, g, b, a);
	}
	static {
		COLOR opCall(ubyte r, ubyte g, ubyte b, ubyte a=a.init) {
			COLOR color;
			
			color.r = r;
			color.g = g;
			color.b = b;
			color.a = a;
			
			return color;
		}
		COLOR opCall(ubyte[] rgba)
		in {
			assert(3 <= rgba.length && rgba.length <= 4);
		}
		body {
			COLOR color;
			
			color.r = rgba[0];
			color.g = rgba[1];
			color.b = rgba[2];
			if(rgba.length == 4) {
				color.a = rgba[3];
			} else {
				color.a = ubyte.init;;
			}
			
			return color;
		}
		COLOR opCall(uint code) {
			COLOR color;
			
			color.code = code;
			
			return color;
		}
	}
}

deprecated alias COLOR Color;
deprecated alias SYSTEMCOLOR SystemColor;
/**
色。
*/
struct COLOR {
	/+
	union {
		/// カラーコード。
		uint code;
		///
		struct {
			/// 赤成分。
			ubyte r;
			/// 緑成分。
			ubyte g;
			/// 青成分。
			ubyte b;
			/// 透明度 (ubyte.min, ubyte.max) = (不透明, 完全透明)
			ubyte a;
		}
	}
	+/
	mixin COLORBODY;

	/**
	現在色を反転。
	*/
	const COLOR negative() {
		COLOR color;
		color.r = cast(ubyte)(ubyte.max - r);
		color.g = cast(ubyte)(ubyte.max - g);
		color.b = cast(ubyte)(ubyte.max - b);
	
		return color;
	}


	static {
		///
		COLOR Maroon() {
			return COLOR(0x80, 0x00, 0x00);
		}
		///
		COLOR Red() {
			return COLOR(0xff, 0x00, 0x00);
		}
		///
		COLOR Purple() {
			return COLOR(0x80, 0x00, 0x80);
		}
		///
		COLOR Fuchsia() {
			return COLOR(0xff, 0x00, 0xff);
		}
		///
		COLOR Yellow() {
			return COLOR(0xff, 0xff, 0x00);
		}
		///
		COLOR Lime() {
			return COLOR(0x00, 0xff, 0x00);
		}
		///
		COLOR Olive() {
			return COLOR(0x80, 0x80, 0x00);
		}
		///
		COLOR Green() {
			return COLOR(0x00, 0x80, 0x00);
		}
		///
		COLOR Navy() {
			return COLOR(0x00, 0x00, 0x80);
		}
		///
		COLOR Blue() {
			return COLOR(0x00, 0x00, 0xff);
		}
		///
		COLOR Teal() {
			return COLOR(0x00, 0x80, 0x80);
		}
		///
		COLOR Aqua() {
			return COLOR(0x00, 0xff, 0xff);
		}
		///
		COLOR Silver() {
			return COLOR(0xc0, 0xc0, 0xc0);
		}
		///
		COLOR White() {
			return COLOR(0xff, 0xff, 0xff);
		}
		///
		COLOR Gray() {
			return COLOR(0x80, 0x80, 0x00);
		}
		///
		COLOR Black() {
			return COLOR(0x00, 0x00, 0x00);
		}
		debug(color) unittest {
			assert(COLOR.Maroon.toHTML  == "#800000");
			assert(COLOR.Red.toHTML     == "#FF0000");
			assert(COLOR.Purple.toHTML  == "#800080");
			assert(COLOR.Fuchsia.toHTML == "#FF00FF");
			
			assert(COLOR.Yellow.toHTML  == "#FFFF00");
			assert(COLOR.Lime.toHTML    == "#00FF00");
			assert(COLOR.Olive.toHTML   == "#808000");
			assert(COLOR.Green.toHTML   == "#008000");
			
			assert(COLOR.Navy.toHTML    == "#000080");
			assert(COLOR.Blue.toHTML    == "#0000FF");
			assert(COLOR.Teal.toHTML    == "#008080");
			assert(COLOR.Aqua.toHTML    == "#00FFFF");
			
			assert(COLOR.Silver.toHTML  == "#C0C0C0");
			assert(COLOR.White.toHTML   == "#FFFFFF");
			assert(COLOR.Gray.toHTML    == "#808000");
			assert(COLOR.Black.toHTML   == "#000000");
		}
	}
}

enum {
	COLOR_3DFRAME = 15,
	COLOR_BTN_HIGHLIGHT = 20,
	COLOR_GRANDIENTACTIVECAPTION = 27,
	COLOR_GRANDIENTINACTIVECAPTION = 28,
	COLOR_INACTIVECAPTIPON = 3,
}

/**
*/
struct SYSTEMCOLOR {
	mixin COLORBODY;
	int index;

	const COLOR opCast() {
		return cast(COLOR)code;
	}
	
	static {
		///
		SYSTEMCOLOR opCall(int index) {
			SYSTEMCOLOR sc;
			sc.code  = GetSysColor(index);
			sc.index = index;
			return sc;
		}

		/// 3D表示の暗い影色
		SYSTEMCOLOR DarkShadow() {
			return SYSTEMCOLOR(COLOR_3DDKSHADOW);
		}
		///COLOR_BTNFACE
		SYSTEMCOLOR Frame() {
			return SYSTEMCOLOR(COLOR_3DFRAME);
		}
		///COLOR_BTNHIGHCOLOR
		SYSTEMCOLOR HighLight() {
			return SYSTEMCOLOR(COLOR_3DHIGHLIGHT);
		}
		///3D表示の明るい色
		SYSTEMCOLOR Light() {
			return SYSTEMCOLOR(COLOR_3DLIGHT);
		}
		///COLOR_BTNSHADOW
		SYSTEMCOLOR Shadow() {
			return SYSTEMCOLOR(COLOR_3DSHADOW);
		}
		///アクティブウィンドウの境界線
		SYSTEMCOLOR ActiveBorder() {
			return SYSTEMCOLOR(COLOR_ACTIVEBORDER);
		}
		///アクティブウィンドウのキャプション
		SYSTEMCOLOR ActiveCaption() {
			return SYSTEMCOLOR(COLOR_ACTIVECAPTION);
		}
		///MDIアプリケーションの背景色
		SYSTEMCOLOR WorkSpace() {
			return SYSTEMCOLOR(COLOR_APPWORKSPACE);
		}
		///デスクトップの背景色
		SYSTEMCOLOR BackGround() {
			return SYSTEMCOLOR(COLOR_BACKGROUND);
		}
		///コマンドボタンの表面色
		SYSTEMCOLOR ButtonFace() {
			return SYSTEMCOLOR(COLOR_BTNFACE);
		}
		///コマンドボタンの強調表示のときの色
		SYSTEMCOLOR ButtonFaceStrong() {
			return SYSTEMCOLOR(COLOR_BTN_HIGHLIGHT);
		}
		///コマンドボタンの影色
		SYSTEMCOLOR ButtonShadow() {
			return SYSTEMCOLOR(COLOR_BTNSHADOW);
		}
		///コマンドボタンの文字色
		SYSTEMCOLOR ButtonText() {
			return SYSTEMCOLOR(COLOR_BTNTEXT);
		}
		///キャプションバーの文字色
		SYSTEMCOLOR CaptionText() {
			return SYSTEMCOLOR(COLOR_CAPTIONTEXT);
		}
		///COLOR_BACKGROUND
		SYSTEMCOLOR DeskTop() {
			return SYSTEMCOLOR(COLOR_DESKTOP);
		}
		///アルティブなタイトルバーのグラデーション色
		SYSTEMCOLOR ActiveCaptionGradation() {
			return SYSTEMCOLOR(COLOR_GRANDIENTACTIVECAPTION);
		}
		///非アクティブなタイトルバーのグラデーション色
		SYSTEMCOLOR InActiveCaptionGradation() {
			return SYSTEMCOLOR(COLOR_GRANDIENTINACTIVECAPTION);
		}
		///グレー表示の文字色
		SYSTEMCOLOR GrayText() {
			return SYSTEMCOLOR(COLOR_GRAYTEXT);
		}
		///選択された項目の背景色
		SYSTEMCOLOR SelectedBack() {
			return SYSTEMCOLOR(COLOR_HIGHLIGHT);
		}
		///選択された項目の文字色
		SYSTEMCOLOR SelectedText() {
			return SYSTEMCOLOR(COLOR_HIGHLIGHTTEXT);
		}
		///ホットトラックの文字色(Win98以降)
		SYSTEMCOLOR HotTrack() {
			return SYSTEMCOLOR(COLOR_HOTLIGHT);
		}
		///非アクティブウィンドウの境界線色
		SYSTEMCOLOR InActiveBorder() {
			return SYSTEMCOLOR(COLOR_INACTIVEBORDER);
		}
		///非アクティブウィンドウのタイトルバーの背景色
		SYSTEMCOLOR InActiveCaption() {
			return SYSTEMCOLOR(COLOR_INACTIVECAPTIPON);
		}
		///非アクティブウィンドウの文字色
		SYSTEMCOLOR InActiveCaptionText() {
			return SYSTEMCOLOR(COLOR_INACTIVECAPTIONTEXT);
		}
		///ツールチップの背景色
		SYSTEMCOLOR ToolTipBack() {
			return SYSTEMCOLOR(COLOR_INFOBK);
		}
		///ツールチップの文字色
		SYSTEMCOLOR ToolTipText() {
			return SYSTEMCOLOR(COLOR_INFOTEXT);
		}
		///メニューの背景色
		SYSTEMCOLOR MenuBack() {
			return SYSTEMCOLOR(COLOR_MENU);
		}
		///メニューの文字色
		SYSTEMCOLOR MenuText() {
			return SYSTEMCOLOR(COLOR_MENUTEXT);
		}
		///スクロールバーの色
		SYSTEMCOLOR ScrollBar() {
			return SYSTEMCOLOR(COLOR_SCROLLBAR);
		}
		///ウィンドウの背景色
		SYSTEMCOLOR WindowBack() {
			return SYSTEMCOLOR(COLOR_WINDOW);
		}
		///ウィンドウの枠色
		SYSTEMCOLOR WindowBorder() {
			return SYSTEMCOLOR(COLOR_WINDOWFRAME);
		}
		///ウィンドウの文字色
		SYSTEMCOLOR WindowText() {
			return SYSTEMCOLOR(COLOR_WINDOWTEXT);
		}
	}
}
debug(color) unittest {
	COLOR c;
	SYSTEMCOLOR s;

	assert(c.r.offsetof == s.r.offsetof);
	assert(c.g.offsetof == s.g.offsetof);
	assert(c.b.offsetof == s.b.offsetof);
	assert(c.a.offsetof == s.a.offsetof);
}

