﻿/**

*/
module nemuxi.negui.draw.brush;

debug import std.stdio: wl = writefln, pl = printf;

debug(brush) void main() {}

import win32.windows;

import nemuxi.base;
import nemuxi.system.raii;
import nemuxi.negui.draw.draw;
import nemuxi.negui.draw.color;


/**
*/
class Brush: Draw {
	protected alias Handle hBrush;
	mixin KillResource!("ブラシ", hBrush, DeleteObject, 0);
	/+
	override void Kill() {
		if(!hBrush)
			throw new NeGuiException(Text("ブラシが未設定"));

		
		debug {
			debug wd(wf("Brush.Kill == %s", DeleteObject(hBrush)));
		} else {
			DeleteObject(hBrush);
		}
	}
	+/
	mixin GetImportObject!("ブラシ", hBrush, LOGBRUSH, CreateBrushIndirect);

	static {
		///
		enum STYLE {
			DIBPATTERN   = BS_DIBPATTERN,   /// デバイスに依存しないビットマップ（DIB）仕様で定義されるパターン ブラシです。lbHatch メンバはパックされた DIB のハンドルを保持します。
			DIBPATTERNPT = BS_DIBPATTERNPT, /// デバイスに依存しないビットマップ（DIB）仕様で定義されるパターン ブラシです。lbHatch メンバはパックされた DIB へのポインタを保持します。
			HATCHED      = BS_HATCHED,      /// ハッチ ブラシです。
			HOLLOW       = BS_HOLLOW,       /// 透明ブラシです。
			NULL         = BS_NULL,         /// ditto
			PATTERN      = BS_PATTERN,      /// メモリ ビットマップで定義されるパターン ブラシです。
			SOLID        = BS_SOLID,        /// 純色のブラシです。
		}
		///
		enum HATCH {
			BDIAGONAL  = HS_BDIAGONAL,  /// 左下から右上への 45 度のハッチ
			CROSS      = HS_CROSS,      /// 水平、垂直の格子状のハッチ
			DIAGCROSS  = HS_DIAGCROSS,  /// 45度の格子状のハッチ
			FDIAGONAL  = HS_FDIAGONAL,  /// 左上から右下への 45 度のハッチ
			HORIZONTAL = HS_HORIZONTAL, /// 水平のハッチ
			VERTICAL   = HS_VERTICAL,   /// 垂直のハッチ
		}
	}

	this(HBRUSH hBrush, bool Suicide) {
		/+
		this.Suicide = Suicide;
		this.hBrush  = hBrush;
		+/
		super(hBrush, Suicide);
	}

	///
	static enum STOCK {
		BLACK     = BLACK_BRUSH,  /// 黒のブラシ 
		DARKGRAY  = DKGRAY_BRUSH, /// 濃い灰色のブラシ 
		GRAY      = GRAY_BRUSH,   /// 灰色のブラシ 
		HOLLOW    = HOLLOW_BRUSH, /// 透明のブラシ 
		NULL      = NULL_BRUSH,   /// ditto
		LIGHTGRAY = LTGRAY_BRUSH, /// 明るい灰色のブラシ 
		WHITE     =WHITE_BRUSH,   /// 白のブラシ 
	}
	/+
	///
	static Brush opCall(STOCK Stock) {
		if(auto hBrush=GetStockObject(Stock)) {
			return new Brush(hBrush, false);
		}
		
		throw new NemuxiException("Brush:GetStockObject");
	}
	+/
	this(STOCK Stock) {
		/+
		super.Suicide = false;
		hBrush = GetStockObject(Stock);
		+/
		super(GetStockObject(Stock), false);
	}
	
	/**
	*/
	this(COLOR color) {
		/+
		Suicide = true;
		hBrush = CreateSolidBrush(color.code);
		+/
		super(CreateSolidBrush(color.code), true);
	}
	/**
	*/
	this(SYSTEMCOLOR sysColor) {
		/+
		Suicide = false;
		hBrush = GetSysColorBrush(sysColor.index);
		+/
		super(GetSysColorBrush(sysColor.index), false);
	}
	/**
	*/
	this(STYLE Style, COLOR color) {
		/+
		Suicide = true;
		hBrush = CreateHatchBrush(Style, color.code);
		+/
		super(CreateHatchBrush(Style, color.code), true);
	}
	
	const STYLE style() {
		return cast(STYLE)GetStruct(hBrush).lbStyle;
	}
	bool style(STYLE Style) {
		auto sBrush=GetStruct(hBrush);
		sBrush.lbStyle = Style;
		return Import(sBrush);
	}
	const COLOR color() {
		return COLOR(GetStruct(hBrush).lbColor);
	}
	bool color(COLOR cl) {
		auto sBrush=GetStruct(hBrush);
		sBrush.lbColor = cl.code;
		return Import(sBrush);
	}
	const HATCH hatch() {
		return cast(HATCH)(GetStruct(hBrush).lbHatch);
	}
	bool hatch(HATCH Hatch) {
		auto sBrush=GetStruct(hBrush);
		sBrush.lbHatch = Hatch;
		return Import(sBrush);
	}
	/+
	///
	HBRUSH opCall() {
		return hBrush;
	}
	+/
}



