﻿/**

*/
module nemuxi.negui.draw.bitmap;

debug import std.stdio: wl = writefln, pl = printf;

debug(bitmap) void main() {}

import win32.core;

import nemuxi.base;
import nemuxi.system.raii;
import nemuxi.negui.draw.draw;
import nemuxi.negui.draw.canvas;

/**
*/
class Bitmap: Draw {
	protected alias Handle hBitmap;
	mixin KillResource!("ビットマップ", hBitmap, DeleteObject, 0);
	mixin GetImportObject!("ビットマップ", hBitmap, BITMAP, CreateBitmapIndirect);
	
	override this(HANDLE hHandle, bool Suicide) {
		super(hHandle, Suicide);
	}

	this(Canvas canvas, SIZE* Size) {
		//Suicide = true;
		
		auto hBmp=CreateCompatibleBitmap(canvas(), Size.cx, Size.cy);
		if(!hBmp) {
			throw new NemuxiException("ビットマップしっぱーい");
		}

		//hBitmap = hBmp;
		this(hBmp, true);
	}
	
	this(SIZE* Size) {
		auto hDC=GetDC(null);
		scope(exit) DeleteDC(hDC);
		
		this(CreateCompatibleBitmap(hDC, Size.cx, Size.cy), true);
		if(!hBitmap) {
			throw new NemuxiException("ビットマップしっぱーい");
		}
	}

	/+
	override HBITMAP opCall() {
		return hBitmap;
	}
	+/
}

