/**
あ
*/
module nemuxi.negui.control.updown.updown;

debug import std.stdio: wl = writefln, pl = printf;
debug(updown) void main() {}

import std.string;

import win32.windows;
import win32.commctrl;

import nemuxi.base;
import nemuxi.negui.window.window;
public import nemuxi.negui.control.control;


/***/
class UpDown: Control, ICommonControl {
	mixin CommonControl;
	
	///
	static enum POSITION {
		NONE    = 0,
		LEFT    = UDS_ALIGNLEFT , /// コントロールをバディウィンドウの左側に配置します。
		RIGHT   = UDS_ALIGNRIGHT, /// コントロールをバディウィンドウの右側に配置します。
		HORIZON = UDS_HORZ, /// コントロールを横向きに配置します。
	}
	
	this(NeGui Owner, ITEM_ID Id, POSITION Position=POSITION.RIGHT) {
		GUIINFO NeGuiInfo;
		
		NeGuiInfo.Owner     = Owner;
		NeGuiInfo.Id        = Id;
		
		this(&NeGuiInfo, Position);
	}
	this(GUIINFO* NeGuiInfo, POSITION Position) {
		NeGuiInfo.ClassName = UPDOWN_CLASS;
		//NeGuiInfo.Style |= UDS_SETBUDDYINT | UDS_WRAP | UDS_ARROWKEYS;
		NeGuiInfo.Style |= UDS_SETBUDDYINT | UDS_ARROWKEYS;
		
		switch(Position) {
			case POSITION.LEFT, POSITION.RIGHT, POSITION.HORIZON:
				NeGuiInfo.Style |= Position;
				break;
			case POSITION.NONE:
				break;
			default:
				assert(false);
		}
		super(NeGuiInfo);
	}

	Control buddy(Control ctrl) {
		return cast(Control)NeGui.getGuiObject(cast(HWND)send(UDM_SETBUDDY, cast(WPARAM)(ctrl ? ctrl(): null), NONE));
	}
	Control buddy() {
		return cast(Control)NeGui.getGuiObject(cast(HWND)send(UDM_GETBUDDY, NONE, NONE));
	}
	bool reBuddy() {
		if(auto Buddy=buddy) {
			buddy = buddy;
			return true;
		} else {
			return false;
		}
	}

	INT value() {
		LPARAM Err;
		auto Value=send(UDM_GETPOS32, NONE, cast(LPARAM)&Err);
		if(Err) {
			throw new UpDownException(format("UpDown.value = %s", Err));
		}
		return Value;
	}
	/**
	Return:
		以前の値。
	*/
	INT value(INT Value) {
		return send(UDM_SETPOS32, NONE, Value);
	}
	

	void range(int min, int max) {
		send(UDM_SETRANGE32, min, max);
	}
}



