/**
あ
*/
module nemuxi.negui.control.listbox.listview;

debug import std.stdio: wl = writefln, pl = printf;
debug(listview) void main() {}

import win32.windows;
import win32.commctrl;

import nemuxi.base;
import nemuxi.negui.draw.color;
import nemuxi.negui.window.window;
public import nemuxi.negui.control.control;
public import nemuxi.negui.control.listbox.header;
public import nemuxi.negui.draw.imagelist;

enum {
	LVIS_DRAPHILITED = 0x0008
}
/+
void InitListView(ref WINDOW Window) {
	with(Window) {
		ExStyle      = WS_EX_CLIENTEDGE;
		ClassName    = "EDIT";
		WindowName   = ClassName;
		Style        = CHILD
		             | ES_LEFT
		             | ES_AUTOHSCROLL;
	}
}
+/

/**
*/
class ListView: Control, ICommonControl, IOwnerDraw, INoHideSelect {
	mixin CommonControl;
	
	this(NeGui Owner, ITEM_ID Id) {
		GUIINFO NeGuiInfo;
		
		NeGuiInfo.Owner     = Owner;
		NeGuiInfo.Id        = Id;
		
		this(&NeGuiInfo);
	}
	override this(GUIINFO* NeGuiInfo) {
		NeGuiInfo.ClassName = WC_LISTVIEW;
		//NeGuiInfo.Style |= LVS_SHOWSELALWAYS;
		super(NeGuiInfo);
		clientEdge=true;
		noHideSelect=true;
	}
	
	mixin(ItemStyleGetSetMixStr("ownerDraw", q{LVS_OWNERDRAWFIXED}, true));
	mixin(ItemStyleGetSetMixStr("noHideSelect", q{LVS_SHOWSELALWAYS}, true));
	mixin(ItemStyleGetSetMixStr("noHeader", q{LVS_NOCOLUMNHEADER}, false));
	//mixin(ItemStyleGetSetMixStr("noHeaderEvent", q{LVS_NOSORTHEADER}, false));
	
	enum TYPE {
		SMALLICON  = LVS_SMALLICON, /// 小さいアイコン
		NORMALICON = LVS_ICON,      /// 大きいアイコン
		//BUTTON     = LVS_BUTTON,    /// 大きいアイコンで項目アイコンをボタン風にする
		LIST       = LVS_LIST,      /// 一覧表示
		REPORT     = LVS_REPORT,    /// 詳細表示
	}
	mixin(ItemStyleGetSetMixStrEx!(TYPE, DWORD)(
		"type", false, [
		q{TYPE.SMALLICON}, q{TYPE.NORMALICON}, q{TYPE.LIST}, q{TYPE.REPORT},
		q{LVS_SMALLICON},  q{LVS_ICON},        q{LVS_LIST}, q{LVS_REPORT}
	]));
	

	enum EVENT : MESSAGETYPE {
		END_LABEL_EDIT = LVN_ENDLABELEDIT,
	}
	/+
	override this(HWND hWnd) {
		super(hWnd);
	}
	+/

	class ListHeader: Header {
		override this(HWND hWnd) {
			super(hWnd);
		}
	}
	Header header() {
		return new ListHeader(cast(HANDLE)send(LVM_GETHEADER, NONE, NONE));
	}

	/// アイテム全削除
	void clear() {
		super.send(LVM_DELETEALLITEMS, NONE, NONE);
	}

	/**
	カラムの削除。

	Params:
		Index = 削除するカラム。
		        0番目は消せない。

	In:
		Indexは1以上。

	Return:
		成功すればtrue、失敗すればfalse。
	*/
	bool delColumn(WPARAM Index)
	in {
		assert(Index > 0);
	}
	body {
		return super.send(LVM_DELETECOLUMN, Index, NONE)
			? true
			: false
		;
	}

	/**
	指定アイテムの削除。

	Params:
		Index = 削除するアイテム

	Return:
		成功すればtrue、失敗すればfalse。
	*/
	bool del(WPARAM Index) {
		return super.send(LVM_DELETEITEM, Index, NONE)
			? true
			: false
		;
	}

	private uint BackColor() {
		return super.send(LVM_GETBKCOLOR, NONE, NONE);
	}
	private bool IsBackColor(uint code) {
		return CLR_NONE != code;
	}
	/**
	背景色の有無を判定。

	Return:
		背景色が設定されていればtrue、設定されていなければfalse。
	*/
	bool isBackColor() {
		return IsBackColor(BackColor());
	}
	/**
	背景色の取得。

	Return:
		取得した背景色。

	Exception:
		背景色が設定されていなければNemuxiException。
	*/
	COLOR backColor() {
		uint code=BackColor();
		
		if(IsBackColor(code)) {
			return COLOR(code);
		}
		
		throw new NemuxiException("背景色未設定");
	}
	/**
	背景色の設定。

	Params:
		cl = 色。
		     nullの場合は背景色を持たない。

	Return:
		成功すればtrue、失敗すればfalse。
	*/
	bool backColor(COLOR* cl) {
		uint code;
		if(cl) {
			code = cl.code;
		} else {
			code = CLR_NONE;
		}
		return send(LVM_SETBKCOLOR, NONE, code)
			? true
			: false
		;
	}
	/**
	アイテムの取得。

	Params:
		ListItem = アイテムの値を格納する構造体。
		           取得する値のための情報を格納しておく。

	Return:
		成功すればtrue、失敗すればfalse。
	*/
	bool get(ref LISTITEM ListItem) {
		return super.send(LVM_GETITEM, NONE, cast(WPARAM)&ListItem.LvItem)
			? true
			: false
		;
	}
	/**
	アイテムの総数を取得。

	Return:
		アイテム数。
	*/
	int count() {
		return super.send(LVM_GETITEMCOUNT, NONE, NONE);
	}
	/**
	*/
	COLOR textColor() {
		return COLOR(send(LVM_GETTEXTCOLOR, NONE, NONE));
	}
	/**
	*/
	bool textColor(COLOR cl) {
		return send(LVM_SETTEXTCOLOR, NONE, cl.code)
			? true
			: false
		;
	}
	/**
	*/
	COLOR textBackColor() {
		return COLOR(send(LVM_GETTEXTBKCOLOR, NONE, NONE));
	}
	/**
	*/
	bool textBackColor(COLOR cl) {
		return send(LVM_SETTEXTBKCOLOR, NONE, cl.code)
			? true
			: false
		;
	}
	/**
	カラムの挿入。

	Params:
		Index = 新しいカラムを挿入する位置。
		        0基準。

		ListColumn = カラム情報。

	Return:
		成功すれば実際のカラムの位置を返す。

	Exception:
		失敗時にNemuxiException。
	*/
	int insertColumn(int Index, LISTCOLUMN* ListColumn)
	in {
		assert(ListColumn);
	}
	body {
		auto pos = send(LVM_INSERTCOLUMN, Index, cast(LPARAM)&ListColumn.LvColumn);

		if(pos == -1) {
			throw new NemuxiException("カラム挿入失敗");
		}

		return pos;
	}
	/**
	アイテムの挿入。

	Params:
		ListItem = アイテム情報。

	Return:
		成功すれば実際のアイテムの位置を返す。

	Exception:
		失敗時にNemuxiException。
	*/
	size_t insertItem(LISTITEM* ListItem)
	in {
		assert(ListItem);
	}
	body {
		auto pos = send(LVM_INSERTITEM, NONE, cast(LPARAM)&ListItem.LvItem);

		if(pos == -1) {
			throw new NemuxiException("アイテム挿入失敗" ~ Err.toString);
		}

		return pos;
	}
	private static enum IMAGE_TYPE {
		NORMAL= LVSIL_NORMAL, /// 通常のアイコン
		SMALL = LVSIL_SMALL,  /// 小さいアイコン
		STATE = LVSIL_STATE,  /// 状態
	}
	private ImageList SetImageList(ImageList NewImage, IMAGE_TYPE ImageType) {

		/+
		HIMAGELIST hImageList;

		with(IMAGE_TYPE) switch(ImageType) {
			case NORMAL:
				hImageList = cast(HIMAGELIST)send(LVM_SETIMAGELIST, ImageType, cast(LPARAM)NewImage());
				break;
			case SMALL:
				hImageList = cast(HIMAGELIST)send(LVM_SETIMAGELIST, ImageType, cast(LPARAM)NewImage());
				break;
			case STATE:
				hImageList = cast(HIMAGELIST)send(LVM_SETIMAGELIST, ImageType, cast(LPARAM)NewImage());
				break;
			default:
				assert(false);
		}
		+/
		auto hImageList = cast(HIMAGELIST)send(LVM_SETIMAGELIST, ImageType, cast(LPARAM)NewImage());
		
		return hImageList
			? new ImageList(hImageList, false)
			: null
		;
	}
	/***/
	ImageList imgaeListNormal(ImageList NewImage) {
		return SetImageList(NewImage, IMAGE_TYPE.NORMAL);
	}
	/// ditto
	ImageList imgaeListSmall(ImageList NewImage) {
		return SetImageList(NewImage, IMAGE_TYPE.SMALL);
	}
	/// ditto
	ImageList imgaeListState(ImageList NewImage) {
		return SetImageList(NewImage, IMAGE_TYPE.STATE);
	}
	/**
	アイテムの設定。

	Params:
		ListItem = 設定するアイテム情報。

	Return:
		成功すればtrue、失敗すればfalse。
	*/
	bool set(LISTITEM* ListItem) {
		return send(LVM_SETITEM, NONE, cast(LPARAM)&ListItem.LvItem)
			? true
			: false
		;
	}
	
	bool get(LISTITEM* ListItem) {
		return cast(bool)send(LVM_GETITEM, NONE, cast(LPARAM)&ListItem.LvItem);
	}
	
}
unittest {
	assert(LVCOLUMN.sizeof == LISTCOLUMN.sizeof);
}
struct LISTCOLUMN {
	LVCOLUMN LvColumn;
	///
	static enum MASK {
		//FMT     = LVCF_FMT    , /// fmt
		POSITION = LVCF_FMT    , /// fmt
		WIDTH    = LVCF_WIDTH  , /// cx
		TEXT     = LVCF_TEXT   , /// pszText
		SUBITEM  = LVCF_SUBITEM, /// iSubItem
		IMAGE    = LVCF_IMAGE  , /// Version 4.70 以降： iImage
		ORDER    = LVCF_ORDER  , /// Version 4.70 以降： iOrder
	}
	///
	MASK mask() {
		return cast(MASK)LvColumn.mask;
	}
	///
	void mask(MASK Mask) {
		LvColumn.mask = Mask;
	}
	
	///
	static enum POSITION {
		LEFT            = LVCFMT_LEFT           , /// テキストが左に配置されます。
		RIGHT           = LVCFMT_RIGHT          , /// テキストが右に配置されます。
		CENTER          = LVCFMT_CENTER         , /// テキストが中央に配置されます。
		IMAGE           = LVCFMT_IMAGE          , /// Version 4.70 以降： アイテムはイメージリストのイメージを表示します。
		BITMAP_ON_RIGHT = LVCFMT_BITMAP_ON_RIGHT, /// Version 4.70 以降： ビットマップをアイテムの右側に表示します。これは、ヘッダアイテムに割り当てられたイメージリストのイメージには影響しません。
		COL_HAS_IMAGES  = LVCFMT_COL_HAS_IMAGES , /// Version 4.70 以降： ヘッダアイテムはイメージリスト中のイメージを含みます。
	}
	/+
	///
	FMT fmt() {
		return cast(FMT)LvColumn.fmt;
	}
	///
	void fmt(FMT Fmt) {
		LvColumn.fmt = Fmt;
	}
	+/
	mixin(StructGetSet!(POSITION)("position", q{LvColumn.fmt}));
	
	///
	mixin(StructGetSet!(uint)("px", q{LvColumn.cx}));

	///
	wchar* text() {
		return LvColumn.pszText;
	}
	///
	void text(wchar* s) {
		LvColumn.pszText = s;
	}
	///
	wchar* text(Text t) {
		return LvColumn.pszText = t.ptr;
	}

	/+
	///
	int length() {
		return LvColumn.cchTextMax;
	}
	///
	void length(int Length) {
		LvColumn.cchTextMax = Length;
	}
	+/
	mixin(StructGetSet!(int)("textMax", q{LvColumn.cchTextMax}));
	
	///
	int subIndex() {
		return LvColumn.iSubItem;
	}
	///
	void subIndex(int Index) {
		LvColumn.iSubItem = Index;
	}
	///
	int imageIndex() {
		return LvColumn.iImage;
	}
	///
	void imageIndex(int Index) {
		LvColumn.iImage = Index;
	}
	///
	int order() {
		return LvColumn.iOrder;
	}
	///
	void order(int Order) {
		LvColumn.iOrder = Order;
	}
}

unittest {
	assert(LVITEM.sizeof == LISTITEM.sizeof);
}
struct LISTITEM {
	LVITEM LvItem;
	mixin(SMixInStructHiddenOriginal!(LISTITEM*)(q{LvItem}));

	///
	static enum MASK {
		TEXT        = LVIF_TEXT       , /// pszText
		IMAGE       = LVIF_IMAGE      , /// iImage
		//PARAM       = LVIF_PARAM      , /// lParam
		DATA        = LVIF_PARAM      , /// lParam
		STATE       = LVIF_STATE      , /// state
		INDENT      = LVIF_INDENT     , /// Version 4.70 以降： iIndent
		GROUPID     = LVIF_GROUPID    , /// Version 6.0 以降： iGroupID
		COLUMNS     = LVIF_COLUMNS    , /// Version 6.0 以降： cColumns
		NORECOMPUTE = LVIF_NORECOMPUTE, /// Version 4.70 以降： コントロールは LVM_GETITEM メッセージを受け取ったときに、テキスト情報を取得するのに LVN_GETDISPINFO 通知メッセージを発生させません。代わりに、 pszText メンバに -1 (LPSTR_TEXTCALLBACK) を格納します。
		DI_SETITEM  = LVIF_DI_SETITEM , /// システムは、要求されたリストアイテムの情報を格納しておき、後で再び情報を求めません。このフラグは LVN_GETDISPINFO 通知メッセージでのみ使用されます。
	}
	/+
	///
	MASK mask() {
		return cast(MASK)LvItem.mask;
	}
	///
	void mask(MASK Mask) {
		LvItem.mask = Mask;
	}
	+/
	mixin(StructGetSet!(MASK)("mask", q{LvItem.mask}));
	///
	int index() {
		return LvItem.iItem;
	}
	///
	void index(int Index) {
		LvItem.iItem = Index;
	}
	///
	int subIndex() {
		return LvItem.iSubItem;
	}
	///
	void subIndex(int Index) {
		LvItem.iSubItem = Index;
	}
	///
	static enum STATE {
		CUT            = LVIS_CUT           , /// 切り取りと貼り付け操作に対してマークされる
		DRAPHILITED    = LVIS_DRAPHILITED   , /// 切り取りと貼り付け操作の対象として強調表示される
		FOCUSED        = LVIS_FOCUSED       , /// フォーカスをもっている
		OVERLAYMASK    = LVIS_OVERLAYMASK   , /// オーバーレイイメージインデックスが含まれているかどうか判定する
		SELECTED       = LVIS_SELECTED      , /// 選択されている
		STATEIMAGEMASK = LVIS_STATEIMAGEMASK, /// 状態イメージが関連付けられているかどうか判定する
	}
	///
	STATE state() {
		return cast(STATE)LvItem.state;
	}
	///
	void state(STATE State) {
		LvItem.state = State;
	}
	///
	STATE stateMask() {
		return cast(STATE)LvItem.stateMask;
	}
	///
	void stateMask(STATE State) {
		LvItem.stateMask = State;
	}
	///
	wchar* text() {
		return LvItem.pszText;
	}
	///
	void text(wchar* s) {
		LvItem.pszText = s;
	}
	///
	wchar* text(Text t) {
		return LvItem.pszText = t.ptr;
	}
	bool textCallBack() {
		return LvItem.pszText == LPSTR_TEXTCALLBACK;
	}
	void textCallBack(bool CallBack) {
		LvItem.pszText = CallBack ? LPSTR_TEXTCALLBACK: null;
	}
	/+
	///
	int textMax() {
		return LvItem.cchTextMax;
	}
	///
	void textMax(int Length) {
		LvItem.cchTextMax = Length;
	}
	+/
	mixin(StructGetSet!(int)("textMax", q{LvItem.cchTextMax}));
	
	///
	int imageIndex() {
		return LvItem.iImage;
	}
	void imageIndex(int Index) {
		LvItem.iImage = Index;
	}
	void* data() {
		return cast(void*)LvItem.lParam;
	}
	void data(void* Data) {
		LvItem.lParam = cast(LPARAM)Data;
	}
	int indent() {
		return LvItem.iIndent;
	}
	void indent(int Indent) {
		LvItem.iIndent = Indent;
	}
	int groupID() {
		return LvItem.iGroupId;
	}
	void groupID(int GroupID) {
		LvItem.iGroupId = GroupID;
	}
	uint columns() {
		return LvItem.cColumns;
	}
	void columns(uint Columns) {
		LvItem.cColumns = Columns;
	}
	uint* columsAddress() {
		return LvItem.puColumns;
	}
	void columsAddress(uint* ColumsAddress) {
		LvItem.puColumns = ColumsAddress;
	}
}

struct LISTVIEWDRAW {
	NMLVCUSTOMDRAW CustomDraw;
	mixin(SMixInStructHiddenOriginal!(CUSTOMDRAW*)(q{CustomDraw}));

	/+
	CUSTOMDRAW* customDraw() {
		return cast(CUSTOMDRAW*)&CustomDraw.nmcd;
	}
	+/
	
	COLOR textColor() {
		return COLOR(CustomDraw.clrText);
	}
	void textColor(COLOR Color) {
		CustomDraw.clrText = Color.code;
	}
	
	COLOR backColor() {
		return COLOR(CustomDraw.clrTextBk);
	}
	void backColor(COLOR Color) {
		CustomDraw.clrTextBk = Color.code;
	}
	mixin(StructGetSet!(int)("subIndex", q{CustomDraw.iSubItem}));
	
}

struct LISTHITTEST {
	LVHITTESTINFO LvHitTest;
	mixin(SMixInStructHiddenOriginal!(LVHITTESTINFO*)(q{LvHitTest}));
}
