/**
あ
*/
module nemuxi.negui.control.label.label;

debug import std.stdio: wl = writefln, pl = printf;
debug(label) void main() {}

import win32.windows;

import nemuxi.base;
import nemuxi.negui.draw.draw;
import nemuxi.negui.draw.icon;
import nemuxi.negui.draw.bitmap;
import nemuxi.negui.window.window;
public import nemuxi.negui.control.control;


/**
*/
abstract class Statc: Control, INotify, IOwnerDraw {
	
	this(NeGui Owner, ITEM_ID Id) {
		GUIINFO NeGuiInfo;
		
		NeGuiInfo.Owner     = Owner;
		NeGuiInfo.Id        = Id;
		
		this(&NeGuiInfo);
	}
	override this(GUIINFO* NeGuiInfo) {
		NeGuiInfo.ClassName = "STATIC";
		
		super(NeGuiInfo);
	}
	
	mixin(ItemStyleGetSetMixStr("notify",    q{SS_NOTIFY},    false));
	mixin(ItemStyleGetSetMixStr("ownerDraw", q{SS_OWNERDRAW}, false));

	static enum EVENT: MESSAGETYPE {
		CLICKED = STN_CLICKED, /// クリックされた
		DBLCLK  = STN_DBLCLK , /// ダブルクリックされた
		ENABLE  = STN_ENABLE , /// 有効になったとき
		DISABLE = STN_DISABLE, /// 無効になったとき
	}
}

class TextLabel: Statc, IHorizonAlign {
	mixin ControlClass;

	/+
	override void horizonAlign(HORIZON_ALIGN TextAlign) {
		auto Style=super.getItemInfo(GWL.STYLE);
		DWORD AlignStyle=void;

		Style &= ~(SS_LEFT | SS_CENTER | SS_RIGHT);
		
		with(HORIZON_ALIGN) switch(TextAlign) {
			case LEFT:   AlignStyle = SS_LEFT;   break;
			case CENTER: AlignStyle = SS_CENTER; break;
			case RIGHT:  AlignStyle = SS_RIGHT;  break;
			default:     assert(false);
		}
		
		super.setItemInfo(GWL.STYLE, Style | AlignStyle);
	}
	override HORIZON_ALIGN horizonAlign() {
		auto Style=super.getItemInfo(GWL.STYLE);

		with(HORIZON_ALIGN) if((Style & SS_LEFT) == SS_LEFT) return LEFT;
		else if((Style & SS_CENTER) == SS_CENTER)        return CENTER;
		else if((Style & SS_RIGHT) == SS_RIGHT)          return RIGHT;
		else assert(false);
	}
	+/
	mixin(ItemStyleGetSetMixStrEx!(HORIZON_ALIGN, DWORD)(
		"horizonAlign", true, [
		q{HORIZON_ALIGN.RIGHT}, q{HORIZON_ALIGN.CENTER}, q{HORIZON_ALIGN.LEFT},
		q{SS_CENTER},       q{SS_RIGHT},         q{SS_LEFT}
	]));

	
	//mixin(ItemStyleGetSetMixStr("simple", q{SS_SIMPLE}, false));
	mixin(ItemStyleGetSetMixStr("noPrefix", q{SS_NOPREFIX}, false));
	mixin(ItemStyleGetSetMixStr("noWordwrap", q{SS_LEFTNOWORDWRAP}, false));

	static enum ELLIPSIS: DWORD {
		DURING = SS_PATHELLIPSIS,  /// 途中
		END    = SS_ENDELLIPSIS, /// 最後
	} // 一度きりの人生
	mixin(ItemStyleGetSetMixStrEx!(ELLIPSIS, DWORD)(
		"ellipsis", false, [
		q{ELLIPSIS.DURING}, q{ELLIPSIS.END},   
		q{SS_PATHELLIPSIS}, q{SS_ENDELLIPSIS}
	]));



}

private enum {
	SS_CENTERIMAGE = 0x00000200,
	SS_RIGHTJUST   = 0x00000400,
}

abstract class PictureLabel: Statc {
	mixin ControlClass;
	
	abstract Draw image();
	abstract Draw image(Draw draw);

	/+
	bool realItemSize() {
		return (super.style() & SS_REALSIZEIMAGE) == SS_REALSIZEIMAGE
			? true
			: false
		;
	}
	void realItemSize(bool RealSize) {
		auto Style=super.style();

		if(RealSize) {
			Style |= SS_REALSIZEIMAGE;
		} else {
			Style &= ~SS_REALSIZEIMAGE;
		}
		
		super.style = Style;
	}
	+/
	mixin(ItemStyleGetSetMixStr("realItemSize", q{SS_REALSIZEIMAGE}, false));
	//SS_REALSIZEIMAGE
	
	static enum POSITION {
		LEFT_TOP     = 0,
		CENTER       = SS_CENTERIMAGE,
		RIGHT_BOTTOM = SS_RIGHTJUST
	}
	/+
	POSITION position() {
		auto Style=super.style();
		
		with(POSITION) if((Style & SS_CENTERIMAGE) == SS_CENTERIMAGE) return CENTER;
		else if((Style & SS_RIGHTJUST) == SS_RIGHTJUST)               return RIGHT_BOTTOM;
		else return LEFT_TOP;
	}
	void position(POSITION Position) {
		auto Style=super.style();
		DWORD NewPos;

		Style &= ~(SS_CENTERIMAGE | SS_RIGHTJUST);
		
		with(POSITION) switch(Position) {
			case LEFT_TOP:     NewPos = 0;              break;
			case CENTER:       NewPos = SS_CENTERIMAGE; break;
			case RIGHT_BOTTOM: NewPos = SS_RIGHTJUST;   break;
			default:           assert(false);
		}
		
		super.style = Style | NewPos;
	}
	+/
	mixin(ItemStyleGetSetMixStrEx!(POSITION, DWORD)(
		"position", false, [
		q{POSITION.CENTER}, q{POSITION.RIGHT_BOTTOM}, q{POSITION.LEFT_TOP},
		q{SS_CENTERIMAGE},  q{SS_RIGHTJUST},          q{0}
	]));
	
	static enum IMAGE_TYPE {
		ICON   = SS_ICON,
		BITMAP = SS_BITMAP,
	}
	mixin(ItemStyleGetSetMixStrEx!(IMAGE_TYPE, DWORD)(
		"imageType", false, [
		q{IMAGE_TYPE.ICON}, q{IMAGE_TYPE.BITMAP},
		q{SS_ICON},         q{SS_BITMAP}
	]));
}

class BoxLabel: Statc {
	mixin ControlClass;

	static enum BOX {
		BORDER  = SS_BLACKFRAME, /// ウィンドウの枠と同じ色（デフォルトでは黒）の枠を持つボックスを作成します。
		DESKTOP = SS_GRAYFRAME, /// 画面の背景 (デスクトップ) と同じ色（デフォルトでは灰色）の枠を持つボックスを作成します。
		WINDOW  = SS_WHITEFRAME, /// ウィンドウの背景と同じ色（デフォルトでは白）の枠を持つボックスを作成します。
	}

	mixin(ItemStyleGetSetMixStrEx!(BOX, DWORD)(
		"box", false, [
		q{BOX.BORDER},    q{BOX.DESKTOP},  q{BOX.WINDOW},
		q{SS_BLACKFRAME}, q{SS_GRAYFRAME}, q{SS_WHITEFRAME}
	]));

	static enum AREA {
		BORDER  = SS_BLACKRECT, /// ウィンドウの枠と同じ色で塗りつぶされた長方形を作成します。Windowsのデフォルトの配色は黒です。
		DESKTOP = SS_GRAYRECT, /// 画面の背景（デスクトップ）と同じ色で塗りつぶされた長方形を作成します。Windowsのデフォルトの配色は灰色です。
		WINDOW  = SS_WHITERECT, /// ウィンドウの背景と同じ色の枠で塗りつぶされた長方形を作成します。Windowsのデフォルトの配色は白です。
	}
	mixin(ItemStyleGetSetMixStrEx!(AREA, DWORD)(
		"area", false, [
		q{AREA.BORDER}, q{AREA.DESKTOP}, q{AREA.WINDOW},
		q{SS_BLACKRECT}, q{SS_GRAYRECT}, q{SS_WHITERECT}
	]));


	
/+
		q{FRAME.BORDER},  q{SS_BLACKFRAME},
		q{FRAME.DESKTOP}, q{SS_GRAYFRAME},
		q{FRAME.WINDOW},  q{SS_WHITEFRAME}
+/
	//static enum RECT
}

class IconLabel: PictureLabel {

	override this(NeGui Owner, ITEM_ID Id) {
		super(Owner, Id);
		imageType = IMAGE_TYPE.ICON;
	}

	override Draw image() {
		auto icon=super.send(STM_GETICON, NONE, NONE);

		return icon
			? new Icon(cast(HICON)icon, false)
			: null
		;
	}
	override Draw image(Draw draw)
	in {
		assert(cast(Icon)draw);
	}
	body {
		auto icon=send(STM_SETICON, cast(WPARAM)draw(), NONE);
		
		return icon
			? new Icon(cast(HICON)icon, false)
			: null
		;
	}
}

