/**
ホットキー。
*/
module nemuxi.negui.control.hotkey.hotkey;

debug import std.stdio: wl = writefln, pl = printf;
debug(hotkey) void main() {}

import win32.windows;
import win32.commctrl;

import nemuxi.base;
import nemuxi.negui.event;
public import nemuxi.negui.control.control;

/**
*/
struct HOTKEYVALUE {
	HOTKEY Mod;
	KEY Key;

	MOD  hotkeyToMod() {
		with(HOTKEY) switch(Mod) {
			case ALT    : return MOD.ALT;
			case CONTROL: return MOD.CONTROL;
			case SHIFT  : return MOD.SHIFT;
			case EXT    : return MOD.WIN;
			default     : assert(false);
		}
	}
	void modToHotkey(MOD Mod) {
		with(MOD) switch(Mod) {
			case ALT    : this.Mod=HOTKEY.ALT;     break;
			case CONTROL: this.Mod=HOTKEY.CONTROL; break;
			case SHIFT  : this.Mod=HOTKEY.SHIFT;   break;
			case WIN    : this.Mod=HOTKEY.EXT;     break;
			default     : this.Mod=cast(HOTKEY)0;
		}
	}
}

/***/
class HotKey: Control, ICommonControl/*, IHorizonAlign*/ {
	/+
	mixin(ItemStyleGetSetMixStrEx!(HORIZON_ALIGN, DWORD)(
		"horizonAlign", true, [
		q{HORIZON_ALIGN.RIGHT}, q{HORIZON_ALIGN.CENTER}, q{HORIZON_ALIGN.LEFT},
		q{ES_RIGHT},        q{BS_CENTER},        q{ES_LEFT}
	]));
	+/
	mixin CommonControl;
	
	this(NeGui Owner, ITEM_ID Id) {
		GUIINFO NeGuiInfo;
		
		NeGuiInfo.Owner     = Owner;
		NeGuiInfo.Id        = Id;
		
		this(&NeGuiInfo);
	}
	override this(GUIINFO* NeGuiInfo) {
		NeGuiInfo.ClassName = HOTKEY_CLASS;
		NeGuiInfo.Style |= ES_CENTER;
		
		super(NeGuiInfo);
	}

	HOTKEYVALUE value() {
		auto Value=cast(WORD)send(HKM_GETHOTKEY, NONE, NONE);
		
		HOTKEYVALUE Hotkey;
		Hotkey.Mod = cast(HOTKEY)HIBYTE(Value);
		Hotkey.Key = cast(KEY)LOBYTE(Value);
		
		return Hotkey;
	}

	void value(HOTKEYVALUE Value) {
		send(HKM_SETHOTKEY, MAKEWORD(Value.Key, Value.Mod), NONE);
	}

	enum RULE {
		ALT = HKCOMB_A, /// ALTキー
		CONTROL=HKCOMB_C, /// Ctrlキー
		SHIT=HKCOMB_S, /// Shiftキー
		CTRL_ALT=HKCOMB_CA, /// Ctrl + ALTキー
		SHIT_ALT=HKCOMB_SA, /// Shift + ALTキー
		SHIFT_CTRL=HKCOMB_SC, /// Shift + Ctrlキー
		SCA=HKCOMB_SCA, /// Shift + Ctrl + ALTキー
		NONE = HKCOMB_NONE, /// 修飾されていないキー
	}
	void rule(RULE Rule, HOTKEY Mod) {
		send(HKM_SETRULES, Rule, MAKELPARAM(Mod, 0));
	}
}



