/**
あ
*/
module nemuxi.negui.control.group;

debug import std.stdio: wl = writefln, pl = printf;
debug(group) void main() {}

import std.contracts;

import nemuxi.base;
public import nemuxi.negui.event;
public import nemuxi.negui.negui;
public import nemuxi.negui.control.control;
import nemuxi.negui.draw.font;

/**
コンロトール寄せ集め！
*/
class Group(T: Control) {

	protected T[]        List; /// コンロトール群のリスト。
	protected T[ITEM_ID] Hash; /// コントロール群のハッシュ。

	/**
	コンストラクタ。

	Params:
		List = コントロール群。
	*/
	this() {}
	this(T[] List)
	in {
		assert(List.length);
	}
	body {
		this.List = List;
		foreach(item; List) {
			Hash[item.id()] = item;
		}
	}
	this(T[] List ... ) {
		this(List);
	}

	// -----------------------------

	/// コントロール数取得。
	size_t length() {
		return List.length;
	}
	ITEM_ID[] keys() {
		return Hash.keys;
	}
	T[] values() {
		return Hash.values;
	}

	// -----------------------------

	T opIndex(size_t n) {
		return List[n];
	}
	T opIndex(ITEM_ID Id) {
		return Hash[Id];
	}
	T[] opSlice() {
		return List[];
	}
	T[] opSlice(size_t start, size_t end) {
		return List[start..end];
	}

	void opAddAssign(T item) {
		enforce(!(item.id in Hash), "(^o^)");
		
		Hash[item.id] = item;
		List ~= item;
	}

	// -----------------------------

	void setShow(SHOW Show) {
		foreach(item; List) {
			item.setShow = Show;
		}
	}
	void enable(bool Enable) {
		foreach(item; List) {
			item.enable = Enable;
		}
	}
	void font(in Font font) {
		foreach(item; List) {
			item.font = font;
		}
	}
	void text(in Text text) {
		foreach(item; List) {
			item.text = text;
		}
	}
}
template TGroupClass(T) {
	/**
	コンストラクタ。

	Params:
		List = コントロール群。
	*/
	this() { super();}
	this(T[] List) {
		super(List);
	}
	this(T[] List ... ) {
		super(List);
	}
}

alias Group!(Control) ControlGroup;
