/**
エディットボックス関係。

ちょっとだけSwingのテキストフィールド参考にしてみたけどうまくいかないなぁ。
*/
module nemuxi.negui.control.editbox.editbox;

debug import std.stdio: wl = writefln, pl = printf;

debug(editbox) void main() {}

import win32.windows;

import nemuxi.base;
import nemuxi.negui.window.window;
public import nemuxi.negui.control.control;


/**
*/
abstract class EditBox: Control, IHorizonAlign, IEditBox, INoHideSelect {
	enum EVENT: MESSAGETYPE {
		SETFOCUS  = EN_SETFOCUS , /// 入力フォーカスを得た。
		KILLFOCUS = EN_KILLFOCUS, /// 入力フォーカスを失った。
		CHANGE    = EN_CHANGE   , /// テキストが変更された｡
		UPDATE    = EN_UPDATE   , /// テキストの内容が変更される。
		ERRSPACE  = EN_ERRSPACE , /// 文字列バッファのメモリ割り当てに失敗した。
		MAXTEXT   = EN_MAXTEXT  , /// 文字数が上限を越えた。
		HSCROLL   = EN_HSCROLL  , /// 水平スクロールを行う｡
		VSCROLL   = EN_VSCROLL  , /// 垂直スクロールを行う｡
	}
	override void horizonAlign(HORIZON_ALIGN TextAlign) {
		auto Style=super.getItemInfo(GWL.STYLE);
		DWORD AlignStyle=void;
		
		Style &= ~(ES_LEFT | ES_CENTER | ES_RIGHT);
		
		with(HORIZON_ALIGN) switch(TextAlign) {
			case LEFT:   AlignStyle = ES_LEFT;   break;
			case CENTER: AlignStyle = ES_CENTER; break;
			case RIGHT:  AlignStyle = ES_RIGHT;  break;
			default:     assert(false);
		}
		
		super.setItemInfo(GWL.STYLE, Style | AlignStyle);
	}
	override HORIZON_ALIGN horizonAlign() {
		auto style=super.getItemInfo(GWL.STYLE);

		with(HORIZON_ALIGN) if((style & ES_LEFT) == ES_LEFT) return LEFT;
		else if((style & ES_CENTER) == ES_CENTER)        return CENTER;
		else if((style & ES_RIGHT) == ES_RIGHT)          return RIGHT;
		else assert(false);
	}
	protected override this(HWND hWnd) {
		super(hWnd);
	}

	protected override this(GUIINFO* NeGuiInfo) {
		NeGuiInfo.ExStyle |= WS_EX_CLIENTEDGE;
		NeGuiInfo.Style   |= ES_NOHIDESEL;
		
		if(!NeGuiInfo.ClassName.length) {
			NeGuiInfo.ClassName = "EDIT";
		}
		
		super(NeGuiInfo);
		
		noHideSelect  =true;
	}
	/+
	override this(HWND hWnd) {
		super(hWnd);
	}
	+/
	
	//mixin(ItemStyleGetSetMixStr("multiLine", q{ES_MULTILINE}));
	//mixin(ItemStyleGetSetMixStr("autoHScroll", q{ES_AUTOHSCROLL}));
	//mixin(ItemStyleGetSetMixStr("autoVScroll", q{ES_AUTOVSCROLL}));
	
	mixin(ItemStyleGetSetMixStr("lower", q{ES_LOWERCASE}));
	mixin(ItemStyleGetSetMixStr("upper", q{ES_UPPERCASE}));
	
	mixin(ItemStyleGetSetMixStr("noHideSelect", q{ES_NOHIDESEL}));
	mixin(ItemStyleGetSetMixStr("numberOnly", q{ES_NUMBER}));
	
	
	/// CANUNDO
	bool canUndo() {
		return super.send(EM_CANUNDO, NONE, NONE)
			? true
			: false
		;
	}
	///
	void unDoClear() {
		super.send(EM_EMPTYUNDOBUFFER, NONE, NONE);
	}

	///
	bool charFromPos(ref POINT Point)
	in {
		assert(Point.x <= short.max);
		assert(Point.y <= short.max);
	}
	body {
		auto pos=super.send(EM_CHARFROMPOS, NONE, MAKELONG(cast(ushort)Point.x, cast(ushort)Point.y));
		if(pos == -1) {
			return false;
		}
		Point.x = LOWORD(pos);
		Point.y = HIWORD(pos);

		return true;
	}


	//EM_GETFIRSTVISIBLELINE ?

	///
	void* ramHandle() {
		auto buffer=super.send(EM_GETHANDLE, NONE, NONE);
		return buffer
			? cast(void*)buffer
			: null
		;
	}

	///
	override int limitLength() {
		return super.send(EM_GETLIMITTEXT, NONE, NONE);
	}

	override void limitLength(int Limit) {
		super.send(EM_SETLIMITTEXT, Limit, NONE);
	}
	

	///
	void margin(out int left, out int right) {
		auto lr=super.send(EM_GETMARGINS, NONE, NONE);

		left  = LOWORD(lr);
		right = HIWORD(lr);
	}
	static enum MARGIN {
		LEFT  = EC_LEFTMARGIN,  /// 左マージンの幅
		RIGHT = EC_RIGHTMARGIN, /// 右マージンの幅
	}
	void margin(MARGIN Margin, int left, int right)
	in {
		assert(ushort.max >= left);
		assert(ushort.max >= right);
	}
	body {
		super.send(EM_SETMARGINS, Margin, MAKELONG(cast(ushort)left, cast(ushort)right));
	}

	///
	bool modify() {
		return super.send(EM_GETMODIFY, NONE, NONE)
			? true
			: false
		;
	}
	void modify(bool Modify) {
		super.send(EM_SETMODIFY, Modify, NONE);
	}


	///
	const ref RECT formatRect() {
		//RECT Rect=void;
		auto Rect=new RECT;
		super.send(EM_GETRECT, NONE, cast(LPARAM)Rect);
		return *Rect;
	}
	///
	void formatRect(ref const(RECT) Rect) {
		super.send(EM_SETRECT, NONE, cast(LPARAM)&Rect);
	}

	//EM_GETSEL utf16 or 8 ?
	bool select(ref int Start, ref int End) {
		send(EM_GETSEL, cast(WPARAM)&Start, cast(LPARAM)&End);

		return Start != End;
	}
	bool select(int Start, int End) {
		return send(EM_SETSEL, Start, End) == 1;
	}

	//EM_GETTHUMB

	///
	bool readOnly() {
		return (super.getItemInfo(GWL_STYLE) & ES_READONLY) == ES_READONLY;
	}
	///
	bool readOnly(bool ReadOnly) {
		return super.send(EM_SETREADONLY, ReadOnly, NONE)
			? true
			: false
		;
	}
}

interface IEditBox {
	/// 入力可能な文字数。
	int limitLength();
	/// ditto
	void limitLength(int);
}

class EditLine: EditBox {
	override this(GUIINFO* NeGuiInfo) {
		NeGuiInfo.Style |= ES_AUTOHSCROLL;
		super(NeGuiInfo);
	}
	override this(NeGui Owner, ITEM_ID Id) {
		GUIINFO NeGuiInfo;
		
		NeGuiInfo.Owner = Owner;
		NeGuiInfo.Id = Id;

		this(&NeGuiInfo);
	}
}

class PassLine: EditLine {
	override this(GUIINFO* NeGuiInfo) {
		NeGuiInfo.Style |= ES_PASSWORD;
		
		super(NeGuiInfo);
	}
	override this(NeGui Owner, ITEM_ID Id) {
		GUIINFO NeGuiInfo;
		
		NeGuiInfo.Owner = Owner;
		NeGuiInfo.Id = Id;

		this(&NeGuiInfo);
	}
	
	///
	wchar passChar() {
		return cast(wchar)super.send(EM_GETPASSWORDCHAR, NONE, NONE);
	}
	///
	void passChar(wchar c) {
		super.send(EM_SETPASSWORDCHAR, c, NONE);
	}
}

class MultiEdit: EditBox {
	this(NeGui Owner, ITEM_ID Id, bool HScroll=true) {
		GUIINFO NeGuiInfo;
		
		NeGuiInfo.Owner     = Owner;
		NeGuiInfo.Id        = Id;
		
		this(&NeGuiInfo, HScroll);
		
		//clientEdge = true;
		//noHideSelect  =true;
		//wantReturn = true;
	}
	this(GUIINFO* NeGuiInfo, bool HScroll) {
		NeGuiInfo.Style |= ES_AUTOVSCROLL | ES_MULTILINE | (HScroll ? ES_AUTOHSCROLL: 0);
		super(NeGuiInfo);
		wantReturn = true;
		//hScroll=true;
		vScroll=true;
	}
	mixin(ItemStyleGetSetMixStr("wantReturn", q{ES_WANTRETURN}));
	/// EM_GETLINE
	
	///
	int lineCount() {
		return super.send(EM_GETLINECOUNT, NONE, NONE);
	}
	
	///
	bool softNewLine(bool Insert) {
		return cast(bool)send(EM_FMTLINES, Insert, NONE);
	}
}


