/**
あ
*/
module nemuxi.negui.control.combobox.combobox;

debug import std.stdio: wl = writefln, pl = printf;

debug(combobox) void main() {}

import std.contracts;

import win32.windows;

import nemuxi.base;
import nemuxi.negui.window.window;
public import nemuxi.negui.control.control;
import nemuxi.negui.control.editbox.editbox;
import nemuxi.negui.control.listbox.listbox;


/**
不慣れなりにもinterface使ってみたよ！
*/
class ComboBox: Control, IEditBox, IListBox {
	invariant() {
		assert(ListHeight >= LIST_HEIGHT);
	}
	enum EVENT: MESSAGETYPE {
		LISTCLOSE    = CBN_CLOSEUP,      /// リストボックスが閉じられた
		DBLCLK       = CBN_DBLCLK,       /// リストボックスの項目をダブルクリック
		LISTDROP     = CBN_DROPDOWN,     /// リストボックスが表示されようとしている
		EDITCHANGE   = CBN_EDITCHANGE,   /// エディットでテキストが変更された可能性がある
		EDITUPDATE   = CBN_EDITUPDATE,   /// エディットのテキストが変更されエディットを表示しようとしている
		ERROR        = CBN_ERRSPACE,     /// 十分なメモリを割り当てられない
		FOCUSKILL    = CBN_KILLFOCUS,    /// キーボードフォーカスを失った
		LISTCHANGE   = CBN_SELCHANGE,    /// リストボックスの選択の変更
		LISTCANCEL   = CBN_SELENDCANCEL, /// アイテムを選択したが、その時に他のコントロールを選択または、ダイアログボックスを閉じた
		LISTSELECTED = CBN_SELENDOK,     /// アイテムを選択し、リストを閉じる
		FOCUSSET     = CBN_SETFOCUS,     /// キーボードフォーカスを得た
	}
	enum TYPE {
		STANDARD = CBS_SIMPLE,
		DROPEDIT = CBS_DROPDOWN,
		DROPLIST = CBS_DROPDOWNLIST,
	}
	protected this(GUIINFO* NeGuiInfo, TYPE Type) {
		if(!NeGuiInfo.ClassName.length) {
			NeGuiInfo.ClassName = "COMBOBOX";
		}
		NeGuiInfo.Style |= CBS_AUTOHSCROLL | CBS_DISABLENOSCROLL | WS_VSCROLL | Type;
		super(NeGuiInfo);
		//disableNoScroll=true;
		//vScroll=true;
		reLoad;
	}
	this(NeGui Owner, ITEM_ID Id, TYPE Type=TYPE.STANDARD) {
		GUIINFO NeGuiInfo;
		
		NeGuiInfo.Owner     = Owner;
		NeGuiInfo.Id        = Id;
		
		this(&NeGuiInfo, Type);
	}

	mixin(ItemStyleGetSetMixStr("disableNoScroll", q{CBS_DISABLENOSCROLL}));
	mixin(ItemStyleGetSetMixStr("noIntegralHeight", q{CBS_NOINTEGRALHEIGHT}));
	 


	// IEditer ------------------------------------------------------------
	
	override int limitLength() {
		assert(false, "can't use this method.");
		//throw new Exception("わかんね");
	}
	override void limitLength(int Limit) {
		return send(CB_LIMITTEXT, Limit, NONE);
	}
	
	
	// IListBox -----------------------------------------------------------

	override int add(in Text text) {
		auto Index=super.send(CB_ADDSTRING, NONE, cast(LPARAM)text.ptr);
		switch(Index) {
			case CB_ERRSPACE: throw new ComboBoxException("メモリ不足");
			case CB_ERR:      throw new ComboBoxException("何らかのエラー");
			default:          return Index;
		}
	}
	override int add(in Text[] texts)
	in {
		assert(texts.length);
	}
	body {
		int LastIndex;
		foreach(text; texts) {
			LastIndex = this.add(text);
		}
		return LastIndex;
	}
	
	override int del(int Index) {
		auto Count=super.send(CB_DELETESTRING, Index, NONE);
		if(Count == CB_ERR) {
			throw new ComboBoxException("何らかのエラー");
		}
		return Count;
	}
	
	override int find(int StartIndex, in Text text) {
		auto Count=super.send(CB_FINDSTRING, StartIndex, cast(LPARAM)text.ptr);
		if(Count == CB_ERR) {
			throw new ComboBoxException("何らかのエラー");
		}
		return Count;
	}
	
	override int count() {
		auto Count=super.send(CB_GETCOUNT, NONE, NONE);
		if(Count == CB_ERR) {
			throw new ComboBoxException("何らかのエラー");
		}
		return Count;
	}

	override int select() {
		auto Index=super.send(CB_GETCURSEL, NONE, NONE);
		if(Index == CB_ERR) {
			throw new ComboBoxException("未選択");
		}
		return Index;
	}
	override int select(int Index) {
		auto SelectIndex=super.send(CB_SETCURSEL, Index, NONE);
		if(SelectIndex == CB_ERR) {
			throw new ComboBoxException("未選択");
		}
		return SelectIndex;
	}
	
	override int getHeight(int Index) {
		auto Size=super.send(CB_GETITEMHEIGHT, Index, NONE);
		if(Size == CB_ERR) {
			throw new ComboBoxException("何らかのエラー");
		}
		return Size;
	}
	override bool setHeight(int Index, int Height) {
		return super.send(CB_SETITEMHEIGHT, Index, Height) != CB_ERR;
	}
	override void setWidth(int Width) {
		super.send(CB_SETHORIZONTALEXTENT, Width, NONE);
	}

	override Text listText(int Index) {
		auto text=new wchar[this.listTextLength(Index) + 1];
		auto Length=super.send(CB_GETLBTEXT, Index, cast(LPARAM)text.ptr);
		if(Length == CB_ERR) {
			throw new ComboBoxException("何らかのエラー");
		}
		return Text(text[0..Length]);
	}
	override bool listText(int Index, in Text text) {
		insert(Index, text);
		
		return cast(bool)del(Index+1);
	}

	override int listTextLength(int Index) {
		auto Length=super.send(CB_GETLBTEXTLEN, Index, NONE);
		if(Length == CB_ERR) {
			throw new ComboBoxException("何らかのエラー");
		}
		return Length;
	}

	override int topIndex() {
		return super.send(CB_GETTOPINDEX, NONE, NONE);
	}

	override int insert(int Index, in Text text) {
		auto Pos=super.send(CB_INSERTSTRING, Index, cast(LPARAM)text.ptr);
		switch(Pos) {
			case CB_ERRSPACE: throw new ComboBoxException("メモリ不足");
			case CB_ERR:      throw new ComboBoxException("何らかのエラー");
			default:          return Pos;
		}
	}
	
	override void clear() {
		send(CB_RESETCONTENT, NONE, NONE);
	}

	override int search(int StartIndex, in Text text) {
		auto Index=super.send(CB_SELECTSTRING, StartIndex, cast(LPARAM)text.ptr);
		if(Index == CB_ERR) {
			throw new ComboBoxException("見つからない");
		}
		return Index;
	}

	mixin ListControlArray!("ComboBox");
	
	//---------------------------------------------------------------------

	const bool list() {
		auto Style = super.style();
		return ((Style & CBS_DROPDOWN) == CBS_DROPDOWN) || ((Style & CBS_DROPDOWNLIST) == CBS_DROPDOWNLIST);
	}

	
	int editerHeight() {
		/+
		SIZE Size=void;
		super.clientSize(Size);

		return Size.cy;
		+/
		return super.clientSize().cy;
	}


	private ref COMBOBOXINFO ComboBoxInfo() {
		auto ComboInfo=new COMBOBOXINFO;

		ComboInfo.cbSize = ComboInfo.sizeof;
		enforce(GetComboBoxInfo(hItem, ComboInfo), new ComboBoxException("コンボボックス情報取得失敗"));
		
		return *ComboInfo;
	}

	/// エディットボックス部分取得。
	EditBox editBox() {
		class ComboEdit: EditBox {
			this() {
				super(ComboBoxInfo.hwndItem);
			}
		}
		return new ComboEdit();
	}
	/// リストボックス部分取得。
	ListBox listBox() {
		class ComboList: ListBox {
			this() {
				super(ComboBoxInfo.hwndList);
			}
		}
		return new ComboList();
	}
	/**
	ドロップダウン表示状態。
	
	*/
	bool dropList() {
		enforce(list(), new ComboBoxException("bool dropList()"));
		
		return super.send(CB_GETDROPPEDSTATE, NONE, NONE)
			? true
			: false
		;
	}
	/// ditto
	void dropList(bool Show) {
		enforce(list(), new ComboBoxException("void dropList(bool Show)"));
		
		super.send(CB_SHOWDROPDOWN, Show, NONE);
	}

	// むりやり。
	private invariant LIST_HEIGHT = 128;
	private int ListHeight = LIST_HEIGHT;
	const int listHeight() {
		return ListHeight;
	}
	void listHeight(in int ListHeight) {
		if(ListHeight >= LIST_HEIGHT) {
			this.ListHeight = ListHeight;
		} else {
			this.ListHeight = LIST_HEIGHT;
		}
	}
	// ↑の辻褄合わせ。
	override bool move(int x, int y, int Width, int Height, bool RePaint=true) {
		if(list()) {
			return super.move(x, y, Width, ListHeight + editerHeight, RePaint);
		} else {
			return super.move(x, y, Width, Height, RePaint);
		}
	}
	///
	override bool pos(AFTER After, int x, int y, int Width, int Height, SWP Flags) {
		if(list()) {
			return super.pos(After, x, y, Width, ListHeight + editerHeight, Flags);
		} else {
			return super.pos(After, x, y, Width, Height, Flags);
		}
	}
	
	/**
	*/
	override bool size(in int Width, in int Height) {
		if(list()) {
			return super.size(Width, ListHeight + editerHeight);
		} else {
			return super.size(Width, Height);
		}
	}
	override bool size(ref const(SIZE) Size) {
		return this.size(Size.cx, Size.cy);
	}
}

