/**
あ
*/
module nemuxi.negui.control.button.group;

debug import std.stdio: wl = writefln, pl = printf;

import std.contracts;

import win32.windows;

import nemuxi.base;
public import nemuxi.negui.negui;
public import nemuxi.negui.control.control;
public import nemuxi.negui.control.group;
public import nemuxi.negui.control.button.button;
import nemuxi.negui.subclass;
import nemuxi.negui.draw.unit;
import nemuxi.negui.draw.brush;
import nemuxi.negui.draw.color;
import nemuxi.negui.draw.canvas;


class GroupBox: Button, ISubClass {
	static alias void delegate(int Width, int Height, int CtrlHeight, ref const(RECT) InSize) SizeTuneType;
	private {
		//SubClass Subclass;
		static extern(Windows) LRESULT SubClass_Proc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam) {
			//auto Groupbox = cast(GroupBox)NeGui.getGui(hWnd);
			mixin(EVENTLOOP.ProcTop!(GroupBox));
			
			switch(Message) {
				case WM_SIZE:
					/+
					Groupbox.OnSize(LOWORD(lParam), HIWORD(lParam));
					return 0;
					+/
					mixin(EVENTLOOP.WM_SIZE);
				case WM_DESTROY:
					/+
					Groupbox.OnDestroy();
					return 0;
					+/
					mixin(EVENTLOOP.WM_DESTROY);
				case WM_COMMAND, WM_NOTIFY:
					return NeGuiObject.parent.send(Message, wParam, lParam);
				case WM_ERASEBKGND:
					/+
					scope canvas=new Canvas(cast(HDC)wParam, false);
					auto dg=Groupbox.OnEraseBackGround(canvas);
					if(dg) {
						return cast(LRESULT)dg();
					} else {
						goto default;
					}
					+/
					mixin(EVENTLOOP.WM_ERASEBKGND);
				default:
					//return Groupbox.Subclass.call(hWnd, Message, wParam, lParam);
					mixin(EVENTLOOP.WM_LAST!(GroupBox));
			}
		}
		SizeTuneType TuneSize;
	}
	mixin(TSubClass);
	bool tuneSize() {
		return TuneSize is null;
	}
	void tuneSize(SizeTuneType TuneSize) {
		//enforce(messageToParent(), new GroupBoxException("要サブクラス化"));
		this.TuneSize = TuneSize;
	}
	override this(NeGui Owner, ITEM_ID Id) {
		GUIINFO NeGuiInfo;
		NeGuiInfo.Owner = Owner;
		NeGuiInfo.Id    = Id;

		this(&NeGuiInfo);

		//messageToParent(true);
		/+
				SubclassObject = new SubClass(this, &SubClass_Proc);
				SubclassObject.start();
		+/
		SubClassOnNeGuiConstructor();
	}
	private class GroupLayout: LayoutManager {
		override this(NeGui Owner) {
			super(Owner);
			
			invariant Padding=GetControlPadding();
			
			padding.left   = Padding.cx * 2;
			padding.right  = Padding.cx * 2;
			padding.top    = 0;
			padding.bottom = Padding.cy * 2;
		}
		
		override void onSize(in int Width, in int Height) {
			RECT ContentSize = void;

			padding.top = padding.bottom/2 + minHeight;
			
			ContentSize.left = margin.left + padding.left;
			ContentSize.top  = margin.top  + padding.top;

			ContentSize.right  = Width  -  margin.right  - padding.right;
			ContentSize.bottom = Height -  margin.bottom - padding.bottom;

			onSize(ContentSize);
		}
		
		alias LayoutManager.onSize onSize;
	}
	override this(GUIINFO* NeGuiInfo) {
		NeGuiInfo.Style |= BS_GROUPBOX;
		super(NeGuiInfo);

		layoutManager = new GroupLayout(parent);

		/+
		invariant Padding=GetControlPadding();
		
		layoutManager.padding.left   = Padding.cx;
		layoutManager.padding.right  = Padding.cx;
		layoutManager.padding.top    = Padding.cy;
		layoutManager.padding.bottom = Padding.cy;
		+/
	}

	/+
	/// WM_COMMAND
	final bool messageToParent() {
		return SubclassObject !is null;
	}
	/// ditto
	final void messageToParent(bool Flag) {
		if(Flag) {
			if(!SubclassObject) {
				SubclassObject = new SubClass(this, &SubClass_Proc);
				SubclassObject.start();
			} else {
				//ん？
				throw new GroupBoxError("二重サブクラス化は不可");
			}
		} else {
			delete SubclassObject;
		}
	}
	+/

	alias NeGui.font font;
	final override void font(in Font font) {
		super.font(font);
		foreach(child; children) {
			child.font = font;
		}
	}
	
	protected override {
		void OnSize(SIZE_TYPE SizeType, int Width, int Height) {
			if(TuneSize) {
				scope BaseFont=font;
				if(!BaseFont) {
					BaseFont = new Font(Font.STOCK.SYSTEM);
				}

				invariant Padding=GetControlPadding();
				invariant CtrlHeight=GetDefaultControlHeight(font);

				RECT InSize;
				
				InSize.left  = Padding.cx * 2;
				InSize.right = Width - InSize.left - Padding.cx * 2;

				InSize.top    = CtrlHeight;
				InSize.bottom = Height - InSize.top - Padding.cy * 2;
				
				TuneSize(Width, Height, CtrlHeight, InSize);
			}
		}
		void OnDestroy() {
			//delete SubclassObject;
			SubClassOnNeGuiDestructor();
			super.OnDestroy();
		}

		OnEraseBackGroundDg OnEraseBackGround(Canvas canvas) {
			auto dg = {
				scope brush  = new Brush(SYSTEMCOLOR.Frame);
				
				canvas.setBrush = brush;
				RECT Rect;
				/+
				SIZE Size;
				clientSize(Size);
				+/
				auto Size=clientSize();
				Rect.right  = Size.cx;
				Rect.bottom = Size.cy;
				
				canvas.fillRect(Rect);
				
				return true;
			};
			return cast(OnEraseBackGroundDg)dg;
		}


		
	}
}

/***/
class RadioGroup: Group!(Radio) {
	mixin TGroupClass!(Radio);

	Radio checked() {
		foreach(radio; List) {
			if(radio.checked) {
				return radio;
			}
		}

		return null;
	}
	int checkIndex() {
		foreach(i, radio; List) {
			if(radio.checked) {
				return i;
			}
		}

		return -1;
	}
	
	void checked(Radio Target) {
		foreach(radio; List) {
			radio.checked = false;
			if(Target is radio) {
				Target.checked =true;
			}
		}
	}
}


