/**
あ
*/
module nemuxi.negui.control.button.button;

debug import std.stdio: wl = writefln, pl = printf;

debug(button) void main() {}

import win32.windows;
import win32.commctrl;

import nemuxi.base;
import nemuxi.negui.window.window;
public import nemuxi.negui.control.control;
import nemuxi.system.raii;
import nemuxi.negui.draw.icon;
import nemuxi.negui.draw.bitmap;
import nemuxi.negui.draw.draw;

///
abstract class Button: Control, IHorizonAlign, IVerticalAlign, INotify, IOwnerDraw {
	//mixin NeGuiClass;
	
	protected this(NeGui Owner, ITEM_ID Id) {
		GUIINFO NeGuiInfo;
		NeGuiInfo.Owner = Owner;
		NeGuiInfo.Id    = Id;
		
		this(&NeGuiInfo);
	}
	override this(GUIINFO* NeGuiInfo) {
		if(!NeGuiInfo.ClassName.length) {
			NeGuiInfo.ClassName = "BUTTON";
		}
		
		super(NeGuiInfo);
	}
	/+
	override this(HWND hWnd) {
		super(hWnd);
	}
	+/
	///
	static enum TYPE {
		PUSH  = BS_PUSHBUTTON,
		CHECK = BS_CHECKBOX,
		RADIO = BS_RADIOBUTTON,
		GROUP = BS_GROUPBOX,
	}
	/***/
	final TYPE type() {
		auto Type=super.getItemInfo(GWL.STYLE);
		
		with(Button.TYPE) {
			if((Type & PUSH) == PUSH) {
				return PUSH;
			} else if((Type & CHECK) == CHECK) {
				return CHECK;
			} else if((Type & RADIO) == RADIO) {
				return RADIO;
			} else if((Type & GROUP) == GROUP) {
				return GROUP;
			} else {
				throw new NemuxiException("ボタンタイプ不明");
			}
		}
	}

	mixin(ItemStyleGetSetMixStr("notify", q{BS_NOTIFY}, true));
	mixin(ItemStyleGetSetMixStr("ownerDraw", q{BS_OWNERDRAW}, true));

	static enum EVENT: MESSAGETYPE {
		CLICKED      = BN_CLICKED,
		DBLCLK       = BN_DBLCLK,
		DISABLE      = BN_DISABLE,
		DOUBLECLICKED= BN_DOUBLECLICKED,
		HILITE       = BN_HILITE,
		KILLFOCUS    = BN_KILLFOCUS,
		PAINT        = BN_PAINT,
		PUSHED       = BN_PUSHED,
		SETFOCUS     = BN_SETFOCUS,
		UNHILITE     = BN_UNHILITE,
		UNPUSHED     = BN_UNPUSHED,
	}
	
	/+
	TYPE type() {
		auto Type=super.getItemInfo(GWL.STYLE);
		
		with(Button.TYPE) {
			if((Type & PUSH) == PUSH) {
				return PUSH;
			} else if((Type & CHECK) == CHECK) {
				return CHECK;
			} else if((Type & RADIO) == RADIO) {
				return RADIO;
			} else if((Type & GROUP) == GROUP) {
				return GROUP;
			} else {
				throw new NemuxiException("ボタンタイプ不明");
			}
		}
	}
	
	void type(TYPE Type) {
		auto Style=super.getItemInfo(GWL.STYLE);
		with(Button.TYPE) {
			Style &= ~PUSH;
			Style &= ~CHECK;
			Style &= ~RADIO;
			Style &= ~GROUP;
			
			super.send(BM_SETSTYLE, Style | Type, true);
		}
	}
	+/
	/+
	mixin(ItemStyleGetSetMixStrEx!(TYPE, DWORD)(
		"type", false, [
		q{TYPE.CHECK},  q{TYPE.RADIO},     q{TYPE.GROUP},  q{TYPE.PUSH},
		q{BS_CHECKBOX}, q{BS_RADIOBUTTON}, q{BS_GROUPBOX}, q{BS_PUSHBUTTON}
	]));
	+/

	/+
	void horizonAlign(HORIZON_ALIGN TextAlign) {
		auto Style=super.getItemInfo(GWL.STYLE);

		Style &= ~(BS_LEFT | BS_CENTER | BS_RIGHT);

		with(HORIZON_ALIGN) switch(TextAlign) {
			case LEFT:   Style |= BS_LEFT;   break;
			case CENTER: Style |= BS_CENTER; break;
			case RIGHT:  Style |= BS_RIGHT;  break;
			default:     assert(false);
		}

		super.send(BM_SETSTYLE, Style, true);
	}
	HORIZON_ALIGN horizonAlign() {
		auto Style=super.getItemInfo(GWL.STYLE);

		with(HORIZON_ALIGN) if((Style & BS_LEFT) == BS_LEFT) {
			return LEFT;
		} else if((Style & BS_CENTER) == BS_CENTER) {
			return CENTER;
		} else if((Style & BS_RIGHT)  == BS_RIGHT) {
			return RIGHT;
		} else {
			throw new NemuxiException("テキスト位置取得失敗");
		}
	}
	+/

	
	mixin(ItemStyleGetSetMixStrEx!(HORIZON_ALIGN, DWORD)(
		"horizonAlign", true, [
		q{HORIZON_ALIGN.RIGHT}, q{HORIZON_ALIGN.CENTER}, q{HORIZON_ALIGN.LEFT},
		q{BS_RIGHT},        q{BS_CENTER},        q{BS_LEFT}
	]));
	
	mixin(ItemStyleGetSetMixStrEx!(VERTICAL_ALIGN, DWORD)(
		"verticaAlign", true, [
		q{VERTICAL_ALIGN.TOP}, q{VERTICAL_ALIGN.CENTER}, q{VERTICAL_ALIGN.BOTTOM},
		q{BS_TOP},            q{BS_VCENTER},           q{BS_BOTTOM}
	]));

	mixin(ItemStyleGetSetMixStr("flat", q{BS_FLAT}, false));
	

	/// BM_CLICK
	void click() {
		super.send(BM_CLICK, NONE, NONE);
	}

	static enum IMAGE_TYPE {
		ICON   = BS_ICON,
		BITMAP = BS_BITMAP,
	}
	mixin(ItemStyleGetSetMixStrEx!(IMAGE_TYPE, DWORD)(
		"imageType", false, [
		q{IMAGE_TYPE.ICON}, q{IMAGE_TYPE.BITMAP},
		q{BS_ICON},         q{BS_BITMAP}
	]));
	//やっつけすぎる
	private Draw ObjectType(HANDLE Handle)
	in {
		assert(Handle);
	}
	body {
		if(GetObjectType(Handle) == OBJ_BITMAP) {
			return new Bitmap(Handle, false);
		} else {
			return new Icon(Handle, false);
		}
	}
	protected Draw Image(IMAGE_TYPE ImageType, Draw draw) {
		int[IMAGE_TYPE] IMAGE = [
			IMAGE_TYPE.BITMAP : IMAGE_BITMAP,
			IMAGE_TYPE.ICON   : IMAGE_ICON
		];
		if(auto Handle=cast(HANDLE)super.send(BM_SETIMAGE, IMAGE[ImageType], cast(WPARAM)(draw ? draw(): null))) {
			return ObjectType(Handle);
		} else {
			return null;
		}
	}
	Icon image(Icon icon) {
		return cast(Icon)Image(IMAGE_TYPE.ICON, icon);
	}
	Bitmap image(Bitmap bmp) {
		return cast(Bitmap)Image(IMAGE_TYPE.BITMAP, bmp);
	}
}


class Push: Button {
	override this(NeGui Owner, ITEM_ID Id) {
		GUIINFO NeGuiInfo;
		NeGuiInfo.Owner = Owner;
		NeGuiInfo.Id    = Id;

		this(&NeGuiInfo);
	}
	override this(GUIINFO* NeGuiInfo) {
		NeGuiInfo.Style |= BS_PUSHBUTTON;
		super(NeGuiInfo);
	}

	/+
	bool def() {
		return (super.getItemInfo(GWL.STYLE) & BS_DEFPUSHBUTTON) == BS_DEFPUSHBUTTON;
	}
	void def(bool Default) {
		auto Style=super.getItemInfo(GWL.STYLE);
		
		if(Default) {
			super.setItemInfo(GWL.STYLE, Style | BS_DEFPUSHBUTTON);
		} else if(this.def()) {
			super.setItemInfo(GWL.STYLE, Style & ~BS_DEFPUSHBUTTON);
		}
	}
	+/
	mixin(ItemStyleGetSetMixStr("def", q{BS_DEFPUSHBUTTON}));

	bool push() {
		return super.send(BM_GETSTATE, NONE, NONE) == BST_PUSHED;
	}
	void push(bool Push) {
		super.send(BM_SETSTATE, Push, NONE);
	}
}

///
abstract class Toggle: Button {
	mixin ControlClass;

	///
	static enum CHECK {
		UNCHECKED     = BST_UNCHECKED,     /// チェックされていない
		CHECKED       = BST_CHECKED,       /// チェックされている
		INDETERMINATE = BST_INDETERMINATE, /// グレー表示
	}
	CHECK check() {
		return cast(CHECK)super.send(BM_GETCHECK, NONE, NONE);
	}
	void check(CHECK Check) {
		send(BM_SETCHECK, Check, NONE);
	}
	bool checked() {
		return check == CHECK.CHECKED;
	}
	void checked(bool Flag) {
		return check = Flag ? CHECK.CHECKED: CHECK.UNCHECKED;
	}
}

class CheckBox: Toggle {
	override this(NeGui Owner, ITEM_ID Id) {
		GUIINFO NeGuiInfo;
		NeGuiInfo.Owner = Owner;
		NeGuiInfo.Id    = Id;

		this(&NeGuiInfo);
	}
	override this(GUIINFO* NeGuiInfo) {
		NeGuiInfo.Style |= BS_CHECKBOX | BS_AUTOCHECKBOX;
		super(NeGuiInfo);

		autoCheck = true;
	}
	mixin(ItemStyleGetSetMixStr("tripleState", q{BS_3STATE}));
	mixin(ItemStyleGetSetMixStr("autoState", q{BS_AUTO3STATE}));
	mixin(ItemStyleGetSetMixStr("autoCheck", q{BS_AUTOCHECKBOX}));
	
}
class Radio: Toggle {
	override this(NeGui Owner, ITEM_ID Id) {
		GUIINFO NeGuiInfo;
		NeGuiInfo.Owner = Owner;
		NeGuiInfo.Id    = Id;

		this(&NeGuiInfo);
	}
	override this(GUIINFO* NeGuiInfo) {
		NeGuiInfo.Style |= BS_AUTORADIOBUTTON;
		super(NeGuiInfo);
	}
	enum AUTO {
		NONE = BS_RADIOBUTTON,
		AUTO = BS_AUTORADIOBUTTON,
	}
	mixin(ItemStyleGetSetMixStrEx!(AUTO, DWORD)(
		"autoCheck", false, [
		q{AUTO.NONE},      q{AUTO.AUTO},
		q{BS_RADIOBUTTON}, q{BS_AUTORADIOBUTTON}
	]));
}


