﻿/**
ボタン型のあれこれ。

こいつの中にはprivate変数が独立できない感じで使用されているので何か呼び出すときは注意。
ボタン型ランチャの静的クラスっぽく使用すること前提。
*/
module nemuxi.gui.window.nemuxiwindow.toolbar;

debug(toolbar) import std.stdio: wl = writefln, pl = printf;

import std.string;

import win32.windows;
import win32.commctrl;

import nemuxi.base;
//debug(appbar) import nemuxi.system.application;
import nemuxi.negui.subclass;
//import nemuxi.negui.draw.canvas;
//import nemuxi.negui.draw.bitmap;
//import nemuxi.negui.draw.color;
//import nemuxi.negui.draw.brush;
import nemuxi.negui.draw.imagelist;
import nemuxi.file.file;
import nemuxi.file.items.item;
import nemuxi.image.icon;
import nemuxi.negui.window.window;
import nemuxi.negui.control.toolbar.toolbar;
//import nemuxi.negui.proc.nemuxiwnd.nemuxiwnd;
//import nemuxi.negui.window.menu.popup;
import nemuxi.negui.window.menu.popup;
//import nemuxi.negui.proc.nemuxiwnd.appmenu;
//alias nemuxi.negui.proc.nemuxiwnd.appmenu.menu AppMenu;
//import nemuxi.negui.proc.nemuxiwnd.itemmenu;
//alias nemuxi.negui.proc.nemuxiwnd.itemmenu.menu ItemMenu;
//import nemuxi.negui.proc.nemuxiwnd.appbutton;
import nemuxi.gui.window.nemuxiwindow.nemuxiwindow;
//import nemuxi.negui.proc.nemuxiwnd.nemuximenu;
import nemuxi.negui.window.dialog.system;

private:
//Bitmap bitmap;
//ImageList ImgList;
//wchar*[] ToolText; // GC用？ スタック用？


package:

final class NemuxiToolBar: ToolBar, ISubClass {
	private {
		//SubClass Subclass;
		static extern(Windows) LRESULT SubClass_Proc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam) {
			//auto Toolbar = cast(NemuxiToolBar)NeGui.getGuiObject(hWnd);
			mixin(EVENTLOOP.ProcTop!(NemuxiToolBar));
			switch(Message) {
				case WM_MBUTTONDOWN:
					/+
					Toolbar.OnMouseMiddleDown(cast(MOUSE_KEY)wParam, LOWORD(lParam), HIWORD(lParam));
					return 0;
					+/
					mixin(EVENTLOOP.WM_MBUTTONDOWN());
				case WM_DESTROY:
					/+
					Toolbar.OnDestroy();
					return 0;
					+/
					mixin(EVENTLOOP.WM_DESTROY());
				case WM_DROPFILES: mixin(EVENTLOOP.WM_DROPFILES());
				default:
					/+
					return Toolbar.Subclass.call(hWnd, Message, wParam, lParam);
					+/
					mixin(EVENTLOOP.WM_LAST!(NemuxiToolBar));
			}
		}
	}
	mixin(TSubClass);
	
	private static ImageList ImgList;

	override this(NeGui Owner, ITEM_ID Id) {
		super(Owner, Id);
		dropFile = true;
		this.top = true;
		this.noDivider = true;
		this.noReSize = true;
		this.flat = true;
		this.wrapable = true;
		this.toolTips = true;
		
		version(none) {
			RegistSubClass(&NemuxiToolBar_Proc);
			//Subclass.start();
		}
		/+
		SubclassObject = new SubClass(this, &SubClass_Proc);
		SubclassObject.start();
		+/
		SubClassOnNeGuiConstructor();
	}
	
	///
	static ~this() {
		delete ImgList;
	}


	//alias ToolBar.buttonSet buttonSet;
	/**
	ボタン変更。

	Params:
		BMItems = 必要情報配列。

		ShowText = テキスト表示フラグ。

		IconSize = アイコンサイズ。
	*/
	void buttonSet(BM_ITEM[] BMItems, bool ShowText, ICONSIZE IconSize) {
		super.buttonClear();
		super.initialize();
		
		//delete ToolText;

		super.barStyle(TBSTYLE_EX_DRAWDDARROWS);

		auto size=GetIconSize(IconSize);

		ImageList NewImageList;
		if(BMItems.length) {
			NewImageList = new ImageList(size, size, ImageList.ILC.COLOR32 | ImageList.ILC.MASK, BMItems.length, 0);
		}
		
		foreach(i, BMItem; BMItems) {
			NewImageList.add(BMItem.icon);
		}
		
		if(auto hImgs=super.imageList(0, NewImageList)) {
			assert(hImgs() == ImgList());
			delete ImgList;
			delete hImgs;
		}
		if(!BMItems.length) {
			return;
		}
		super.initialize();
		ImgList = NewImageList;
		/+
		auto TB_Buttons=new TBBUTTON[BMItems.length];
		foreach(i, ref TB_Button; TB_Buttons) {
			TB_Button.iBitmap   = i;
			TB_Button.idCommand = i+1;
			TB_Button.fsState   = (BMItems[i].live ? TBSTATE_ENABLED: 0) | TBSTATE_ELLIPSES;
			TB_Button.fsStyle   = BTNS_DROPDOWN | BTNS_SHOWTEXT;
			TB_Button.dwData    = cast(DWORD)cast(void*)BMItems[i].item; // 処理の流れとしては絶対に参照が有効のはず(nemuxi.negui.proc.nemuxiwnd.BMItems)。てかこの型変じゃね？
			TB_Button.iString   = ShowText ? cast(INT)BMItems[i].name.ptr: 0;
		}
		//SendMessage(hAppbar, TB_ADDBUTTONS, TB_Buttons.length, cast(LPARAM)TB_Buttons.ptr);
		super.buttonSet(TB_Buttons);
		+/
		auto ToolButtons=new TOOLBUTTON[BMItems.length];
		foreach(i, ref ToolButton; ToolButtons) {
			ToolButton.imageIndex   = i;
			ToolButton.command = cast(COMMAND_ID)(i+1);
			ToolButton.state   = (BMItems[i].live ? TOOLBUTTON.STATE.ENABLED: cast(TOOLBUTTON.STATE)0) | TOOLBUTTON.STATE.ELLIPSES;
			ToolButton.style   = TOOLBUTTON.STYLE.DROPDOWN | TOOLBUTTON.STYLE.SHOWTEXT;
			ToolButton.data    = cast(void*)BMItems[i].item; // 処理の流れとしては絶対に参照が有効のはず(nemuxi.negui.proc.nemuxiwnd.BMItems)。てかこの型変じゃね？
			ToolButton.stringIndex   = ShowText ? cast(INT)BMItems[i].name.ptr: 0;
		}
		super.buttonSet(ToolButtons);
		//ToolText.length = BMItems.length;
		//AutoSize(hAppbar);
		super.autoSize();
	}

	///
	//alias ToolBar.buttonGet buttonGet;
	///
	Item buttonGet(size_t ButtonIndex) {
		/+
		TBBUTTON TBButton;
		super.buttonGet(CommandID-1, TBButton);
		return cast(Item)cast(void*)TBButton.dwData;
		+/
		TOOLBUTTON ToolButton;
		super.buttonGet(ButtonIndex-1, ToolButton);
		return cast(Item)ToolButton.data;
	}
	
	void buttonWidth(bool ShowText, bool ListStyle, ICONSIZE IconSize)
	in {
		if(ListStyle) assert(ShowText);
	}
	body {
		ushort MinWidth=cast(ushort)GetIconSize(IconSize);
		if(ShowText) {
			MinWidth = ListStyle
				? cast(ushort)(GetSystemMetrics(SM_CXMIN) + MinWidth)
				: cast(ushort)(GetSystemMetrics(SM_CXMIN))
			;
		}
		super.setButtonWidth(MinWidth, MinWidth);
	}

	
	protected override {
		bool OnMouseMiddleDown(MOUSE_KEY Keys, int x, int y) {
			parent.send(WM_MBUTTONDOWN, Keys, MAKELONG(cast(ushort)x, cast(ushort)y));
			return true;
		}
		void OnDestroy() {
			//delete SubclassObject;
			SubClassOnNeGuiDestructor();
			super.OnDestroy();
		}
		void OnDropFiles(DropFile drop) {
			
			for(COMMAND_ID i=1; i <= buttonCount; i++) {
				auto Rect=buttonRect(i);
				if(
					Rect.left <= drop.point.x
					&& drop.point.x <= Rect.right
					&& Rect.top  <= drop.point.y
					&& drop.point.y <= Rect.bottom
				) {
					TOOLBUTTON ToolButton;
					ToolButton.initialize;
					super.buttonGet(i-1, ToolButton);
					if((ToolButton.state & TOOLBUTTON.STATE.ENABLED) == TOOLBUTTON.STATE.ENABLED) {
						auto item=cast(Item)ToolButton.data;
						MessageDialog.show(item.toString.toText);
					}
				}
			}
			
		}
	}

}

