﻿/**
ボタン型付属のメニュー。

こいつもappbarと同じ扱いで家庭内序列では末っ子。
ほっとんどメニュー用。
*/
module nemuxi.gui.window.nemuxiwindow.titlebar;

debug(titlebar) import std.stdio: wl = writefln, pl = printf;
//debug(titlebar) void main() {}

import win32.windows;

import nemuxi.base;
import nemuxi.system.application;
import nemuxi.negui.subclass;
//import nemuxi.negui.proc.nemuxiwnd.appmenu;
import nemuxi.negui.window.menu.ownerdraw;
import nemuxi.file.items.item;
import nemuxi.negui.draw.color;
import nemuxi.negui.draw.brush;
import nemuxi.image.icon;
//import nemuxi.image.font;
import nemuxi.negui.draw.canvas;
//import nemuxi.negui.negui;
import nemuxi.negui.window.window;
//import nemuxi.negui.control.button.button;
public import nemuxi.gui.control.titlebar;
//import nemuxi.negui.proc.nemuxiwnd.nemuxiwnd;
import nemuxi.gui.window.nemuxiwindow.nemuxiwindow;

/+
private:
OwnerDrawMenu ExeButtonListMenu;
OwnerDrawMenu ProcessListMenu;
static ~this() {
	delete ExeButtonListMenu;
	delete ProcessListMenu;
}
+/
//bool HoverFlag=false;
//BM_ITEM[] BMItems;
package:
//bool ActiveFlag;
//AppButton Appbtn;
/**
AppToolBarのノリで作ったけど存在意義が見つからない。
*/
final class NemuxiTitleBar: TitleBar, ISubClass {
//warning - gui\window\nemuxiwindow\titlebar.d(54): Error: overrides base class function nemuxi.gui.control.titlebar.TitleBar.callSubProc, but is not marked with 'override'
	private {
		//SubClass Subclass;
		static extern(Windows) LRESULT SubClass_Proc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam) {
			//auto Titlebar = cast(NemuxiTitleBar)NeGui.getGuiObject(hWnd);
			mixin(EVENTLOOP.ProcTop!(NemuxiTitleBar));
			switch(Message) {
				case WM_RBUTTONDOWN:
					/+
					Titlebar.OnMouseRightDown(cast(MOUSE_KEY)wParam, LOWORD(lParam), HIWORD(lParam));
					return 0;
					+/
					mixin(EVENTLOOP.WM_RBUTTONDOWN);
				
				case WM_DESTROY:
					/+
					Titlebar.OnDestroy();
					return 0;
					+/
					mixin(EVENTLOOP.WM_DESTROY);
				
				default:
					/+
					return Titlebar.Subclass.call(hWnd, Message, wParam, lParam);
					+/
					mixin(EVENTLOOP.WM_LAST!(NemuxiTitleBar));
					
			}
		}
	}
	mixin(TSubClass);

	package {
		//OwnerDrawMenu ExeButtonListMenu;
		//OwnerDrawMenu ProcessListMenu;
		//BM_ITEM[] BMItems;
	}

	/+
	///
	override this(HWND hWnd) {
		super(hWnd);
		//sub = new SubClass(this, &AppButton_Proc);
		RegistSubClass(&AppButton_Proc);
		Subclass.start();
	}
	+/
	this(NeGui Owner, ITEM_ID Id) {
		super(Owner, Id);
		
		//RegistSubClass(&NemuxiTitleBar_Proc);
		//Subclass.start();
		/+
		SubclassObject = new SubClass(this, &SubClass_Proc);
		SubclassObject.start();
		+/
		SubClassOnNeGuiConstructor();
	}

	/+
	private struct INDEX {
		COMMAND_ID Id;
		OwnerDrawMenu ProcessListMenu;
	}
	void showProcessList(NeGui gui, POINT* Point, RECT* Rect) {
		delete ProcessListMenu;
		// 現在実行中の可視ウィンドウを表示。
		ProcessListMenu = new OwnerDrawMenu(application.AppData.exeMenuIcon());
		INDEX Index;
		Index.Id = 1;
		Index.ProcessListMenu = ProcessListMenu;
		EnumWindows(&EnumWindowsProc, cast(LPARAM)&Index);
		
		auto id=ProcessListMenu.show(
			//PopUp.TPM.RIGHTBUTTON |
			gui,
			PopUp.TPM.NONOTIFY | PopUp.TPM.RETURNCMD,
			Point,
			Rect
		);

		if(!id) {
			return;
		}

		MENUITEM GetItem;
		GetItem.sizeInit();
		GetItem.mask = MENUITEM.MIIM.ID | MENUITEM.MIIM.DATA | MENUITEM.MIIM.TYPE;
		GetItem.id   = id;
		if(ProcessListMenu.get(GetItem)) {
			auto Target=new OtherWindow(cast(HWND)GetItem.itemData);
			if(Target.alive()) {
				if(Target.isSmall()) {
					Target.openSmall();
				} else {
					Target.pos(cast(NeGui.AFTER)HWND_TOP, 0 ,0 ,0 ,0, NeGui.SWP.NOMOVE | NeGui.SWP.NOSIZE);
				}
			} else {
				throw new NemuxiException("既に存在しないウィンドウ");
			}
		} else {
			throw new NemuxiException("AppButton_Proc_RButtonDown:ProcessListMenu.get(MENUITEM)");
		}
	}
	private static extern(Windows) BOOL EnumWindowsProc(HWND hWnd , LPARAM lParam)
	in {
		assert(IsWindow(hWnd));
	}
	body {
		auto window=new OtherWindow(hWnd);

		auto Index = cast(INDEX*)lParam;

		// 整理が必要
		if(!window() || !window.visible()) {
			return TRUE;
		}
		if(window.relation(NeGui.GW.OWNER)) {
			return TRUE;
		}
		auto style=window.getItemInfo(GWL_EXSTYLE);
		if(style & WS_EX_TOOLWINDOW) {
			return TRUE;
		}

		auto WindowText=window.text;
		if(WindowText.empty) {
			return TRUE;
		}

		DRAWITEM DrawItem=void;
		DrawItem.text = WindowText.ptr;

		// ウィンドウから
		// 対応する大きさ
		DrawItem.icon = window.getIcon(Index.ProcessListMenu.iconSize);
		// クラスから
		// 対応する大きさ
		if(!DrawItem.icon()) {
			DrawItem.icon = new Icon(cast(HICON)window.getClassInfo(Index.ProcessListMenu.iconSize == ICONSIZE.NORMAL ? GCL_HICON: GCL_HICONSM), false);
		}
		// 見つからず
		if(!DrawItem.icon()) {
			DrawItem.icon = GetSystemIcon(SYSICON.APPLICATION, Index.ProcessListMenu.iconSize);
		}

		MENUITEM MenuItem;
		MenuItem.sizeInit();
		MenuItem.mask     = MENUITEM.MIIM.ID | MENUITEM.MIIM.TYPE | MENUITEM.MIIM.DATA;
		MenuItem.type     = MENUITEM.MFT.OWNERDRAW;
		MenuItem.id       = Index.Id++;
		MenuItem.itemData = cast(void*)hWnd;
		Index.ProcessListMenu.insert(&MenuItem, &DrawItem);

		return TRUE;
	}
	+/

	/+
	protected override {
		void OnMouseRightDown(MOUSE_KEY Keys, int x, int y) {
		}
	}
	+/
	protected override {
		bool OnMouseRightDown(MOUSE_KEY Keys, int x, int y) {
			parent.send(WM_MY_MSG.BUTTONLIST, NONE, NONE);
			return true;
		}
		void OnDestroy() {
			//delete SubclassObject;
			SubClassOnNeGuiDestructor();
			super.OnDestroy();
		}
	}
}
__EOF__;
extern(Windows) LRESULT NemuxiTitleBar_Proc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam) {
	auto Titlebar = cast(NemuxiTitleBar)NeGui.getGui(hWnd);
	
	switch(Message) {
		case WM_DESTROY:
			return 0;

		case WM_LBUTTONDOWN:
			if(application.AppData.position != application.AppData.POSITION.FLOAT) {
				return 0;
			}
			goto default;
		case WM_RBUTTONDOWN:
			AppButton_Proc_RButtonDown(Titlebar);
			return 0;
		case WM_MEASUREITEM: {
			auto MeasureItem=cast(MEASUREITEMSTRUCT*)lParam;

			if(!wParam && MeasureItem.CtlType == ODT.MENU) {
				if(!IsWindow(cast(HWND)MeasureItem.itemData)) {
					Titlebar.ExeButtonListMenu.measureItem(Titlebar, MeasureItem);
				} else {
					Titlebar.ProcessListMenu.measureItem(Titlebar, MeasureItem);
				}
			}
			
			return 1;
		}
		case WM_DRAWITEM: {
			auto DrawItem = cast(DRAWITEMSTRUCT*)lParam;
			
			if(DrawItem.CtlType == ODT.MENU) {
				if(!IsWindow(cast(HWND)DrawItem.itemData)) {
					Titlebar.ExeButtonListMenu.drawItem(DrawItem);
				} else {
					Titlebar.ProcessListMenu.drawItem(DrawItem);
				}
			}
			
			return 1;
		}
		default:
			assert(Titlebar);
			return Titlebar.call(hWnd, Message, wParam, lParam);
	}
}

void AppButton_Proc_RButtonDown(NemuxiTitleBar Titlebar) {
	if(!Titlebar.ExeButtonListMenu) {
		return;
	}
	
	RECT Rect=void;
	Titlebar.itemRect(Rect);

	POINT Point=void;
	Point.x = Rect.right + 1;
	Point.y = Rect.top;
	
	auto id=Titlebar.ExeButtonListMenu.show(Titlebar, PopUp.TPM.RETURNCMD | PopUp.TPM.LEFTBUTTON, &Point, &Rect);
	if(!id) {
		return;
	}
	MENUITEM MenuItem;
	MenuItem.sizeInit();
	MenuItem.mask = MENUITEM.MIIM.ID | MENUITEM.MIIM.DATA;
	MenuItem.id   = id;
	// exemenuと同じ。
	if(Titlebar.ExeButtonListMenu.get(MenuItem)) {
		application.executeItem(cast(Item)MenuItem.itemData);
	} else {
		throw new NemuxiException("AppButton_Proc_LButtonDown:ExeButtonListMenu.get");
	}
	
}

