﻿/**
本体ウィンドウ。

いろいろ管理してるしこのpackageはもはや運命共同体。

*/
module nemuxi.gui.window.nemuxiwindow.nemuxiwindow;

debug import std.stdio: wl = writefln, pl = printf;
debug(nemuxiwindow) void main() {}
debug import std.random;

import core.memory;
import std.contracts;

import win32.windows;
import win32.commctrl;

debug {
	import nemuxi.test.debugdialog;
	import nemuxi.test.childdialog;
	import nemuxi.test.itemdialog;
	import nemuxi.test.layoutdialog;
}

import nemuxi.base;
import nemuxi.system.application;
import nemuxi.file.app;
import nemuxi.file.file;
import nemuxi.file.items.item;
import nemuxi.image.icon;
//import nemuxi.negui.draw.canvas;
import nemuxi.negui.draw.cursor;
import nemuxi.negui.window.newindow;
import nemuxi.negui.control.toolbar.toolbar;
import nemuxi.negui.control.button.button;
import nemuxi.negui.window.menu.ownerdraw;
import nemuxi.gui.window.dialog.commanddialog.commanddialog;
/+
import nemuxi.negui.proc.nemuxiwnd.appbar;
import nemuxi.negui.proc.nemuxiwnd.appbutton;
import nemuxi.negui.proc.nemuxiwnd.appmenu;
import nemuxi.negui.proc.nemuxiwnd.groupmenu;
import nemuxi.negui.proc.nemuxiwnd.itemmenu;
import nemuxi.negui.proc.nemuxiwnd.apptray;
+/
//import nemuxi.negui.proc.nemuxiwnd.tooltip; // 時期が来れば活躍
import nemuxi.gui.window.nemuxiwindow.toolbar;
import nemuxi.gui.window.nemuxiwindow.tooltip;
import nemuxi.gui.window.nemuxiwindow.tasktray;
import nemuxi.gui.window.nemuxiwindow.titlebar;
/+
import nemuxi.negui.proc.nemuxiwnd.groupmenu;
import nemuxi.negui.proc.nemuxiwnd.executemenu;
import nemuxi.negui.proc.nemuxiwnd.itemmenu;
+/
import nemuxi.gui.window.nemuxiwindow.buttonlauncher;
import nemuxi.gui.window.nemuxiwindow.menulauncher;
import nemuxi.gui.window.nemuxiwindow.proccessmenu;

import nemuxi.negui.window.adtb;
//import nemuxi.negui.window.titlebar;
//import nemuxi.negui.proc.commandwnd.commandwnd;
//import nemuxi.negui.proc.commandwnd.commanddialog;
import nemuxi.negui.hotkey;
import nemuxi.negui.dropfile;
import nemuxi.gui.window.dialog.inputdialog.inputdialog;
import nemuxi.negui.window.dialog.system;
import nemuxi.negui.draw.cursor;
import nemuxi.gui.window.dialog.settingdialog.settingdialog;
import nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;
import nemuxi.negui.window.mainwindow;
import nemuxi.gui.gui;
import nemuxi.dll.plugin.hooker.hooker;
import nemuxi.utility.controller;
import nemuxi.negui.window.dialog.system;
import nemuxi.gui.window.nemuxiwindow.ver;

package enum MENUS {
	MENU = 1,
	BUTTON,
	FILE,
	PROCCESS,
}
package enum WM_MY_MSG: UINT {
	APPDESKTOP_TOOLBAR = WM_APP+1,
	TASKTRAY_MESSAGE,
	BUTTONLIST,
	COMMAND_DESTROY,

	HOOKER = HookerDLL.WM_HOOKER,
}

/**
History:
	[V]:
		Applicationを持つように変更中。
		これに伴いpackage、nemuxi.gui.window.nemuxiwindowの各クラス修正。
		全ファイル置き換えて修正しただけなんで多分問題ないはず。
*/
final class NemuxiWindow: MainWindow {
	private {
		static enum CTRL: ITEM_ID {
			BUTTONS=1,
			TITLE,
		}

		static enum HK: HOTKEY_ID {
			COMMAND = 1,
		}
	}
	public Application application;
	private {
		
		ApplicationDesktopToolBar AppDesktopToolbar;
		NemuxiTaskTray Tasktray;
		
		NemuxiToolBar  Toolbar;
		NemuxiToolTip  Tooltip;
		NemuxiTitleBar Titlebar;

		/// ボタン型
		ButtonLauncher Buttons;

		/// メニュー型ランチャーメニュー
		MenuLauncher Menus;

		/// プロセス一覧
		ProcessListMenu PLMenu;

		HotKey Hotkey;

		//フック
		HookerDLL Hooker;

		/+
		/// ボタン型ランチャー一覧
		BM_ITEM[] BMItems;
		/// ボタングループ切り替えメニュー
		GroupMenu Groupmenu;
		/// ボタン型ランチャー
		OwnerDrawMenu ExeButtonListMenu;
		
		/// プロセスメニュー
		OwnerDrawMenu ProcessListMenu;

		/// アイテムメニュー
		PopUp ItemNormalMenu;
		/// アイテムメニューのフォルダのファイル一覧
		ItemMenu ItemFileMenu;
		+/

		CommandDialog cd;
	}
	
	this(Application application)
	in {
		assert(application);
	}
	body {
		this.application = application;
		
		GUIINFO NeGuiInfo;
		NeGuiInfo.ExStyle      = WS_EX_TOOLWINDOW | WS_EX_WINDOWEDGE | WS_EX_ACCEPTFILES;
		NeGuiInfo.Style        = WS_THICKFRAME | WS_SYSMENU | WS_MINIMIZEBOX;
		
		super(&NeGuiInfo);
	}

	private void BlockSize(ref SIZE PaddingSize, ref SIZE ButtonSize, ref SIZE TitleSize) {
		//パディング取得
		PaddingSize.cx = GetSystemMetrics(SM_CXDLGFRAME) * 2;
		PaddingSize.cy = GetSystemMetrics(SM_CYDLGFRAME) * 2;
		
		if(Toolbar.buttonCount) {
			//Toolbar.buttonSize(1, ButtonSize);
			ButtonSize = Toolbar.buttonSize(1);
		} else {
			ButtonSize.cx = GetSystemMetrics(SM_CXSMSIZE);
			ButtonSize.cy = GetSystemMetrics(SM_CYSMSIZE);
		}
		
		// タイトルバーサイズ(有効方向のみ)
		TitleSize.cx = Titlebar.isHorizon() ? Titlebar.getSize(): 0;
		TitleSize.cy = Titlebar.isHorizon() ? 0: Titlebar.getSize();
	}
	
	void dataLoad() {
		// ボタン型
		Toolbar.initialize();
		if(application.MainData().length) {
			auto groups=application.initExeButtonGroup;
			if(groups) {
			application.changeMainGroup(groups[0]);
			application.changeSubGroup(groups[1]);
			}
			Buttons.setNowState();
		}

		delete Menus;
		Menus = new MenuLauncher(application);
		if(application.MenuData().length) {
			application.changeMenuGroup(application.initExeMenuGroup());

			Menus.setNowState();
		}
	
		// ホットキー
		auto Keys=application.AppData.exeCoomandHotkey();
		delete Hotkey;
		Hotkey = new HotKey(this, HK.COMMAND, cast(MOD)Keys[0], cast(KEY)Keys[1]);
		if(!Hotkey.start()) {
			Logger.write("ホットキー競合？");
		}

		// フック
		if(Hooker && Hooker.isRunning) {
			Hooker.stop;
		}
		delete Hooker;
		if(application.AppData.exeMenuDeskTop) {
			try {
				Hooker = new HookerDLL(this);
				Hooker.start;
			} catch(NemuxiException e) {
				Logger.write(e);
				Hooker = null;
			}
		}
		
		// ウィンドウ表示方法
		auto pos=application.AppData.position;
		//application.AppData.position = application.AppData.POSITION.SMALL;
		//application.setNemuxiPosition(hWnd, pos, MY_WM_APPDESKTOPTOOLBAR);
		delete AppDesktopToolbar;
		SetPosition(pos, false);
		
		// Z位置
		topMost(application.AppData.front);
	}
	

	private void SetPosition(in App.POSITION NewPosition, bool Save=true) {
		assert(Titlebar);
		
		auto OldPosition=application.AppData.position();
		if(application.isAppDeskTopToolBar(OldPosition)) {
			// 現在有効なら一旦登録解除
			delete AppDesktopToolbar;
		}
		// 現状を記録
		if(Save) {
			/+
			RECT Rect;
			this.itemRect(Rect);
			+/
			auto Rect=itemRect;
			switch(OldPosition) {
				case App.POSITION.LEFT, App.POSITION.RIGHT:
					application.AppData.barSize(OldPosition, Rect.right - Rect.left);
					break;
				case App.POSITION.TOP, App.POSITION.BOTTOM:
					application.AppData.barSize(OldPosition, Rect.bottom - Rect.top);
					break;
				case App.POSITION.FLOAT: {
					POINT Point;
					Point.x = Rect.left;
					Point.y = Rect.top;
					SIZE Size;
					Size.cx = Rect.right  - Rect.left;
					Size.cy = Rect.bottom - Rect.top;

					application.AppData.floatPos(Point);
					application.AppData.floatSize(Size);
					break;
				}
				default:
			}
		}
		
		// 位置設定
		RECT Rect;
		if(application.isAppDeskTopToolBar(NewPosition)) {
			AppDesktopToolbar = new ApplicationDesktopToolBar(this, WM_MY_MSG.APPDESKTOP_TOOLBAR);

			SIZE  Size;

			auto Bar=application.AppData.barSize(NewPosition);
			
			SystemParametersInfo(SPI_GETWORKAREA, 0, &Rect, 0);
			
			switch(NewPosition) {
				case App.POSITION.LEFT:
					Rect.right  = Bar;
					break;
				case App.POSITION.RIGHT:
					Rect.left   = Rect.right - Bar;
					Rect.right  = Bar;
					break;
				case App.POSITION.TOP:
					Rect.bottom = Bar;
					break;
				case App.POSITION.BOTTOM:
					Rect.top    = Rect.bottom - Bar;
					Rect.bottom = Bar;
					break;
				default:
					assert(false);
			}
		} else if(NewPosition == App.POSITION.FLOAT) {
			POINT Point = application.AppData.floatPos();
			SIZE  Size  = application.AppData.floatSize();

			Rect.left   = Point.x;
			Rect.top    = Point.y;
			Rect.right  = Size.cx;
			Rect.bottom = Size.cy;
		}
		
		application.AppData.position = NewPosition;
		
		with(ApplicationDesktopToolBar.ABE) {
			void WindowSetter(TitleBar.POSITION Title) {
				assert(NewPosition != App.POSITION.SMALL);
				
				Titlebar.Position = Title;
				
				this.pos(NeGui.AFTER.NONE, Rect.left, Rect.top, Rect.right, Rect.bottom, SWP.DRAWFRAME | SWP.NOZORDER | SWP.FRAMECHANGED);
				this.reLoad();
				this.setShow(SHOW.SHOW);
			}
			void BarSetter(ApplicationDesktopToolBar.ABE Abe, TitleBar.POSITION Title) {
				WindowSetter(Title);
				AppDesktopToolbar.position = Abe;
			}
			
			switch(NewPosition) {
				case App.POSITION.LEFT:
					BarSetter(LEFT, TitleBar.POSITION.TOP);
					break;
				case App.POSITION.TOP:
					BarSetter(TOP, TitleBar.POSITION.LEFT);
					break;
				case App.POSITION.RIGHT:
					BarSetter(RIGHT, TitleBar.POSITION.TOP);
					break;
				case App.POSITION.BOTTOM:
					BarSetter(BOTTOM, TitleBar.POSITION.LEFT);
					break;
				case App.POSITION.FLOAT:
					WindowSetter(TitleBar.POSITION.LEFT);
					break;
				case App.POSITION.SMALL:
					this.setShow(SHOW.HIDE);
					break;
				default:
					assert(false);
			}
		}
		reLoad;
	}

	
	protected override {
		void OnDestroy() {
			/+
			delete Executemenu;
			delete BMItems;
			delete Groupmenu;
			delete ExeButtonListMenu;
			delete ProcessListMenu;
			delete ItemFileMenu;
			delete ItemNormalMenu;
			+/
			//SetPosition(new Window(hWnd), application.AppData.position, true);
			
			delete Buttons;
			delete Menus;
			
			delete Hotkey;
			
		if(Hooker && Hooker.isRunning) {
			Hooker.stop;
		}
		delete Hooker;
			delete AppDesktopToolbar;
			delete Tasktray;
			
			super.OnDestroy();
		}
		void OnCreate() {
			// タスクトレイ
			Tasktray = new NemuxiTaskTray(this, WM_MY_MSG.TASKTRAY_MESSAGE);
			Tasktray.makeTray(0);
			
			// ツールバー
			Toolbar = new NemuxiToolBar(this, CTRL.BUTTONS);
			Toolbar.initialize();

			// ツールチップ
			Tooltip = new NemuxiToolTip(this);

			// タイトルバー
			Titlebar = new NemuxiTitleBar(this, CTRL.TITLE);

			// ボタン型
			Buttons = new ButtonLauncher(Toolbar, Tooltip, Titlebar, application);
			
			debug {
				dchar[] s=[
					1578, 1608, 1603, 1608, 1594, 1575, 1608, 1575,   32,
					1573, 1610, 1574, 1607,   45, 1610, 1575, 1587, 1608
				];
				text=Text(s);
			}
		}

		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			if(Sender == Toolbar) {
				try {
					auto item=Toolbar.buttonGet(Id);
					application.executeItem(item);
				} catch(Exception e) {
					ShowExceptionDialog(this, e);
				}
				return true;
			}
			return false;
		}
		
		void OnSize(SIZE_TYPE SizeType, int Width, int Height) {
			Titlebar.onSize();
			//Appbar.sizeTune(window);
	
			//SIZE Size=void;

			auto PaddingWidth=Titlebar.getSize();

			/+
			if(!clientSize(Size))
				throw new NemuxiException("sizeTune:OwnerWnd.clientSize");
			+/
			try {
				auto Size = clientSize();
				
				if(Titlebar.isHorizon()) {
					Toolbar.move(PaddingWidth, 0, Size.cx - PaddingWidth, Size.cy, true);
				} else {
					Toolbar.move(0, PaddingWidth, Size.cx, Size.cy - PaddingWidth, true);
				}
			} catch(Exception e) {
				throw new NemuxiException("sizeTune:OwnerWnd.clientSize", EC.NONE, e);
			}

		}
		void OnSizing(SIDEFLAG Sides, ref RECT Rect) {
			//パディング取得
			SIZE PaddingSize, ButtonSize, TitleSize;
			BlockSize(PaddingSize, ButtonSize, TitleSize);

			//左変更制限
			void SizingLeft() {
				Rect.left = 
				Rect.right - TitleSize.cx - ((Rect.right - Rect.left) / ButtonSize.cx) * ButtonSize.cx - PaddingSize.cx;
			}
			//右変更制限
			void SizingRight() {
				Rect.right =
				Rect.left + TitleSize.cx + ((Rect.right - Rect.left) / ButtonSize.cx) * ButtonSize.cx + PaddingSize.cx;
			}
			//上変更制限
			void SizingTop() {
				Rect.top  =
				Rect.bottom - TitleSize.cy - ((Rect.bottom - Rect.top) / ButtonSize.cy) * ButtonSize.cy-PaddingSize.cy;
			}
			//下変更制限
			void SizingBottom() {
				Rect.bottom =
				Rect.top + TitleSize.cy + ((Rect.bottom - Rect.top) / ButtonSize.cy) * ButtonSize.cy + PaddingSize.cy;
			}
			//
			//判定と計算。計算は内部関数で行う。内部関数の最適化等は後の課題
			switch(Sides) {
				case SIDEFLAG.LEFT:        //左辺
					SizingLeft();
					break;
				case SIDEFLAG.RIGHT:       //右辺
					SizingRight();
					break;
				case SIDEFLAG.TOP:         //上辺
					SizingTop();
					break;
				case SIDEFLAG.TOPLEFT:     //左上隅
					SizingTop();
					SizingLeft();
					break;
				case SIDEFLAG.TOPRIGHT:    //右上隅
					SizingTop();
					SizingRight();
					break;
				case SIDEFLAG.BOTTOM:      //底辺
					SizingBottom();
					break;
				case SIDEFLAG.BOTTOMLEFT:  //左下隅
					SizingBottom();
					SizingLeft();
					break;
				case SIDEFLAG.BOTTOMRIGHT: //右下隅
					SizingBottom();
					SizingRight();
					break;
				default: assert(0);
			}
		}

		bool OnMinMax(POINT* MaxSize, POINT* MaxPos, POINT* MaxTrack, POINT* MinTrack) {
			//パディング取得
			SIZE PaddingSize, ButtonSize, TitleSize;
			BlockSize(PaddingSize, ButtonSize, TitleSize);
			
			MinTrack.x = PaddingSize.cx + ButtonSize.cx + TitleSize.cx;
			MinTrack.y = PaddingSize.cy + ButtonSize.cy + TitleSize.cy;
			
			version(none) with(App.POSITION) switch(application.AppData.position) {
				case LEFT:
					break;
				case TOP:
					break;
				case RIGHT:
					break;
				case BOTTOM:
					break;
				case FLOAT:
					break;
				default:
			}
			
			return true;
		}
		
		void OnActive(WA Active, bool NotSmall, HWND NextWnd) {
			/+
			RECT Rect;
			SIZE Size;
			Titlebar.clientSize(Size);
			Rect.right = Size.cx;
			Rect.bottom= Size.cy;
			scope canvas=Titlebar.canvas();
			Titlebar.draw(cast(bool)Active, canvas, &Rect);
			+/
			Titlebar.onActive(Active);
			
			if(AppDesktopToolbar) {
				AppDesktopToolbar.procActivate();
			}
			
		}
		void OnHotKey(HOTKEY_ID Id, HOTKEY HotKey, KEY VKey) {
			switch(Id) {
				case HK.COMMAND:
				if(!cd)cd = new CommandDialog(this, application);
				//POINT p;Cursor.getPos(p);
				auto p=Cursor.getPos();
				cd.		move(p.x,p.y,100,100);
				cd.		setShow(SHOW.SHOWNORMAL);
					break;
				default:
					assert(false);
			}
		}
		
		void OnEnable(bool Enable) {
			if(Hotkey) if(Enable) {
				Hotkey.start;
			} else {
				Hotkey.stop;
			}
			if(Hooker) if(Enable) {
				Hooker.start;
			} else {
				Hooker.stop;
			}
		}

		void OnWindowPosChanged(ref WINDOWPOS WindowPos) {
			if(AppDesktopToolbar) {
				AppDesktopToolbar.procWindowPosChanged();
			}
		}
		private void AppDesktopToolbarPosition() {
			if(AppDesktopToolbar) {
				AppDesktopToolbar.position(AppDesktopToolbar.position());
			}
		}
		void OnExitSizeMove() {
			SetPosition(application.AppData.position(), true);
			AppDesktopToolbarPosition();
		}
		void OnDisplayChange(int Bits, int Horizontal, int Vertical) {
			AppDesktopToolbarPosition();
		}

		void OnContexMenu(NeGui CatchItem, int x, int y) {
			Buttons.groupMenuSelect(this);
		}
		
		void OnMeasureItem(MEASUREITEM* Measure) {
			switch(cast(MENUS)Measure.data) {
				case MENUS.MENU:
					Menus.Executemenu.measureItem(this, Measure);
					return;
				case MENUS.BUTTON:
					Buttons.Listmenu.measureItem(this, Measure);
					break;
				case MENUS.FILE:
					Buttons.Filemenu.measureItem(this, Measure);
					break;
				case MENUS.PROCCESS:
					PLMenu.measureItem(this, Measure);
					break;
				default:
					assert(false);
			}
		}
		void OnDrawItem(DRAWITEM* DrawItem) {
			
			switch(DrawItem.type) {
				case CONTROL_TYPE.BUTTON: // アプリボタン
					assert(DrawItem.id == CTRL.TITLE);
					//assert(DrawItem.hwndItem == GetDlgItem(hWnd, CTRL.TITLE));
					//Titlebar.draw(GetActiveWindow() == hWnd, DrawItem);
					Titlebar.draw(DrawItem);
					return;
				case CONTROL_TYPE.MENU: // メニュー
					switch(cast(MENUS)DrawItem.data) {
						case MENUS.MENU:
							Menus.Executemenu.drawItem(DrawItem);
							return;
						case MENUS.BUTTON:
							Buttons.Listmenu.drawItem(DrawItem);
							return;
						case MENUS.FILE:
							Buttons.Filemenu.drawItem(DrawItem);
							return;
						case MENUS.PROCCESS:
							PLMenu.drawItem(DrawItem);
							return;
						default:
							assert(false);
					}
				default:
					assert(false);
			}
		}

		bool OnInitPupUpMenu(ITEM_ID Id, bool SystemFlag, HMENU hMenu) {
			if(Buttons.Filemenu && Buttons.Filemenu() == hMenu) {
				Buttons.Filemenu.readFolder(ItemMenu.ITEMID.max+1);
				return true;
			} else {
				return false;
			}
		}
		
		bool OnMouseMiddleDown(MOUSE_KEY Keys, int x, int y) {
			/+
			POINT Point;
			Cursor.getPos(Point);
			+/
			auto Point=Cursor.getPos();
			
			Menus.show(this, Point);

			return true;
		}

		/**
		History:
			[V]:
				新規追加。
		*/
		HT OnNcHitTest(HT HitFlag, int x, int y) {
			immutable HT[][App.POSITION] table = [
				App.POSITION.LEFT:   [HT.RIGHT,  HT.TOPRIGHT,   HT.BOTTOMRIGHT],
				App.POSITION.RIGHT:  [HT.LEFT,   HT.TOPLEFT,    HT.BOTTOMLEFT],
				App.POSITION.TOP:    [HT.BOTTOM, HT.BOTTOMLEFT, HT.BOTTOMRIGHT],
				App.POSITION.BOTTOM: [HT.TOP,    HT.TOPLEFT,    HT.TOPRIGHT],
			];
			if(auto p=application.AppData.position in table) {

				foreach(value; *p) {
					if(HitFlag == value) {
						return *p[0];
					}
				}

				return HT.CLIENT;
			}
			/+
			with(App.POSITION) switch(application.AppData.position) {
				case LEFT:
					if(HitFlag != HT.RIGHT) {
						return HT.CLIENT;
					}
					break;
				case TOP:
					if(HitFlag != HT.BOTTOM) {
						return HT.CLIENT;
					}
					break;
				case RIGHT:
					if(HitFlag != HT.LEFT) {
						return HT.CLIENT;
					}
					break;
				case BOTTOM:
					if(HitFlag != HT.TOP) {
						return HT.CLIENT;
					}
					break;
				case FLOAT:
					break;
				default:
					assert(false);
			}
			+/
			return HitFlag;
		}
		
		/**
		History:
			[V]:
				新規追加。
		*/
		bool OnNonClientMouseLeftDown(HT HitFlag, int x, int y) {
			if(HitFlag == HT.CAPTION) {
				if(application.AppData.position != App.POSITION.FLOAT) {
					return true;
				}
				assert(application.AppData.position != App.POSITION.SMALL);
			}
			return false;
		}
		
		int OnNotify(ITEM_ID Id, NOTIFY* Notify) {
			switch(Notify.code) {
				case ToolBar.EVENT.DROPDOWN:
					Buttons.itemShow(this, Notify);
					return 0;
				default:
					return 0;
			}
		}

		/**
		History:
			[V]:
				一部文言修正。
		*/
		bool OnOtherEvent(UINT Message, WPARAM wParam, LPARAM lParam) {
			switch(Message) {
				case WM_MY_MSG.APPDESKTOP_TOOLBAR:
					OnAppDeskTopToolBar(wParam, lParam);
					return true;
				case WM_MY_MSG.TASKTRAY_MESSAGE:
					return OnTasktray(lParam);
				case WM_MY_MSG.BUTTONLIST:
					if(auto item=Buttons.listShow(this)) {
						application.executeItem(item);
					}
					return true;
				case WM_MY_MSG.HOOKER:
					auto HookData = cast(HOOKDATA*)wParam;
					HookData.Chain = true;
					if(HookData.wParam == WM_MBUTTONDOWN) {
						const MouseHook = cast(MOUSEHOOKSTRUCT*)HookData.lParam;

						auto hWnd=WindowFromPoint(MouseHook.pt);
						const desk=Window.find(Text("Progman"), Text("Program Manager"));
						auto hTemp=hWnd;
						while(cast(bool)(hTemp = GetParent(hWnd))) {
							hWnd = hTemp;
						}
						if(desk == hWnd) {
							scope pause=new Pause(Hooker);
							send(WM_MBUTTONDOWN, NONE, NONE);
						}
					}
					return true;
				case TaskTray.TaskBar:
					Logger.write("タスクバー再登録につきタスクトレイへ再配置");
					if(Tasktray) {
						Tasktray.makeTray(0);
					} else {
						Logger.write("タスクトレイに登録出来なかった？");
					}
					return true;
				default:
					return false;
			}
		}
	}
	private {
		void OnAppDeskTopToolBar(WPARAM wParam, LPARAM lParam) {
			switch(wParam) {
				case ABN_POSCHANGED:
					AppDesktopToolbar.position(AppDesktopToolbar.position());
					break;
				case ABN_FULLSCREENAPP:
					if(lParam) {
						setShow(SHOW.HIDE);
					} else {
						setShow(SHOW.SHOWNORMAL);
					}
					break;
				default:
					break;
			}
		}
		bool OnTasktray(LPARAM lParam) {
			if(lParam == WM_LBUTTONDOWN || lParam == WM_RBUTTONUP || lParam == WM_MBUTTONDOWN) {
				if(enable) {
					foreGround();
					switch(lParam) {
						case WM_LBUTTONDOWN: // メニューーランチャ
							send(WM_MBUTTONDOWN, NONE, NONE);
							break;
						case WM_MBUTTONDOWN: {// プロセス一覧。
							PLMenu = new ProcessListMenu(application.AppData.exeMenuIcon());
							PLMenu.show(this);
							delete PLMenu;
							//window.sendChild(CTRL.APPBUTTON, WM_RBUTTONDOWN, NeGui.NONE, NeGui.NONE);
							//ShowProcessList(window.child(CTRL.APPBUTTON), &Point, null);
							//ShowProcessList(Appbtn, &Point, null);
							break;
						}
						case WM_RBUTTONUP: // ﾈﾑぃメニュー
							SystemMenu();
							break;
						default:
							assert(false);
					}
					// マナー
					post(WM_NULL, NONE, NONE);
				} else {
					if(auto relation=relation(GW.ENABLEDPOPUP))
						relation.foreGround();
				}
				
				return true;
			}
			
			return false;
			
		}
	}

	/**
	History:
		1.00β11:
			バージョン情報部分修正。
	*/
	private void SystemMenu() {
		enum SYSMENU: COMMAND_ID {
			WINDOW=1,
			WINDOW_LEFT,
			WINDOW_TOP,
			WINDOW_RIGHT,
			WINDOW_BOTTOM,
			WINDOW_FLOAT,
			WINDOW_SEP_1,
			WINDOW_TOPMOST,
			WINDOW_SEP_2,
			WINDOW_SMALL,
			
			/+
			FOLDER,
			FOLDER_NEMUXI,
			FOLDER_USER,
			FOLDER_SEP_1,
			FOLDER_MY_DOCUMENT,
			FOLDER_MY_PICTURE,
			FOLDER_MY_MUSIC,
			FOLDER_MY_VIDEO,
			FOLDER_SEP_2,
			FOLDER_DESKTOP,
			FOLDER_STARTMENU,
			FOLDER_STARTUP,
			FOLDER_SENDTO,
			FOLDER_FAVORITES,
			FOLDER_SEP_3,
			FOLDER_COMPUTER,
			FOLDER_CONTROLPANEL,
			FOLDER_NETWORK,
			FOLDER_RECENT,
			FOLDER_PRINTER,
			FOLDER_FONTS,
			FOLDER_SEP_4,
			FOLDER_TEMP,
			FOLDER_WINDOWS,
			FOLDER_SYSTEM,
			FOLDER_PROGRAMS,
			+/
			
			SEP_1,
			SETTING,
			SEP_2,
			HELP,
			SEP_3,
			ABOUT,
			SEP_4,
			EXIT,

			//---------
			DEBUG_SEP,
			DEBUG_DIALOG,
			CHILD_DIALOG,
			ITEM_DIALOG,
			LAYOUT_DIALOG,
			//---------

			TOOLS,
			
		}

		MENUITEM MenuItem;
		MenuItem.sizeInit();
		scope MainMenu  =new PopUp();
		scope MenuWindow=new PopUp();
		//scope MenuFolder=new PopUp();
		scope MenuTools =new PopUp();

		// ウィンドウ部分
		MenuWindow.insertString(SYSMENU.WINDOW_LEFT, Text("左部"), true);
		MenuWindow.insertString(SYSMENU.WINDOW_TOP, Text("上部"), true);
		MenuWindow.insertString(SYSMENU.WINDOW_RIGHT, Text("右部"), true);
		MenuWindow.insertString(SYSMENU.WINDOW_BOTTOM, Text("下部"), true);
		MenuWindow.insertString(SYSMENU.WINDOW_FLOAT, Text("フロート"), true);
		MenuWindow.insertSeparator(SYSMENU.WINDOW_SEP_1);
		MenuWindow.insertString(SYSMENU.WINDOW_TOPMOST, Text("最前面"), true);
		MenuWindow.insertSeparator(SYSMENU.WINDOW_SEP_2);
		MenuWindow.insertString(SYSMENU.WINDOW_SMALL, Text("非表示"), true);

		// ウィンドウ位置によるマーク付け
		COMMAND_ID PosCheck;
		switch(application.AppData.position) {
			case App.POSITION.LEFT:   PosCheck = SYSMENU.WINDOW_LEFT;   break;
			case App.POSITION.TOP:    PosCheck = SYSMENU.WINDOW_TOP;    break;
			case App.POSITION.RIGHT:  PosCheck = SYSMENU.WINDOW_RIGHT;  break;
			case App.POSITION.BOTTOM: PosCheck = SYSMENU.WINDOW_BOTTOM; break;
			case App.POSITION.FLOAT:  PosCheck = SYSMENU.WINDOW_FLOAT;  break;
			case App.POSITION.SMALL:  PosCheck = SYSMENU.WINDOW_SMALL;  break;
			default: assert(false);
		}
		MenuWindow.radio(SYSMENU.WINDOW_LEFT, SYSMENU.WINDOW_SMALL, PosCheck);
		// 最前面設定
		MenuWindow.check(SYSMENU.WINDOW_TOPMOST, application.AppData.front);

		/+
		//フォルダ
		MenuFolder.insertString(SYSMENU.FOLDER_NEMUXI, Text("本体フォルダ"), true);
		MenuFolder.insertString(SYSMENU.FOLDER_USER, Text("ユーザーフォルダ"), true);
		MenuFolder.insertSeparator(SYSMENU.FOLDER_SEP_1);
		MenuFolder.insertString(SYSMENU.FOLDER_MY_DOCUMENT, Text("マイドキュメント"), true);
		MenuFolder.insertString(SYSMENU.FOLDER_MY_PICTURE, Text("マイピクチャ"), true);
		MenuFolder.insertString(SYSMENU.FOLDER_MY_MUSIC, Text("マイミュージック"), true);
		MenuFolder.insertString(SYSMENU.FOLDER_MY_VIDEO, Text("マイビデオ"), true);
		MenuFolder.insertSeparator(SYSMENU.FOLDER_SEP_2);
		MenuFolder.insertString(SYSMENU.FOLDER_DESKTOP, Text("デスクトップ"), true);
		MenuFolder.insertString(SYSMENU.FOLDER_STARTMENU, Text("スタートメニュー"), true);
		MenuFolder.insertString(SYSMENU.FOLDER_STARTUP, Text("スタートアップ"), true);
		MenuFolder.insertString(SYSMENU.FOLDER_SENDTO, Text("送る"), true);
		MenuFolder.insertString(SYSMENU.FOLDER_FAVORITES, Text("お気に入り"), true);
		MenuFolder.insertSeparator(SYSMENU.FOLDER_SEP_3);
		MenuFolder.insertString(SYSMENU.FOLDER_COMPUTER, Text("マイコンピュータ"), true);
		MenuFolder.insertString(SYSMENU.FOLDER_CONTROLPANEL, Text("コントロールパネル"), true);
		MenuFolder.insertString(SYSMENU.FOLDER_NETWORK, Text("ネットワーク"), true);
		MenuFolder.insertString(SYSMENU.FOLDER_RECENT, Text("最近使用したファイル"), true);
		MenuFolder.insertString(SYSMENU.FOLDER_PRINTER, Text("プリンタ"), true);
		MenuFolder.insertString(SYSMENU.FOLDER_FONTS, Text("フォント"), true);
		MenuFolder.insertSeparator(SYSMENU.FOLDER_SEP_4);
		MenuFolder.insertString(SYSMENU.FOLDER_TEMP, Text("テンポラリ"), true);
		MenuFolder.insertString(SYSMENU.FOLDER_WINDOWS, Text("Windows"), true);
		MenuFolder.insertString(SYSMENU.FOLDER_SYSTEM, Text("System"), true);
		MenuFolder.insertString(SYSMENU.FOLDER_PROGRAMS, Text("プログラムファイル"), true);
		+/

		//ツールメニュー
		//MenuTools.insertString

		// 親メニュー
		MainMenu.insertSubMenu(SYSMENU.WINDOW, Text("ウィンドウ"), MenuWindow, true);
		//MainMenu.insertSubMenu(SYSMENU.FOLDER, Text("フォルダ"), MenuFolder, true);
		MainMenu.insertSubMenu(SYSMENU.TOOLS, Text("ツール"), MenuTools, false);
		MainMenu.insertSeparator(SYSMENU.SEP_1);
		MainMenu.insertString(SYSMENU.SETTING, Text("設定"), true);
		MainMenu.insertSeparator(SYSMENU.SEP_2);
		MainMenu.insertString(SYSMENU.HELP, Text("ヘルプ"), FILE.isExistence(StaticData.help));
		MainMenu.insertSeparator(SYSMENU.SEP_3);
		MainMenu.insertString(SYSMENU.ABOUT, Text("バージョン"), true);
		MainMenu.insertSeparator(SYSMENU.SEP_4);
		MainMenu.insertString(SYSMENU.EXIT, Text("終了"), true);

		debug {
			MainMenu.insertSeparator(SYSMENU.DEBUG_SEP);
			MainMenu.insertString(SYSMENU.DEBUG_DIALOG, Text("dialog"), true);
			MainMenu.insertString(SYSMENU.CHILD_DIALOG, Text("child"), true);
			MainMenu.insertString(SYSMENU.ITEM_DIALOG, Text("items"), true);
			MainMenu.insertString(SYSMENU.LAYOUT_DIALOG, Text("layout"), true);
			
			
		}

		if(auto id=MainMenu.show(this, PopUp.TPM.RETURNCMD)) {
			assert(id != SYSMENU.WINDOW_SEP_1);
			assert(id != SYSMENU.WINDOW_SEP_2);
			/+
			assert(id != SYSMENU.FOLDER_SEP_1);
			assert(id != SYSMENU.FOLDER_SEP_2);
			assert(id != SYSMENU.FOLDER_SEP_3);
			assert(id != SYSMENU.FOLDER_SEP_4);
			+/
			assert(id != SYSMENU.SEP_1);
			assert(id != SYSMENU.SEP_2);
			assert(id != SYSMENU.SEP_3);
			assert(id != SYSMENU.SEP_4);
			/+
			if(SYSMENU.FOLDER_NEMUXI <= id && id <= SYSMENU.FOLDER_PROGRAMS) {
				// フォルダ
				switch(id) {
					case SYSMENU.FOLDER_NEMUXI:
						break;
					case SYSMENU.FOLDER_USER:
						break;
					case SYSMENU.FOLDER_MY_DOCUMENT:
						break;
					case SYSMENU.FOLDER_MY_PICTURE:
						break;
					case SYSMENU.FOLDER_MY_MUSIC:
						break;
					case SYSMENU.FOLDER_MY_VIDEO:
						break;
					case SYSMENU.FOLDER_DESKTOP:
						break;
					case SYSMENU.FOLDER_STARTMENU:
						break;
					case SYSMENU.FOLDER_STARTUP:
						break;
					case SYSMENU.FOLDER_SENDTO:
						break;
					case SYSMENU.FOLDER_FAVORITES:
						break;
					case SYSMENU.FOLDER_COMPUTER:
						break;
					case SYSMENU.FOLDER_CONTROLPANEL:
						break;
					case SYSMENU.FOLDER_NETWORK:
						break;
					case SYSMENU.FOLDER_RECENT:
						break;
					case SYSMENU.FOLDER_PRINTER:
						break;
					case SYSMENU.FOLDER_FONTS:
						break;
					case SYSMENU.FOLDER_TEMP:
						break;
					case SYSMENU.FOLDER_WINDOWS:
						break;
					case SYSMENU.FOLDER_SYSTEM:
						break;
					case SYSMENU.FOLDER_PROGRAMS:
						break;
					default:
						assert(false);
				}
			} else +/if(SYSMENU.WINDOW_LEFT <= id && id <= SYSMENU.WINDOW_SMALL) {
				// ウィンドウ
				if(id == SYSMENU.WINDOW_TOPMOST) {
					application.AppData.front(!application.AppData.front);
					this.topMost(application.AppData.front);
				} else {
					App.POSITION Position;
					switch(id) {
						case SYSMENU.WINDOW_LEFT:   Position = App.POSITION.LEFT;   break;
						case SYSMENU.WINDOW_TOP:    Position = App.POSITION.TOP;    break;
						case SYSMENU.WINDOW_RIGHT:  Position = App.POSITION.RIGHT;  break;
						case SYSMENU.WINDOW_BOTTOM: Position = App.POSITION.BOTTOM; break;
						case SYSMENU.WINDOW_FLOAT:  Position = App.POSITION.FLOAT;  break;
						case SYSMENU.WINDOW_SMALL:  Position = App.POSITION.SMALL;  break;
						default: assert(false);
					}
					SetPosition(Position, true);
					//application.AppData.position=SetPosition(window, application.AppData.position, Position);
				}
			} else if(SYSMENU.TOOLS <= id) {
				// ツール
			} else {
				// 本体メニュー
				switch(id) {
					case SYSMENU.SETTING: {
					SetPosition(application.AppData.position, true);
						auto Setting = new SettingDialog(this, application);
						if(Setting.select) {
							application=MakeApplication;
							dataLoad();
					//SetPosition(application.AppData.position, true);
						}
						break;
					}
					case SYSMENU.HELP:
						application.executePath(StaticData.help);
						break;
					case SYSMENU.ABOUT:
						//MessageDialog.show(Text("1.00β11"));
						auto ver=new NemuxiVersion(this);
						ver.show();
							break;
					case SYSMENU.EXIT:
						this.destroy();
						break;
					debug {
						case SYSMENU.DEBUG_DIALOG:
							auto a=new DebugDialog(this);
							a.messageLoop(CENTER.DESKTOP);
							break;
						case SYSMENU.CHILD_DIALOG:
							auto a=new ChildDialog(this);
							a.messageLoop(CENTER.DESKTOP);
							break;
						case SYSMENU.ITEM_DIALOG:
							auto a=new ItemDialog(this);
							a.messageLoop(CENTER.DESKTOP);
							break;
						case SYSMENU.LAYOUT_DIALOG:
							auto a=new LayoutDialog(this);
							a.messageLoop(CENTER.DESKTOP);
							break;
					}
					default:
						assert(false);
				}
			}
		}
	}
}

