﻿/**
メニュー型ランチャーのあれこれ。

次男。
*/
module nemuxi.gui.window.nemuxiwindow.menulauncher;

debug(menulauncher) import std.stdio: wl = writefln, pl = printf;
debug(menulauncher) void main() {}

import win32.windows;
import win32.commctrl;

import nemuxi.base;
import nemuxi.system.application;
import nemuxi.system.raii;
import nemuxi.image.icon;
import nemuxi.file.items.item;
import nemuxi.file.items.group;
import nemuxi.negui.window.newindow;
import nemuxi.negui.window.menu.datamenu;
import nemuxi.gui.window.nemuxiwindow.nemuxiwindow;

final class MenuLauncher {
	ExecuteMenu Executemenu;

	private BM_ITEM[] BMItems;
	COMMAND_ID SplitIndex;
	Application application;

	this(Application application)
	in {
		assert(application);
	}
	body {
		this.application = application;
	}

	void setNowState() {
		delete Executemenu;
		SplitIndex = 0;
		
		if(!application.MenuData().length) {
			return;
		}
		BMItems = application.getExeMenuItems(application.getMenuGroupName());
		
		Executemenu = new ExecuteMenu(application.AppData.exeMenuIcon());
		SplitIndex=Executemenu.makeGroupMenu(application.MenuData, application.getMenuGroupName());
		Executemenu.makeItemMenu(SplitIndex, BMItems, application.AppData.exeMenuText());
	}

	~this() {
		delete Executemenu;
	}

	void show(NeWindow Owner, ref const(POINT) Point) {
		if(!Executemenu) {
			return;
		}
		
		auto Id=Executemenu.show(
			Owner,
			PopUp.TPM.CENTERALIGN | PopUp.TPM.RETURNCMD | PopUp.TPM.NONOTIFY,
			Point,
			null
		);

		if(!Id) {
			return;
		}
		
		if(SplitIndex <= Id) {
			application.executeItem(Executemenu.data(Id));
		} else {
			application.changeMenuGroup(application.MenuData()[Id-1]);
			setNowState();
			show(Owner, Point);
		}
	}
}

final class ExecuteMenu: DataMenu!(Item), IRaii {

	override this(ICONSIZE IconSize) {
		super(IconSize);
	}
	override void Kill() {
		super.Kill();
	}

	COMMAND_ID makeGroupMenu(Sub MenuGroup, string DefaultName)
	in {
		assert(MenuGroup().length);
		assert(DefaultName.length);
	}
	out(r) {
		assert(r > 0);
	}
	body {
		MENUITEM MenuItem;
		MenuItem.sizeInit();
		MenuItem.mask = MENUITEM.MIIM.ID | MENUITEM.MIIM.STATE | MENUITEM.MIIM.TYPE | MENUITEM.MIIM.DATA;
		MenuItem.type = MENUITEM.MFT.STRING;
		
		bool OnDefault;

		COMMAND_ID Id=1;
		foreach(GroupName; MenuGroup()) {
			MenuItem.id = Id++;
			auto state = GroupName in MenuGroup ? MENUITEM.MFS.ENABLED: MENUITEM.MFS.GRAYED;
			if(!OnDefault && GroupName == DefaultName) {
				state |=  MENUITEM.MFS.DEFAULT;
				OnDefault = true;
			}
			MenuItem.state = state;
			MenuItem.typeData = Text(GroupName).ptr;
			MenuItem.itemData = null;

			this.insert(MenuItem, null, null);
		}
		return Id;
	}

	void makeItemMenu(COMMAND_ID StartID, BM_ITEM[] NoSaveBMItems, size_t TextLength)
	in {
		assert(StartID > 0);
	}
	body {
		//BMItems = NoSaveBMItems;

		MENUITEM MenuItem;
		MenuItem.sizeInit();
		MenuItem.mask = MENUITEM.MIIM.ID | MENUITEM.MIIM.STATE | MENUITEM.MIIM.TYPE| MENUITEM.MIIM.DATA;

		DRAWMENUITEM DrawMenuItem;

		auto Id=StartID;
		foreach(BMItem; NoSaveBMItems) {
			if(TextLength) {
				if(BMItem.name.length > TextLength) {
					DrawMenuItem.text = BMItem.name.text[0..TextLength] ~ "...";
				} else {
					DrawMenuItem.text = BMItem.name;
				}
			} else {
				DrawMenuItem.text = BMItem.name;
			}
			DrawMenuItem.icon = BMItem.icon;
			DrawMenuItem.key  = BMItem.key;
			
			MenuItem.type = MENUITEM.MFT.OWNERDRAW | (Id == StartID ? MENUITEM.MFT.MENUBARBREAK: cast(MENUITEM.MFT)0);
			MenuItem.id = Id++;
			MenuItem.state = BMItem.live ? MENUITEM.MFS.ENABLED: MENUITEM.MFS.DISABLED;
			MenuItem.itemData = cast(void*)MENUS.MENU;
			
			this.insert(MenuItem, &DrawMenuItem, BMItem.item);
		}
	}
}
__EOF__;//---------------------------------------------------------------------


/**
*/
void SetExeMenu(Sub MenuGroup, string NowMenuGroup, BM_ITEM[] BMItems, ICONSIZE IconSize, size_t TextLength) {
	delete menu;
	
	if(!MenuGroup().length) {
		return;
	}
	
	menu = new AppMenu(IconSize);
	auto Index=menu.makeGroupMenu(MenuGroup, NowMenuGroup);
	menu.makeItemMenu(Index, BMItems, TextLength);
}


void ExeMenuShow(HWND hWnd, POINT* Point) { // applicationから独立できなんだ…
	if(!menu) {
		return;
	}

	auto id=menu.show(
		hWnd,
		PopUp.TPM.CENTERALIGN | PopUp.TPM.RETURNCMD | PopUp.TPM.NONOTIFY | PopUp.TPM.RIGHTBUTTON,
		Point,
		null
	);

	if(!id) {
		return;
	}

	MENUITEM MenuItem;
	MenuItem.sizeInit();
	MenuItem.mask = MENUITEM.MIIM.ID | MENUITEM.MIIM.DATA;
	MenuItem.id   = id;

	if(menu.get(MenuItem)) {
		if(MenuItem.itemData) {
			// アイテム
			application.executeItem(cast(Item)MenuItem.itemData);
		} else {
			// グループ
			application.changeMenuGroup(application.MenuData()[id-1]);
			SetExeMenu(application.MenuData, application.getMenuGroupName(), application.getExeMenuItems(application.getMenuGroupName()), application.AppData.exeMenuIcon(), application.AppData.exeMenuText());
			//PostMessage(hWnd, WM_MBUTTONDOWN, MK.MBUTTON, MAKELONG(cast(ushort)Point.x, cast(ushort)Point.y));
			ExeMenuShow(hWnd, Point);
		}
	} else {
		throw new NemuxiException("ExeMenuShow:menu.get");
	}
}




