﻿/**
ボタン型ランチャの心臓
*/
module nemuxi.gui.window.nemuxiwindow.buttonlauncher;

debug(buttonlauncher) import std.stdio: wl = writefln, pl = printf;
debug(buttonlauncher) void main() {}

import std.string;
import std.file;

import win32.windows;
import win32.commctrl;

import nemuxi.base;
import nemuxi.system.application;
import nemuxi.file.file;
import nemuxi.file.find;
import nemuxi.file.exec;
import nemuxi.file.items.item;
import nemuxi.file.items.itemfunc;
import nemuxi.file.items.group;
import nemuxi.negui.window.window;
import nemuxi.negui.window.newindow;
import nemuxi.negui.window.menu.ownerdraw;
import nemuxi.negui.window.menu.datamenu;
import nemuxi.negui.control.toolbar.toolbar;
import nemuxi.negui.draw.cursor;
import nemuxi.image.icon;
import nemuxi.gui.window.nemuxiwindow.nemuxiwindow;
import nemuxi.gui.window.nemuxiwindow.toolbar;
import nemuxi.gui.window.nemuxiwindow.titlebar;
import nemuxi.gui.window.nemuxiwindow.tooltip;
import nemuxi.utility.clipboard;
import nemuxi.gui.window.dialog.execdialog.execdialog;
import nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;


/***/
final class ButtonLauncher {
	GroupMenu Groupmenu;
	
	ButtonListMenu Listmenu;
	ItemMenu       Itemmenu;
	ItemFileMenu   Filemenu;
	
	NemuxiToolBar  Toolbar;
	NemuxiToolTip  Tooltip;
	NemuxiTitleBar Titlebar;
	
	BM_ITEM[] BMItems;
	Application application;
	
	this(NemuxiToolBar Toolbar, NemuxiToolTip Tooltip, NemuxiTitleBar Titlebar, Application application)
	in {
		assert(Toolbar);
	}
	body {
		this.Toolbar = Toolbar;
		this.Tooltip = Tooltip;
		this.Titlebar = Titlebar;

		this.application = application;
	}
	~this() {
		delete Groupmenu;
		delete Listmenu;
		delete Filemenu;
		delete Itemmenu;
		delete BMItems;
	}

	void toolTipSet() {
		TOOLINFO ToolInfo;
		ToolInfo.cbSize = ToolInfo.sizeof;
		ToolInfo.hwnd   = Toolbar();
		ToolInfo.hinst  = GetModuleHandle(null);
		ToolInfo.uFlags = TTF_SUBCLASS;
		
		for(COMMAND_ID i=0; i < Toolbar.buttonCount; i++) {
			auto item=Toolbar.buttonGet(i+1);
			//Toolbar.buttonRect(i, ToolInfo.rect);
			ToolInfo.rect = Toolbar.buttonRect(i);
			
			ToolInfo.uId      = i+1;
			ToolInfo.lpszText = Text(item.itemID).ptr;
			
			Tooltip.send(TTM_DELTOOL, Tooltip.NONE, cast(LPARAM)&ToolInfo);
			Tooltip.send(TTM_ADDTOOL, Tooltip.NONE, cast(LPARAM)&ToolInfo);
		}
		Toolbar.send(TB_SETTOOLTIPS, cast(WPARAM)Tooltip(), NeGui.NONE);
	}
	/**
	applicationの設定に基づいて設定。
	*/
	void setNowState() {
		delete Listmenu;
		delete BMItems;
		
		if(application.getMainGroupName.length && application.getSubGroupName.length) {
			BMItems   = application.getExeButtonItems(application.getMainGroupName, application.getSubGroupName);
			Groupmenu = new GroupMenu(application.MainData, application.getMainGroupName, application.getSubGroupName);
		}
		
		Toolbar.buttonSet(BMItems, application.AppData.exeButtonText(), application.AppData.exeButtonIcon());
		if(BMItems.length)
		Listmenu = new ButtonListMenu(application.AppData.exeButtonIcon(), BMItems);
		Toolbar.list(application.AppData.exeButtonList());
		Toolbar.buttonWidth(application.AppData.exeButtonText(), application.AppData.exeButtonList(),application.AppData.exeButtonIcon());
		toolTipSet();
	}
	
	void groupMenuSelect(NeWindow Owner) {
		if(!Groupmenu) {
			return;
		}
		
		auto GroupIndex=Groupmenu.show(Owner);
		if(!GroupIndex[0] && !GroupIndex[1]) {
			return;
		}
		string MainGroupName, SubGroupName;
		application.getButtonGroupName(GroupIndex[0], GroupIndex[1], MainGroupName, SubGroupName);
	
		assert(MainGroupName);
		assert(SubGroupName);
		//auto hAppbar=GetDlgItem(hWnd, CTRL.APPBAR);
		//auto Appbar=new AppToolBar(GetDlgItem(hWnd, CTRL.APPBAR));
		application.changeMainGroup(MainGroupName);
		application.changeSubGroup(SubGroupName);
		/+
		auto BMItems = application.getExeButtonItems(MainGroupName, SubGroupName);
		//SetExeButtons(Appbar, BMItems, application.AppData.exeButtonText(), application.AppData.exeButtonIcon());
		Appbar.buttonSet(BMItems, application.AppData.exeButtonText(), application.AppData.exeButtonIcon());
		SetExeButtonMenu(BMItems, application.AppData.exeButtonIcon());
		SetExeButtonGroup(application.MainData, application.getMainGroupName, application.getSubGroupName);
		//SetTextPosition(hAppbar, application.AppData.exeButtonList());
		Appbar.list(application.AppData.exeButtonList());
		//SetExeButtonSize(hAppbar, application.AppData.exeButtonText(), application.AppData.exeButtonList(),application.AppData.exeButtonIcon());
		Appbar.buttonWidth(application.AppData.exeButtonText(), application.AppData.exeButtonList(),application.AppData.exeButtonIcon());
		//debug wl("WRYYYYYYYYYYY!!!!!!!!!!!!!!!");
		//GC.collect();
		//GC.minimize();
		+/
		setNowState();
	}

	Item listShow(NemuxiWindow Owner) {
		if(!Listmenu) {
			return null;
		}
		
		return Listmenu.show(Owner, Titlebar);
	}

	void itemShow(NemuxiWindow Owner, NOTIFY* Notify) {
		assert(!Itemmenu);
		assert(!Filemenu);
		
		try {
			Itemmenu = new ItemMenu(application.AppData.exeButtonIcon(), Toolbar, cast(NMTOOLBAR*)Notify, Filemenu);
			Itemmenu.show(Owner, application);
		} finally {
			Filemenu=null;
			delete Itemmenu;
		}
	}
}

///
final class GroupMenu: PopUp {
	this(Main MainGroup, string MainGroupName, string SubGroupName)
	in {
		assert(MainGroup);
		assert(MainGroupName.length);
		assert(SubGroupName.length);
	}
	body {
		super();
		
		MENUITEM MainItem;
		MainItem.sizeInit();
		
		with(MainItem) {
			mask  = MIIM.ID | MIIM.STATE | MIIM.SUBMENU | MIIM.TYPE;
			type  = MFT.STRING;
		}
		
		// メイングループ
		auto BreakLine=MainGroup().length;
		Sub ViewSubGroup;
		with(MENUITEM) foreach(i, MainName; MainGroup()) {
			assert(i < short.max-1);
			
			auto NowMain = MainName == MainGroupName;
			
			try {
				// サブグループ。これが有効でなければ例外が投げられるはず
				Sub SubGroup = new Sub(MainGroup, MainGroup[MainName]);
				if(NowMain) {
					ViewSubGroup = SubGroup;
				}
				// 先にサブグループ作成
				PopUp SubGroupMenu=null;
				
				foreach(j, SubName; SubGroup()) {
					assert(j < short.max-1);
					MENUITEM SubItem;
					SubItem.sizeInit();
					with(SubItem) {
						mask  = MIIM.ID | MIIM.STATE | MIIM.TYPE;
						type  = MFT.STRING;
					}
					
					if(!j) {
						SubGroupMenu=new PopUp();
					}
					
					auto NowSub=NowMain && (SubName == SubGroupName);
					
					SubItem.id       = cast(COMMAND_ID)(MAKELONG(cast(ushort)(i+1), cast(ushort)(j+1)));
					SubItem.state    = (SubName in SubGroup ? MFS.ENABLED: MFS.GRAYED) | (NowSub ? MFS.CHECKED: cast(MFS)0);
					//Text text = SubName;
					SubItem.text = Text(SubName);

					SubGroupMenu.insert(SubItem);
				}
				// 有効なメイングループの数値設定
				MainItem.state    = MFS.ENABLED;
				MainItem.subMenu  = SubGroupMenu;
			} catch(Exception e) {
				// 無効なメイングループの数値設定
				MainItem.state    = MFS.GRAYED;
				MainItem.subMenu  = null;
			}
			MainItem.id       = cast(COMMAND_ID)(i+1);
			MainItem.state    = MainItem.state() | (NowMain ? MFS.DEFAULT: cast(MFS)0);
			/+
			Text text=MainName;
			MainItem.typeData = text;
			+/
			MainItem.text = Text(MainName);
			
			this.insert(MainItem);
		}
		// 現在メイングループのサブグループ表示。
		with(MENUITEM) if(ViewSubGroup) {
			MainItem.subMenu  = null;
			
			foreach(i, SubName; ViewSubGroup()) {
				assert(i < short.max-1);
				
				MainItem.id       = cast(COMMAND_ID)(MAKELONG(cast(ushort)0, cast(ushort)(i+1)));
				MFT Type = MFT.STRING;
				if(!i) {
					Type |= MFT.MENUBARBREAK;
				}
				MFS State = (ViewSubGroup.length ? MFS.ENABLED: MFS.GRAYED);
				if(SubName == SubGroupName) {
					State |= MFS.CHECKED;
				}
				
				MainItem.type  = Type;
				MainItem.state = State | (SubName in ViewSubGroup ? MFS.ENABLED: MFS.GRAYED);
				MainItem.text = Text(SubName);
				this.insert(MainItem);
			}
		}
	}

	///
	ushort[] show(NeWindow Owner) {
		/+
		POINT Point=void;
		Cursor.getPos(Point);
		+/
		auto Point=Cursor.getPos();

		auto id=super.show(
			Owner,
			PopUp.TPM.CENTERALIGN | PopUp.TPM.RETURNCMD | PopUp.TPM.NONOTIFY | PopUp.TPM.RIGHTBUTTON,
			Point,
			null
		);
		
		return [LOWORD(id), HIWORD(id)];
	}
}

final class ButtonListMenu: DataMenu!(Item) {
	
	this(ICONSIZE IconSize, BM_ITEM[] BMItems)
	in {
		assert(BMItems.length);
	}
	body {
		super(IconSize);

		MENUITEM MenuItem;
		DRAWMENUITEM DrawMenuItem;

		MenuItem.sizeInit();
		MenuItem.mask = MENUITEM.MIIM.ID | MENUITEM.MIIM.STATE | MENUITEM.MIIM.TYPE | MENUITEM.MIIM.DATA;
		MenuItem.type = MENUITEM.MFT.OWNERDRAW;
		foreach(i, BMItem; BMItems) {
			DrawMenuItem.text = BMItem.name;
			DrawMenuItem.icon = BMItem.icon;
			DrawMenuItem.key  = BMItem.key;
			
			MenuItem.id    = cast(COMMAND_ID)(i+1);
			MenuItem.state = BMItem.live ? MENUITEM.MFS.DEFAULT: MENUITEM.MFS.DISABLED;
			MenuItem.itemData = cast(void*)MENUS.BUTTON;
			
			this.insert(MenuItem, &DrawMenuItem, BMItem.item);
		}
	}

	///
	Item show(NemuxiWindow Owner, Control NoHideObject) {
		RECT Rect;
		POINT Point;
		if(NoHideObject && NoHideObject.alive) {
			/+
			Rect = new RECT;
			//RECT TempRect;
			NoHideObject.itemRect(*Rect);
			+/
			Rect = NoHideObject.itemRect();

			//Rect[0..RECT.sizeof] = TempRect;

			Point.x = Rect.right + 1;
			Point.y = Rect.top;
		} else {
			//Cursor.getPos(Point);
			Point = Cursor.getPos();
		}

		auto Id=super.show(Owner, PopUp.TPM.RETURNCMD | PopUp.TPM.LEFTBUTTON, Point, &Rect);

		if(Id) {
			return data(Id);
		} else {
			return null;
		}
	}
}

/// 妥協に妥協。
final class ItemFileMenu: DataMenu!(Text*) {
	//private Text[] Addresses; /// アドレス。
	private Text BaseFolder;
	private size_t StartID;
	private bool OnRead; // むりやり。再読み込み回避。

	/**
	History:
		1.00β11:
			基点フォルダの有効・無効をによる契約の追加。
	*/
	override this(ICONSIZE IconSize, Text BaseFolder)
	in {
		assert(BaseFolder.length);
	}
	body {
		super(IconSize);
		this.BaseFolder = BaseFolder;
		OnRead = false;
	}

	/**
	並び替え情報要素。
	構造体は無理？
	＠いけることが判明。
	*/
	class FileSort {
		Text Address;
		bool Folder;
		Text FileName;
		Text Extension;

		enum POS {
			OWNER,
			FOLDER,
			INITEM
		}
		POS Pos;

		DRAWMENUITEM DrawMenuItem;

		override bool opEquals(Object obj) {
			auto FileInfo = cast(FileSort)obj;
			
			return
				Pos       == FileInfo.Pos
				&& Folder    == FileInfo.Folder
				&& Extension == FileInfo.Extension
				&& FileName  == FileInfo.FileName
			;
		}
		
		/**
		基準が分からん。

		History:
			1.00β11:
				-debug無し時にAccess Violation、_memsetなるエラー。
				正直知らんがなってエラー修正。
		*/
		override int opCmp(Object obj) {
			auto FileInfo = cast(FileSort)obj;
			
			if(Folder && FileInfo.Folder) {
				assert(!(Pos == POS.OWNER && FileInfo.Pos == POS.OWNER), "only POS.OWNER");

				if(Pos == POS.OWNER) {
					return -1;
				}
				if(FileInfo.Pos == POS.OWNER) {
					return 1;
				}
				
				assert(!(Pos == POS.FOLDER && FileInfo.Pos == POS.FOLDER), "only POS.FOLDER");
				if(Pos == POS.FOLDER) {
					return -1;
				}
				if(FileInfo.Pos == POS.FOLDER) {
					return 1;
				}
				assert(Pos == POS.INITEM && FileInfo.Pos == POS.INITEM);
				//return ~icmp(FileName.toString(), FileInfo.FileName.toString())*-1;
				return PATH.cmp(FileName, FileInfo.FileName);
			}
			if(Folder && !FileInfo.Folder) {
				return -1;
			}
			if(!Folder && FileInfo.Folder) {
				return 1;
			}
			assert(!Folder && !FileInfo.Folder);
			/+
			if(auto ExtCmp=icmp(Extension.toString(), FileInfo.Extension.toString())) {
				return ExtCmp;
			} else {
				return icmp(FileName.toString(), FileInfo.FileName.toString());
			}
			+/
			if(auto ExtCmp=PATH.cmp(Extension, FileInfo.Extension)) {
				return ExtCmp;
			} else {
				return PATH.cmp(FileName, FileInfo.FileName);
			}
		}
	}


	/**
	フォルダから読み込み。

	親フォルダ・サブフォルダに関しては親ウィンドウにメッセージが来た時点で読み込む。
	※ただしメニュー自体は作成しておく。

	History:
		1.00β11:
			-debug無し時に特定環境内でillegal UTF-16 valueが発生していたバグを修正。
			FileSort.opCmpに通じるものがあるはず。
			insertSeparatorのID問題を暫定対処。
	*/
	bool readFolder(COMMAND_ID StartID)
	in {
		assert(FILE.isFolder(BaseFolder));
		assert(StartID);
	}
	body {
		scope(success) OnRead = true;
		if(OnRead) return true;

		this.StartID = StartID;
		
		MENUITEM MenuItem;
		MenuItem.sizeInit();
		with(MenuItem) {
			mask  = MIIM.ID | MIIM.STATE | MIIM.TYPE | MIIM.DATA;
			type  = MFT.OWNERDRAW;
			state = MFS.ENABLED;
		}

		invariant COUNT_UNIT = 16;
		size_t i;
		auto FileInfos=new FileSort[COUNT_UNIT];
		FILEITEM FileItem;
		scope finder=new Finder(BaseFolder ~ "*");
		while(finder.find(FileItem)) {
			if(i == FileInfos.length) {
				FileInfos.length = i + COUNT_UNIT;
			}
			auto FileInfo=new FileSort;
			FileInfo.Folder = FileItem.isFolder();
			
			if(FileItem.fileName == ".") {
				FileInfo.Address       = BaseFolder;
				FileInfo.DrawMenuItem.text = "このフォルダ";
				FileInfo.Pos           = FileSort.POS.FOLDER;
				assert(FileInfo.Folder);
			} else if(FileItem.fileName == "..") {
				//FileInfo.Address       = FolderName(BaseFolder[0..BaseFolder.length-1]);
				FileInfo.Address       = PATH.getOwnerFolder(BaseFolder);
				FileInfo.DrawMenuItem.text = "親フォルダ";
				FileInfo.Pos           = FileSort.POS.OWNER;
				assert(FileInfo.Folder);
			} else {
				FileInfo.Address           = BaseFolder ~ FileItem.fileName;
				FileInfo.DrawMenuItem.text = FileItem.fileName.dup;
				if(FileInfo.Folder) {
					FileInfo.FileName      = FileInfo.DrawMenuItem.text;
				} else {
					FileInfo.FileName      = PATH.getName(FileItem.fileName);//.dup;
					FileInfo.Extension     = PATH.getExtension(FileItem.fileName);//.dup;
				}
				FileInfo.Pos = FileSort.POS.INITEM;
			}
			//OutputDebugString(format("%s(%s) %s", FileInfo.Address.toString, __LINE__, __FILE__).toText.ptr);
			
			FileInfo.DrawMenuItem.icon = GetFileIcon(FileInfo.Address, 0, super.IconSize);
			
			if(!FileInfo.DrawMenuItem.icon || !FileInfo.DrawMenuItem.icon()) {
				FileInfo.DrawMenuItem.icon = GetSystemIcon(SYSICON.APPLICATION, super.IconSize);
			}

			//OutputDebugString(format("%s(%s) %s", FileInfo.Address.toString, __LINE__, __FILE__).toText.ptr);
			
			FileInfo.DrawMenuItem.key = 'a';
			
			FileInfos[i++] = FileInfo;
		}
		FileInfos.length = finder.count();
		//OutputDebugString(format("%s(%s)",  __LINE__, __FILE__).toText.ptr);
		FileInfos=FileInfos.sort;
		//OutputDebugString(format("%s(%s)",  __LINE__, __FILE__).toText.ptr);

		bool PervFolder=true;
		bool FolderSeparator=true;
		//size_t Padding = 0;
		for(i=0; i < FileInfos.length/++Padding+/; i++) {
			scope(exit) PervFolder = FileInfo.Folder;
			
			auto FileInfo=&FileInfos[i/+ - Padding+/];
			MenuItem.id       = cast(COMMAND_ID)i + StartID;
			MenuItem.itemData = cast(void*)MENUS.FILE;//cast(void*)i;
			//Addresses ~= FileInfo.Address;
			if(PervFolder && !FileInfo.Folder) {
				// フォルダとファイルの間。
				//super.insertSeparator(cast(COMMAND_ID)(++i) + StartID);
				//Padding++;
				super.insertSeparator();
				PervFolder = false;
				FolderSeparator = false;
			}
			super.insert(MenuItem, &FileInfo.DrawMenuItem, &FileInfo.Address);
			if(FolderSeparator && FileInfos[i].Pos == FileSort.POS.FOLDER && (i < FileInfos.length+1 && FileInfos[i+1].Folder)) {
				// フォルダとフォルダ内の間
				//super.insertSeparator(cast(COMMAND_ID)(++i) + StartID);
				//Padding++;
				super.insertSeparator();
			}
		}
		
		return finder.count ? true: false;
	}
}



final class ItemMenu: PopUp {
	///
	static enum ITEMID: COMMAND_ID {
		EXEC_NORMAL = 1, /// 通常起動
		EXEC_WINDOW, /// 指定して実行
		EXEC_SEP,
		ADDR_ADDR, /// アドレス
		ADDR_ADDR_OPEN_OWNERFOLDER, /// 親フォルダ表示
		ADDR_ADDR_OPEN_WORKFOLDER, /// 作業フォルダ表示
		ADDR_ADDR_OPEN_SEP,
		ADDR_ADDR_COPY_ADDRESS, /// アドレスコピー
		ADDR_ADDR_COPY_OWNERFOLDER, /// 親フォルダコピー
		ADDR_ADDR_COPY_WORKFOLDER, /// 作業フォルダコピー
		ADDR_ADDR_COPY_OPTION, /// 引数コピー
		ADDR_ADDR_COPY_SEP,
		ADDR_ADDR_PROPERTY, /// プロパティ
		ADDR_FILE, /// ファイル
	}

	NemuxiToolBar Toolbar;
	COMMAND_ID Id;
	Item item;
	ItemFileMenu Filemenu;
	
	this(ICONSIZE IconSize, NemuxiToolBar Toolbar, NMTOOLBAR* NMToolbar, ref ItemFileMenu Filemenu)
	in {
		assert(NMToolbar);
	}
	body {
		super();

		this.Toolbar = Toolbar;
		Id = cast(COMMAND_ID)NMToolbar.iItem;
		assert(Id > 0);
		
		/+
		TOOLBUTTON ToolButton;
		
		Toolbar.buttonGet(Id-1, ToolButton.TbButton);
		item=cast(Item)cast(void*)ToolButton.data;
		+/
		item=cast(Item)Toolbar.buttonGet(Id);
		
		Text BaseFolder=void;
		if(auto Folder=GetFolder(item)) {
			BaseFolder = Folder;
		} else {
			BaseFolder = Text.emptyText();
		}

		bool NormalAddr =  item.type == Item.TYPE.NORMAL ? cast(bool)exists(item.address): false;
		bool WorkAddr   =  item.workFolder.length ? cast(bool)exists(item.workFolder) ? cast(bool)isdir(item.workFolder): false: false;
		if(NormalAddr && WorkAddr) {
			WorkAddr = PATH.getOwnerFolder(Text(item.address)) != PATH.addFolderSep(Text(item.workFolder));
		}
		bool Exec = true;
		if(NormalAddr) {
			// アイテムがフォルダの場合に死んじゃう。
			// 原因不明（ExecWindowのOKボタンで死んでるっぽい）
			Exec=exists(item.address) && isfile(item.address);
		}
		this.insertString(ITEMID.EXEC_NORMAL, Text("通常実行"));
		this.insertString(ITEMID.EXEC_WINDOW, Text("指定して実行"), Exec);
		this.insertSeparator(ITEMID.EXEC_SEP);


		auto addr=new PopUp();
		with(addr) {
			/*addr.*/insertString(ITEMID.ADDR_ADDR_OPEN_OWNERFOLDER, Text("親フォルダを開く"), NormalAddr);
			/*addr.*/insertString(ITEMID.ADDR_ADDR_OPEN_WORKFOLDER,  Text("作業フォルダを開く"), WorkAddr);
			/*addr.*/insertSeparator(ITEMID.ADDR_ADDR_OPEN_SEP);
			/*addr.*/insertString(ITEMID.ADDR_ADDR_COPY_ADDRESS,     Text("アドレスをコピー"), NormalAddr);
			/*addr.*/insertString(ITEMID.ADDR_ADDR_COPY_OWNERFOLDER, Text("親フォルダをコピー"), NormalAddr);
			/*addr.*/insertString(ITEMID.ADDR_ADDR_COPY_WORKFOLDER,  Text("作業フォルダをコピー"), WorkAddr);
			/*addr.*/insertString(ITEMID.ADDR_ADDR_COPY_OPTION,      Text("オプションをコピー"), item.option.length > 0);
			/*addr.*/insertSeparator(ITEMID.ADDR_ADDR_COPY_SEP);
			/*addr.*/insertString(ITEMID.ADDR_ADDR_PROPERTY, Text("プロパティ"), NormalAddr);
		}
		this.insertSubMenu(ITEMID.ADDR_ADDR, Text("アドレス"), addr, NormalAddr || WorkAddr);

		immutable FileMenu=BaseFolder.length && FILE.isExistence(BaseFolder) && FILE.isFolder(BaseFolder);
		if(FileMenu) {
			Filemenu = this.Filemenu=new ItemFileMenu(IconSize, BaseFolder);
		}
		this.insertSubMenu(ITEMID.ADDR_FILE, Text("ファイル"), Filemenu, FileMenu && BaseFolder.length > 0);
	}

	/**
	Bugs:
		アイコンサイズ、文字列表示に関するメニュー位置が不完全。
	*/
	void show(NemuxiWindow Owner, Application application) {
		//RECT Rect;
		SIZE Size;
		//Toolbar.buttonRect(Id, Rect);
		auto Rect = Toolbar.buttonRect(Id);
		Size.cx = Rect.right  - Rect.left;
		Size.cy = Rect.bottom - Rect.top;
		MapWindowPoints(Toolbar(), GetDesktopWindow(), cast(POINT*)&Rect, Rect.sizeof / POINT.sizeof);

		// Bug.1
		PopUp.TPM Tpm;
		POINT Point;
		with(PopUp.TPM) switch(application.AppData.position()) {
			case application.AppData.POSITION.LEFT:
				Point.x = Rect.right;
				Point.y = Rect.top;
				Tpm = LEFTALIGN | TOPALIGN;
				break;
			case application.AppData.POSITION.TOP:
				Point.x = Rect.left + Size.cx / 2;
				Point.y = Rect.bottom;
				Tpm = CENTERALIGN | TOPALIGN;
				break;
			case application.AppData.POSITION.RIGHT:
				Point.x = Rect.left;
				Point.y = Rect.top;
				Tpm = RIGHTALIGN | TOPALIGN;
				break;
			case application.AppData.POSITION.BOTTOM:
				Point.x = Rect.left + Size.cx / 2;
				Point.y = Rect.top;
				Tpm = CENTERALIGN | BOTTOMALIGN;
				break;
			case application.AppData.POSITION.FLOAT:
				Point.x = Rect.left;
				Point.y = Rect.bottom;
				Tpm = LEFTALIGN | TOPALIGN;
				break;
			default:
				assert(false);
		}
		auto id=super.show(Owner, Tpm | PopUp.TPM.RETURNCMD | PopUp.TPM.LEFTBUTTON, Point, &Rect);
		if(!id) {
			return;
		}
		
		try {
			auto Clip=new TextClipBoard(Owner);

			with(ITEMID) switch(id) {
				case EXEC_NORMAL:
					application.executeItem(item);
					break;
				case EXEC_WINDOW:
				//delete Clip;
					auto exec=new ExecDialog(Owner, item, application);
					exec.select;
					break;
				case ADDR_ADDR_OPEN_OWNERFOLDER:
					application.executePath(Text(GetFolder(item, application.itemBase())));
					break;
				case ADDR_ADDR_OPEN_WORKFOLDER:
					application.executePath(Text(GetWorkFolder(item, application.itemBase())));
					break;
				case ADDR_ADDR_COPY_ADDRESS:
					Clip.set(Text(item.address));
					break;
				case ADDR_ADDR_COPY_OWNERFOLDER:
					Clip.set(Text(GetFolder(item, application.itemBase())));
					break;
				case ADDR_ADDR_COPY_WORKFOLDER:
					Clip.set(Text(GetWorkFolder(item, application.itemBase())));
					break;
				case ADDR_ADDR_COPY_OPTION:
					assert(item.option.length);
					Clip.set(Text(item.option));
					break;
				case ADDR_ADDR_PROPERTY:
					PropertyExecute(Text(item.address), Owner);
					break;
				case ADDR_ADDR, ADDR_FILE, EXEC_SEP, ADDR_ADDR_OPEN_SEP, ADDR_ADDR_COPY_SEP:
					assert(false);
				default: // 選択ファイル実行。
					application.executePath(*Filemenu.data(id));
			}
		} catch(Exception e) {
			Logger.write(e);
			scope exd=new ExceptionDialog(Owner, e);
			exd.select;
		}
	}
}

