﻿/**
*/
module nemuxi.gui.window.dialog.settingdialog.settingdialog;

debug import std.stdio: wl = writefln, pl = printf;
debug(settingdialog) void main() {}

import std.contracts;

import win32.windows;
import win32.commctrl;

import nemuxi.base;
import nemuxi.system.application;
import nemuxi.file.file;
import nemuxi.file.data;
import nemuxi.file.items.item;
import nemuxi.image.font;
import nemuxi.negui.negui;
import nemuxi.negui.window.newindow;
import nemuxi.negui.window.dialog.dialog;
import nemuxi.negui.window.dialog.system;
import nemuxi.negui.control.control;
import nemuxi.negui.control.group;
import nemuxi.negui.control.toolbar.toolbar;
import nemuxi.negui.control.label.label;
//import nemuxi.negui.proc.settingwnd.settingwnd;
import nemuxi.gui.window.dialog.selectdialog;

import nemuxi.gui.window.dialog.inputdialog.inputdialog;
import nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;

import nemuxi.gui.window.dialog.settingdialog.settingif;
import nemuxi.gui.window.dialog.settingdialog.nemuxidialog;
import nemuxi.gui.window.dialog.settingdialog.itemdialog.itemdialog;
import nemuxi.gui.window.dialog.settingdialog.groupdialog;

/**
History:
	[V]:
		凄くしょうもない事情によりokとcancelの位置変更。
*/
final class SettingDialog: SelectDialog {
	private {
		enum CTRL: ITEM_ID {
			MENULIST=1, /// 
		}
		enum COMMAND: COMMAND_ID {
			NEMUXI = 1,
			ITEM,
			GROUP,
			COMMAND,
			OTHER,

			SEP,
			OK,
			CANCEL,
		}
		NemuxiDialog NemuxiDlg;
		ItemDialog   ItemDlg;
		GroupDialog  GroupDlg;

		struct DialogGroup {
			ISettingInFrame[] list;
			ISettingInFrame now;
		}
		DialogGroup Dialogs;
	}
	package {
		Application application;
		
		ToolBar Menulist;
		Font Menufont;

	}
	
	this(NeWindow Owner, Application application)
	in {
		assert(application);
	}
	body {
		this.application = application;
		
		GUIINFO NeGuiInfo;
		//NeGuiInfo.Style        = WS_DLGFRAME | WS_CAPTION | WS_SIZEBOX | WS_SYSMENU;
		//NeGuiInfo.ExStyle      = WS_EX_DLGMODALFRAME | WS_EX_TOOLWINDOW;
		NeGuiInfo.Owner = Owner;
		super(&NeGuiInfo);
		this.Center = CENTER.DESKTOP;
	}
	
	private COMMAND GetSelectedCommand() {
		TOOLBUTTON ToolButton;
		ToolButton.initialize();
		
		invariant LIMIT=Menulist.buttonCount;
		for(auto i=0; i < COMMAND.SEP; i++) {
			Menulist.buttonGet(i, ToolButton);
			if((ToolButton.state & TOOLBUTTON.STATE.CHECKED) == TOOLBUTTON.STATE.CHECKED) {
				return cast(COMMAND)ToolButton.command;
			}
		}
		assert(false);
	}
	private void InFrameShow(COMMAND Command)
	in {
		assert(COMMAND.NEMUXI <= Command && Command <= COMMAND.OTHER);
	}
	body {
		foreach(dialog; Dialogs.list) {
			dialog.hide();
		}
		
		with(COMMAND) switch(Command) {
			case NEMUXI:  Dialogs.now = NemuxiDlg; break;
			case ITEM:    Dialogs.now = ItemDlg;   break;
			case GROUP:   Dialogs.now = GroupDlg;  break;
			case COMMAND: 
			case OTHER:   
			default:
				assert(false);
		}
		if(Dialogs.now !is ItemDlg)
		Dialogs.now.setItemList=ItemDlg.getItemList;;

		Dialogs.now.show();
		FrameReSize(Dialogs.now);
	}
	private void FrameReSize(ISettingInFrame dialog) {
		/+
		SIZE OwnerSize;
		clientSize(OwnerSize);
		+/
		auto OwnerSize=clientSize();
		/+
		SIZE MenuSize;
		Menulist.clientSize(MenuSize);
		+/
		auto MenuSize=Menulist.clientSize();
		
		dialog.reSize(0, MenuSize.cy, OwnerSize.cx, OwnerSize.cy - MenuSize.cy);
	}

	protected override {
		void OnDestroy() {
			delete Menufont;

			/+
			foreach(ref dlg; Dialogs.list) {
				if(dlg) {
//					dlg.destroy();
					delete dlg;
				}
			}
			delete Dialogs.list;
			+/
			super.OnDestroy();

			// 設定部分実装後に取り除く。
			Owner.setShow = SHOW.SHOWNORMAL;
		}
		void OnCreate() {
			super.OnCreate();
			
			Owner.setShow = SHOW.HIDE;
			
			caption = true;
			haveSystemMenu = true;
			taskBar = true;
			maxButton = true;
			minButton = true;
			frameSize = true;
			
			Menulist = new ToolBar(this, CTRL.MENULIST);
			
			auto texts = Texts(
				"nemuxi",
				"item",
				"group",
				//"command",
				//"others",
				"",
				"ok",
				"cancel"
			);
			auto commands = [
				COMMAND.NEMUXI,
				COMMAND.ITEM,
				COMMAND.GROUP,
				//COMMAND.COMMAND,
				//COMMAND.OTHER,
				COMMAND.SEP,
				COMMAND.OK,
				COMMAND.CANCEL
			];

			assert(texts.length == commands.length);

			auto ToolButtons = new TOOLBUTTON[texts.length];
			
			foreach(i, ref ToolButton; ToolButtons) {
				ToolButton.initialize();
				ToolButton.nonImage;
				ToolButton.command = commands[i];
				ToolButton.state   = TOOLBUTTON.STATE.ENABLED;
				// 初期値
				if(commands[i] == COMMAND.NEMUXI) {
					ToolButton.state = ToolButton.state | TOOLBUTTON.STATE.CHECKED;
				}
				
				if(commands[i] == COMMAND.SEP) {
					ToolButton.style   = TOOLBUTTON.STYLE.SEP;
				} else if(commands[i] < COMMAND.SEP) {
					ToolButton.style   = TOOLBUTTON.STYLE.CHECKGROUP | TOOLBUTTON.STYLE.AUTOSIZE | TOOLBUTTON.STYLE.SHOWTEXT;
				} else {
					ToolButton.style   = TOOLBUTTON.STYLE.AUTOSIZE | TOOLBUTTON.STYLE.SHOWTEXT;
				}
				ToolButton.data    = null;
				ToolButton.text    = texts[i];
			}
			
			Menulist.initialize;
			//Menulist.flat = true;
			Menulist.autoSize;
			Menulist.buttonSet(ToolButtons);
			//Menulist.border = true;
			Menulist.list = true;
			Menulist.font = Menufont = GetSystemFont(SYSFONT.MENU);

			//
			Item[] items;
			if(application.itemBase.length) foreach(item; application.itemBase.keys) {
				items~=new Item(item, application.itemBase());
			}

			//
			NemuxiDlg = new NemuxiDialog(this, application.AppData, items);

			//
			ItemDlg = new ItemDialog(this, application.itemBase.dup(true), items);

			//
			GroupDlg = new GroupDialog(this, application.groupBase.dup(true), items);
			
			Dialogs.list = [
				cast(ISettingInFrame)
				NemuxiDlg,
				ItemDlg,
				GroupDlg
			];
			foreach(dialog; Dialogs.list) {
				dialog.toChild();
			}

			InFrameShow(GetSelectedCommand());
			
			this.adjustSize(412, 412);
			reLoad;
		}
		void OnSize(SIZE_TYPE SizeType, int Width, int Height) {
			Menulist.size(Width, Height);
			FrameReSize(Dialogs.now);
		}
		
		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			if(Id < COMMAND.SEP) {
				InFrameShow(GetSelectedCommand());
				return true;
			} else if(Id == COMMAND.OK) {
				Text[] path=[
					PATH.addFolderSep(StaticData.dataFolder) ~ StaticData.applicationDataFile,
					PATH.addFolderSep(StaticData.dataFolder) ~ StaticData.itemDataFile,
					PATH.addFolderSep(StaticData.dataFolder) ~ StaticData.groupDataFile
				];

				FILE.makeFolder(StaticData.dataFolder);
				
				for(auto i=0; i < path.length; i++) {
					if(auto aki=Dialogs.list[i].akiDocument) {
						WriteAkiDocument(path[i], aki);
					}
				}
				SelectFlag = true;
			} else if(Id == COMMAND.CANCEL) {
				SelectFlag = false;
			}
			destroy();
				return true;
		}
		bool OnAccelerator(COMMAND_ID Id) {
			//debug wl("%s",cast(int)Id);
			return false;
		}
	}
}

