﻿/**
*/
module nemuxi.gui.window.dialog.settingdialog.nemuxidialog;

debug import std.stdio: wl = writefln, pl = printf;
debug(nemuxidialog) void main() {}

import std.contracts;
import std.string;

import win32.windows;
import win32.commctrl;

import etc.kareki.kareki;

import nemuxi.base;
import nemuxi.image.icon;
import nemuxi.image.font;
import nemuxi.negui.draw.unit;
import nemuxi.file.exec;
import nemuxi.file.app;
import nemuxi.file.file;
import nemuxi.file.items.item;
import nemuxi.negui.negui;
import nemuxi.negui.window.newindow;
import nemuxi.negui.window.dialog.dialog;
import nemuxi.negui.window.dialog.system;
import nemuxi.negui.control.control;
import nemuxi.negui.control.group;
import nemuxi.negui.control.editbox.editbox;
import nemuxi.negui.control.label.label;
import nemuxi.negui.control.button.button;
import nemuxi.negui.control.button.group;
import nemuxi.negui.control.updown.updown;
import nemuxi.negui.control.hotkey.hotkey;
import nemuxi.gui.window.dialog.selectdialog;
//import nemuxi.gui.control.button;
import nemuxi.gui.control.combobox;
import nemuxi.gui.control.listview;
import nemuxi.gui.window.dialog.inputdialog.inputdialog;
import nemuxi.negui.layout.panel.tansu;
import nemuxi.negui.layout.panel.line;
import nemuxi.negui.layout.panel.dual;
import nemuxi.gui.window.dialog.settingdialog.settingif;


class NemuxiDialog: ModalDialog, ISettingInFrame {
	private enum CTRL: ITEM_ID {
		WINDOW = 1,
		WINDOW_POS,
		WINDOW_FRONT,
		WINDOW_,

		BUTTON,
		BUTTON_ICON_SMALL,
		BUTTON_ICON_NORMAL,
		BUTTON_TEXT,
		BUTTON_TEXT_LIST,
		BUTTON_,
		
		MENU,
		MENU_ICON_SMALL,
		MENU_ICON_NORMAL,
		MENU_TEXT_INFO,
		MENU_TEXT_INPUT,
		MENU_TEXT_UPDOWN,
		MENU_DESKTOP,
		MENU_,

		COMMAND,
		COMMAND_CALL,
		COMMAND_FONT,
		COMMAND_TIMER_INFO,
		COMMAND_TIMER_INPUT,
		COMMAND_TIMER_UPDOWN,
		COMMAND_ICON_SMALL,
		COMMAND_ICON_NORMAL,
		COMMAND_COLOR,
		COMMAND_,

		FOLDER,
		FOLDER_NORAML,
		FOLDER_EXPLORER,
		FOLDER_ITEM,
		FOLDER_SELECT,
		FOLDER_,
	}
	private {
		App AppData;
		Item[] items;
		
		Font CtrlFont;

		GroupBox WindowGroup;
		WindowPosComboBox WindowPosSelect;
		CheckBox FrontSelect;

		GroupBox BuutonGroup;
		Radio ButtonIconSmall;
		Radio ButtonIconNormal;
		CheckBox ButtonTextSelect;
		CheckBox ButtonTextList;

		GroupBox MenuGroup;
		Radio MenuIconSmall;
		Radio MenuIconNormal;
		TextLabel MenuTextInfo;
		EditBox MenuTextInput;
		UpDown MenuTextSpin;
		CheckBox MenuDesktop;

		GroupBox CommandGroup;
		HotKey CommandCallInput;
		Font CommandFont;
		Push CommandFontSelect;
		TextLabel CommandHiddenInfo;
		EditBox CommandHiddenInput;
		UpDown CommandHiddenSpin;
		Radio CommandIconSmall;
		Radio CommandIconNormal;
		ColorList CommandColor;

		GroupBox FolderGroup;
		Radio FolderOpenNormal;
		Radio FolderOpenExplorer;
		Radio FolderOpenItem;
		ItemComboBox FolderOpenSelect;
	}
	this(NeWindow Owner, App AppData, Item[] items)
	in {
		assert(AppData);
	}
	body {
		this.AppData = AppData;
		this.items   = items;
		
		GUIINFO NeGuiInfo;
		NeGuiInfo.Owner  = Owner;
		NeGuiInfo.Window = true;
		
		super(&NeGuiInfo);
	}

	private void CommandFontSetting() {
		// 未実装
		scope dialog=new FontDialog();
		dialog.ownerWindow = this;
		dialog.font  = CommandFont;
		dialog.point = CommandFont.height;
		dialog.flags = FontDialog.FLAGS.SCREENFONTS | FontDialog.FLAGS.NOSCRIPTSEL | FontDialog.FLAGS.INITTOLOGFONTSTRUCT;

		if(dialog.select()) {
			CommandFont.kill();
			CommandFont = dialog.font;

			CommandFontSelect.text = CommandFont.faceName;
			CommandFontSelect.font = CommandFont;
		} else if(dialog.errCode) {
			throw new NemuxiException(format("[FontDialog] ErrCode = %s", dialog.errCode));
		}
	}

	private void IconRadio(Radio Small, Radio Normal, ICONSIZE IconSize) {
	}

	override void setItemList(Item[] items) {
		this.items = items;
		auto Enable=FolderOpenItem.checked;
		FolderOpenSelect.setItemList = items;
		FolderOpenSelect.enable = Enable;
	}
	override Item[] getItemList() {
		return items;
	}
	mixin MixInSettingInFrame;
	override AkiDocument akiDocument() {
		auto aki=new AkiDocument;
		aki[App.TREE.WINDOW]  = WindowPosSelect.select;
		aki[App.TREE.WINDOW, App.TREE.WINDOW_FRONT]  = FrontSelect.checked;
		aki[App.TREE.WINDOW, App.TREE.WINDOW_LEFT]   = AppData.barSize(App.POSITION.LEFT);
		aki[App.TREE.WINDOW, App.TREE.WINDOW_RIGHT]  = AppData.barSize(App.POSITION.RIGHT);
		aki[App.TREE.WINDOW, App.TREE.WINDOW_TOP]    = AppData.barSize(App.POSITION.TOP);
		aki[App.TREE.WINDOW, App.TREE.WINDOW_BOTTOM] = AppData.barSize(App.POSITION.BOTTOM);
		aki[App.TREE.WINDOW, App.TREE.WINDOW_FLOAT, App.TREE.WINDOW_FLOAT_POS]  = [AppData.floatPos.x, AppData.floatPos.y];
		aki[App.TREE.WINDOW, App.TREE.WINDOW_FLOAT, App.TREE.WINDOW_FLOAT_SIZE] = [AppData.floatSize.cx, AppData.floatSize.cy];

		{
			//フォルダ
			auto group=new RadioGroup(FolderOpenNormal, FolderOpenExplorer, FolderOpenItem);
			aki[App.TREE.FOLDER]  = group.checkIndex;
			if(group.checked is FolderOpenItem) {
				aki[App.TREE.FOLDER, App.TREE.FOLDER_PROGRAM]  = FolderOpenSelect.selectID.toString;
			} else if([App.TREE.FOLDER, App.TREE.FOLDER_PROGRAM] in aki) {
				aki[App.TREE.FOLDER, App.TREE.FOLDER_PROGRAM].fileKill;
			}
		}
		{
			//ボタン
			auto group=new RadioGroup(ButtonIconSmall, ButtonIconNormal);
			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_BUTTON, App.TREE.LAUNCHER_BUTTON_ICON] = group.checkIndex;
			
			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_BUTTON, App.TREE.LAUNCHER_BUTTON_TEXT] = ButtonTextSelect.checked;
			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_BUTTON, App.TREE.LAUNCHER_BUTTON_LIST] = ButtonTextList.checked;
		}
		{
			//メニュー
			auto group=new RadioGroup(MenuIconSmall, MenuIconNormal);
			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_MENU, App.TREE.LAUNCHER_MENU_ICON] = group.checkIndex;

			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_MENU, App.TREE.LAUNCHER_MENU_TEXT] = MenuTextSpin.value;
			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_MENU, App.TREE.LAUNCHER_MENU_DESKTOP] = MenuDesktop.checked;
		}
		{
			//コマンド
			auto group=new RadioGroup(CommandIconSmall, CommandIconNormal);
			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_COMMAND, App.TREE.LAUNCHER_COMMAND_ICON] = group.checkIndex;

			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_COMMAND, App.TREE.LAUNCHER_COMMAND_FONT, App.TREE.LAUNCHER_COMMAND_FONT_NAME] = CommandFont.faceName.toString;
			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_COMMAND, App.TREE.LAUNCHER_COMMAND_FONT, App.TREE.LAUNCHER_COMMAND_FONT_SIZE] = CommandFont.height;

			auto value=CommandCallInput.value;
			Integer[2] keys;
			if(value.Mod) {
				keys[0] = value.hotkeyToMod;
			}
			if(KEY.A <= value.Key && value.Key <= KEY.Z) {
				keys[1] = value.Key;
			}
			
			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_COMMAND, App.TREE.LAUNCHER_COMMAND_KEYS] = keys;

			aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_COMMAND, App.TREE.LAUNCHER_COMMAND_TIMER] = CommandHiddenSpin.value;

			// ひどすぎる
			{
				auto CommandTrees=[
					//App.TREE.LAUNCHER_COMMAND_COLOR_NORMAL,
					App.TREE.LAUNCHER_COMMAND_COLOR_ID,
					App.TREE.LAUNCHER_COMMAND_COLOR_NAME,
					App.TREE.LAUNCHER_COMMAND_COLOR_TAG
				];
				foreach(i, CommandTree; CommandTrees) {
					Binary[] bin;
					foreach(j; 0..1+1) {
						bin ~= cast(Binary)CommandColor.color(i, j+1).toRGBArray;
					}
					aki[App.TREE.LAUNCHER, App.TREE.LAUNCHER_COMMAND, App.TREE.LAUNCHER_COMMAND_COLOR, CommandTree] = bin;
				}
			}
		}
		
		return aki;
	}
	
	protected override {
		void OnDestroy() {
			delete CtrlFont;
			delete CommandFont;
			
			super.OnDestroy();
		}
		void OnCreate() {
			super.OnCreate();
			
			CtrlFont = GetSystemFont(SYSFONT.MESSAGE);

			immutable FontHeight = GetFontHeightPx(CtrlFont);
			immutable CtrlHeight = GetDefaultControlHeight(CtrlFont);
			immutable CtrlPadding= GetControlPadding();

			// ウィンドウ ----------------------
			
			WindowGroup = new GroupBox(this, CTRL.WINDOW);
			WindowGroup.text = Text("ウィンドウ表示");
			
			WindowPosSelect = new WindowPosComboBox(WindowGroup, CTRL.WINDOW_POS);
			WindowPosSelect.initialize();
			WindowPosSelect.select = AppData.position;

			FrontSelect = new CheckBox(WindowGroup, CTRL.WINDOW_FRONT);
			FrontSelect.text = Text("最前面表示");
			FrontSelect.checked = AppData.front;

			WindowGroup.font = CtrlFont;

			/+
			WindowGroup.tuneSize = delegate(int Width, int Height, int CtrlHeight, ref const RECT InSize) {
				invariant StdHeight=WindowPosSelect.editerHeight();
				invariant Padding=GetControlPadding();
				//invariant InWidth=InSize.right-InSize.left;
				
				WindowPosSelect.move(InSize.left,InSize.top,InSize.right, StdHeight*5);
				FrontSelect.move(InSize.left, InSize.top+StdHeight+Padding.cy, InSize.right,CtrlHeight);
			};
			+/
			auto WindowPanel=new Dual(DIRECTION.VERTICAL);
			WindowPanel[0] = WindowPosSelect;
			WindowPanel[1] = FrontSelect;
			WindowPanel.sizeInfo.percent = 50;
			WindowGroup.layoutManager.basePanel=WindowPanel;

			// フォルダ表示方法 ------------------------
			FolderGroup = new GroupBox(this, CTRL.FOLDER);
			FolderGroup.text = Text("フォルダ表示");
			
			FolderOpenNormal = new Radio(FolderGroup, CTRL.FOLDER_NORAML);
			FolderOpenNormal.text = Text("デフォルト");
			FolderOpenExplorer = new Radio(FolderGroup, CTRL.FOLDER_EXPLORER);
			FolderOpenExplorer.text = Text("Explorer");
			FolderOpenItem = new Radio(FolderGroup, CTRL.FOLDER_ITEM);
			FolderOpenItem.text = Text("アイテム");
			FolderOpenSelect = new ItemComboBox(FolderGroup, CTRL.FOLDER_SELECT);
			
			with(FOLDER) {
				bool SelectEnable=true;
				auto group=new RadioGroup(FolderOpenNormal, FolderOpenExplorer, FolderOpenItem);
				switch(AppData.folder()) {
					case NORMAL:   group.checked = FolderOpenNormal;   SelectEnable = false; break;
					case EXPLORER: group.checked = FolderOpenExplorer; SelectEnable = false; break;
					case PROGRAM:  group.checked = FolderOpenItem;     SelectEnable = cast(bool)FolderOpenSelect.count; break;
					default:       assert(false);
				}
				
			setItemList(items);
			}

			FolderGroup.font = CtrlFont;
			/+
			FolderGroup.tuneSize = delegate(int Width, int Height, int CtrlHeight, ref const RECT InSize) {
				invariant StdHeight=FolderOpenSelect.editerHeight();
				invariant Padding=GetControlPadding();

				FolderOpenNormal.move(InSize.left,  InSize.top+CtrlHeight*0+Padding.cy*0, InSize.right, CtrlHeight);
				FolderOpenExplorer.move(InSize.left, InSize.top+CtrlHeight*1+Padding.cy*1, InSize.right, CtrlHeight);
				FolderOpenItem.move(InSize.left, InSize.top+CtrlHeight*2+Padding.cy*2, InSize.right, CtrlHeight);
				FolderOpenSelect.move(InSize.left, InSize.top+CtrlHeight*3+Padding.cy*3, InSize.right, StdHeight * 10);
			};
			+/
			auto FolderPanel=new Line(DIRECTION.VERTICAL);
			FolderPanel.padding.bottom = FolderGroup.layoutManager.padding.bottom;
			FolderPanel += FolderOpenNormal;
			FolderPanel.sizeInfo(0).absolute = FontHeight;
			FolderPanel += FolderOpenExplorer;
			FolderPanel.sizeInfo(1).absolute = FontHeight;
			FolderPanel += FolderOpenItem;
			FolderPanel.sizeInfo(2).absolute = FontHeight;
			FolderPanel += FolderOpenSelect;
			FolderPanel.sizeInfo(3).absolute = -1;
			FolderGroup.layoutManager.basePanel=FolderPanel;
			
			// ボタン型 ------------------------
			BuutonGroup = new GroupBox(this, CTRL.BUTTON);
			BuutonGroup.text = Text("ボタン型");
			
			ButtonIconSmall = new Radio(BuutonGroup, CTRL.BUTTON_ICON_SMALL);
			ButtonIconSmall.text = Text("16px");
			ButtonIconNormal = new Radio(BuutonGroup, CTRL.BUTTON_ICON_NORMAL);
			ButtonIconNormal.text = Text("32px");
			with(ICONSIZE) {
				auto group=new RadioGroup(ButtonIconSmall, ButtonIconNormal);
				switch(AppData.exeButtonIcon()) {
					case SMALL:  group.checked = ButtonIconSmall;  break;
					case NORMAL: group.checked = ButtonIconNormal; break;
					default:    assert(false);
				}
			}

			ButtonTextSelect = new CheckBox(BuutonGroup, CTRL.BUTTON_TEXT);
			ButtonTextSelect.text = Text("テキスト");
			ButtonTextSelect.checked = AppData.exeButtonText();
				
			ButtonTextList   = new CheckBox(BuutonGroup, CTRL.BUTTON_TEXT_LIST);
			ButtonTextList.text = Text("リスト表示");
			ButtonTextList.enable = ButtonTextSelect.checked;
			ButtonTextList.checked = AppData.exeButtonList();
			
			BuutonGroup.font = CtrlFont;
			/+
			BuutonGroup.tuneSize = delegate(int Width, int Height, int CtrlHeight, ref const RECT InSize) {
				invariant Padding=GetControlPadding();
				//invariant InWidth=InSize.right-InSize.left;
				
				ButtonIconSmall.move(InSize.left,  InSize.top+CtrlHeight*0+Padding.cy*0, InSize.right, CtrlHeight);
				ButtonIconNormal.move(InSize.left, InSize.top+CtrlHeight*1+Padding.cy*1, InSize.right, CtrlHeight);
				ButtonTextSelect.move(InSize.left, InSize.top+CtrlHeight*2+Padding.cy*2, InSize.right, CtrlHeight);
				ButtonTextList.move(InSize.left,   InSize.top+CtrlHeight*3+Padding.cy*3, InSize.right, CtrlHeight);
			};
			+/
			auto BuutonPanel=new Line(DIRECTION.VERTICAL);
			BuutonPanel.padding.bottom = FolderGroup.layoutManager.padding.bottom;
			BuutonPanel += ButtonIconSmall;
			BuutonPanel.sizeInfo(0).absolute = FontHeight;
			BuutonPanel += ButtonIconNormal;
			BuutonPanel.sizeInfo(1).absolute = FontHeight;
			BuutonPanel += ButtonTextSelect;
			BuutonPanel.sizeInfo(2).absolute = FontHeight;
			BuutonPanel += ButtonTextList;
			BuutonPanel.sizeInfo(3).absolute = -1;
			BuutonGroup.layoutManager.basePanel=BuutonPanel;
			
			// メニュー型 ----------------------
			MenuGroup = new GroupBox(this, CTRL.MENU);
			MenuGroup.text = Text("メニュー型");

			MenuIconSmall = new Radio(MenuGroup, CTRL.MENU_ICON_SMALL);
			MenuIconSmall.text = Text("16px");
			MenuIconNormal = new Radio(MenuGroup, CTRL.MENU_ICON_NORMAL);
			MenuIconNormal.text = Text("32px");
			with(ICONSIZE) {
				auto group=new RadioGroup(MenuIconSmall, MenuIconNormal);
				switch(AppData.exeMenuIcon()) {
					case SMALL:  group.checked = MenuIconSmall;  break;
					case NORMAL: group.checked = MenuIconNormal; break;
					default:    assert(false);
				}
			}

			MenuTextInfo = new TextLabel(MenuGroup, CTRL.MENU_TEXT_INFO);
			MenuTextInfo.text = Text("文字列長");
			MenuTextInfo.horizonAlign = HORIZON_ALIGN.RIGHT;
			//MenuTextInfo.verticaAlign = VERTICAL_ALIGN.CENTER;
			
			MenuTextInput = new EditLine(MenuGroup, CTRL.MENU_TEXT_INPUT);
			MenuTextInput.numberOnly=true;
			
			MenuTextSpin = new UpDown(MenuGroup, CTRL.MENU_TEXT_UPDOWN, UpDown.POSITION.RIGHT);
			MenuTextSpin.buddy = MenuTextInput;
			MenuTextSpin.range(0, Integer.max);
			MenuTextSpin.value = AppData.exeMenuText();
			
			MenuDesktop   = new CheckBox(MenuGroup, CTRL.MENU_DESKTOP);
			MenuDesktop.text = Text("デスクトップで有効にする");
			MenuDesktop.checked = AppData.exeMenuDeskTop();
			
			MenuGroup.font = CtrlFont;
			MenuGroup.tuneSize = delegate(int Width, int Height, int CtrlHeight, ref const RECT InSize) {
				/+
				invariant Padding=GetControlPadding();
				//invariant InWidth=InSize.right-InSize.left;

				MenuIconSmall.move(InSize.left,  InSize.top+CtrlHeight*0+Padding.cy*0, InSize.right, CtrlHeight);
				MenuIconNormal.move(InSize.left, InSize.top+CtrlHeight*1+Padding.cy*1, InSize.right, CtrlHeight);

				invariant InfoWidth=InSize.right / 10 * 5;
				invariant InputWidth=InSize.right - InfoWidth;
				MenuTextInfo.move(InSize.left, InSize.top+CtrlHeight*2+Padding.cy*2+Padding.cy, InfoWidth, CtrlHeight);
				MenuTextInput.move(InSize.left+InfoWidth, InSize.top+CtrlHeight*2+Padding.cy*2, InputWidth, CtrlHeight);

				MenuTextSpin.buddy = MenuTextInput;
				
				MenuDesktop.move(InSize.left,   InSize.top+CtrlHeight*3+Padding.cy*3, InSize.right, CtrlHeight);
				+/
				MenuTextSpin.reBuddy;
			};
			auto MenuPanel=new Line(DIRECTION.VERTICAL);
			MenuPanel.padding.bottom = FolderGroup.layoutManager.padding.bottom;
			MenuPanel += MenuIconSmall;
			MenuPanel.sizeInfo(0).absolute = FontHeight;
			MenuPanel += MenuIconNormal;
			MenuPanel.sizeInfo(1).absolute = FontHeight;

			auto MenuTextPanel=new Dual(DIRECTION.HORIZON);
			MenuTextPanel[0] = MenuTextInfo;
			MenuTextPanel[1] = MenuTextInput;
			MenuTextPanel.sizeInfo.percent = 45;
			MenuTextPanel.centerSize = CtrlPadding.cx;
			MenuPanel += MenuTextPanel;
			MenuPanel.sizeInfo(2).absolute = CtrlHeight;
			
			MenuPanel += MenuDesktop;
			MenuPanel.sizeInfo(3).absolute = -1;
			MenuGroup.layoutManager.basePanel=MenuPanel;

			// コマンド型 ----------------------
			CommandGroup = new GroupBox(this, CTRL.COMMAND);
			CommandGroup.text = Text("コマンド型");
			
			CommandIconSmall = new Radio(CommandGroup, CTRL.COMMAND_ICON_SMALL);
			CommandIconSmall.text = Text("16px");
			CommandIconNormal = new Radio(CommandGroup, CTRL.COMMAND_ICON_NORMAL);
			CommandIconNormal.text = Text("32px");
			with(ICONSIZE) {
				auto group=new RadioGroup(CommandIconSmall, CommandIconNormal);
				switch(AppData.exeCommandIcon()) {
					case SMALL:  group.checked = CommandIconSmall;  break;
					case NORMAL: group.checked = CommandIconNormal; break;
					default:    assert(false);
				}
			}

			CommandCallInput = new HotKey(CommandGroup, CTRL.COMMAND_CALL);
			HOTKEYVALUE HotKeyValue;
			auto keys = AppData.exeCoomandHotkey();
			if(keys[0]) {
				HotKeyValue.modToHotkey = cast(MOD)keys[0];
			}
			HotKeyValue.Key         = cast(KEY)keys[1];
			CommandCallInput.value  = HotKeyValue;

			CommandFont = AppData.exeCommandFont();
			CommandFontSelect = new Push(CommandGroup, CTRL.COMMAND_FONT);
			CommandFontSelect.text = CommandFont.faceName;

			CommandHiddenInfo = new TextLabel(CommandGroup, CTRL.COMMAND_TIMER_INFO);
			CommandHiddenInfo.text = Text("消滅時間");
			CommandHiddenInfo.horizonAlign = HORIZON_ALIGN.RIGHT;
			
			CommandHiddenInput = new EditLine(CommandGroup, CTRL.COMMAND_TIMER_INPUT);
			CommandHiddenInput.numberOnly=true;
			
			CommandHiddenSpin = new UpDown(CommandGroup, CTRL.COMMAND_TIMER_UPDOWN, UpDown.POSITION.RIGHT);
			CommandHiddenSpin.buddy = CommandHiddenInput;
			CommandHiddenSpin.range(-1, Integer.max);
			CommandHiddenSpin.value = AppData.exeCommandTimer();

			CommandColor = new ColorList(CommandGroup, CTRL.COMMAND_COLOR);
			CommandColor.columns = Texts("", "前景色", "背景色");
			CommandColor.lines   = Texts("ID", "NAME", "TAGS");

			auto CommandColors = [
				AppData.exeCommandColor(App.COMMANDCOLOR.ID),
				AppData.exeCommandColor(App.COMMANDCOLOR.NAME),
				AppData.exeCommandColor(App.COMMANDCOLOR.TAG)
			];
			foreach(i, Colors; CommandColors) {
				foreach(j, color; Colors) {
					CommandColor.color(i, j+1, color);
				}
			}

			
			CommandGroup.font = CtrlFont;
			CommandFontSelect.font = CommandFont;
			CommandGroup.tuneSize = delegate(int Width, int Height, int CtrlHeight, ref const RECT InSize) {
				/+
				invariant Padding=GetControlPadding();

				CommandCallInput.move(InSize.left,  InSize.top+CtrlHeight*0+Padding.cy*0, InSize.right, CtrlHeight);
				CommandIconSmall.move(InSize.left,  InSize.top+CtrlHeight*1+Padding.cy*1, InSize.right, CtrlHeight);
				CommandIconNormal.move(InSize.left,  InSize.top+CtrlHeight*2+Padding.cy*2, InSize.right, CtrlHeight);
				CommandFontSelect.move(InSize.left, InSize.top+CtrlHeight*3+Padding.cy*3, InSize.right, CtrlHeight);
				
				invariant InfoWidth=InSize.right / 10 * 5;
				invariant InputWidth=InSize.right - InfoWidth;
				CommandHiddenInfo.move(InSize.left, InSize.top+CtrlHeight*4+Padding.cy*4+Padding.cy, InfoWidth, CtrlHeight);
				CommandHiddenInput.move(InSize.left+InfoWidth, InSize.top+CtrlHeight*4+Padding.cy*4, InputWidth, CtrlHeight);
				CommandHiddenSpin.reBuddy;

				CommandColor.move(InSize.left, InSize.top+CtrlHeight*5+Padding.cy*5, InSize.right, CtrlHeight*4);
				+/
				CommandHiddenSpin.reBuddy;
			};
			auto CommandPanel=new Line(DIRECTION.VERTICAL);
			CommandPanel.padding.bottom = FolderGroup.layoutManager.padding.bottom;
			CommandPanel += CommandIconSmall;
			CommandPanel.sizeInfo(0).absolute = FontHeight;
			CommandPanel += CommandIconNormal;
			CommandPanel.sizeInfo(1).absolute = FontHeight;
			CommandPanel += CommandCallInput;
			CommandPanel.sizeInfo(2).absolute = CtrlHeight;
			CommandPanel += CommandFontSelect;
			CommandPanel.sizeInfo(3).absolute = CtrlHeight;
			
			auto CommandHiddenPanel=new Dual(DIRECTION.HORIZON);
			CommandHiddenPanel[0] = CommandHiddenInfo;
			CommandHiddenPanel[1] = CommandHiddenInput;
			CommandHiddenPanel.sizeInfo.percent = 45;
			CommandHiddenPanel.centerSize = CtrlPadding.cx;
			CommandPanel += CommandHiddenPanel;
			CommandPanel.sizeInfo(4).absolute = CtrlHeight;
			
			CommandPanel += CommandColor;
			CommandPanel.sizeInfo(5).absolute = -1;
			
			CommandGroup.layoutManager.basePanel=CommandPanel;
		}
		void OnCreated() {
			auto hooker=StaticData.dllHooker;
			MenuDesktop.enable = FILE.isExistence(hooker) && FILE.isFile(hooker);
		}
		
		void OnSize(SIZE_TYPE SizeType, int Width, int Height) {
			invariant CtrlHeight=GetDefaultControlHeight(CtrlFont);
			SIZE Padding=GetControlPadding();

			auto group=160;
			
			WindowGroup.move(0, 0, group, CtrlHeight*3+Padding.cy*4);
			BuutonGroup.move(0, CtrlHeight*3+Padding.cy*5, group, CtrlHeight*5+Padding.cy*6);

			MenuGroup.move(0, CtrlHeight*3+Padding.cy*5 + CtrlHeight*5+Padding.cy*7, group, CtrlHeight*6+Padding.cy*6);

			CommandGroup.move(group+10, 0, group, CtrlHeight*10+Padding.cy*11);
			FolderGroup.move(group+10, CtrlHeight*10+Padding.cy*11, group, CtrlHeight*5+Padding.cy*5);
		}
		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			if(MessageType == Button.EVENT.CLICKED) {
				switch(Id) {
					case CTRL.BUTTON_TEXT:
						ButtonTextList.enable = ButtonTextSelect.checked;
						return true;
					case CTRL.COMMAND_FONT:
						CommandFontSetting();
						return true;
					case CTRL.FOLDER_NORAML:
					case CTRL.FOLDER_EXPLORER:
						FolderOpenSelect.enable = false;
						return true;
					case CTRL.FOLDER_ITEM:
						FolderOpenSelect.enable = true;
						return true;
					default:
						return false;
				}
			}
			
			return false;
		}
		int OnNotify(ITEM_ID ItemID, NOTIFY* Notify) {
			if(ItemID == CTRL.COMMAND_COLOR && CommandColor) {
				return CommandColor.onNotify(Notify);
			}
			return 0;
		}
	}
}
