﻿/**
*/
module nemuxi.gui.window.dialog.settingdialog.itemdialog.datasetctrl;

debug import std.stdio: wl = writefln, pl = printf;
debug(datasetctrl) void main() {}

import std.contracts;

import etc.kareki.kareki;

import nemuxi.base;
import nemuxi.file.file;
import nemuxi.file.items.item;
import nemuxi.negui.control.control;
import nemuxi.negui.control.editbox.editbox;
import nemuxi.negui.control.listbox.listbox;
import nemuxi.negui.control.time.datetimepicker;
import nemuxi.gui.control.combobox;



package:

bool SetData(in Item item, lazy bool Have, lazy string Value, EditBox Ctrl) {
	//Ctrl.text = item ? Text(Value): Text.emptyText;
	if(item && Have) {
		Ctrl.text = Text(Value);
	} else {
		Ctrl.text = Text.emptyText;
	}
	return item !is null;
}
bool SetData(in Item item, lazy bool Have, lazy string[] Value, ListBox Ctrl) {
	Ctrl.clear;
	if(item && Have) {
		if(auto texts=Texts(Value)) {
			Ctrl.add = texts;
		}
	}
	
	return item !is null;
}


bool SetData(in Item item, lazy DateTime Value, DatePicker DateCtrl, TimePicker TimeCtrl) {
	DateTime dt;
	
	if(item) {
		dt = Value;
	}
	if(!dt) {
		dt = new DateTime();
	}
	ChangeData(dt, DateCtrl, TimeCtrl);
	
	return item !is null;
}
void ChangeData(DateTime Value, DatePicker DateCtrl, TimePicker TimeCtrl)
in{
	assert(Value);
	assert(Value.mask == DateTime.MASK.DATE | DateTime.MASK.TIME);
}
body {
	auto dt=Value;
	DateCtrl.value = dt;
	TimeCtrl.value = dt;
}

bool SetData(in Item item, lazy Integer Value, Control Ctrl) {
	ChangeData(item ? Value: Integer.init, Ctrl);
	
	return item !is null;
}
void ChangeData(Integer Value, Control Ctrl) {
	Ctrl.number = Value;
}

bool SetDataLimited(T)(in Item item, lazy bool Have, lazy T Value, LimitedComboBox!(T) Ctrl) {
	Ctrl.initialize;
	
	if(item && Have) {
		Ctrl.select = Value;
	}
	
	return item !is null;
}

