﻿/**
*/
module nemuxi.gui.window.dialog.settingdialog.groupdialog;

debug import std.stdio: wl = writefln, pl = printf;
debug(groupdialog) void main() {}

import std.contracts;

import etc.kareki.kareki;

import nemuxi.file.items.item;
import nemuxi.negui.window.dialog.dialog;
import nemuxi.negui.control.treeview.treeview;
import nemuxi.negui.control.listbox.listbox;
import nemuxi.image.font;
import nemuxi.negui.layout.panel.dual;
import nemuxi.file.items.group;
import nemuxi.gui.control.combobox;
//import nemuxi.gui.control.iteminput;
import nemuxi.negui.draw.cursor;
import nemuxi.gui.window.dialog.inputdialog.inputdialog;
import nemuxi.negui.window.menu.popup;
import nemuxi.gui.window.dialog.settingdialog.settingif;
import nemuxi.negui.event;
import nemuxi.utility.convert.item;

class GroupDialog: ModalDialog, ISettingInFrame {
	protected enum CTRL: ITEM_ID {
		GROUP = 1,
		//ADDRESS,
		//ITEMLIST,
		ITEM,
	}
	protected enum TYPE {
		NONE,
		MENU,
		MAIN,
		SUB,
		ITEM
	}
	protected {
		TreeView GroupTree;
		//ListBox ItemList;
		//AddressInput  ai;
		ItemComboBox ItemSelect;
	}
	protected {
		Font CtrlFont;
		
		Item[] items;
		Kareha GroupBase;

		Item[][] ItemDatas;
	}
	this(NeWindow Owner, Kareha GroupBase, Item[] items) {
		this.items   = items;
		this.GroupBase  = GroupBase;
		
		GUIINFO NeGuiInfo;
		NeGuiInfo.Owner  = Owner;
		NeGuiInfo.Window = true;
		
		super(&NeGuiInfo, DIALOG_ID.init);
	}
	override void setItemList(Item[] items) {
		ItemSelect.setItemList = items;
		auto TreeItem=GroupTree.get(GroupTree.nodeCaret());
		auto Enable=ItemSelect.enable && cast(TYPE)TreeItem.data == TYPE.ITEM;
		ItemSelect.enable = Enable;
		if(Enable) {
			auto NowID=Text(TreeItem.text);
			if(NowID.toString in ItemSelect)
			ItemSelect.selectID(NowID);
		}
	}
	override Item[] getItemList() {
		return ItemSelect.getItemList;
	}
	mixin MixInSettingInFrame;
	override AkiDocument akiDocument() {
		auto aki=new AkiDocument;

		string[] MainGroupNames;
		TREE_NODE MainGroupNode=GroupTree.nodeRoot(TREE_NODE.init);
		do {
			auto MainItem=GroupTree.get(MainGroupNode);
			auto MainGroupName=Text(MainItem.text).toString;
			if(cast(TYPE)MainItem.data != TYPE.MENU) {
				MainGroupNames ~= MainGroupName;
			}

			string[] SubGroupNames;
			TREE_NODE SubGroupNode=GroupTree.nodeChild(MainGroupNode);
			while(SubGroupNode) {
				auto SubItem=GroupTree.get(SubGroupNode);
				auto SubGroupName=Text(SubItem.text).toString;
				SubGroupNames ~= SubGroupName;

				string[] ItemIDs;
				TREE_NODE ItemNode=GroupTree.nodeChild(SubGroupNode);
				while(ItemNode) {
					auto ItemItem=GroupTree.get(ItemNode);
					auto ItemID=Text(ItemItem.text).toString;
					ItemIDs ~= ItemID;
					
					ItemNode = GroupTree.nodeNext(ItemNode);
				}
				aki[`Group`, MainGroupName, SubGroupName] = ItemIDs;

				SubGroupNode = GroupTree.nodeNext(SubGroupNode);
			}
			
			aki[`Group`, MainGroupName] = SubGroupNames;
			
		} while(cast(bool)(MainGroupNode=GroupTree.nodeNext(MainGroupNode)));
		
		aki[`Group`] = MainGroupNames;
		
		return aki;
	}

	protected override {
		void OnDestroy() {
			delete CtrlFont;
			
			super.OnDestroy();
		}
		void OnCreate() {
			super.OnCreate();
			
			CtrlFont = GetSystemFont(SYSFONT.MESSAGE);
			
			GroupTree = new TreeView(this, CTRL.GROUP);
			GroupTree.font = CtrlFont;

			ItemSelect = new ItemComboBox(this, CTRL.ITEM);
			ItemSelect.font = CtrlFont;

			auto panel=new Dual(DIRECTION.VERTICAL);
			panel.sizeInfo.absolute=ItemSelect.editerHeight;
			panel[0] = ItemSelect;
			panel[1] = GroupTree;

			layoutManager.basePanel=panel;
		}

		void OnCreated() {
			InitTree;
			ItemSelect.enable=false;

		}

		void OnContexMenu(NeGui CatchItem, int x, int y) {
			auto TreeItem=GetTreeItem(x, y);
			if(!TreeItem) {
				TreeItem = new TREEITEM;
				TreeItem.data = cast(void*)TYPE.NONE;
				TreeItem.item = GroupTree.nodeRoot(TREEINSERTITEM.ROOT);
			}

			enum COMMAND: COMMAND_ID {
				MOVE_UP=1,
				MOVE_DOWN,
				EDIT,
				DEL,
				MAIN_ADD,
				MAIN_INSERT,
				SUB_ADD,
				SUB_INSERT,
				ITEM_ADD,
				ITEM_INSERT,
			}
			
			scope menu=new PopUp();
			menu.insertText(COMMAND.MOVE_UP, Text("上へ"), cast(bool)GroupTree.nodePrevious(TreeItem.item));
			menu.insertText(COMMAND.MOVE_DOWN, Text("下へ"), cast(bool)GroupTree.nodeNext(TreeItem.item));
			menu.insertSeparator();
			menu.insertText(COMMAND.EDIT, Text("編集"));
			menu.insertText(COMMAND.DEL, Text("削除"));
			menu.insertSeparator();
			auto DISABLE=cast(MENU_FLAG)(MENU_FLAG.GRAYED | MENU_FLAG.DISABLED);
			
			with(COMMAND) switch(cast(TYPE)TreeItem.data) {
				case TYPE.MAIN:
					menu.insertText(MAIN_INSERT, Text("メイングループ挿入"));
					menu.insertText(MAIN_ADD, Text("メイングループ追加"));
					menu.insertSeparator();
					menu.insertText(SUB_ADD, Text("サブグループ追加"));
					if(!GroupTree.nodeNext(GroupTree.nodeNext(TreeItem.item))) {
						//最後が<Menu>なんでその次がnullだったら×。
						menu.enable(MOVE_DOWN, DISABLE);
					}
					break;
				case TYPE.SUB:
					menu.insertText(SUB_INSERT, Text("サブグループ挿入"));
					menu.insertText(ITEM_ADD, Text("アイテム追加"));
					break;
				case TYPE.ITEM:
					menu.insertText(ITEM_INSERT, Text("アイテム挿入"));
					break;
				case TYPE.MENU:
					menu.insertText(SUB_ADD, Text("サブグループ追加"));
					menu.enable(MOVE_UP, DISABLE);
					menu.enable(MOVE_DOWN, DISABLE);
					menu.enable(EDIT, DISABLE);
					menu.enable(DEL, DISABLE);
					break;
				case TYPE.NONE:
					menu.insertText(MAIN_ADD, Text("メイングループ追加"));
					menu.enable(MOVE_UP, DISABLE);
					menu.enable(MOVE_DOWN, DISABLE);
					menu.enable(EDIT, DISABLE);
					menu.enable(DEL, DISABLE);
					break;
				default:
					assert(false);
			}
			if(cast(TYPE)TreeItem.data != TYPE.NONE) {
				GroupTree.select(TreeItem.item, TreeView.SELECT.CARET);
			}
			if(auto id=menu.show(this, PopUp.FLAGS.NONOTIFY | PopUp.FLAGS.RETURNCMD)) {
				TREEINSERTITEM TreeInsertItem;
				bool InsertFlag=true;
				
				with(COMMAND) switch(id) {
					case MOVE_UP:
						GroupTree.nodeMove(TreeItem.item, +1);
						InsertFlag = false;
						break;
					case MOVE_DOWN:
						GroupTree.nodeMove(TreeItem.item, -1);
						InsertFlag = false;
						break;
					case EDIT:
						if(cast(TYPE)TreeItem.data == TYPE.ITEM) {
							ItemSelect.setFocus;
						} else {
							InputContent(*TreeItem);
						}
						InsertFlag = false;
						break;
					case DEL:
						GroupTree.del(TreeItem.item);
						InsertFlag = false;
						break;
					case MAIN_ADD:
						TreeInsertItem = GetInsertItem(TreeItem.item, TYPE.MAIN, Text("new"), false);
						if(cast(TYPE)TreeItem.data != TYPE.NONE) {
							TreeInsertItem.insertAfter = GroupTree.nodePrevious(GroupTree.nodeTail(TreeItem.item));
						} else {
							TreeInsertItem.insertAfter = TREEINSERTITEM.FIRST;
						}
						break;
					case MAIN_INSERT:
						TreeInsertItem = GetInsertItem(TreeItem.item, TYPE.MAIN, Text("new"), true);
						break;
					case SUB_ADD:
						TreeInsertItem = GetInsertItem(TreeItem.item, TYPE.SUB, Text("new"), false);
						TreeInsertItem.parent = TreeItem.item;
						break;
					case SUB_INSERT:
						TreeInsertItem = GetInsertItem(TreeItem.item, TYPE.SUB, Text("new"), true);
						break;
					case ITEM_ADD:
						TreeInsertItem = GetInsertItem(TreeItem.item, TYPE.ITEM, Text("new"), false);
						TreeInsertItem.parent = TreeItem.item;
						break;
					case ITEM_INSERT:
						TreeInsertItem = GetInsertItem(TreeItem.item, TYPE.ITEM, Text("new"), true);
						break;
					default:
						assert(false);
				}

				if(InsertFlag) {
					GroupTree.select(GroupTree.insert(TreeInsertItem), TreeView.SELECT.CARET);
				}
			}
		}

		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			if(Sender is ItemSelect) if(MessageType == ComboBox.EVENT.LISTCHANGE) {
				auto TreeItem=GroupTree.get(GroupTree.nodeCaret());
				TreeItem.text = ItemSelect.selectID;
				GroupTree.set=TreeItem;
			}
			return 0;
		}
		
		int OnNotify(ITEM_ID Id, NOTIFY* Notify) {
			if(Id == CTRL.GROUP) switch(Notify.code) {
				case TreeView.COMMONEVENT.DBLCLK:
					auto Point=Cursor.getPos;
					if(auto TreeItem=GetTreeItem(Point.x, Point.y)) {
						// 編集
						switch(cast(TYPE)TreeItem.data) {
							case TYPE.MAIN:
							case TYPE.SUB:
								InputContent(*TreeItem);
								break;
							case TYPE.ITEM:
								ItemSelect.setFocus;
								break;
							case TYPE.MENU: // 編集不可ってことで
								break;
							default:
								assert(false);
						}
						return 0;
					}
					goto default;
				
				case TreeView.EVENT.SELCHANGED:
					auto TreeViewMessage=cast(TREEVIEWMESSAGE*)Notify;
					if(*TreeViewMessage.itemNew != TREEITEM.init) {
						// アイテムの編集可不可 setItemListとの統一が必要。
						auto IsItem=cast(TYPE)TreeViewMessage.itemNew.data == TYPE.ITEM;
						ItemSelect.enable=IsItem;
						if(IsItem) {
							auto CopyItem=GetTreeItem(TreeViewMessage.itemNew.item);
							auto NowID=Text(CopyItem.text);
							if(NowID.toString in ItemSelect)
							ItemSelect.selectID(NowID);
						}
						return 0;
					}
				default:
					return 0;
			}
			return 0;
		}
	}

	private TREEITEM* GetTreeItem(int x, int y, in size_t TextLength=TreeView.TEXTLENGTH) {
		TREEHITTEST TreeHitTest;
		TreeHitTest.point.x = x;
		TreeHitTest.point.y = y;
		if(GroupTree.pointToClient(TreeHitTest.point)) {
			auto Item = GroupTree.hitTest(TreeHitTest);
			
			if(Item) {
				return GetTreeItem(Item, TextLength);
			} else {
				return null;
			}
		} else {
			return null;
		}
	}
	private TREEITEM* GetTreeItem(TREE_ITEM Item, in size_t TextLength=TreeView.TEXTLENGTH) {
		auto TreeItem=new TREEITEM;
		auto str=new wchar[TextLength];
		TreeItem.mask = TREEITEM.MASK.HANDLE | TREEITEM.MASK.TEXT | TREEITEM.MASK.USERDATA;
		TreeItem.item = Item;
		TreeItem.text = str.ptr;
		TreeItem.textLength=str.length;
		if(GroupTree.get(*TreeItem)) {
			return TreeItem;
		} else {
			return null;
		}
	}

	bool InputContent(const ref TREEITEM TreeItem) {
		TREEITEM CopyItem=cast(TREEITEM)TreeItem;
		INPUTSTATUS InputStatus;
		
		with(InputStatus) {
			InputText = true;
			CanselSelect = true;
			InitText  = CopyItem.text;
			dg = delegate(in Text text) {
				enforce(Convert.isTreeName(text.toString), new SettingException(text ~ "はむり"));
			};
		}
		scope dialog=new InputDialog(cast(NeWindow)parent, InputStatus);

		if(dialog.select) {
			if(dialog.inputText != Text(CopyItem.text)) {
				CopyItem.text = dialog.inputText;
				enforce(GroupTree.set(CopyItem), new NemuxiException(Err.toString));
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	ref TREEINSERTITEM GetInsertItem(TREE_NODE BaseNode, TYPE Type, in Text text, bool Insert) {
		auto TreeInsertItem = new TREEINSERTITEM;
		
		TreeInsertItem.item.mask = TREEITEM.MASK.TEXT | TREEITEM.MASK.DATA;
		TreeInsertItem.item.text = text;
		TreeInsertItem.item.data = cast(void*)Type;
		TreeInsertItem.parent = GroupTree.nodeParent(BaseNode);
		
		if(Insert) {
			TreeInsertItem.insertAfter = BaseNode;
		} else {
			TreeInsertItem.insertAfter = TREEINSERTITEM.LAST;
		}

		return *TreeInsertItem;
	}


	private void InitTree() {
		auto main=new Main(GroupBase);
		
		foreach(i, MainName; main() ~ "<Menu>") {
			TREEINSERTITEM TreeInsertItem;
			
			TreeInsertItem.item.mask = TREEITEM.MASK.TEXT | TREEITEM.MASK.HANDLE | TREEITEM.MASK.USERDATA;
			TreeInsertItem.insertAfter = TREEINSERTITEM.LAST;
			TreeInsertItem.item.text = MainName.toText;
			if(i == (main() ~ "<Menu>").length-1)
			TreeInsertItem.item.data = cast(void*)TYPE.MENU;
			else
			TreeInsertItem.item.data = cast(void*)TYPE.MAIN;
			TreeInsertItem.parent = GroupTree.insert(TreeInsertItem);

			if(MainName in GroupBase) {
				auto subs=new Sub(main, main[MainName]);
				foreach(j, SubName; subs()) {
					TreeInsertItem.item.text = SubName.toText;
					auto SubParent = TreeInsertItem.parent;
					scope(exit)TreeInsertItem.parent = SubParent;
					TreeInsertItem.item.data = cast(void*)TYPE.SUB;
					TreeInsertItem.parent = GroupTree.insert(TreeInsertItem);
					if(SubName in subs) {
						foreach(ItemName; subs[SubName].get!(string[])) {
							TreeInsertItem.item.text = ItemName.toText;
							TreeInsertItem.item.data = cast(void*)TYPE.ITEM;
							GroupTree.insert(TreeInsertItem);
						}
					}
				}
			}
		}
	}


}


