﻿/**

Bugs:
<del>-inlineつけると滅茶苦茶になる。</del>
なおったー。けど設計が古い。

*/
module nemuxi.gui.window.dialog.inputdialog.inputdialog;

debug(inputdialog) void main() {}

import win32.windows;

import nemuxi.base;
import nemuxi.system.application;
import nemuxi.file.file;
import nemuxi.file.folder;
import nemuxi.negui.control.button.button;
import nemuxi.negui.control.editbox.editbox;
//import nemuxi.negui.proc.inputdlg.inputdlg;
import nemuxi.negui.window.window;
import nemuxi.negui.window.dialog.dialog;
import nemuxi.image.font;
import nemuxi.negui.draw.unit;
import nemuxi.image.icon;
import nemuxi.gui.control.titlebar;
public import nemuxi.negui.window.dialog.system;
import nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;
import nemuxi.gui.window.dialog.selectdialog;
public import nemuxi.utility.convert.convert;

/***/
struct INPUTSTATUS {
	version(unittest) void assertion() {
		/+
		if(FileSelect) {
			assert(Extension);
			assert(Extension.length == 2);
		}
		+/
	}
	bool InputText; /// 使用可不可
	bool FileSelect; /// ditto
	bool FolderSelect; /// ditto
	bool CanselSelect; /// ditto
	Text InitText; /// 初期入力文字
	Text FileTitleText; /// ファイルタイトル文字
	Text FolderTitleText; /// フォルダタイトル文字
	//Text[][] Extension; /// ファイル選択フィルタ
	FileDialog.FILTER[] Filter; /// ファイル選択フィルタ
	Text FolderAddress; /// 両用不初期フォルダ。

	void function(in Text text) fc;
	void delegate(in Text text) dg;
}


class InputDialog: SelectDialog {
	private {
		Font CtrlFont;
		Icon FileIcon, FolderIcon;

		const INPUTSTATUS InputStatus;
		
		//SubClass Subclass;
		
		static enum CTRL: ITEM_ID {
			TITLE=short.max / 2 + 1,
			INPUT,
			OK,
			CANCEL,
			FILE,
			FOLDER,
		}
	}
	
	/***/
	int ctrlHeight() {
		return GetDefaultControlHeight(CtrlFont);
	}
	
	package {
		TitleBar Titlebar;
		EditLine InputText;
		Button  FileSelect;
		Button  FolderSelect;
		Button  OkSelect;
		Button  CanselSelect;

		Text input;
		//bool SelectFlag;
	}
	package void setInputText() {
		assert(this.alive);
		input = InputText.text;
	}
	/+
	version(unittest) private bool HandleSetFlag=true;
	/// 一度きり
	package void setHandle(NeGui gui)
	in {
		version(unittest) assert(HandleSetFlag);
	}
	out {
		version(unittest) HandleSetFlag=false;
	}
	body {
		hItem = gui();
	}
	+/
	/+
	bool executeFlag() {
		return SelectFlag;
	}
	+/
	/**
	*/
	this(NeWindow OwnerWindow, const ref INPUTSTATUS InputStatus)
	in {
		assert(OwnerWindow);
	}
	body
	{
		/+
		WINDOW Wnd;
		
		with(Wnd) {
			ExStyle      = WS_EX_DLGMODALFRAME | WS_EX_TOOLWINDOW;
			ClassName    = Ipt;
			WindowName   = Ipt;
			Style        = WS_POPUP | WS_CLIPCHILDREN | WS_DLGFRAME;
			hOwnerWindow = OwnerWindow();
			// もうほんと勘弁してください
			//Param        = cast(void*)this;
		}

		//ShowText(OwnerWindow, Text("生成\n") ~ cast(uint)h);
		
		super(Wnd.makeWindow());
		+/
		GUIINFO NeGuiInfo;
		NeGuiInfo.Owner = OwnerWindow;
		NeGuiInfo.ExStyle      = WS_EX_DLGMODALFRAME | WS_EX_TOOLWINDOW;
		NeGuiInfo.Style        = WS_DLGFRAME;

		this.InputStatus = InputStatus;
		super(&NeGuiInfo);
		//Subclass = new SubClass(this, &InputDlgProc);
		//ShowText(OwnerWindow, Text(cast(uint)this.opCall));
		//ShowText(OwnerWindow, Text("親コンストラクタ呼び出し完了"));

		/+
		Titlebar     = super.child(CTRL.TITLE).to!(TitleBar);
		InputText    = super.child(CTRL.INPUT).to!(EditBox);
		FileSelect   = super.child(CTRL.FILE).to!(Push);
		FolderSelect = super.child(CTRL.FOLDER).to!(Push);
		OkSelect     = super.child(CTRL.OK).to!(Push);
		CanselSelect = super.child(CTRL.CANCEL).to!(Push);
		+/
		/+
		Titlebar     = new TitleBar(super.child(CTRL.TITLE));
		InputText    = new EditBox(super.child(CTRL.INPUT));
		FileSelect   = new Button(super.child(CTRL.FILE));
		FolderSelect = new Button(super.child(CTRL.FOLDER));
		OkSelect     = new Button(super.child(CTRL.OK));
		CanselSelect = new Button(super.child(CTRL.CANCEL));
		+/
		
		
		//assert(this.alive);

	}
	

	
	/*
	override bool select() {
		/+
		super.ownerEnable(false);
		scope(exit) super.ownerEnable(true);
		
		super.toCenter(CENTER.WINDOW, Owner);
		super.setShow(SW.SHOW);
		//scope(exit) super.setShow(SW.HIDE);
		super.modal();
		+/
		super.modalLoop(MAINLOOP_KEY, CENTER.WINDOW);
		
		return SelectFlag;
	}
	*/
	/***/
	Text inputText() {
		return input;
	}

	private void SetInputText(Text text) {
		if(InputText.readOnly) {
			InputText.text = text;
		} else {
			int Start;
			int End;
			if(InputText.select(Start, End)) {
				auto str=InputText.text;
				auto StartText=str[0..Start];
				auto EndText=str[End..str.length];
				InputText.text = Text(StartText ~ text ~ EndText);
			} else {
				InputText.text = text;
			}
		}
	}

	void selectFile() {
		scope dialog=new OpenDialog();
		
		dialog.text = InputStatus.FileTitleText;
		dialog.ownerWindow = this;
		dialog.currentFolder = InputStatus.FolderAddress;
		dialog.filter(InputStatus.Filter);
		
		if(InputStatus.FolderAddress.length && FILE.isExistence(InputStatus.FolderAddress)) {
			dialog.currentFolder = PATH.getOwnerFolder(InputStatus.FolderAddress);
		} else {
			dialog.currentFolder = GetSystemFolder(SYS_FOLDER.PERSONAL);
		}
		with(FileDialog.OFN) dialog.flags = EXPLORER|FILEMUSTEXIST|HIDEREADONLY|LONGNAMES|PATHMUSTEXIST;

		if(dialog.select()) {
			SetInputText(dialog.fileAddress);
		}
	}
	void selectFolder() {
		scope dialog=new FolderDialog();

		dialog.ownerWindow = this;
		if(InputStatus.FolderAddress.length && FILE.isExistence(InputStatus.FolderAddress) && FILE.isFolder(InputStatus.FolderAddress)) {
			dialog.folderAddress = InputStatus.FolderAddress;
		}
		with(FolderDialog.BIF) dialog.flags = RETURNSANCESTORS|RETURNNONLYFSDIRS|USENEWUI;
	
		if(dialog.select()) {
			SetInputText(dialog.folderAddress);
		}
	}

	// きたー！
	
	override protected {
		void OnCreate() {
			super.OnCreate();
			
			Titlebar     = new TitleBar(this, CTRL.TITLE);
			InputText    = new EditLine(this, CTRL.INPUT);
			InputText.noHideSelect=true;
			InputText.reLoad;
			FileSelect   = new Push(this, CTRL.FILE);
			FolderSelect = new Push(this, CTRL.FOLDER);
			OkSelect     = new Push(this, CTRL.OK);
			CanselSelect = new Push(this, CTRL.CANCEL);
			
			InputText.readOnly  = !InputStatus.InputText;
			FileSelect.enable   = InputStatus.FileSelect;
			FolderSelect.enable = InputStatus.FolderSelect;
			CanselSelect.enable = InputStatus.CanselSelect;

			InputText.text    = InputStatus.InitText;
			OkSelect.text     = Text("OK");
			CanselSelect.text = Text("キャンセル");

			FileSelect.imageType = Button.IMAGE_TYPE.ICON;
			FolderSelect.imageType = Button.IMAGE_TYPE.ICON;

			FileIcon   = GetSystemIcon(SYSICON.FILE, ICONSIZE.SMALL);
			FolderIcon = GetSystemIcon(SYSICON.FOLDER, ICONSIZE.SMALL);
			FileSelect.image(FileIcon);
			FolderSelect.image(FolderIcon);

			// フォント設定
			this.CtrlFont = GetSystemFont(SYSFONT.MESSAGE, true);
			InputText.font    = CtrlFont;
			FileSelect.font   = CtrlFont;
			FolderSelect.font = CtrlFont;
			OkSelect.font     = CtrlFont;
			CanselSelect.font = CtrlFont;

			//super.userData(this);

			SIZE IconSize;
			GetIconControlHeight(ICONSIZE.SMALL, IconSize);

			SIZE Size;
			Size.cx = 256;
			Size.cy = this.Titlebar.getSize()+this.ctrlHeight()+1+IconSize.cy;
			super.adjustSize(&Size);
		}
		
		void OnSize(SIZE_TYPE SizeType, int Width, int Height) {
			SIZE IconSize;
			GetIconControlHeight(ICONSIZE.SMALL, IconSize);
			auto CtrlHeight = ctrlHeight();
			auto CtrlWidth  = (Width - IconSize.cx * 2) / 2;
			auto TitleHeight= Titlebar.getSize();

			Titlebar.onSize();
			
			InputText.move(0, TitleHeight, Width, CtrlHeight);
			
			FileSelect.move(0, TitleHeight+CtrlHeight+1, IconSize.cx, IconSize.cy, true);
			FolderSelect.move(IconSize.cx, TitleHeight+CtrlHeight+1, IconSize.cx, IconSize.cy, true);
			
			OkSelect.move(IconSize.cx*2, TitleHeight+CtrlHeight+1, CtrlWidth, IconSize.cy, true);
			CanselSelect.move(IconSize.cx*2+CtrlWidth, TitleHeight+CtrlHeight+1, CtrlWidth, IconSize.cy, true);
		}

		void OnDestroy() {
			setInputText();
			delete CtrlFont;
			delete FileIcon;
			delete FolderIcon;
			super.OnDestroy();
		}
		
		void OnDrawItem(DRAWITEM* DrawItem) {
			switch(DrawItem.type) {
				case CONTROL_TYPE.BUTTON: // タイトルボタン
					assert(DrawItem.id == CTRL.TITLE);
					Titlebar.draw(DrawItem);
					break;
				default:
					assert(false);
			}
		}
		
		void OnActive(WA Active, bool NotSmall, HWND NextWnd) {
			/+
			RECT Rect;
			SIZE Size;
			Titlebar.clientSize(Size);
			Rect.right = Size.cx;
			Rect.bottom= Size.cy;
			scope canvas=Titlebar.canvas();
			Titlebar.draw(cast(bool)Active, canvas, &Rect);
			+/
			Titlebar.onActive(Active);
		}

		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			try {
				if(MessageType == BN_CLICKED) switch(Id) {
					case CTRL.OK:
						try {
							if(InputStatus.fc) {
								InputStatus.fc(InputText.text);
							}
							if(InputStatus.dg) {
								InputStatus.dg(InputText.text);
							}
						} catch(Exception e) {
							throw new InputException("ん？", EC.NONE, e);
						}
						SelectFlag = true;
						destroy;
						break;
					case CTRL.CANCEL:
						SelectFlag = false;
						destroy;
						break;
					case CTRL.FILE:
						selectFile();
						break;
					case CTRL.FOLDER:
						selectFolder();
						break;
					default:
						return false;
				}
			} catch(NemuxiException e) {
				Logger.write(e);
				SelectFlag = false;
				scope exd=new ExceptionDialog(this, e);
				exd.select;
			}
			return false;
		}
	}

}

