﻿/**

BUGS:
	フォルダを実行できない。
*/
module nemuxi.gui.window.dialog.execdialog.execdialog;

debug import std.stdio: wl = writefln, pl = printf;
debug(execdialog) void main() {}

import std.string;
import std.contracts;

import win32.windows;
import win32.commctrl;

import nemuxi.base;
import nemuxi.system.application;
import nemuxi.file.file;
import nemuxi.file.folder;
import nemuxi.file.items.item;
import nemuxi.file.items.itemfunc;
import nemuxi.file.items.linkitem;
import nemuxi.image.font;
import nemuxi.image.icon;
import nemuxi.negui.draw.unit;
import nemuxi.image.cursor;
import nemuxi.negui.window.newindow;
//import nemuxi.negui.window.dialog.dialog;
import nemuxi.negui.control.button.button;
import nemuxi.negui.control.editbox.editbox;
import nemuxi.negui.control.combobox.combobox;
import nemuxi.gui.control.combobox;
//import nemuxi.negui.window.dialog.system;
//import nemuxi.negui.window.hook;
//import nemuxi.negui.proc.commandwnd.commanddialog;
import nemuxi.utility.simple.his;
//import nemuxi.negui.control.listbox.listbox;
import nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;
//import nemuxi.negui.proc.exceptionwnd.exceptionalert;
import nemuxi.gui.window.dialog.selectdialog;

import nemuxi.negui.layout.panel.line;
import nemuxi.negui.layout.panel.tansu;
import nemuxi.negui.layout.panel.dual;


class ExecDialog: SelectDialog {
	private {
		enum CTRL: ITEM_ID {
			ADDRESS=short.max / 2 + 1,
			WORK_SELECT,
			WORK_INPUT,
			OPTION_SELECT,
			OPTION_INPUT,
			SHOW,
			EXECUTE,
			CLOSE,
		}

		BM_ITEM BMItem;
		Font CtrlFont;
		//bool SelectFlag;

		Application application;
		
		EditLine Address;
		Push WorkSelect, OptionSelect, Execute, Close;
		ComboBox WorkInput, OptionInput;
		ShowComboBox ShowSelect;
	}
	this(NeWindow Owner, Item item, Application application)
	in {
		assert(Owner);
		assert(item);
		assert(application);
	}
	body {
		this.application = application;
		
		BMItem = ItemToButtonMenuItem(item, true, ICONSIZE.SMALL);
		
		GUIINFO NeGuiInfo;
		NeGuiInfo.Owner   = Owner;
		NeGuiInfo.Style   = WS_DLGFRAME | WS_CAPTION | WS_THICKFRAME | WS_SYSMENU;

		super(&NeGuiInfo);
		
		defButton = Execute;

		this.Center = CENTER.DESKTOP;
	}

	override protected {
		void OnCreate() {
			super.OnCreate();
			
			auto item=BMItem.item;
			text=Text(item.itemID);
			CtrlFont = GetSystemFont(SYSFONT.MESSAGE, true);
			
			setIcon(ICONSIZE.SMALL, BMItem.icon);

			// アイテムアドレス(Item.TYPE依存)
			Address=new EditLine(this, CTRL.ADDRESS);
			with(Item.TYPE) switch(item.type()) {
				case NORMAL: Address.text = Text(item.address); break;
				case URI:    Address.text = Text(item.uri);     break;
				case MULTI:  Address.text = Text(join(item.multi, ", "));   break;
				default:     assert(false);
			}
			Address.readOnly=true;
			Address.font = CtrlFont;

			// 作業フォルダ選択コントロール
			WorkSelect=new Push(this, CTRL.WORK_SELECT);
			WorkSelect.font = CtrlFont;
			WorkSelect.text = Text("作業フォルダ...");

			// 作業フォルダ入力コントロール
			WorkInput=new ComboBox(this, CTRL.WORK_INPUT, ComboBox.TYPE.DROPEDIT);
			WorkInput.font = CtrlFont;
			Text WorkText = Text(GetWorkFolder(item));
			if(item.historyWorkFolders.length) {
				WorkInput.add(Texts(item.historyWorkFolders));
			}
			WorkInput.add(WorkText);
			WorkInput.text = WorkText;

			// オプション選択コントロール
			OptionSelect=new Push(this, CTRL.OPTION_SELECT);
			OptionSelect.font = CtrlFont;
			OptionSelect.text = Text("オプション...");

			// オプション入力コントロール
			OptionInput=new ComboBox(this, CTRL.OPTION_SELECT, ComboBox.TYPE.DROPEDIT);
			OptionInput.font = CtrlFont;
			Text OptionText = Text(item.option);
			if(item.historyOptions.length) {
				OptionInput.add(Texts(item.historyOptions));
			}
			OptionInput.text = OptionText;
			OptionInput.add(OptionText);
			
			// 表示方法選択コントロール
			ShowSelect=new ShowComboBox(this, CTRL.SHOW);
			ShowSelect.font = CtrlFont;
			ShowSelect.initialize();
			ShowSelect.select(item.show);

			// 表示方法選択コントロール
			Execute=new Push(this, CTRL.EXECUTE);
			Execute.font = CtrlFont;
			Execute.text = Text("実行");
			Execute.def = true;
			Execute.setFocus;

			// 表示方法選択コントロール
			Close=new Push(this, CTRL.CLOSE);
			Close.font = CtrlFont;
			Close.text = Text("閉じる");

			immutable Padding=GetControlPadding();
				
			auto Rows=new Tansu(DIRECTION.VERTICAL);
			Rows.sizeInfo.absolute = WorkInput.editerHeight();
			Rows.padding.bottom = Rows.padding.top    = Padding.cy / 2;
			Rows += Address;
			
			auto Works=new Dual(DIRECTION.HORIZON);
			Works[0] = WorkSelect;
			Works[1] = WorkInput;
			Works.centerSize = Padding.cx;
			Works.sizeInfo.percent = 35;
			Rows += Works;
			
			auto Options=new Dual(DIRECTION.HORIZON);
			Options[0] = OptionSelect;
			Options[1] = OptionInput;
			Options.centerSize = Padding.cx;
			Options.sizeInfo.percent = 35;
			Rows += Options;

			auto Selects=new Dual(DIRECTION.HORIZON);
			Selects[0] = Execute;
			Selects[1] = Close;
			Selects.centerSize = Padding.cx;
			Selects.sizeInfo.percent = 50;
			
			auto Others=new Line(DIRECTION.HORIZON);
			Others += ShowSelect;
			Others += null;
			Others += Selects;
			Others.sizeInfo(0).percent = 30;
			Others.sizeInfo(1).percent = 25;
			Others.sizeInfo(2).absolute = -1;
			Rows += Others;
			
			layoutManager.basePanel = Rows;
			
			//SIZE Padding=GetControlPadding();
			SIZE Size=void;
			Size.cx = 256;
			Size.cy = WorkInput.editerHeight() * 4 + Padding.cy/2 * 5*2;

			adjustSize(Size.cx, Size.cy);
		}
		void OnDestroy() {
			delete BMItem.icon;
			delete CtrlFont;
			
			super.OnDestroy();
		}
		HT OnNcHitTest(HT HitFlag, int x, int y) {
			with(HT) switch(HitFlag) {
				case TOP, BOTTOM:
					return CLIENT;
				case BOTTOMLEFT, TOPLEFT:
					return LEFT;
				case BOTTOMRIGHT, TOPRIGHT:
					return RIGHT;
				default:
					return HitFlag;
			}
		}
		/+
		void OnSize(SIZE_TYPE SizeType, int Width, int Height) {
			SIZE Padding=GetControlPadding();
			
			// 詰め領域含め1/10を基準に位置あわせ。
			invariant SplitWidth=Width / 10;

			invariant auto CtrlHeight=GetDefaultControlHeight(CtrlFont);
			invariant auto StdHeight=WorkInput.editerHeight();
			
			Address.move(Padding.cx, Padding.cy, Width - Padding.cx * 2, StdHeight, true);

			WorkSelect.move(Padding.cx, StdHeight + Padding.cy * 2, SplitWidth * 3, StdHeight, true);
			WorkInput.move(SplitWidth * 3 + Padding.cx * 2, StdHeight + Padding.cy * 2, SplitWidth * 7 - Padding.cx * 2, CtrlHeight*10, true);

			OptionSelect.move(Padding.cx, StdHeight * 2 + Padding.cy * 3, SplitWidth * 3, StdHeight, true);
			OptionInput.move(SplitWidth * 3 + Padding.cx * 2, StdHeight * 2 + Padding.cy * 3, SplitWidth * 7 - Padding.cx * 2, CtrlHeight*10, true);

			ShowSelect.move(Padding.cx, StdHeight * 3 + Padding.cy * 4, SplitWidth * 4, StdHeight*6, true);
			Execute.move(Width - SplitWidth * 5 - Padding.cx * 2, StdHeight * 3 + Padding.cy * 4, SplitWidth * 3, StdHeight, true);
			Close.move(Width - SplitWidth * 2 - Padding.cx * 1, StdHeight * 3 + Padding.cy * 4, SplitWidth * 2, StdHeight, true);
		}
		+/

		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			if(MessageType == Button.EVENT.CLICKED) {
				switch(Id) {
					case CTRL.WORK_SELECT: {
						workSelect();
						return true;
					}
					case CTRL.OPTION_SELECT: {
						optionSelect();
						return true;
					}
					case CTRL.EXECUTE: {
						executeSelect();
						destroy();
						return true;
					}
					case CTRL.CLOSE: {
						destroy();
						return true;
					}
					default:
						return false;
				}
			} else {
				return false;
			}

		}
	}

	private void workSelect() {
		auto WorkFolder=WorkInput.text;

		auto Folder=new FolderDialog();
		Folder.ownerWindow = this;
		if(WorkFolder.length && FILE.isExistence(WorkFolder) && FILE.isFolder(WorkFolder)) {
			Folder.folderAddress = WorkFolder;
		}
		with(FolderDialog.BIF) Folder.flags = RETURNSANCESTORS|RETURNNONLYFSDIRS|USENEWUI;
		
		try {
			if(Folder.select()) {
				WorkInput.text = Folder.folderAddress;
			}
		} catch(Exception e) {
			Logger.write(e);
			ShowExceptionDialog(this, e);
		}
	}

	void optionSelect() {
		auto OptionFolder=OptionInput.text;

		auto File=new OpenDialog();
		File.ownerWindow = this;
		if(OptionFolder.length && FILE.isExistence(OptionFolder)) {
			File.currentFolder = PATH.getOwnerFolder(OptionFolder);
		} else {
			File.currentFolder = GetSystemFolder(SYS_FOLDER.PERSONAL);
		}
		//with(FileDialog.OFN) File.flags = EXPLORER|FILEMUSTEXIST|HIDEREADONLY|LONGNAMES|PATHMUSTEXIST;
		File.flags = FileDialog.FLAGS.DEFAULT;
		
		//auto ExtPair = [[Text("すべてのファイル(*.*)")], [Text("*")]];
		//File.filter(ExtPair[0], ExtPair[1]);
		//File.filter = [OpenDialog.FILTER(Text("すべてのファイル(*.*)"), Texts("*"))];
					OpenDialog.FILTER[] filter;
					auto FiltersList=StaticData.fileFilter;
					foreach(Filters; FiltersList) {
						filter ~= OpenDialog.FILTER(Filters[0], Filters[1..$]);
					}
		File.filter = filter;
		
		if(File.select()) {
			OptionInput.text = File.fileAddress;
		}
	}



	void executeSelect() {
	// コンボボックスの中身の登録
	// 最終要素と文字列最後の余白を無くす。
	//auto WorkInput=new ComboBox(GetDlgItem(dialog(), CTRL.WORK_INPUT));
	//auto WorkInput=new ComboBox(dialog.child(CTRL.WORK_INPUT));
	////auto OptionInput=new ComboBox(GetDlgItem(dialog(), CTRL.OPTION_INPUT));
	//auto OptionInput=new ComboBox(dialog.child(CTRL.OPTION_INPUT));
	//auto ShowSelect=new ShowComboBox(dialog.child(CTRL.SHOW));

		

		
		// 実行
		try {
			OverrideInfo* OverInfo;
			void OverSet() {
				if(OverInfo is null) {
					OverInfo = new OverrideInfo;
				}
			}
			enforce(BMItem.live, new NemuxiException("あれれ"));
			if(WorkInput.text != BMItem.item.workFolder) {
				OverSet();
				OverInfo.Mask       |= OverrideInfo.MASK.WORK;
				OverInfo.WorkFolder =  WorkInput.text.toString();
			}
			if(OptionInput.text != BMItem.item.option) {
				OverSet();
				OverInfo.Mask   |= OverrideInfo.MASK.OPTION;
				OverInfo.Option =  OptionInput.text.toString();
			}
			if(ShowSelect.select != BMItem.item.show) {
				OverSet();
				OverInfo.Mask |= OverrideInfo.MASK.SHOW;
				OverInfo.Show =  ShowSelect.select;
			}
			/*synchronized(BMItem.item)*/ application.executeItem(BMItem.item, OverInfo);
		} catch(Exception e) {
			Logger.write(e);
			ShowExceptionDialog(this, e);
		}


		// 履歴設定
		invariant HISTORY_MAX=application.AppData.historyMax();
		if(!HISTORY_MAX) {
			return;
		}

		void HistoryList(ComboBox Target, void delegate(string[]) dg) {
			if(Target.count > 1) {
				string[] TempStrs;
				if(Target.count-1 == 1) {
					// 登録はひとつだけ
					TempStrs=[Target[0].toString];
				} else {
					TempStrs=Strings(Target[0..Target.count-2]);
				}
				auto AddStr  =Target.text.strip.toString();

				if(Target[Target.count-1].strip == AddStr) {
					return;
				}
				
				auto TempList=HistorySort(TempStrs, AddStr);
				
				if(TempList.length > HISTORY_MAX) {
					TempList.length = HISTORY_MAX;
				}
				dg(TempList);
			} else if(Target[0] != Target.text) {
				dg([Target.text.toString]);
			//	Msg([Target.text.toString]);
			}
		}


		// 履歴設定
		/+
		if(WorkInput.count > 1) {
			// 作業フォルダ
			auto WorkStrings=Strings(WorkInput[0..WorkInput.count-1]);
			auto TempList   =HistorySort(WorkStrings, WorkInput.text.toString());
			if(TempList.length > HISTORY_MAX) {
				TempList.length = HISTORY_MAX;
			}
			BMItem.item.historyWorkfolders = TempList;
		}
		+/
		HistoryList(WorkInput, &BMItem.item.historyWorkFolders);
		/+
		if(OptionInput.count > 1) {
			// 作業フォルダ
			auto OptionStrings=Strings(OptionInput[0..OptionInput.count-1]);
			auto TempList     =HistorySort(OptionStrings, OptionInput.text.toString());
			if(TempList.length > HISTORY_MAX) {
				TempList.length = HISTORY_MAX;
			}
			BMItem.item.historyOptions = TempList;
		}
		+/
		HistoryList(OptionInput, &BMItem.item.historyOptions);
	}
}

